/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.misc;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.content.capability.persistentstack.PersistentStackCapabilityHandles;
import net.tslat.aoa3.content.capability.persistentstack.PersistentStackCapabilityProvider;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class ExpFlask
extends Item {
    public ExpFlask() {
        super(new Item.Properties().m_41491_(AoAItemGroups.TOOLS).m_41487_(1));
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 100;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
            if (cap.getValue() <= 0.0f) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_6672_(hand);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
            if (cap.getValue() > 0.0f) {
                int xpChange = (int)Math.min((float)(1 + (int)((float)player.f_36078_ / 15.0f)), cap.getValue());
                player.m_6756_(xpChange);
                cap.setValue(cap.getValue() - (float)xpChange);
                if (cap.getValue() == 0.0f) {
                    player.m_5810_();
                }
            }
        }
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = super.getShareTag(stack);
        if (tag == null) {
            tag = new CompoundTag();
        }
        tag.m_128350_("AdventMiscStackCapability", PersistentStackCapabilityProvider.getOrDefault(stack, null).getValue());
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_("AdventMiscStackCapability")) {
            PersistentStackCapabilityProvider.getOrDefault(stack, null).setValue(nbt.m_128457_("AdventMiscStackCapability"));
        }
        super.readShareTag(stack, nbt);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new PersistentStackCapabilityProvider(null);
    }

    public static void addExp(ItemStack stack, int xp) {
        PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
        cap.setValue(cap.getValue() + (float)xp);
    }

    public static void setExp(ItemStack stack, int xp) {
        PersistentStackCapabilityProvider.getOrDefault(stack, null).setValue(xp);
    }

    public static boolean consumeExp(ItemStack stack, int xp) {
        PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
        if (cap.getValue() >= (float)xp) {
            cap.setValue(cap.getValue() - (float)xp);
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        int storedValue = (int)PersistentStackCapabilityProvider.getOrDefault(stack, null).getValue();
        if (storedValue > 0) {
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.SPECIAL, 1, new Component[]{Component.m_237113_((String)(NumberUtil.floorAndAppendSuffix(storedValue, true) + (String)(storedValue >= 7 ? " (" + PlayerUtil.getPlayerLevelFromExp(storedValue) + ")" : "")))}));
        }
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 2, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 3, new Component[0]));
    }
}

