/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.axe;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.common.registration.AoATiers;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.content.capability.persistentstack.PersistentStackCapabilityHandles;
import net.tslat.aoa3.content.capability.persistentstack.PersistentStackCapabilityProvider;
import net.tslat.aoa3.content.item.tool.axe.BaseAxe;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class EnergisticAxe
extends BaseAxe {
    public EnergisticAxe() {
        super(AoATiers.ENERGISTIC, 2.0f, -3.0f);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        float speed = super.m_8102_(stack, state);
        if (speed != 1.0f && this.hasEnergy(stack)) {
            return speed * 3.0f;
        }
        return speed;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        PersistentStackCapabilityHandles cap = EnergisticAxe.getCapability(stack);
        if (super.m_8102_(stack, state) != 1.0f) {
            cap.setValue(Math.max(0.0f, cap.getValue() - 5.0f));
        }
        return super.m_6813_(stack, world, state, pos, entity);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            PersistentStackCapabilityHandles cap = EnergisticAxe.getCapability(player.m_21120_(hand));
            AoAResource.Instance spirit = PlayerUtil.getAdventPlayer((ServerPlayer)player).getResource((AoAResource)AoAResources.SPIRIT.get());
            float storeAmount = Mth.m_14036_((float)(2000.0f - cap.getValue()), (float)0.0f, (float)Math.min(20.0f, spirit.getCurrentValue()));
            cap.setValue(cap.getValue() + storeAmount);
            spirit.consume(storeAmount, true);
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(world, player, hand);
    }

    private boolean hasEnergy(ItemStack stack) {
        return EnergisticAxe.getCapability(stack).getValue() >= 5.0f;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new PersistentStackCapabilityProvider(null);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = super.getShareTag(stack);
        if (tag == null) {
            tag = new CompoundTag();
        }
        tag.m_128350_("AoAEnergyStored", EnergisticAxe.getCapability(stack).getValue());
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_("AoAEnergyStored")) {
            EnergisticAxe.getCapability(stack).setValue(Math.min(2000.0f, nbt.m_128457_("AoAEnergyStored")));
        }
        super.readShareTag(stack, nbt);
    }

    public static PersistentStackCapabilityHandles getCapability(ItemStack stack) {
        return PersistentStackCapabilityProvider.getOrDefault(stack, null);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.tool.energisticCharge", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[0]));
        PersistentStackCapabilityHandles cap = EnergisticAxe.getCapability(stack);
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.tool.energisticStorage", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.m_237113_((String)Integer.toString((int)cap.getValue()))}));
    }
}

