/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc.summoning;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.item.misc.summoning.BossSpawningItem;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public class HeavyBoulder
extends BossSpawningItem {
    public HeavyBoulder() {
        super((Supplier<SoundEvent>)AoASounds.ENTITY_ROCK_RIDER_SWITCH, new ParticleOptions[]{ParticleTypes.f_123768_, ParticleTypes.f_123755_});
    }

    @Override
    public void spawnBoss(Level world, ServerPlayer summoner, double posX, double posY, double posZ) {
    }

    @Override
    public boolean canSpawnHere(Level world, ServerPlayer player, double posX, double posY, double posZ) {
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            PlayerUtil.notifyPlayer((Player)player, (Component)Component.m_237115_((String)"message.feedback.spawnBoss.difficultyFail").m_130940_(ChatFormatting.RED));
            return false;
        }
        if (!WorldUtil.isWorld(world, AoADimensions.HAVEN.key)) {
            return false;
        }
        if (!world.m_45772_(new AABB(posX - 1.0, posY, posZ - 1.0, posX + 1.0, posY + 4.0, posZ + 1.0))) {
            PlayerUtil.notifyPlayer((Player)player, (Component)Component.m_237115_((String)"message.feedback.spawnBoss.noSpace").m_130940_(ChatFormatting.RED));
            return false;
        }
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
        tooltip.add((Component)LocaleUtil.getLocaleMessage("items.description.boss_summon_item.unstable", ChatFormatting.AQUA, new Component[0]));
    }
}

