/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc.summoning;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.content.entity.misc.BossItemEntity;
import net.tslat.aoa3.util.RandomUtil;

public abstract class BossSpawningItem
extends Item {
    private final ParticleOptions[] timerParticles;
    private final Supplier<SoundEvent> throwingSound;

    public BossSpawningItem(@Nullable Supplier<SoundEvent> throwSound, ParticleOptions ... timerParticles) {
        super(new Item.Properties().m_41491_(AoAItemGroups.MISC_ITEMS).m_41497_(Rarity.UNCOMMON));
        this.timerParticles = timerParticles;
        this.throwingSound = throwSound;
    }

    public void handleTimerParticles(ItemEntity entityItem, double posX, double posY, double posZ, int lifespan, int ticksExisted) {
        int index = (int)((float)ticksExisted / (float)lifespan * (float)this.timerParticles.length);
        if (RandomUtil.oneInNChance(1 + (lifespan - ticksExisted) / 20)) {
            entityItem.f_19853_.m_7106_(this.timerParticles[index], posX, posY + 0.25, posZ, 0.0, 0.0, 0.0);
        }
    }

    public abstract void spawnBoss(Level var1, ServerPlayer var2, double var3, double var5, double var7);

    public abstract boolean canSpawnHere(Level var1, ServerPlayer var2, double var3, double var5, double var7);

    @Nullable
    public SoundEvent getThrowingSound() {
        return this.throwingSound.get();
    }

    public static BossItemEntity newBossEntityItemFromExisting(ItemEntity item, Player player) {
        BossItemEntity bossItem = new BossItemEntity(item.f_19853_, item.m_20185_(), item.m_20186_(), item.m_20189_(), item.m_32055_(), player);
        bossItem.m_32010_(10);
        bossItem.m_32052_(player.m_20148_());
        bossItem.m_32047_(player.m_20148_());
        bossItem.m_20256_(item.m_20184_());
        return bossItem;
    }
}

