/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.data.client.MiscellaneousReloadListener;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class WornBook
extends WrittenBookItem {
    private static final CompoundTag contents = new CompoundTag();

    public WornBook() {
        super(new Item.Properties().m_41491_(AoAItemGroups.MISC_ITEMS).m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemStack getBook(ItemStack stack) {
        stack.m_41751_(WornBook.getBookContents());
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack bookStack = player.m_21120_(hand);
        if (!world.f_46443_) {
            if (!ItemUtil.findInventoryItem(player, new ItemStack((ItemLike)AoAItems.BLANK_REALMSTONE.get()), false, 1)) {
                ItemUtil.givePlayerItemOrDrop(player, new ItemStack((ItemLike)AoAItems.BLANK_REALMSTONE.get()));
                player.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.wornBook.droppedRealmstone"));
                PlayerUtil.getAdventPlayer((ServerPlayer)player).addPatchouliBook(AdventOfAscension.id("worn_book"));
            }
        } else {
            DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientOperations::displayWornBookGui);
        }
        return InteractionResultHolder.m_19090_((Object)bookStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static CompoundTag getBookContents() {
        contents.m_128359_("author", LocaleUtil.getLocaleString("entity.aoa3.corrupted_traveller"));
        contents.m_128359_("title", LocaleUtil.getLocaleString("item.aoa3.worn_book"));
        String pageContents = MiscellaneousReloadListener.DATA.get(AoAItems.WORN_BOOK.get());
        if (pageContents == null) {
            return contents;
        }
        String[] lines = pageContents.split("\n");
        ListTag pages = new ListTag();
        for (String line : lines) {
            pages.add((Object)StringTag.m_129297_((String)line.replaceAll("<br>", "\n")));
        }
        contents.m_128365_("pages", (Tag)pages);
        return contents;
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }
}

