/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.entity.mob.shyrelands.ArcwormEntity;
import net.tslat.aoa3.content.item.weapon.blaster.ExperimentW801;
import net.tslat.aoa3.library.builder.EffectBuilder;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class ReservedItem
extends Item {
    private final String sequenceId;

    public ReservedItem(String sequenceName) {
        super(new Item.Properties().m_41497_(Rarity.EPIC));
        this.sequenceId = sequenceName;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.verifyStack(stack)) {
            stack.m_41764_(0);
            ((Player)entityIn).m_150109_().m_6836_(itemSlot, ItemStack.f_41583_);
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43723_() == null) {
            return super.onItemUseFirst(stack, context);
        }
        Block block = context.m_43725_().m_8055_(context.m_8083_()).m_60734_();
        if (block == AoABlocks.CHARGING_TABLE.get()) {
            if (this == AoAItems.FLESHY_BONES.get()) {
                context.m_43723_().m_21008_(context.m_43724_(), ((ReservedItem)((Object)AoAItems.DARK_BONES.get())).newValidStack());
                return InteractionResult.SUCCESS;
            }
        } else if (block == AoABlocks.MINERALIZATION_STATION.get() && this == AoAItems.DARK_BONES.get()) {
            context.m_43723_().m_21008_(context.m_43724_(), ((ReservedItem)((Object)AoAItems.ROCK_BONES.get())).newValidStack());
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!target.f_19853_.f_46443_) {
            if (stack.m_41720_() == AoAItems.MILLENNIUM_UPGRADER.get()) {
                if (target.m_20077_() && attacker.m_20077_()) {
                    attacker.m_21008_(InteractionHand.MAIN_HAND, ((ReservedItem)((Object)AoAItems.MOLTEN_UPGRADER.get())).newValidStack());
                    return true;
                }
            } else if (stack.m_41720_() == AoAItems.MOONSTONE.get()) {
                if (target instanceof ArcwormEntity) {
                    EntityUtil.applyPotions((Entity)target, new EffectBuilder(MobEffects.f_19620_, 200).level(11).hideParticles());
                }
                return true;
            }
        }
        return false;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!this.verifyStack(entity.m_32055_())) {
            entity.m_32045_(ItemStack.f_41583_);
            entity.m_146870_();
        }
        return false;
    }

    public ItemStack newValidStack() {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(this.sequenceId, true);
        stack.m_41751_(tag);
        return stack;
    }

    private boolean verifyStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (!tag.m_128441_(this.sequenceId)) {
            return false;
        }
        return tag.m_128471_(this.sequenceId);
    }

    public static void handlePlayerToss(ItemTossEvent ev) {
        Level world = ev.getEntityItem().f_19853_;
        if (!world.m_5776_() && ev.getEntityItem().m_32055_().m_41720_() == AoAItems.MOLTEN_UPGRADER.get() && world.m_46940_() == 1.0f) {
            ev.getEntityItem().m_32045_(((ReservedItem)((Object)AoAItems.MOONSTONE.get())).newValidStack());
        }
    }

    public static void handleArcworm(ArcwormEntity arcworm) {
        if (arcworm.m_20186_() > 275.0 && arcworm.m_21232_() instanceof Player && arcworm.m_21232_().m_21205_().m_41720_() == AoAItems.MOONSTONE.get()) {
            arcworm.m_5552_(((ExperimentW801)AoAWeapons.EXPERIMENT_W_801.get()).newValidStack(), 0.0f);
            arcworm.m_21232_().m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            arcworm.m_146870_();
        }
    }

    public static void handlePlayerDeath(Player pl) {
        if (pl.m_21223_() > 0.0f && !pl.f_19853_.m_6106_().m_5466_()) {
            return;
        }
        if (!ForgeRegistries.ITEMS.getKey((Object)pl.m_21205_().m_41720_()).m_135815_().toLowerCase(Locale.ENGLISH).startsWith("a")) {
            return;
        }
        NonNullList armour = pl.m_150109_().f_35975_;
        if (!ForgeRegistries.ITEMS.getKey((Object)((ItemStack)armour.get(3)).m_41720_()).m_135815_().toLowerCase(Locale.ENGLISH).startsWith("l")) {
            return;
        }
        if (!ForgeRegistries.ITEMS.getKey((Object)((ItemStack)armour.get(2)).m_41720_()).m_135815_().toLowerCase(Locale.ENGLISH).startsWith("i")) {
            return;
        }
        if (!ForgeRegistries.ITEMS.getKey((Object)((ItemStack)armour.get(1)).m_41720_()).m_135815_().toLowerCase(Locale.ENGLISH).startsWith("e")) {
            return;
        }
        if (!ForgeRegistries.ITEMS.getKey((Object)((ItemStack)armour.get(0)).m_41720_()).m_135815_().toLowerCase(Locale.ENGLISH).startsWith("n")) {
            return;
        }
        if (ItemUtil.findInventoryItem(pl, new ItemStack((ItemLike)AoAItems.ALIEN_ORB.get()), false, 1)) {
            return;
        }
        pl.m_5552_(((ReservedItem)((Object)AoAItems.ALIEN_ORB.get())).newValidStack(), 0.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41720_() == AoAItems.ALIEN_ORB.get()) {
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new Component[0]));
        }
    }
}

