/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.content.entity.misc.LottoTotemEntity;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RandomUtil;

public class LottoTotem
extends Item {
    public LottoTotem() {
        super(new Item.Properties().m_41491_(AoAItemGroups.MISC_ITEMS));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState targetBlockState = world.m_8055_(pos);
        if (context.m_43719_() != Direction.UP || !targetBlockState.m_60783_((BlockGetter)world, pos, Direction.UP)) {
            return InteractionResult.FAIL;
        }
        if (!world.f_46443_) {
            if (!world.m_45976_(LottoTotemEntity.class, new AABB(pos).m_82400_(4.0)).isEmpty()) {
                PlayerUtil.notifyPlayer(player, (Component)Component.m_237115_((String)"message.feedback.lottoTotem.nearby").m_130940_(ChatFormatting.RED));
                return InteractionResult.FAIL;
            }
            ArrayList<BlockPos> spawnPositions = new ArrayList<BlockPos>(5);
            spawnPositions.add(pos);
            if (this.populateSpawnPositions(world, pos, spawnPositions)) {
                player.m_21120_(context.m_43724_()).m_41774_(1);
                int selectedWinner = RandomUtil.randomNumberUpTo(5);
                UUID winningUUID = Mth.m_14002_();
                for (BlockPos spawnPos : spawnPositions) {
                    LottoTotemEntity totem = new LottoTotemEntity(world, spawnPos, winningUUID, player.m_20148_());
                    if (selectedWinner == 0) {
                        totem.m_20084_(winningUUID);
                    }
                    world.m_7967_((Entity)totem);
                    --selectedWinner;
                }
                PlayerUtil.notifyPlayer(player, (Component)Component.m_237115_((String)"message.feedback.lottoTotem.spawn").m_130940_(ChatFormatting.GOLD));
            } else {
                PlayerUtil.notifyPlayer(player, (Component)Component.m_237115_((String)"message.feedback.lottoTotem.noSpace").m_130940_(ChatFormatting.RED));
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean populateSpawnPositions(Level world, BlockPos pos, ArrayList<BlockPos> spawnPositions) {
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int x = pos.m_123341_() - 1; x <= pos.m_123341_() + 1; x += 2) {
            for (int z = pos.m_123343_() - 1; z <= pos.m_123343_() + 1; z += 2) {
                checkPos.m_122178_(x, pos.m_123342_(), z);
                if (!world.m_8055_(checkPos.m_7494_()).m_60767_().m_76336_() || !world.m_8055_((BlockPos)checkPos).m_60783_((BlockGetter)world, (BlockPos)checkPos, Direction.UP)) continue;
                spawnPositions.add(checkPos.m_7949_());
                if (spawnPositions.size() < 5) continue;
                return true;
            }
        }
        return false;
    }
}

