/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.model.armor.AoAMiscModels;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ClientPlayerDataManager;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;

public class SkillHelmet
extends AdventArmour {
    private final Supplier<AoASkill> skill;

    public SkillHelmet(Supplier<AoASkill> skill) {
        super((ArmorMaterial)ArmorMaterials.DIAMOND, EquipmentSlot.HEAD);
        this.skill = skill;
    }

    public AoASkill getSkill() {
        return this.skill.get();
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public boolean m_41465_() {
        return false;
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.ALL;
    }

    public boolean m_8120_(ItemStack pStack) {
        return true;
    }

    @Override
    public void onEquip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
        plData.getSkill(this.getSkill()).applyXpModifier(0.5f);
    }

    @Override
    public void onUnequip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
        plData.getSkill(this.getSkill()).removeXpModifier(0.5f);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            @Nonnull
            public Model getBaseArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> defaultModel) {
                return AoAMiscModels.getSkillHelmetModel(SkillHelmet.this.getSkill(), entityLiving instanceof Player && ClientPlayerDataManager.get().getSkill(SkillHelmet.this.getSkill()).hasLevel(1000), defaultModel);
            }
        });
    }

    @Override
    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return AdventOfAscension.id("textures/models/armor/custom/" + ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_() + (ClientPlayerDataManager.get().getSkill(this.getSkill()).getLevel(true) == 1000 ? "_trim" : "") + ".png").toString();
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> tooltip, TooltipFlag pFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.unbreakable", LocaleUtil.ItemDescriptionType.UNIQUE, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.skillXpBonus", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[]{LocaleUtil.numToComponent(50), this.getSkill().getName()}));
        tooltip.add((Component)this.anySetEffectHeader());
    }
}

