/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class SealordHelmet
extends AdventArmour {
    public static final AttributeModifier SEALORD_ATTACK_BUFF = new AttributeModifier(UUID.fromString("027744fa-e85d-4d1e-946a-747739900753"), "AoASealordMovementBuff", 2.0, AttributeModifier.Operation.ADDITION);

    public SealordHelmet() {
        super(ItemUtil.customArmourMaterial("aoa3:sealord", 60, new int[]{5, 7, 9, 5}, 10, SoundEvents.f_11675_, 7.0f), EquipmentSlot.HEAD);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.ALL;
    }

    @Override
    public void onEffectTick(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots) {
        ServerPlayer player = plData.player();
        if (player.m_204029_(FluidTags.f_13131_)) {
            EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22283_, SEALORD_ATTACK_BUFF, false);
        } else {
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22283_, SEALORD_ATTACK_BUFF);
        }
        if (plData.player().m_20069_()) {
            plData.player().m_20301_(-10);
        }
    }

    @Override
    public void onUnequip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
        EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22283_, SEALORD_ATTACK_BUFF);
    }

    @Override
    public boolean isHelmetAirTight(ServerPlayer player) {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.helmet.airTight", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add((Component)this.anySetEffectHeader());
    }
}

