/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.tablet;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.content.item.tablet.TabletItem;

public abstract class SoulTabletEntity
extends Entity {
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(SoulTabletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected ServerPlayer owner = null;
    private UUID ownerUUID = null;

    public SoulTabletEntity(EntityType<? extends SoulTabletEntity> entityType, Level world) {
        super(entityType, world);
        this.f_19850_ = true;
    }

    public SoulTabletEntity(EntityType<? extends SoulTabletEntity> entityType, Level world, ServerPlayer placer) {
        this(entityType, world);
        this.owner = placer;
        this.ownerUUID = this.owner != null ? this.owner.m_20148_() : null;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ACTIVE, (Object)true);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return this.ownerUUID == null || player.m_20148_().equals(this.ownerUUID) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (this.m_6084_() && (this.ownerUUID == null || player.m_20148_().equals(this.ownerUUID))) {
            if (!this.f_19853_.f_46443_ && !player.m_7500_()) {
                ItemStack stack = new ItemStack((ItemLike)this.getRelevantItem());
                if (player.m_21120_(hand).m_41619_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)this.getRelevantItem()));
                } else if (!player.m_36356_(stack)) {
                    this.m_5552_(stack, 0.0f);
                }
            }
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.owner != null) {
            compound.m_128359_("OwnedBy", this.ownerUUID.toString());
        }
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("OwnedBy")) {
            try {
                this.ownerUUID = UUID.fromString(compound.m_128461_("OwnedBy"));
                this.owner = this.f_19853_ instanceof ServerLevel ? (ServerPlayer)this.f_19853_.m_46003_(this.ownerUUID) : null;
            }
            catch (IllegalArgumentException e) {
                Logging.logMessage(org.apache.logging.log4j.Level.WARN, "Unknown or malformed owner UUID for soul tablet entity: " + compound.m_128461_("OwnerBy"));
            }
        }
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_6084_() && this.f_19797_ % 5 == 0) {
                if (this.f_19853_.m_46859_(this.m_20183_().m_7495_())) {
                    ItemEntity itemDrop = this.m_5552_(new ItemStack((ItemLike)this.getRelevantItem()), 0.0f);
                    if (this.owner != null && itemDrop != null) {
                        itemDrop.m_32047_(this.ownerUUID);
                    }
                    this.m_146870_();
                    return;
                }
                if (this.isActive()) {
                    if (this.testSoulSupply()) {
                        this.doTickEffect();
                    } else {
                        this.deactivate();
                    }
                }
            }
        } else if (this.f_19853_.m_46859_(this.m_20183_().m_7495_())) {
            this.m_146870_();
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        return source != DamageSource.f_19317_;
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
    }

    protected abstract void doTickEffect();

    public abstract TabletItem getRelevantItem();

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private boolean testSoulSupply() {
        return this.owner != null;
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    private void deactivate() {
        this.f_19804_.m_135381_(ACTIVE, (Object)false);
    }

    protected <T extends Entity> List<T> getTargetsWithinRadius(Class<T> targetClass, @Nullable Predicate<? super T> predicate) {
        return this.f_19853_.m_6443_(targetClass, this.m_20191_().m_82400_((double)this.getRelevantItem().getEffectRadius()), predicate);
    }
}

