/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.precasia;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.content.block.functional.altar.ArmyBlock;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;

public class SkeleElderEntity
extends AoAMeleeMob {
    private BlockPos armyBlockPos;
    private int wave;

    public SkeleElderEntity(Level world, BlockPos armyBlockPos, int wave) {
        super((EntityType<? extends Monster>)((EntityType)AoAMobs.SKELE_ELDER.get()), world);
        this.armyBlockPos = armyBlockPos;
        this.wave = wave;
        this.m_21446_(armyBlockPos, 18);
    }

    public SkeleElderEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.armyBlockPos = null;
        this.wave = -1;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.armyBlockPos == null || this.wave < 0;
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 2.34375f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12381_;
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return null;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("SkeletalArmyWave")) {
            this.wave = compound.m_128451_("SkeletalArmyWave");
        }
        if (compound.m_128441_("ArmyBlockPos")) {
            this.armyBlockPos = BlockPos.m_122022_((long)compound.m_128454_("ArmyBlockPos"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.wave > 0) {
            compound.m_128405_("SkeletalArmyWave", this.wave);
        }
        if (this.armyBlockPos != null) {
            compound.m_128356_("ArmyBlockPos", this.armyBlockPos.m_121878_());
        }
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_6667_(DamageSource cause) {
        Block bl;
        super.m_6667_(cause);
        if (this.wave >= 0 && this.armyBlockPos != null && this.m_20275_(this.armyBlockPos.m_123341_(), this.armyBlockPos.m_123342_(), this.armyBlockPos.m_123343_()) < 2500.0 && (bl = this.f_19853_.m_8055_(this.armyBlockPos).m_60734_()) == AoABlocks.ARMY_BLOCK.get()) {
            ArmyBlock.spawnWave(this.f_19853_, this.armyBlockPos, this.wave + 1);
        }
    }
}

