/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.mysterium;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;

public class RunicGolemEntity
extends AoAMeleeMob {
    private static final EntityDataAccessor<Boolean> SHIELDED = SynchedEntityData.m_135353_(RunicGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int shieldCooldown = 120;
    private int runeStoneCooldown = 0;

    public RunicGolemEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.59375f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHIELDED, (Object)false);
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_RUNIC_GOLEM_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_RUNIC_GOLEM_HURT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return SoundEvents.f_12010_;
    }

    public void deactivateShield() {
        this.shieldCooldown = 120;
        this.setShielded(false);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_ && this.isShielded() && EntityUtil.Predicates.SURVIVAL_PLAYER.test(source.m_7639_())) {
            if (DamageUtil.isMeleeDamage(source) && this.runeStoneCooldown <= 0) {
                this.runeStoneCooldown = 120;
                this.m_20000_((ItemLike)AoAItems.ACTIVE_RUNE_STONE.get(), 1);
            }
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_20147_() {
        return super.m_20147_() || this.isShielded();
    }

    public boolean isShielded() {
        return (Boolean)this.f_19804_.m_135370_(SHIELDED);
    }

    private void setShielded(boolean shielded) {
        this.f_19804_.m_135381_(SHIELDED, (Object)shielded);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.runeStoneCooldown > 0) {
            --this.runeStoneCooldown;
        }
        if (this.shieldCooldown > 0) {
            --this.shieldCooldown;
        } else if (this.shieldCooldown == 0) {
            this.shieldCooldown = -1;
            this.m_5496_((SoundEvent)AoASounds.ENTITY_RUNIC_GOLEM_CHARGE.get(), 1.0f, 1.0f);
            this.setShielded(true);
        }
    }
}

