/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.misc.doppelganger;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.registration.AoABrainSensors;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.content.entity.brain.SmartBrainHandler;
import net.tslat.aoa3.content.entity.brain.SmartBrainOwner;
import net.tslat.aoa3.content.entity.brain.task.BlockIncomingProjectileTask;
import net.tslat.aoa3.content.entity.brain.task.CounterTargetWeaponTask;
import net.tslat.aoa3.content.entity.brain.task.FirstSuccessfulTask;
import net.tslat.aoa3.content.entity.brain.task.ParryStunlockTask;
import net.tslat.aoa3.content.entity.brain.task.RetaliateOrTargetTask;
import net.tslat.aoa3.util.BrainUtils;
import org.apache.commons.lang3.tuple.Triple;

public class DoppelgangerEntity
extends Monster
implements SmartBrainOwner<DoppelgangerEntity>,
CrossbowAttackMob {
    private static final ImmutableList<SensorType<? extends Sensor<? super DoppelgangerEntity>>> SENSORS = ImmutableList.of((Object)SensorType.f_26812_, (Object)SensorType.f_26814_, (Object)SensorType.f_26811_, (Object)((SensorType)AoABrainSensors.INCOMING_PROJECTILES.get()));
    private static final EntityDataAccessor<Boolean> LOADING_CROSSBOW = SynchedEntityData.m_135353_(DoppelgangerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private SmartBrainHandler<DoppelgangerEntity> handler;

    public DoppelgangerEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    public DoppelgangerEntity(Level world) {
        super((EntityType)AoAMobs.DOPPELGANGER.get(), world);
    }

    @Override
    @Nullable
    public SmartBrainHandler<DoppelgangerEntity> getBrainHandler() {
        return this.handler;
    }

    @Override
    public void setBrainHandler(SmartBrainHandler<DoppelgangerEntity> handler) {
        this.handler = handler;
    }

    @Override
    public ImmutableList<SensorType<? extends Sensor<? super DoppelgangerEntity>>> getSensors() {
        return SENSORS;
    }

    public Brain.Provider<?> m_5490_() {
        return this.getBrainHandler().getBrainCodec();
    }

    public Brain<?> m_8075_(Dynamic<?> codecLoader) {
        if (this.getBrainHandler() == null) {
            this.setBrainHandler(new SmartBrainHandler<DoppelgangerEntity>(this));
        }
        return this.getBrainHandler().makeBrain(codecLoader);
    }

    public Brain<?> m_6274_() {
        return this.getBrainHandler().getBrain();
    }

    @Override
    public Triple<Integer, ImmutableList<? extends Behavior<? super DoppelgangerEntity>>, MemoryModuleType<?>> getCoreTasks() {
        return Triple.of((Object)0, (Object)ImmutableList.of((Object)new LookAtTargetSink(60, 240), (Object)new MoveToTargetSink()), null);
    }

    @Override
    public Triple<Integer, ImmutableList<? extends Behavior<? super DoppelgangerEntity>>, MemoryModuleType<?>> getIdleTasks() {
        return Triple.of((Object)10, (Object)ImmutableList.of(new FirstSuccessfulTask(ImmutableList.of((Object)Pair.of(new RetaliateOrTargetTask<DoppelgangerEntity>(this), (Object)1), (Object)Pair.of((Object)new SetEntityLookTarget(EntityType.f_20532_, 8.0f), (Object)1), (Object)Pair.of((Object)new SetEntityLookTarget(8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(1.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)))), null);
    }

    @Override
    public Triple<Integer, ImmutableList<? extends Behavior<? super DoppelgangerEntity>>, MemoryModuleType<?>> getFightTasks() {
        return Triple.of((Object)10, (Object)ImmutableList.of((Object)new StopAttackingIfTargetInvalid(target -> !target.m_6084_() || target instanceof Player && ((Player)target).m_7500_()), (Object)((Object)new CounterTargetWeaponTask()), (Object)new MeleeAttack(6), (Object)new SetWalkTargetFromAttackTargetIfTargetOutOfReach(1.3f)), (Object)MemoryModuleType.f_26372_);
    }

    @Override
    public Map<Activity, Triple<Integer, ImmutableList<? extends Behavior<? super DoppelgangerEntity>>, MemoryModuleType<?>>> getAdditionalTasks() {
        return ImmutableMap.of((Object)Activity.f_37991_, (Object)Triple.of((Object)0, (Object)ImmutableList.of((Object)((Object)new BlockIncomingProjectileTask(true)), new ParryStunlockTask()), null));
    }

    @Override
    public Set<Activity> getAlwaysRunningActivities() {
        return ImmutableSet.of((Object)Activity.f_37978_, (Object)Activity.f_37991_);
    }

    @Override
    public List<Activity> getActivityPriorities() {
        return ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37979_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOADING_CROSSBOW, (Object)false);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance difficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData data = super.m_6518_(pLevel, difficulty, pReason, pSpawnData, pDataTag);
        this.m_213945_(this.f_19796_, difficulty);
        this.m_213946_(this.f_19796_, difficulty);
        return data;
    }

    protected void m_213945_(RandomSource rand, DifficultyInstance difficulty) {
        AoAArmour.ArmourSet armourSet = AoAArmour.ALACRITY_ARMOUR;
        if (difficulty.m_19048_() == Difficulty.NORMAL || difficulty.m_19048_() == Difficulty.HARD) {
            armourSet = AoAArmour.KNIGHT_ARMOUR;
        }
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)armourSet.helmet.get()));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)armourSet.chestplate.get()));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)armourSet.leggings.get()));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)armourSet.boots.get()));
    }

    protected boolean m_8028_() {
        return false;
    }

    public Component m_5446_() {
        if (this.f_19853_.m_5776_()) {
            return ClientOperations.getPlayerName();
        }
        return super.m_5446_();
    }

    protected void m_8024_() {
        this.handler.tick();
        super.m_8024_();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (damageSource == DamageSource.f_19307_) {
            return SoundEvents.f_12273_;
        }
        if (damageSource == DamageSource.f_19312_) {
            return SoundEvents.f_12324_;
        }
        return damageSource == DamageSource.f_19325_ ? SoundEvents.f_12274_ : SoundEvents.f_12323_;
    }

    public boolean m_21254_() {
        return this.m_6117_() && !this.f_20935_.m_41619_() && this.f_20935_.m_41720_().m_6164_(this.f_20935_) == UseAnim.BLOCK;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12322_;
    }

    public void m_6136_(boolean pIsCharging) {
        this.f_19804_.m_135370_(LOADING_CROSSBOW);
    }

    public void m_5811_(LivingEntity target, ItemStack crossbow, Projectile bolt, float angle) {
        this.m_32322_((LivingEntity)this, target, bolt, angle, 1.6f);
    }

    @Nullable
    public LivingEntity m_5448_() {
        return BrainUtils.getTargetOfEntity((LivingEntity)this, super.m_5448_());
    }

    public boolean m_5886_(ProjectileWeaponItem weapon) {
        return weapon instanceof CrossbowItem;
    }

    public void m_5847_() {
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }
}

