/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.lunalus;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;

public class LunarcherEntity
extends AoAFlyingRangedMob {
    public LunarcherEntity(EntityType<? extends FlyingMob> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)AoAWeapons.LUNAR_BOW.get()));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        return data;
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.625f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_LUNARCHER_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_LUNARCHER_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_LUNARCHER_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundEvents.f_11687_;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return null;
    }

    @Override
    public void m_6504_(@Nonnull LivingEntity target, float bowDamageFactor) {
        CustomArrowEntity projectile = new CustomArrowEntity(this.f_19853_, (BaseBow)((Object)AoAWeapons.LUNAR_BOW.get()), (LivingEntity)this, this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
        double distanceFactorX = target.m_20185_() - projectile.m_20185_();
        double distanceFactorY = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - projectile.m_20186_();
        double distanceFactorZ = target.m_20189_() - projectile.m_20189_();
        double hyp = Math.sqrt(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ) * 0.05;
        if (this.getShootSound() != null) {
            this.m_5496_(this.getShootSound(), 1.0f, 1.0f);
        }
        projectile.m_6686_(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.f_19853_.m_46791_().m_19028_());
        this.f_19853_.m_7967_((Entity)projectile);
    }
}

