/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.creeponia;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.mob.creeponia.AoACreeponiaCreeper;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.CreeperShotEntity;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public class MagicalCreeperEntity
extends AoACreeponiaCreeper
implements AoARangedAttacker {
    public MagicalCreeperEntity(EntityType<? extends AoACreeponiaCreeper> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.40625f;
    }

    @Override
    public float getExplosionStrength() {
        return 3.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_CREEPOID_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_CREEPOID_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)AoASounds.ENTITY_CREEPOID_HURT.get();
    }

    public void m_8107_() {
        super.m_8107_();
        Player target = this.f_19853_.m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 20.0, false);
        if (target == null || target.m_7500_()) {
            return;
        }
        if (RandomUtil.oneInNChance(70)) {
            CreeperShotEntity projectile = new CreeperShotEntity(this, BaseMobProjectile.Type.MAGIC);
            double distanceFactorX = target.m_20185_() - this.m_20185_();
            double distanceFactorY = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - projectile.m_20186_();
            double distanceFactorZ = target.m_20189_() - this.m_20189_();
            double hyp = Math.sqrt(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ) + 0.2;
            this.m_5496_((SoundEvent)AoASounds.ENTITY_MAGICAL_CREEPER_SHOOT.get(), 1.0f, 1.0f);
            projectile.m_6686_(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.f_19853_.m_46791_().m_19028_());
            this.f_19853_.m_7967_((Entity)projectile);
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (DamageUtil.dealBlasterDamage((LivingEntity)this, target, (Entity)projectile, 7.0f, false)) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        WorldUtil.createExplosion((Entity)this, this.f_19853_, (Entity)projectile, 2.0f);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.f_19853_, (Entity)projectile, 2.0f);
    }
}

