/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.PlayMessages;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.content.entity.misc.HaulingFishingBobberEntity;
import net.tslat.aoa3.data.server.AoAHaulingFishReloadListener;
import net.tslat.aoa3.event.AoAPlayerEvents;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public class ThermalFishingBobberEntity
extends HaulingFishingBobberEntity {
    public ThermalFishingBobberEntity(Level world, Player player, double posX, double posY, double posZ) {
        super(world, player, posX, posY, posZ);
    }

    public ThermalFishingBobberEntity(Player player, Level world, ItemStack rod) {
        super(player, world, rod);
    }

    public ThermalFishingBobberEntity(Player player, Level world, ItemStack rod, float luck, float lure) {
        super(player, world, rod, luck, lure);
    }

    @Override
    public TagKey<Fluid> getApplicableFluid() {
        return FluidTags.f_13132_;
    }

    @Override
    public EntityType<?> m_6095_() {
        return (EntityType)AoAMiscEntities.THERMAL_BOBBER.get();
    }

    @Override
    protected void spawnFish(ServerPlayer player) {
        Function<Level, Entity> fishFunction = AoAHaulingFishReloadListener.getFishListForBiome((Biome)this.f_19853_.m_204166_(this.m_20183_()).m_203334_(), true).getRandomElement(player, this.getLuck());
        if (fishFunction != null) {
            Entity entity = fishFunction.apply(player.f_19853_);
            if (entity == null) {
                return;
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                BlockPos pos = RandomUtil.getRandomPositionWithinRange(this.m_20183_(), 10, 10, 10, false, this.f_19853_, state -> state.m_60819_().m_76152_() == Fluids.f_76195_, 5);
                mob.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                mob.m_21573_().m_7864_(this.m_20183_(), 0);
                this.f_19853_.m_7967_((Entity)mob);
            } else {
                entity.m_6034_(this.m_20185_(), this.m_20186_() - (double)entity.m_20206_(), this.m_20189_());
                this.f_19853_.m_7967_(entity);
            }
            this.spawnedFish = entity;
            AoAPlayerEvents.handleCustomInteraction(player, "hauling_spawn_fish", this.spawnedFish);
        }
    }

    @Override
    protected void calculateFishingLureBonus() {
        this.fishingBonusMod = 1.0f;
        Holder biome = this.f_19853_.m_204166_(this.m_20183_());
        float temperature = ((Biome)biome.m_203334_()).m_47505_(this.m_20183_());
        if (temperature > 2.0f) {
            this.fishingBonusMod *= 1.25f;
        } else if (temperature < 1.5f) {
            this.fishingBonusMod *= 0.8f;
        }
        this.fishingBonusMod = ((Biome)biome.m_203334_()).m_47530_() == Biome.Precipitation.NONE ? (this.fishingBonusMod *= 1.1f) : (this.fishingBonusMod *= 0.9f);
        if (this.f_19853_.m_46758_(this.m_20183_())) {
            this.fishingBonusMod *= 0.75f;
        }
        this.fishingBonusMod *= this.fishingBonusModForBiome((Holder<Biome>)biome);
        int nearbyFluidBlocks = WorldUtil.getBlocksWithinAABB(this.f_19853_, this.m_20191_().m_82377_(2.0, 1.0, 2.0), (state, pos) -> state.m_60819_().m_205070_(this.getApplicableFluid()) && state.m_60819_().m_76170_()).size();
        if (nearbyFluidBlocks <= 50) {
            this.fishingBonusMod *= 0.5f;
            if (nearbyFluidBlocks < 15) {
                this.fishingBonusMod *= 0.5f;
            }
        }
        this.fishingBonusMod *= 1.0f + (float)nearbyFluidBlocks * 0.0035f;
        this.fishingBonusMod += 0.25f * this.lure;
        if (!WorldUtil.getAllPlayersInRegion(this.f_19853_, this.m_20191_().m_82400_(5.0)).isEmpty()) {
            this.fishingBonusMod *= 0.2f;
        }
    }

    @Override
    protected void doBobbing(FluidState fluidState) {
        if (this.state == HaulingFishingBobberEntity.State.IN_FLUID) {
            BlockPos pos = this.m_20183_();
            float fluidHeight = fluidState.m_76155_((BlockGetter)this.f_19853_, pos);
            Vec3 vector3d = this.m_20184_();
            double fluidAdjustedHeight = this.m_20186_() + vector3d.f_82480_ - (double)pos.m_123342_() - (double)fluidHeight + 0.1;
            if (Math.abs(fluidAdjustedHeight) < 0.01) {
                fluidAdjustedHeight += Math.signum(fluidAdjustedHeight) * 0.1;
            }
            this.m_20334_(vector3d.f_82479_ * 0.9, vector3d.f_82480_ - fluidAdjustedHeight * (double)this.f_19796_.m_188501_() * 0.05, vector3d.f_82481_ * 0.9);
        }
    }

    @Override
    protected float fishingBonusModForBiome(Holder<Biome> biome) {
        for (TagKey tag : biome.m_203616_().toList()) {
            if (tag == BiomeTags.f_207603_ || tag == BiomeTags.f_207605_ || tag == Tags.Biomes.IS_SWAMP) {
                return 0.5f;
            }
            if (tag != Tags.Biomes.IS_DEAD && tag != Tags.Biomes.IS_DRY && tag != Tags.Biomes.IS_HOT) continue;
            return 1.25f;
        }
        return 1.0f;
    }

    @Nullable
    public static ThermalFishingBobberEntity handleClientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        Entity owner = world.m_6815_((int)packet.getPosY());
        if (owner instanceof Player) {
            return new ThermalFishingBobberEntity(world, (Player)owner, packet.getPosX(), owner.m_20188_(), packet.getPosZ());
        }
        return null;
    }
}

