/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.event.AoAPlayerEvents;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.RandomUtil;

public class FishingCageEntity
extends Entity {
    private static final EntityDataAccessor<ItemStack> CAUGHT_STACK_1 = SynchedEntityData.m_135353_(FishingCageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> CAUGHT_STACK_2 = SynchedEntityData.m_135353_(FishingCageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> CAUGHT_STACK_3 = SynchedEntityData.m_135353_(FishingCageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private UUID ownerUUID = null;
    private int damage;
    private List<ItemStack> loot = null;

    public FishingCageEntity(Level world, Player player, ItemStack stack) {
        this((EntityType<? extends Entity>)((EntityType)AoAMiscEntities.FISHING_CAGE.get()), world);
        this.m_6034_(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        this.m_19915_(player.m_146908_(), player.m_146909_());
        this.m_20256_(EntityUtil.getDirectionForFacing((Entity)player).m_82542_(0.75, 0.75, 0.75));
        this.ownerUUID = player.m_20148_();
        this.damage = stack.m_41773_();
    }

    public FishingCageEntity(EntityType<? extends Entity> entityType, Level world) {
        super(entityType, world);
        this.f_19850_ = true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.f_19853_.m_5776_() && this.ownerUUID == null || player.m_20148_().equals(this.ownerUUID)) {
            List<ItemStack> loot;
            int damage = this.damage + 1;
            ItemStack fishingCage = new ItemStack((ItemLike)AoATools.FISHING_CAGE.get());
            if (damage < fishingCage.m_41776_()) {
                fishingCage.m_41721_(damage);
                if (!player.m_7500_()) {
                    ItemUtil.givePlayerItemOrDrop(player, fishingCage);
                }
            }
            if (!(loot = this.getLoot()).isEmpty()) {
                AoAPlayerEvents.handleCustomInteraction((ServerPlayer)player, "fishing_cage_harvest", loot);
                for (ItemStack drop : loot) {
                    if (drop.m_204117_(ItemTags.f_13156_)) {
                        player.m_36222_(Stats.f_12939_, 1);
                    }
                    ItemUtil.givePlayerItemOrDrop(player, drop);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)AoATools.FISHING_CAGE.get())));
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return this.f_19853_.m_5776_() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public boolean m_6072_() {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(CAUGHT_STACK_1, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(CAUGHT_STACK_2, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(CAUGHT_STACK_3, (Object)ItemStack.f_41583_);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (this.f_19853_.m_5776_()) {
            ItemStack stack = ItemStack.f_41583_;
            if (key.equals(CAUGHT_STACK_1)) {
                stack = (ItemStack)this.m_20088_().m_135370_(CAUGHT_STACK_1);
            } else if (key.equals(CAUGHT_STACK_2)) {
                stack = (ItemStack)this.m_20088_().m_135370_(CAUGHT_STACK_2);
            } else if (key.equals(CAUGHT_STACK_3)) {
                stack = (ItemStack)this.m_20088_().m_135370_(CAUGHT_STACK_3);
            }
            if (stack != ItemStack.f_41583_) {
                if (this.loot == null) {
                    this.loot = new ArrayList<ItemStack>(3);
                }
                this.loot.add(stack);
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
        if (!this.loot.isEmpty()) {
            ListTag lootList = new ListTag();
            for (ItemStack stack : this.loot) {
                lootList.add((Object)stack.m_41739_(new CompoundTag()));
            }
            compound.m_128365_("loot", (Tag)lootList);
        }
    }

    protected void m_7378_(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
        if (compound.m_128441_("loot")) {
            ListTag lootList = compound.m_128437_("loot", 10);
            this.loot = new ArrayList<ItemStack>(Math.min(lootList.size(), 3));
            for (Tag nbt : lootList) {
                try {
                    this.loot.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)nbt)));
                }
                catch (Exception exception) {}
            }
            this.updateLootData();
        }
    }

    @Nonnull
    public List<ItemStack> getLoot() {
        return this.loot == null ? Collections.emptyList() : this.loot;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_5829_() {
        return this.f_19797_ > 1;
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19317_;
    }

    protected void doFishingCheckTick() {
        if (this.f_19853_.m_5776_() || this.ownerUUID == null) {
            return;
        }
        if (this.loot != null && this.loot.size() >= 3) {
            return;
        }
        if (!this.f_19861_ || !this.m_20069_()) {
            return;
        }
        if (RandomUtil.oneInNChance(5000)) {
            Player owner;
            FluidState fluid = this.f_19853_.m_6425_(this.m_20183_());
            Fluid fluid2 = fluid.m_76152_();
            if (!(fluid2 instanceof FlowingFluid)) {
                if (!RandomUtil.oneInNChance(3)) {
                    return;
                }
            } else {
                FlowingFluid flowingFluid = (FlowingFluid)fluid2;
                if (flowingFluid.m_7000_((BlockGetter)this.f_19853_, this.m_20183_(), fluid).m_82556_() == 0.0 && !RandomUtil.fiftyFifty()) {
                    return;
                }
            }
            if ((owner = this.f_19853_.m_46003_(this.ownerUUID)) != null) {
                LootContext.Builder lootContext = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)AoATools.FISHING_CAGE.get())).m_78972_(LootContextParams.f_81455_, (Object)this).m_78972_(LootContextParams.f_81458_, (Object)owner).m_230911_(this.f_19796_).m_78963_(2.0f + owner.m_36336_());
                LootTable lootTable = this.f_19853_.m_7654_().m_129898_().m_79217_(AdventOfAscension.id("misc/fishing_cage_catches"));
                if (this.loot == null) {
                    this.loot = new ArrayList<ItemStack>(3);
                }
                this.loot.addAll((Collection<ItemStack>)lootTable.m_230922_(lootContext.m_78975_(LootContextParamSets.f_81414_)));
                this.updateLootData();
            }
        }
    }

    protected void updateLootData() {
        SynchedEntityData data = this.m_20088_();
        if (this.loot == null || this.loot.isEmpty()) {
            data.m_135381_(CAUGHT_STACK_1, (Object)ItemStack.f_41583_);
            data.m_135381_(CAUGHT_STACK_2, (Object)ItemStack.f_41583_);
            data.m_135381_(CAUGHT_STACK_3, (Object)ItemStack.f_41583_);
        } else {
            data.m_135381_(CAUGHT_STACK_1, (Object)this.loot.get(0));
            if (this.loot.size() > 1) {
                data.m_135381_(CAUGHT_STACK_2, (Object)this.loot.get(1));
                if (this.loot.size() > 2) {
                    data.m_135381_(CAUGHT_STACK_3, (Object)this.loot.get(2));
                }
            }
        }
    }

    public void m_8119_() {
        boolean wasInWater = this.m_20069_();
        this.m_6075_();
        this.doFishingCheckTick();
        Vec3 velocity = this.m_20184_();
        double gravity = 0.08;
        if (this.m_20069_()) {
            double yPos = this.m_20186_();
            if (!wasInWater) {
                this.m_20256_(velocity.m_82542_((double)0.1f, (double)0.1f, (double)0.1f));
            }
            if (velocity.m_7098_() < (double)-0.023f) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + this.f_19796_.m_188583_() * (double)this.m_20205_() * 0.5, this.m_20186_(), this.m_20189_() + this.f_19796_.m_188583_() * (double)this.m_20205_() * 0.5, 0.0, 0.0, 0.0);
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            Vec3 motion = this.m_20184_().m_82542_((double)0.8f, (double)0.8f, (double)0.8f);
            double yVelocity = velocity.m_7098_() <= 0.0 && Math.abs(motion.m_7098_() - 0.005) >= 0.003 && Math.abs(motion.m_7098_() - gravity / 16.0) < 0.003 ? -0.003 : motion.m_7098_() - gravity / 16.0;
            Vec3 newVelocity = new Vec3(motion.m_7096_(), yVelocity, motion.m_7094_());
            this.m_20256_(newVelocity);
            if (this.f_19862_ && this.m_20229_(newVelocity.m_7096_(), newVelocity.m_7098_() + (double)0.6f - this.m_20186_() + yPos, newVelocity.m_7094_())) {
                this.m_20334_(newVelocity.m_7096_(), 0.3f, newVelocity.m_7094_());
            }
        } else {
            BlockPos feetPos = this.m_20099_();
            float blockSlipperiness = this.f_19853_.m_8055_(this.m_20099_()).getFriction((LevelReader)this.f_19853_, this.m_20099_(), (Entity)this);
            float friction = this.f_19861_ ? blockSlipperiness * 0.91f : 0.91f;
            this.m_6478_(MoverType.SELF, this.m_20184_());
            Vec3 newVelocity = this.m_20184_();
            double newYVelocity = newVelocity.m_7098_();
            if (this.f_19853_.f_46443_ && !this.f_19853_.m_46805_(feetPos)) {
                newYVelocity = this.m_20186_() > 0.0 ? -0.1 : 0.0;
            } else if (!this.m_20068_()) {
                newYVelocity -= gravity;
            }
            this.m_20334_(newVelocity.m_7096_() * (double)friction, newYVelocity * (double)0.98f, newVelocity.m_7094_() * (double)friction);
        }
        this.m_20256_(this.m_20184_().m_82542_((double)0.98f, (double)0.98f, (double)0.98f));
        if (!this.f_19853_.m_5776_()) {
            this.m_20115_(6, this.m_146886_());
        }
    }

    public void m_6075_() {
        this.f_19853_.m_46473_().m_6180_("entityBaseTick");
        this.m_20073_();
        if (!this.f_19853_.m_5776_()) {
            if (this.m_20186_() < -64.0) {
                this.m_6088_();
            }
            if (this.m_20077_()) {
                this.m_20093_();
            }
            if (this.m_6084_() && this.f_19797_ > 40 && this.f_19861_ && !this.m_20069_()) {
                ItemStack fishingCage = new ItemStack((ItemLike)AoATools.FISHING_CAGE.get());
                if (!this.getLoot().isEmpty()) {
                    ++this.damage;
                }
                fishingCage.m_41721_(this.damage);
                this.m_19983_(fishingCage);
                this.m_146870_();
            }
        }
        this.f_19853_.m_46473_().m_7238_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.m_5776_() && amount >= 1.0f) {
            this.m_5834_();
            this.m_146870_();
        }
        return true;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.f_19853_.m_5776_() && this.loot != null) {
            for (ItemStack stack : this.loot) {
                this.m_19983_(stack);
            }
        }
        super.m_142687_(reason);
    }
}

