/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.EntityRetrievalUtil;

public class CustomisableLightningBolt
extends LightningBolt {
    protected boolean doFire = true;
    protected Consumer<Entity> onEntityStrike = null;

    public CustomisableLightningBolt(EntityType<? extends CustomisableLightningBolt> entityType, Level level) {
        super(entityType, level);
    }

    public CustomisableLightningBolt(Level level, BlockPos pos) {
        this(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public CustomisableLightningBolt(Level level, double x, double y, double z) {
        this((EntityType<? extends CustomisableLightningBolt>)((EntityType)AoAMiscEntities.CUSTOMISABLE_LIGHTNING_BOLT.get()), level);
        this.m_6027_(x, y, z);
    }

    public void noFire() {
        this.doFire = false;
    }

    public void whenStrikingEntity(Consumer<Entity> consumer) {
        this.onEntityStrike = consumer;
    }

    public void m_8119_() {
        List<Entity> entities;
        this.m_6075_();
        if (this.f_20860_ == 2) {
            if (this.f_19853_.m_5776_()) {
                if (!this.m_20067_()) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f, false);
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12089_, SoundSource.WEATHER, 1.0f, 0.5f + this.f_19796_.m_188501_() * 0.2f, false);
                }
            } else {
                Difficulty difficulty = this.f_19853_.m_46791_();
                if ((difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) && this.doFire) {
                    this.m_20870_(4);
                }
                this.m_147161_();
                CustomisableLightningBolt.m_147150_((Level)this.f_19853_, (BlockPos)this.m_147162_());
                this.m_146850_(GameEvent.f_157772_);
            }
        }
        --this.f_20860_;
        if (this.f_20860_ < 0) {
            if (this.f_20861_ == 0) {
                if (this.f_19853_ instanceof ServerLevel) {
                    entities = EntityRetrievalUtil.getEntities(this.f_19853_, new AABB(this.m_20185_() - 15.0, this.m_20186_() - 15.0, this.m_20189_() - 15.0, this.m_20185_() + 15.0, this.m_20186_() + 21.0, this.m_20189_() + 15.0), new EntityPredicate((Entity)this).isAlive().notInCollection(this.f_147134_));
                    for (ServerPlayer player2 : ((ServerLevel)this.f_19853_).m_8795_(player -> player.m_20270_((Entity)this) < 256.0f)) {
                        CriteriaTriggers.f_145089_.m_153391_(player2, (LightningBolt)this, entities);
                    }
                }
                this.m_146870_();
            } else if (this.f_20860_ < -this.f_19796_.m_188503_(10)) {
                --this.f_20861_;
                this.f_20860_ = 1;
                this.f_20859_ = this.f_19796_.m_188505_();
                if (this.doFire) {
                    this.m_20870_(0);
                }
            }
        }
        if (this.f_20860_ >= 0) {
            if (!(this.f_19853_ instanceof ServerLevel)) {
                this.f_19853_.m_6580_(2);
            } else if (!this.f_20862_) {
                entities = EntityRetrievalUtil.getEntities(this.f_19853_, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 9.0, this.m_20189_() + 3.0), new EntityPredicate((Entity)this).isAlive());
                for (Entity entity : entities) {
                    if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBolt)this)) continue;
                    entity.m_8038_((ServerLevel)this.f_19853_, (LightningBolt)this);
                    if (this.onEntityStrike == null) continue;
                    this.onEntityStrike.accept(entity);
                }
                this.f_147134_.addAll(entities);
                if (this.f_20863_ != null) {
                    CriteriaTriggers.f_10554_.m_21721_(this.f_20863_, entities);
                }
            }
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

