/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class ParryStunlockTask<E extends Mob>
extends Behavior<E> {
    private int lastHitTime = 0;
    private int stunCount = 0;
    private int blockTime = 0;

    public ParryStunlockTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26382_, (Object)MemoryStatus.VALUE_PRESENT), 200);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        int lastHitTime = owner.m_21213_();
        return lastHitTime != 0 && lastHitTime >= ((Mob)owner).f_19797_ - 60;
    }

    protected void start(ServerLevel level, E owner, long gameTime) {
        this.lastHitTime = owner.m_21213_();
        this.stunCount = 1;
    }

    protected void tick(ServerLevel level, E owner, long gameTime) {
        if (owner.m_21254_()) {
            ++this.blockTime;
            LivingEntity target = owner.m_21188_();
            if (this.blockTime >= 5) {
                if (!owner.m_6274_().m_21874_(MemoryModuleType.f_26371_)) {
                    BehaviorUtils.m_22595_(owner, (LivingEntity)target);
                }
                if (owner.m_217066_(target)) {
                    owner.m_6674_(InteractionHand.MAIN_HAND);
                    owner.m_7327_((Entity)target);
                    this.m_22562_(level, (LivingEntity)owner, gameTime);
                } else if (owner.m_20096_()) {
                    Vec3 lungeVector = new Vec3(target.m_20185_() - owner.m_20185_(), 0.0, target.m_20189_() - owner.m_20189_());
                    if (lungeVector.m_82556_() > 1.0E-7) {
                        lungeVector = lungeVector.m_82541_().m_82490_(0.4);
                    }
                    owner.m_20334_(lungeVector.m_7096_(), (double)0.1f, lungeVector.m_7094_());
                }
            }
            return;
        }
        if (this.lastHitTime != owner.m_21213_()) {
            this.lastHitTime = owner.m_21213_();
            ++this.stunCount;
        }
        if (this.stunCount > 2) {
            if (!(owner.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ShieldItem)) {
                owner.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42740_));
            }
            owner.m_6672_(InteractionHand.OFF_HAND);
        }
    }

    protected boolean canStillUse(ServerLevel pLevel, E owner, long pGameTime) {
        return this.lastHitTime > ((Mob)owner).f_19797_ - 60 && owner.m_21188_() != null;
    }

    protected void stop(ServerLevel pLevel, E owner, long pGameTime) {
        this.stunCount = 0;
        this.lastHitTime = 0;
        this.blockTime = 0;
        if (owner.m_6117_()) {
            owner.m_5810_();
        }
    }
}

