/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.content.entity.brain.SmartBrainOwner;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;

public class SmartBrainHandler<T extends LivingEntity> {
    private static final HashMap<EntityType<? extends LivingEntity>, ImmutableList<MemoryModuleType<?>>> brainMemoryCache = new HashMap();
    private final T owner;
    private Brain<T> brain = null;
    private final boolean saveMemories;
    private final boolean hasDynamicTasks;

    public SmartBrainHandler(T owner) {
        this(owner, false);
    }

    public SmartBrainHandler(T owner, boolean hasDynamicTasks) {
        this(owner, false, hasDynamicTasks);
    }

    public SmartBrainHandler(T owner, boolean saveMemories, boolean hasDynamicTasks) {
        this.owner = owner;
        this.saveMemories = saveMemories;
        this.hasDynamicTasks = hasDynamicTasks;
    }

    public Brain.Provider<T> getBrainCodec() {
        if (!this.hasDynamicTasks && brainMemoryCache.containsKey(this.owner.m_6095_())) {
            return Brain.m_21923_((Collection)((Collection)brainMemoryCache.get(this.owner.m_6095_())), ((SmartBrainOwner)this.owner).getSensors());
        }
        if (this.brain != null) {
            return Brain.m_21923_((Collection)ImmutableList.copyOf(this.brain.f_21843_.keySet()), ((SmartBrainOwner)this.owner).getSensors());
        }
        ImmutableList sensors = ((SmartBrainOwner)this.owner).getSensors();
        return Brain.m_21923_(this.getMemoryList(this.compileTasks(), sensors), sensors);
    }

    public Brain<T> getBrain() {
        return this.brain;
    }

    public Brain<T> makeBrain(Dynamic<?> codecLoader) {
        ImmutableList<MemoryModuleType<?>> memories;
        if (this.brain != null && !this.saveMemories) {
            return this.brain;
        }
        ImmutableList sensors = ((SmartBrainOwner)this.owner).getSensors();
        Map<Activity, Triple<Integer, ImmutableList<? extends Behavior<? super T>>, MemoryModuleType<?>>> taskList = this.compileTasks();
        if (!this.hasDynamicTasks && brainMemoryCache.containsKey(this.owner.m_6095_())) {
            memories = brainMemoryCache.get(this.owner.m_6095_());
        } else {
            memories = this.getMemoryList(taskList, sensors);
            if (!this.hasDynamicTasks) {
                brainMemoryCache.put((EntityType<? extends LivingEntity>)this.owner.m_6095_(), memories);
            }
        }
        if (!this.saveMemories) {
            Codec brainCodec = this.emptyBrainCodec();
            this.brain = new Brain(memories, sensors, ImmutableList.of(), () -> brainCodec);
        } else {
            this.brain = Brain.m_21923_(memories, sensors).m_22073_(codecLoader);
        }
        this.sanityCheckBrainState(taskList);
        this.applyTasks(taskList);
        return this.brain;
    }

    private Codec<Brain<T>> emptyBrainCodec() {
        MutableObject brainCodec = new MutableObject();
        brainCodec.setValue((Object)Codec.unit(() -> new Brain((Collection)ImmutableList.of(), (Collection)ImmutableList.of(), ImmutableList.of(), () -> ((MutableObject)brainCodec).getValue())));
        return (Codec)brainCodec.getValue();
    }

    protected ImmutableList<MemoryModuleType<?>> getMemoryList(Map<Activity, Triple<Integer, ImmutableList<? extends Behavior<? super T>>, MemoryModuleType<?>>> taskList, ImmutableList<SensorType<? extends Sensor<? super T>>> sensors) {
        if (!this.hasDynamicTasks && brainMemoryCache.containsKey(this.owner.m_6095_())) {
            return brainMemoryCache.get(this.owner.m_6095_());
        }
        HashSet memoryTypes = new HashSet();
        taskList.forEach((key, value) -> ((ImmutableList)value.getMiddle()).forEach(task -> memoryTypes.addAll(task.f_22522_.keySet())));
        return ImmutableList.copyOf(memoryTypes);
    }

    private Map<Activity, Triple<Integer, ImmutableList<? extends Behavior<? super T>>, MemoryModuleType<?>>> compileTasks() {
        HashMap map = new HashMap();
        map.put(Activity.f_37978_, ((SmartBrainOwner)this.owner).getCoreTasks());
        map.put(Activity.f_37979_, ((SmartBrainOwner)this.owner).getIdleTasks());
        map.put(Activity.f_37988_, ((SmartBrainOwner)this.owner).getFightTasks());
        map.putAll(((SmartBrainOwner)this.owner).getAdditionalTasks());
        map.entrySet().removeIf(entry -> ((ImmutableList)((Triple)entry.getValue()).getMiddle()).isEmpty());
        return map;
    }

    private void applyTasks(Map<Activity, Triple<Integer, ImmutableList<? extends Behavior<? super T>>, MemoryModuleType<?>>> taskList) {
        for (Map.Entry<Activity, Triple<Integer, ImmutableList<Behavior<T>>, MemoryModuleType<?>>> tasksEntry : taskList.entrySet()) {
            Triple<Integer, ImmutableList<? extends Behavior<? super T>>, MemoryModuleType<?>> tasks = tasksEntry.getValue();
            if (tasks.getRight() != null) {
                this.brain.m_21895_(tasksEntry.getKey(), ((Integer)tasks.getLeft()).intValue(), (ImmutableList)tasks.getMiddle(), (MemoryModuleType)tasks.getRight());
                continue;
            }
            this.brain.m_21891_(tasksEntry.getKey(), ((Integer)tasks.getLeft()).intValue(), (ImmutableList)tasks.getMiddle());
        }
        this.brain.m_21930_(((SmartBrainOwner)this.owner).getAlwaysRunningActivities());
        this.brain.m_21944_(((SmartBrainOwner)this.owner).getDefaultActivity());
        this.brain.m_21962_();
        ((SmartBrainOwner)this.owner).handleAdditionalBrainSetup(this.brain);
    }

    private void sanityCheckBrainState(Map<Activity, Triple<Integer, ImmutableList<? extends Behavior<? super T>>, MemoryModuleType<?>>> taskList) {
        if (!FMLLoader.isProduction()) {
            for (Sensor sensor : this.brain.f_21844_.values()) {
                for (MemoryModuleType memoryType : sensor.m_7163_()) {
                    if (this.brain.f_21843_.containsKey(memoryType)) continue;
                    Logging.logMessage(Level.ERROR, "Required memory module not present in entity brain. " + ForgeRegistries.ENTITIES.getKey((Object)this.owner.m_6095_()).toString());
                }
            }
        }
    }

    public void tick() {
        ((LivingEntity)this.owner).f_19853_.m_46473_().m_6180_("SmartBrain");
        this.brain.m_21865_((ServerLevel)((LivingEntity)this.owner).f_19853_, this.owner);
        this.brain.m_21926_(((SmartBrainOwner)this.owner).getActivityPriorities());
        ((LivingEntity)this.owner).f_19853_.m_46473_().m_7238_();
        if (this.owner instanceof Mob) {
            ((Mob)this.owner).m_21561_(((Mob)this.owner).m_5448_() != null);
        }
    }
}

