/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAEntityData;
import net.tslat.aoa3.content.entity.ai.movehelper.RoamingSwimmingMovementController;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.util.DamageUtil;
import software.bernie.aoa3.geckolib3.core.IAnimatable;
import software.bernie.aoa3.geckolib3.core.manager.AnimationData;
import software.bernie.aoa3.geckolib3.core.manager.AnimationFactory;

public abstract class AoAWaterRangedMob
extends WaterAnimal
implements RangedAttackMob,
AoARangedAttacker,
Enemy,
IAnimatable {
    private final AnimationFactory animationFactory = new AnimationFactory(this);

    protected AoAWaterRangedMob(EntityType<? extends WaterAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new RoamingSwimmingMovementController((PathfinderMob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 40, 32.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 30));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.f_21364_ = (int)(5.0 + (this.m_21133_(Attributes.f_22276_) + this.m_21133_(Attributes.f_22284_) * 1.75 + this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()) * 2.0) / 10.0);
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    protected abstract float m_6431_(Pose var1, EntityDimensions var2);

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return null;
    }

    protected void m_7355_(BlockPos pos, BlockState groundBlock) {
    }

    @Nullable
    protected abstract SoundEvent getShootSound();

    protected abstract BaseMobProjectile getNewProjectileInstance();

    protected void onAttack(Entity target) {
    }

    protected void onHit(DamageSource source, float amount) {
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return AoAEntityData.SpawnConditions.DAYLIGHT_MOBS.contains(this.m_6095_()) ? 1.0f : super.m_5610_(pos, worldIn);
    }

    public boolean m_7327_(Entity target) {
        if (super.m_7327_(target)) {
            this.onAttack(target);
            return true;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            this.onHit(source, amount);
            return true;
        }
        return false;
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        boolean success;
        switch (projectile.getProjectileType()) {
            case MAGIC: {
                boolean bl = DamageUtil.dealMagicDamage((Entity)projectile, (LivingEntity)this, target, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()), false);
                break;
            }
            case GUN: {
                boolean bl = DamageUtil.dealGunDamage(target, (LivingEntity)this, projectile, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
                break;
            }
            case PHYSICAL: {
                boolean bl = DamageUtil.dealRangedDamage(target, (LivingEntity)this, (Entity)projectile, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
                break;
            }
            default: {
                boolean bl = success = target.m_6469_(DamageSource.m_19340_((Entity)projectile, (LivingEntity)this), (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
            }
        }
        if (success) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        BaseMobProjectile projectile = this.getNewProjectileInstance();
        double distanceFactorX = target.m_20185_() - this.m_20185_();
        double distanceFactorY = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - projectile.m_20186_();
        double distanceFactorZ = target.m_20189_() - this.m_20189_();
        double hyp = Math.sqrt(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ) + 0.2;
        if (this.getShootSound() != null) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getShootSound(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        projectile.m_6686_(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.f_19853_.m_46791_().m_19028_());
        this.f_19853_.m_7967_((Entity)projectile);
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
    }

    public void m_7023_(Vec3 motion) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.001, 0.0));
            }
        } else {
            super.m_7023_(motion);
        }
    }

    protected boolean m_8028_() {
        return true;
    }

    @Override
    public void registerControllers(AnimationData data) {
    }

    @Override
    public AnimationFactory getFactory() {
        return this.animationFactory;
    }
}

