/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.common.registration.AoAProfessions;
import net.tslat.aoa3.content.entity.ai.trader.TraderFaceCustomerGoal;
import net.tslat.aoa3.content.entity.ai.trader.TraderPlayerTradeGoal;
import net.tslat.aoa3.content.entity.ai.trader.TraderRestockGoal;
import net.tslat.aoa3.util.WorldUtil;
import software.bernie.aoa3.geckolib3.core.IAnimatable;
import software.bernie.aoa3.geckolib3.core.manager.AnimationData;
import software.bernie.aoa3.geckolib3.core.manager.AnimationFactory;

public abstract class AoATrader
extends Villager
implements IAnimatable {
    private final AnimationFactory animationFactory = new AnimationFactory(this);

    public AoATrader(EntityType<? extends AoATrader> entityType, Level world) {
        super(entityType, world);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 8.0f, 0.8, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new TraderPlayerTradeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new TraderFaceCustomerGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new TraderRestockGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(world, difficulty, reason, spawnData, dataTag);
        this.m_34375_(this.m_7141_().m_35565_((VillagerProfession)AoAProfessions.WANDERER.get()));
        return data;
    }

    public Brain<?> m_8075_(Dynamic<?> dynamic) {
        return this.m_5490_().m_22073_(dynamic);
    }

    public void m_35483_(ServerLevel world) {
    }

    protected void m_30232_() {
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() != Items.f_42601_ && this.m_6084_() && !this.m_35306_() && !this.m_6162_()) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.m_36220_(Stats.f_12940_);
            }
            if (!this.m_6616_().isEmpty() && !this.f_19853_.f_46443_) {
                this.m_35540_(player);
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), this.m_7141_().m_35576_());
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected void m_35540_(Player player) {
        int reputation = this.m_35532_(player);
        if (reputation != 0) {
            for (MerchantOffer offer : this.m_6616_()) {
                offer.m_45353_(-Mth.m_14143_((float)((float)reputation * offer.m_45378_())));
            }
        }
    }

    protected void m_7604_() {
        int professionLevel;
        VillagerTrades.ItemListing[] currentLevelOffers;
        Int2ObjectMap<VillagerTrades.ItemListing[]> trades = this.getTradesMap();
        if (trades != null && !trades.isEmpty() && (currentLevelOffers = (VillagerTrades.ItemListing[])trades.get(professionLevel = this.m_7141_().m_35576_())) != null) {
            this.m_35277_(this.m_6616_(), currentLevelOffers, this.getMaxTradesToUnlock(professionLevel));
        }
    }

    protected Component m_5677_() {
        return this.m_6095_().m_20676_();
    }

    public int getMaxTradesToUnlock(int newProfessionLevel) {
        return 2;
    }

    protected boolean isOverworldNPC() {
        return false;
    }

    public boolean m_21531_() {
        return false;
    }

    public int m_5792_() {
        return 1;
    }

    public SoundEvent m_7596_() {
        return null;
    }

    protected void m_8058_(MerchantOffer offer) {
        int xp = 3 + this.f_19796_.m_188503_(4);
        this.f_35362_ += offer.m_45379_();
        this.f_35375_ = this.m_7962_();
        if (this.m_35527_()) {
            this.f_35373_ = 40;
            this.f_35374_ = true;
            xp += 5;
        }
        xp = (int)((float)xp / ((float)offer.m_45373_() / 16.0f));
        if (offer.m_45383_()) {
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), xp));
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11915_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.isOverworldNPC() || !WorldUtil.isWorld(this.f_19853_, Level.f_46428_) || this.f_19797_ >= 48000;
    }

    public Villager m_142606_(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public void m_8038_(ServerLevel world, LightningBolt lightning) {
        this.m_7311_(this.m_20094_() + 1);
        if (this.m_20094_() == 0) {
            this.m_20254_(8);
        }
        this.m_6469_(DamageSource.f_19306_, 5.0f);
    }

    public void m_6667_(DamageSource cause) {
        if (cause.m_7639_() != null) {
            this.m_35420_(cause.m_7639_());
        }
        if (!(ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause) || this.m_213877_() || this.f_20890_)) {
            Entity entity = cause.m_7639_();
            LivingEntity killer = this.m_21232_();
            if (this.f_20897_ >= 0 && killer != null) {
                killer.m_5993_((Entity)this, this.f_20897_, cause);
            }
            this.f_20890_ = true;
            this.m_21231_().m_19296_();
            if (this.f_19853_ instanceof ServerLevel) {
                this.m_6668_(cause);
                this.m_21268_(killer);
            }
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_20124_(Pose.DYING);
        }
        this.m_7996_();
    }

    @Nullable
    public abstract Int2ObjectMap<VillagerTrades.ItemListing[]> getTradesMap();

    @Override
    public void registerControllers(AnimationData animationData) {
    }

    @Override
    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    public static class BuildableTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack item;
        private ItemStack cost1 = null;
        @Nullable
        private ItemStack cost2 = null;
        private int xpValue = 2;
        private float priceMultiplier = 0.05f;
        private int maxUses = 16;
        private boolean isLocked = false;

        private BuildableTrade(ItemStack item) {
            this.item = item;
        }

        public static BuildableTrade trade(RegistryObject<? extends ItemLike> item) {
            return BuildableTrade.trade(item, 1);
        }

        public static BuildableTrade trade(RegistryObject<? extends ItemLike> item, int amount) {
            return BuildableTrade.trade((ItemLike)item.get(), amount);
        }

        public static BuildableTrade trade(ItemLike item) {
            return BuildableTrade.trade(item, 1);
        }

        public static BuildableTrade trade(ItemLike item, int amount) {
            return BuildableTrade.trade(new ItemStack(item, amount));
        }

        public static BuildableTrade trade(ItemStack stack) {
            return new BuildableTrade(stack);
        }

        public BuildableTrade locked() {
            this.isLocked = true;
            this.maxUses = 0;
            return this;
        }

        public BuildableTrade cost(RegistryObject<? extends ItemLike> item) {
            return this.cost(item, 1);
        }

        public BuildableTrade cost(RegistryObject<? extends ItemLike> item, int amount) {
            return this.cost((ItemLike)item.get(), amount);
        }

        public BuildableTrade cost(ItemLike item) {
            return this.cost(item, 1);
        }

        public BuildableTrade cost(ItemLike item, int amount) {
            return this.cost(new ItemStack(item, amount));
        }

        public BuildableTrade cost(ItemStack cost) {
            if (this.cost1 == null) {
                this.cost1 = cost;
            } else if (this.cost2 == null) {
                this.cost2 = cost;
            }
            return this;
        }

        public BuildableTrade xp(int tradeXp) {
            this.xpValue = tradeXp;
            return this;
        }

        public BuildableTrade priceMultiplier(float multiplier) {
            this.priceMultiplier = multiplier;
            return this;
        }

        public BuildableTrade stock(int stock) {
            this.maxUses = stock;
            return this;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            MerchantOffer offer;
            if (this.cost2 != null) {
                offer = new MerchantOffer(this.cost1.m_41777_(), this.cost2.m_41777_(), this.item.m_41777_(), this.maxUses, this.xpValue, this.priceMultiplier);
            } else if (this.cost1 != null) {
                offer = new MerchantOffer(this.cost1.m_41777_(), this.item.m_41777_(), this.maxUses, this.xpValue, this.priceMultiplier);
            } else {
                return null;
            }
            if (this.isLocked) {
                offer.m_45381_();
            }
            return offer;
        }
    }

    public static class TradeListBuilder {
        private final HashMap<Integer, VillagerTrades.ItemListing[]> trades = new HashMap();

        public TradeListBuilder trades(int professionLevel, BuildableTrade ... offers) {
            this.trades.put(professionLevel, offers);
            return this;
        }

        public Int2ObjectMap<VillagerTrades.ItemListing[]> build() {
            return new Int2ObjectOpenHashMap(this.trades);
        }
    }
}

