/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class TelegraphedRangedAttackGoal<T extends Mob>
extends Goal {
    private final T taskOwner;
    private int attackCooldownMin = 20;
    private int attackCooldownMax = 40;
    private float speedModifier = 1.0f;
    private float attackRadius = 32.0f;
    private int preAttackTime = 0;
    public int attackCooldownTimer;
    private LivingEntity target = null;
    private int attackTime = -1;
    private int seeTime;

    public TelegraphedRangedAttackGoal(T taskOwner) {
        this.taskOwner = taskOwner;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public TelegraphedRangedAttackGoal<T> moveSpeedMod(float mod) {
        this.speedModifier = mod;
        return this;
    }

    public TelegraphedRangedAttackGoal<T> attackFrequency(int min, int max) {
        this.attackCooldownMin = min;
        this.attackCooldownMax = max;
        return this;
    }

    public TelegraphedRangedAttackGoal<T> windUpTime(int ticks) {
        this.preAttackTime = ticks;
        return this;
    }

    public TelegraphedRangedAttackGoal<T> targetRadius(float radius) {
        this.attackRadius = radius;
        return this;
    }

    public boolean m_8036_() {
        LivingEntity target = this.taskOwner.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        this.target = target;
        return true;
    }

    public void m_8056_() {
        this.attackCooldownTimer = 0;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.taskOwner.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double targetDistance = this.taskOwner.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean canSeeTarget = this.taskOwner.m_21574_().m_148306_((Entity)this.target);
        this.seeTime = canSeeTarget ? ++this.seeTime : 0;
        if (!(targetDistance > (double)this.attackRadius * (double)this.attackRadius) && this.seeTime >= 5) {
            this.taskOwner.m_21573_().m_26573_();
        } else {
            this.taskOwner.m_21573_().m_5624_((Entity)this.target, (double)this.speedModifier);
        }
        this.taskOwner.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime <= 0 && this.attackTime >= -this.preAttackTime) {
            if (!canSeeTarget) {
                return;
            }
            if (this.attackTime == 0) {
                this.taskOwner.m_6674_(InteractionHand.MAIN_HAND);
            }
            if (this.attackTime == -this.preAttackTime) {
                float distMod = (float)Math.sqrt(targetDistance) / this.attackRadius;
                float distFactor = Mth.m_14036_((float)distMod, (float)0.1f, (float)1.0f);
                ((RangedAttackMob)this.taskOwner).m_6504_(this.target, distFactor);
                this.attackTime = Mth.m_14143_((float)(distMod * (float)(this.attackCooldownMax - this.attackCooldownMin) + (float)this.attackCooldownMin));
            }
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(targetDistance) / (double)this.attackRadius), (double)this.attackCooldownMin, (double)this.attackCooldownMax));
        }
    }
}

