/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.grass;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.level.material.MaterialColor;
import net.tslat.aoa3.content.block.generation.grass.GrassBlock;

public class UpsideDownGrassBlock
extends GrassBlock {
    public UpsideDownGrassBlock(MaterialColor mapColour, Supplier<Block> dirtBlock, boolean growsInDark, boolean isStoneBased) {
        super(mapColour, dirtBlock, growsInDark, isStoneBased);
    }

    @Override
    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
    }

    @Override
    public boolean hasSufficientLight(BlockState grassState, Level world, BlockPos grassPos) {
        if (world.m_46472_() == ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("aoa3", "lelyetia"))) {
            return true;
        }
        BlockPos bottomPos = grassPos.m_7495_();
        BlockState bottomBlock = world.m_8055_(bottomPos);
        return LayerLightEngine.m_75667_((BlockGetter)world, (BlockState)grassState, (BlockPos)grassPos, (BlockState)bottomBlock, (BlockPos)bottomPos, (Direction)Direction.DOWN, (int)bottomBlock.m_60739_((BlockGetter)world, bottomPos)) < world.m_7469_();
    }

    @Override
    public boolean canStayGrass(BlockState grassState, Level world, BlockPos grassPos) {
        return this.hasSufficientLight(grassState, world, grassPos) && !world.m_6425_(grassPos.m_7495_()).m_205070_(FluidTags.f_13131_);
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!this.hasSufficientLight(state, (Level)world, pos)) {
            if (!world.isAreaLoaded(pos, 3)) {
                return;
            }
            world.m_46597_(pos, ((Block)this.soilBlock.get()).m_49966_());
        } else if (this.growsInDark == world.m_46803_(pos.m_7495_()) < 9) {
            BlockState grassState = this.m_49966_();
            for (int i = 0; i < 4; ++i) {
                BlockPos growPos = pos.m_7918_(rand.m_188503_(3) - 1, rand.m_188503_(5) - 3, rand.m_188503_(3) - 1);
                if (world.m_8055_(growPos).m_60734_() != this.soilBlock.get() || !this.canStayGrass(grassState, (Level)world, growPos)) continue;
                world.m_46597_(growPos, (BlockState)grassState.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(world.m_8055_(growPos.m_7495_()).m_60734_() == Blocks.f_50125_)));
            }
        }
    }

    @Override
    protected boolean couldBeSnowy(BlockState state, LevelAccessor worldReader, BlockPos pos) {
        BlockPos downPos = pos.m_7495_();
        BlockState bottomBlock = worldReader.m_8055_(downPos);
        if (bottomBlock.m_60713_(Blocks.f_50125_) && (Integer)bottomBlock.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (bottomBlock.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LayerLightEngine.m_75667_((BlockGetter)worldReader, (BlockState)state, (BlockPos)pos, (BlockState)bottomBlock, (BlockPos)downPos, (Direction)Direction.DOWN, (int)bottomBlock.m_60739_((BlockGetter)worldReader, downPos));
        return i < worldReader.m_7469_();
    }
}

