/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.portal;

import java.util.Collection;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.tslat.aoa3.common.particletype.PortalFloaterParticleType;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.content.block.functional.portal.PortalBlock;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.PlayerUtil;

public class NowhereActivityPortal
extends PortalBlock {
    private static final EnumProperty<Activity> ACTIVITY = EnumProperty.m_61587_((String)"activity", Activity.class);

    public NowhereActivityPortal() {
        super(AoADimensions.NOWHERE.key, MaterialColor.f_76366_, 0);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(ACTIVITY, (Comparable)((Object)Activity.UTILITY)));
    }

    @Override
    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.m_20202_() == null && !entity.m_20160_() && entity instanceof ServerPlayer) {
            if (entity.f_19818_ > 0) {
                entity.f_19818_ = 30;
                return;
            }
            entity.f_19818_ = 100;
            Activity activity = (Activity)((Object)state.m_61143_(ACTIVITY));
            BlockPos teleportPos = activity.teleportPos;
            entity.m_6021_((double)teleportPos.m_123341_(), (double)teleportPos.m_123342_(), (double)teleportPos.m_123343_());
            activity.onUse((ServerPlayer)entity);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVITY});
    }

    @Override
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        for (int i = 0; i < 4; ++i) {
            double posXStart = (float)pos.m_123341_() + rand.m_188501_();
            double posYStart = (float)pos.m_123342_() + rand.m_188501_();
            double posZStart = (float)pos.m_123343_() + rand.m_188501_();
            double motionX = ((double)rand.m_188501_() - 0.5) * 0.5;
            double motionY = ((double)rand.m_188501_() - 0.5) * 0.5;
            double motionZ = ((double)rand.m_188501_() - 0.5) * 0.5;
            int randomMod = rand.m_188503_(2) * 2 - 1;
            int colour = switch ((Activity)((Object)state.m_61143_(ACTIVITY))) {
                case Activity.PARKOUR -> 39103;
                case Activity.BOSSES -> 0xBA0000;
                case Activity.DUNGEON -> 9502944;
                case Activity.UTILITY -> 29210;
                default -> 0xFFFFFF;
            };
            if (world.m_8055_(pos.m_122024_()).m_60734_() != this && world.m_8055_(pos.m_122029_()).m_60734_() != this) {
                posXStart = (double)pos.m_123341_() + 0.5 + 0.25 * (double)randomMod;
                motionX = rand.m_188501_() * 2.0f * (float)randomMod;
            } else {
                posZStart = (double)pos.m_123343_() + 0.5 + 0.25 * (double)randomMod;
                motionZ = rand.m_188501_() * 2.0f * (float)randomMod;
            }
            world.m_7106_((ParticleOptions)new PortalFloaterParticleType.Data(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), colour), posXStart, posYStart, posZStart, motionX, motionY, motionZ);
        }
    }

    public static enum Activity implements StringRepresentable
    {
        PARKOUR(0, 202, 0, pl -> {
            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
            for (NonNullList inv : pl.m_150109_().f_35979_) {
                plData.storeItems((Collection<ItemStack>)inv);
            }
            pl.m_150109_().m_6211_();
        }),
        BOSSES(0, 202, 0),
        DUNGEON(0, 202, 0),
        UTILITY(0, 202, 0),
        RETURN(0, 202, 0, pl -> PlayerUtil.getAdventPlayer(pl).returnItemStorage());

        private final BlockPos teleportPos;
        private final Consumer<ServerPlayer> useFunction;

        private Activity(int x, @Nullable int y, int z, Consumer<ServerPlayer> useFunction) {
            this.teleportPos = new BlockPos(x, y, z);
            this.useFunction = useFunction;
        }

        private Activity(int x, int y, int z) {
            this(x, y, z, null);
        }

        public String m_7912_() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public void onUse(ServerPlayer pl) {
            if (this.useFunction != null) {
                this.useFunction.accept(pl);
            }
        }
    }
}

