/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.AoAEntityData;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.content.entity.base.AbstractLavaFishEntity;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public final class AoAEntitySpawns {
    public static void registerEntitySpawns() {
        Logging.logStatusMessage("Setting entity spawn placements");
        AoAEntitySpawns.setOverworldSpawnPlacements();
    }

    public static void setOverworldSpawnPlacements() {
        AoAEntitySpawns.placeAsMonster((EntityType<? extends Mob>)((EntityType)AoAMobs.ICE_GIANT.get()));
        AoAEntitySpawns.placeAsMonster((EntityType<? extends Mob>)((EntityType)AoAMobs.LEAFY_GIANT.get()));
        AoAEntitySpawns.placeAsMonster((EntityType<? extends Mob>)((EntityType)AoAMobs.STONE_GIANT.get()));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.SHINY_SQUID.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)GlowSquid::m_217017_));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.BLUE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CANDLEFISH.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CHARRED_CHAR.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CHOCAW.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CRIMSON_SKIPPER.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.CRIMSON_STRIPEFISH.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.DARK_HATCHETFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.GREEN_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.HYDRONE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.IRONBACK.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.JAMFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.PARAPIRANHA.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.PEARL_STRIPEFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.PURPLE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.RAINBOWFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.RAZORFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.RED_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.REEFTOOTH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.ROCKETFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.SAILBACK.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.SAPPHIRE_STRIDER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.SKELECANTH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.WHITE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.YELLOW_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.TURQUOISE_STRIPEFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawns.setSpawnPlacement((EntityType)AoAAnimals.VIOLET_SKIPPER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
    }

    private static void placeAsNpc(EntityType<? extends Mob> entityType) {
        AoAEntitySpawns.setSpawnPlacement(entityType, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.npcPredicate(false));
    }

    private static void placeAsMonster(EntityType<? extends Mob> entityType) {
        AoAEntitySpawns.setSpawnPlacement(entityType, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.MONSTER);
    }

    private static void placeAsWaterMonster(EntityType<? extends Mob> entityType) {
        AoAEntitySpawns.setSpawnPlacement(entityType, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.WATER_MONSTER);
    }

    private static void placeAsFish(EntityType<? extends Mob> entityType) {
        AoAEntitySpawns.setSpawnPlacement(entityType, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
    }

    private static <T extends Mob> void setSpawnPlacement(EntityType<T> entityType, SpawnPlacements.Type placementType, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<? extends Mob> spawnPredicate) {
        try {
            if (SpawnPlacements.m_21752_(entityType) == SpawnPlacements.Type.NO_RESTRICTIONS) {
                SpawnPlacements.m_21754_(entityType, (SpawnPlacements.Type)placementType, (Heightmap.Types)heightmap, spawnPredicate);
            }
        }
        catch (IllegalStateException ex) {
            Logging.logMessage(org.apache.logging.log4j.Level.WARN, "Caught duplicate spawn placement registration from: " + ForgeRegistries.ENTITIES.getKey(entityType).toString());
        }
    }

    private static final class SpawnPredicates {
        private static final SpawnPlacements.SpawnPredicate<Mob> MONSTER = (type, world, reason, pos, rand) -> {
            if (world.m_46791_() == Difficulty.PEACEFUL) {
                return false;
            }
            boolean isVanillaWorld = WorldUtil.isWorld(world, Level.f_46428_, Level.f_46429_);
            if (EntityUtil.isNaturalSpawnReason(reason)) {
                if (AoAEntityData.SpawnConditions.DAYLIGHT_MOBS.contains(type) && !world.m_6042_().m_63967_() && !world.m_6018_().m_46461_() && isVanillaWorld) {
                    return false;
                }
                if (AoAEntityData.SpawnConditions.SPAWN_HEIGHTS.containsKey(type) && pos.m_123342_() > AoAEntityData.SpawnConditions.SPAWN_HEIGHTS.get(type)) {
                    return false;
                }
                if (!ForgeRegistries.BIOMES.getKey((Object)((Biome)world.m_204166_(pos).m_203334_())).m_135827_().equals("aoa3") && !isVanillaWorld) {
                    return false;
                }
            }
            if (!Mob.m_217057_((EntityType)type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)rand)) {
                return false;
            }
            if (!AoAEntityData.SpawnConditions.DAYLIGHT_MOBS.contains(type) && isVanillaWorld) {
                return Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)rand);
            }
            return WorldUtil.getLightLevel(world, pos, true, false) <= RandomUtil.randomNumberUpTo(8);
        };
        private static final SpawnPlacements.SpawnPredicate<Mob> WATER_MONSTER = (type, world, reason, pos, rand) -> {
            if (world.m_46791_() == Difficulty.PEACEFUL) {
                return false;
            }
            boolean isVanillaWorld = WorldUtil.isWorld(world, Level.f_46428_, Level.f_46429_);
            if (EntityUtil.isNaturalSpawnReason(reason)) {
                if (world.m_6018_().m_46461_() ? !AoAEntityData.SpawnConditions.DAYLIGHT_MOBS.contains(type) && !world.m_6042_().m_63967_() && isVanillaWorld : !world.m_6042_().m_63967_() && !world.m_6018_().m_46472_().m_135782_().m_135827_().equals("aoa3") && AoAEntityData.SpawnConditions.DAYLIGHT_MOBS.contains(type)) {
                    return false;
                }
                if (AoAEntityData.SpawnConditions.SPAWN_HEIGHTS.containsKey(type) && pos.m_123342_() > AoAEntityData.SpawnConditions.SPAWN_HEIGHTS.get(type)) {
                    return false;
                }
                if (!ForgeRegistries.BIOMES.getKey((Object)((Biome)world.m_204166_(pos).m_203334_())).m_135827_().equals("aoa3") && !isVanillaWorld) {
                    return false;
                }
            }
            if (!world.m_8055_(pos).m_60819_().m_76152_().m_205067_(FluidTags.f_13131_)) {
                return false;
            }
            if (!AoAEntityData.SpawnConditions.DAYLIGHT_MOBS.contains(type) && isVanillaWorld) {
                return Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)rand);
            }
            return WorldUtil.getLightLevel(world, pos, true, false) <= RandomUtil.randomNumberUpTo(8);
        };
        private static final SpawnPlacements.SpawnPredicate<Mob> FISH = (type, world, reason, pos, rand) -> world.m_8055_(pos).m_60713_(Blocks.f_49990_) && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);

        private SpawnPredicates() {
        }

        private static final SpawnPlacements.SpawnPredicate<Mob> npcPredicate(boolean spawnsInDarkness) {
            return (type, world, reason, pos, rand) -> {
                if (!Mob.m_217057_((EntityType)type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)rand)) {
                    return false;
                }
                return spawnsInDarkness || WorldUtil.getLightLevel(world, pos, false, false) >= 8;
            };
        }

        private static <T extends Mob> SpawnPlacements.SpawnPredicate<T> animalPredicate(@Nullable TagKey<Block> blockTag, boolean spawnsInDarkness) {
            return (type, world, reason, pos, rand) -> {
                if (blockTag != null && !world.m_8055_(pos.m_7495_()).m_204336_(blockTag)) {
                    return false;
                }
                return spawnsInDarkness || world.m_45524_(pos, 0) >= 8;
            };
        }
    }
}

