/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.client.gui.hud.XpParticlesRenderer;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.player.skill.AoASkill;

public class XpGainPacket
implements AoAPacket {
    private final ResourceLocation skillId;
    private final float xp;
    private final boolean levelUp;

    public XpGainPacket(ResourceLocation skillId, float xp, boolean isLevelUp) {
        this.skillId = skillId;
        this.xp = xp;
        this.levelUp = isLevelUp;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.skillId);
        buffer.writeFloat(this.xp);
        buffer.writeBoolean(this.levelUp);
    }

    public static XpGainPacket decode(FriendlyByteBuf buffer) {
        return new XpGainPacket(buffer.m_130281_(), buffer.readFloat(), buffer.readBoolean());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        AoASkill skill;
        if (((Boolean)AoAConfig.CLIENT.showXpParticles.get()).booleanValue() && (skill = AoASkills.getSkill(this.skillId)) != null) {
            XpParticlesRenderer.addXpParticle(skill, this.xp, this.levelUp);
        }
        context.get().setPacketHandled(true);
    }
}

