/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.util.AoAHaloUtil;
import org.apache.logging.log4j.Level;

public class HaloChangePacket
implements AoAPacket {
    private final String haloChoice;

    public HaloChangePacket(@Nonnull AoAHaloUtil.Type.Choosable haloChoice) {
        this.haloChoice = haloChoice.toString();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.haloChoice);
    }

    public static HaloChangePacket decode(FriendlyByteBuf buffer) {
        return new HaloChangePacket(AoAHaloUtil.Type.Choosable.valueOf(buffer.m_130136_(Short.MAX_VALUE)));
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        AoAHaloUtil.Type preferredHalo = AoAHaloUtil.Type.Donator;
        try {
            preferredHalo = AoAHaloUtil.Type.Choosable.valueOf(this.haloChoice).toBaseType();
        }
        catch (IllegalArgumentException e) {
            Logging.logMessage(Level.WARN, "Error parsing halo info from client: " + this.haloChoice);
        }
        ServerPlayer sender = context.get().getSender();
        if (sender != null) {
            AoAHaloUtil.syncNewHaloChoice(sender.m_36316_().getId(), preferredHalo);
        } else {
            Logging.logMessage(Level.WARN, "No sender assigned to received PacketChangedHalo, skipping");
        }
        context.get().setPacketHandled(true);
    }
}

