/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class AddSkillCyclePacket
implements AoAPacket {
    private final AoASkill skill;

    public AddSkillCyclePacket(ResourceLocation skillId) {
        this.skill = AoASkills.getSkill(skillId);
    }

    public AddSkillCyclePacket(AoASkill skill) {
        this.skill = skill;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.skill == null ? new ResourceLocation("", "") : AoARegistries.AOA_SKILLS.getId(this.skill));
    }

    public static AddSkillCyclePacket decode(FriendlyByteBuf buffer) {
        return new AddSkillCyclePacket(buffer.m_130281_());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        if (this.skill != null) {
            context.get().enqueueWork(() -> PlayerUtil.getAdventPlayer(((NetworkEvent.Context)context.get()).getSender()).getSkill(this.skill).addCycle());
        }
        context.get().setPacketHandled(true);
    }
}

