/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.aoa3.common.registration.AoAContainers;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.content.recipe.InfusionRecipe;
import net.tslat.aoa3.event.custom.AoAEvents;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class InfusionTableContainer
extends AbstractContainerMenu {
    private final InfusionInventory inputs = new InfusionInventory(this);
    private final ResultContainer output = new ResultContainer();
    private final ContainerLevelAccess functionCaller;
    private final Player player;

    public InfusionTableContainer(int id, Inventory plInventory, ContainerLevelAccess functionCaller) {
        super((MenuType)AoAContainers.INFUSION_TABLE.get(), id);
        this.functionCaller = functionCaller;
        this.player = plInventory.f_35978_;
        this.m_38897_(new SlotCraftingMod(this.player, this.inputs, this.output, 0, 139, 35){

            @Override
            protected void m_5845_(ItemStack stack) {
                InfusionRecipe recipe;
                if (!InfusionTableContainer.this.player.f_19853_.f_46443_ && (recipe = (InfusionRecipe)((ResultContainer)this.f_40218_).m_7928_()) != null && recipe.getMaxXp() > 0) {
                    if (recipe.getMinXp() == recipe.getMaxXp()) {
                        InfusionTableContainer.this.applyRecipeXp((ServerPlayer)InfusionTableContainer.this.player, recipe.getMinXp());
                    } else {
                        InfusionTableContainer.this.applyRecipeXp((ServerPlayer)InfusionTableContainer.this.player, recipe.getMinXp() + InfusionTableContainer.this.player.m_217043_().m_188503_(recipe.getMaxXp() - recipe.getMinXp()));
                    }
                }
                super.m_5845_(stack);
            }
        });
        this.m_38897_(new Slot((Container)this.inputs, 0, 17, 35));
        for (int matrixY = 0; matrixY < 3; ++matrixY) {
            for (int matrixX = 0; matrixX < 3; ++matrixX) {
                this.m_38897_(new Slot((Container)this.inputs, 1 + matrixX + matrixY * 3, 45 + matrixX * 18, 17 + matrixY * 18));
            }
        }
        for (int inventoryY = 0; inventoryY < 3; ++inventoryY) {
            for (int inventoryX = 0; inventoryX < 9; ++inventoryX) {
                this.m_38897_(new Slot((Container)plInventory, inventoryX + inventoryY * 9 + 9, 8 + inventoryX * 18, 84 + inventoryY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)plInventory, hotbarSlot, 8 + hotbarSlot * 18, 142));
        }
    }

    public void m_6199_(Container inventory) {
        this.functionCaller.m_39292_((world, pos) -> this.slotChangedCraftingGrid((Level)world, this.player, this.inputs, this.output));
    }

    public boolean m_6875_(Player player) {
        return InfusionTableContainer.m_38889_((ContainerLevelAccess)this.functionCaller, (Player)player, (Block)((Block)AoABlocks.INFUSION_TABLE.get()));
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.functionCaller.m_39292_((world, pos) -> this.m_150411_(player, (Container)this.inputs));
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.output && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index == 0) {
                this.functionCaller.m_39292_((world, pos) -> slotStack.m_41720_().m_7836_(slotStack, player.f_19853_, player));
                if (!this.m_38903_(slotStack, 11, 47, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, stack);
            } else if (index >= 11 && index < 38 ? !this.m_38903_(slotStack, 1, 11, false) && !this.m_38903_(slotStack, 38, 47, false) : (index >= 38 && index < 47 ? !this.m_38903_(slotStack, 1, 11, false) && !this.m_38903_(slotStack, 11, 38, false) : !this.m_38903_(slotStack, 11, 47, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
            if (index == 0) {
                player.m_36176_(slotStack, false);
            }
        }
        return stack;
    }

    public static void openContainer(ServerPlayer player, final BlockPos pos) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"container.aoa3.infusion_table");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                return new InfusionTableContainer(windowId, inv, ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)pos));
            }
        }, (BlockPos)pos);
    }

    protected void slotChangedCraftingGrid(Level world, Player player, InfusionInventory inv, ResultContainer craftResult) {
        if (!world.f_46443_) {
            InfusionRecipe matchedRecipe;
            ItemStack resultStack = ItemStack.f_41583_;
            Optional recipeMatch = world.m_7654_().m_129894_().m_44015_((RecipeType)AoARecipes.INFUSION.type().get(), (Container)inv, world);
            if (recipeMatch.isPresent() && ((matchedRecipe = (InfusionRecipe)recipeMatch.get()).m_5598_() || !world.m_46469_().m_46207_(GameRules.f_46151_) || ((ServerPlayer)player).m_8952_().m_12709_((Recipe)matchedRecipe)) && (player.m_7500_() || PlayerUtil.doesPlayerHaveLevel((Player)((ServerPlayer)player), (AoASkill)AoASkills.IMBUING.get(), matchedRecipe.getInfusionReq()))) {
                craftResult.m_6029_((Recipe)matchedRecipe);
                resultStack = matchedRecipe.assemble(inv);
            }
            craftResult.m_6836_(0, resultStack);
            if (AoAEvents.firePlayerCraftingEvent(player, craftResult.m_8020_(0), inv, craftResult)) {
                craftResult.m_6836_(0, ItemStack.f_41583_);
            }
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, resultStack));
        }
    }

    private void applyRecipeXp(ServerPlayer player, float xp) {
        PlayerUtil.giveXpToPlayer(player, (AoASkill)AoASkills.IMBUING.get(), xp, false);
    }

    public static class InfusionInventory
    extends CraftingContainer {
        private final NonNullList<ItemStack> stackList = NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_);
        private final AbstractContainerMenu eventListener;

        public InfusionInventory(AbstractContainerMenu eventHandler) {
            super(eventHandler, 0, 0);
            this.eventListener = eventHandler;
        }

        public int m_6643_() {
            return 10;
        }

        public boolean m_7983_() {
            for (ItemStack stack : this.stackList) {
                if (stack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int index) {
            return index >= this.m_6643_() || index < 0 ? ItemStack.f_41583_ : (ItemStack)this.stackList.get(index);
        }

        public ItemStack m_8016_(int index) {
            return ContainerHelper.m_18966_(this.stackList, (int)index);
        }

        public ItemStack m_7407_(int index, int count) {
            ItemStack stack = ContainerHelper.m_18969_(this.stackList, (int)index, (int)count);
            if (!stack.m_41619_()) {
                this.eventListener.m_6199_((Container)this);
            }
            return stack;
        }

        public void m_6836_(int index, ItemStack stack) {
            this.stackList.set(index, (Object)stack);
            this.eventListener.m_6199_((Container)this);
        }

        public void m_6211_() {
            this.stackList.clear();
        }

        public void m_5809_(StackedContents recipeItemHelper) {
            for (ItemStack stack : this.stackList) {
                recipeItemHelper.m_36491_(stack);
            }
        }
    }

    public static class SlotCraftingMod
    extends Slot {
        private final InfusionInventory craftInv;
        private final Player player;
        private int amountCrafted;

        public SlotCraftingMod(Player pl, InfusionInventory craftInv, ResultContainer inv, int slotIndex, int xPos, int yPos) {
            super((Container)inv, slotIndex, xPos, yPos);
            this.player = pl;
            this.craftInv = craftInv;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public ItemStack m_6201_(int amount) {
            if (this.m_6657_()) {
                this.amountCrafted += Math.min(amount, this.m_7993_().m_41613_());
            }
            return super.m_6201_(amount);
        }

        protected void m_7169_(ItemStack stack, int amount) {
            this.amountCrafted += amount;
            this.m_5845_(stack);
        }

        protected void m_6405_(int amount) {
            this.amountCrafted += amount;
        }

        protected void m_5845_(ItemStack stack) {
            if (this.amountCrafted > 0) {
                stack.m_41678_(this.player.f_19853_, this.player, this.amountCrafted);
                ForgeEventFactory.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, (Container)this.craftInv);
            }
            this.amountCrafted = 0;
            ((ResultContainer)this.f_40218_).m_6029_(null);
        }

        public void m_142406_(Player player, ItemStack stack) {
            this.m_5845_(stack);
            ForgeHooks.setCraftingPlayer((Player)player);
            NonNullList remainingItems = player.f_19853_.m_7465_().m_44069_((RecipeType)AoARecipes.INFUSION.type().get(), (Container)this.craftInv, player.f_19853_);
            ForgeHooks.setCraftingPlayer(null);
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack slotStack = this.craftInv.m_8020_(i);
                ItemStack remainingItem = (ItemStack)remainingItems.get(i);
                if (!slotStack.m_41619_()) {
                    this.craftInv.m_7407_(i, 1);
                    slotStack = this.craftInv.m_8020_(i);
                }
                if (remainingItem.m_41619_()) continue;
                if (slotStack.m_41619_()) {
                    this.craftInv.m_6836_(i, remainingItem);
                    continue;
                }
                if (ItemStack.m_41746_((ItemStack)slotStack, (ItemStack)remainingItem) && ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)remainingItem)) {
                    remainingItem.m_41769_(slotStack.m_41613_());
                    this.craftInv.m_6836_(i, remainingItem);
                    continue;
                }
                if (player.m_150109_().m_36054_(remainingItem)) continue;
                player.m_36176_(remainingItem, false);
            }
        }
    }
}

