/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.aoa3.common.registration.AoAContainers;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.recipe.UpgradeKitRecipe;

public class DivineStationContainer
extends AbstractContainerMenu {
    public DivineStationInventory inputs = new DivineStationInventory(this);
    public ResultContainer output = new ResultContainer();
    private final ContainerLevelAccess functionCaller;
    private final Player player;

    public DivineStationContainer(int id, Inventory inventory) {
        this(id, inventory, ContainerLevelAccess.f_39287_);
    }

    public DivineStationContainer(int screenId, Inventory plInventory, ContainerLevelAccess functionCaller) {
        super((MenuType)AoAContainers.DIVINE_STATION.get(), screenId);
        this.functionCaller = functionCaller;
        this.player = plInventory.f_35978_;
        this.m_38897_((Slot)new ResultSlot(this.player, (CraftingContainer)this.inputs, (Container)this.output, 0, 134, 23));
        this.m_38897_(new Slot((Container)this.inputs, 0, 27, 23));
        this.m_38897_(new Slot((Container)this.inputs, 1, 76, 23));
        for (int inventoryY = 0; inventoryY < 3; ++inventoryY) {
            for (int inventoryX = 0; inventoryX < 9; ++inventoryX) {
                this.m_38897_(new Slot((Container)plInventory, inventoryX + inventoryY * 9 + 9, 8 + inventoryX * 18, 60 + inventoryY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)plInventory, hotbarSlot, 8 + hotbarSlot * 18, 118));
        }
    }

    public void m_6199_(Container inventory) {
        this.functionCaller.m_39292_((world, pos) -> this.slotChangedCraftingGrid((Level)world, this.player, this.inputs, this.output));
    }

    public boolean m_6875_(Player player) {
        return DivineStationContainer.m_38889_((ContainerLevelAccess)this.functionCaller, (Player)player, (Block)((Block)AoABlocks.DIVINE_STATION.get()));
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.functionCaller.m_39292_((world, pos) -> this.m_150411_(player, (Container)this.inputs));
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.output && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index == 0) {
                this.functionCaller.m_39292_((world, pos) -> slotStack.m_41720_().m_7836_(slotStack, player.f_19853_, player));
                if (!this.m_38903_(slotStack, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, stack);
            } else if (index > 2 ? index < 39 && !this.m_38903_(slotStack, 1, 3, false) : !this.m_38903_(slotStack, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
            if (index == 0) {
                player.m_36176_(slotStack, false);
            }
        }
        return stack;
    }

    protected void slotChangedCraftingGrid(Level world, Player player, DivineStationInventory inv, ResultContainer craftResult) {
        if (!world.f_46443_) {
            UpgradeKitRecipe recipe;
            ItemStack resultStack = ItemStack.f_41583_;
            Optional recipeMatch = world.m_7654_().m_129894_().m_44015_((RecipeType)AoARecipes.UPGRADE_KIT.type().get(), (Container)inv, world);
            if (recipeMatch.isPresent() && ((recipe = (UpgradeKitRecipe)recipeMatch.get()).m_5598_() || !world.m_46469_().m_46207_(GameRules.f_46151_) || ((ServerPlayer)player).m_8952_().m_12709_((Recipe)recipe))) {
                craftResult.m_6029_((Recipe)recipe);
                resultStack = recipe.assemble(inv);
            }
            craftResult.m_6836_(0, resultStack);
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, resultStack));
        }
    }

    public static void openContainer(ServerPlayer player, final BlockPos pos) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"container.aoa3.divine_station");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                return new DivineStationContainer(windowId, inv, ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)pos));
            }
        }, (BlockPos)pos);
    }

    public static class DivineStationInventory
    extends CraftingContainer {
        private final NonNullList<ItemStack> stackList = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        private final AbstractContainerMenu eventListener;

        public DivineStationInventory(AbstractContainerMenu container) {
            super(container, 0, 0);
            this.eventListener = container;
        }

        public int m_6643_() {
            return 2;
        }

        public boolean m_7983_() {
            for (ItemStack stack : this.stackList) {
                if (stack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int index) {
            return index >= this.m_6643_() || index < 0 ? ItemStack.f_41583_ : (ItemStack)this.stackList.get(index);
        }

        public ItemStack m_8016_(int index) {
            return ContainerHelper.m_18966_(this.stackList, (int)index);
        }

        public ItemStack m_7407_(int index, int count) {
            ItemStack stack = ContainerHelper.m_18969_(this.stackList, (int)index, (int)count);
            if (!stack.m_41619_()) {
                this.eventListener.m_6199_((Container)this);
            }
            return stack;
        }

        public void m_6836_(int index, ItemStack stack) {
            this.stackList.set(index, (Object)stack);
            this.eventListener.m_6199_((Container)this);
        }

        public void m_6211_() {
            this.stackList.clear();
        }

        public void m_5809_(StackedContents recipeItemHelper) {
            for (ItemStack stack : this.stackList) {
                recipeItemHelper.m_36491_(stack);
            }
        }
    }
}

