/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.registration.AoAContainers;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.npc.trader.CorruptedTravellerEntity;
import net.tslat.aoa3.util.ItemUtil;

public class CorruptedTravellerContainer
extends AbstractContainerMenu {
    private final Container input;
    public final CorruptedTravellerEntity traveller;
    private final Player player;
    private boolean handledFood = false;

    public CorruptedTravellerContainer(int screenId, Inventory playerInventory) {
        this(screenId, playerInventory, null);
    }

    public CorruptedTravellerContainer(int screenId, Inventory playerInventory, CorruptedTravellerEntity traveller) {
        super((MenuType)AoAContainers.CORRUPTED_TRAVELLER.get(), screenId);
        this.traveller = traveller;
        this.player = playerInventory.f_35978_;
        this.input = new SimpleContainer(1){

            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_().m_41473_() != null;
            }
        };
        this.m_38897_(new Slot(this.input, 0, 80, 34){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_().m_41473_() != null;
            }

            public void m_6654_() {
                super.m_6654_();
                if (this.m_6657_()) {
                    CorruptedTravellerContainer.this.handleFoodInput();
                }
            }
        });
        for (int inventoryY = 0; inventoryY < 3; ++inventoryY) {
            for (int inventoryX = 0; inventoryX < 9; ++inventoryX) {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), inventoryX + inventoryY * 9 + 9, 8 + inventoryX * 18, 65 + inventoryY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)this.player.m_150109_(), hotbarSlot, 8 + hotbarSlot * 18, 123));
        }
    }

    private void handleFoodInput() {
        if (!this.handledFood) {
            ItemStack stack = ((Slot)this.f_38839_.get((int)0)).f_40218_.m_8020_(0);
            if (!stack.m_41619_() && stack.m_41720_().m_41473_() != null) {
                ItemUtil.givePlayerItemOrDrop(this.player, new ItemStack((ItemLike)AoAItems.WORN_BOOK.get()));
                stack.m_41774_(1);
            }
            this.handledFood = true;
        } else {
            this.handledFood = false;
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.f_19853_.f_46443_) {
            this.m_150411_(player, this.input);
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index != 0) {
                if (index < 28) {
                    if (!this.m_38903_(slotStack, 28, 36, true)) {
                        return ItemStack.f_41583_;
                    }
                    slot.m_40234_(slotStack, stack);
                } else if (index < 37 && !this.m_38903_(slotStack, 1, 27, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(slotStack, 1, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return stack;
    }

    public boolean m_6875_(Player player) {
        return this.traveller != null && this.traveller.m_6084_() && this.player.m_20280_((Entity)this.traveller) <= 64.0;
    }
}

