/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.registration.AoAContainers;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.npc.banker.AoABanker;

public class BankerContainer
extends AbstractContainerMenu {
    private final Container inputs;
    private final Container outputs;
    public final AoABanker banker;
    private final Player player;

    public BankerContainer(int screenId, Inventory playerInventory) {
        this(screenId, playerInventory, null);
    }

    public BankerContainer(int screenId, Inventory playerInventory, AoABanker banker) {
        super((MenuType)AoAContainers.BANKER.get(), screenId);
        int i;
        this.player = playerInventory.f_35978_;
        this.banker = banker;
        this.inputs = new SimpleContainer(6){

            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() == BankerContainer.getCoinForSlot(index);
            }
        };
        this.outputs = new SimpleContainer(6){

            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() == BankerContainer.getCoinForSlot(index + 6);
            }
        };
        for (i = 0; i < 6; ++i) {
            this.m_38897_(new Slot(this.inputs, i, i < 3 ? 15 : 101, 28 + i % 3 * 23){

                public boolean m_5857_(ItemStack stack) {
                    return stack.m_41720_() == BankerContainer.getCoinForSlot(this.getSlotIndex());
                }

                public void m_6654_() {
                    super.m_6654_();
                    BankerContainer.this.updateOutput(this.getSlotIndex());
                }
            });
        }
        for (i = 0; i < 6; ++i) {
            this.m_38897_(new Slot(this.outputs, i, i < 3 ? 58 : 144, 28 + i % 3 * 23){

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }

                public boolean m_8010_(Player playerIn) {
                    return this.m_6657_();
                }

                public void m_142406_(Player thePlayer, ItemStack stack) {
                    BankerContainer.this.inputs.m_8020_(this.getSlotIndex()).m_41774_(this.getSlotIndex() < 3 ? 20 : 1);
                    BankerContainer.this.updateOutput(this.getSlotIndex());
                }
            });
        }
        for (int inventoryY = 0; inventoryY < 3; ++inventoryY) {
            for (int inventoryX = 0; inventoryX < 9; ++inventoryX) {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), inventoryX + inventoryY * 9 + 9, 8 + inventoryX * 18, 105 + inventoryY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)this.player.m_150109_(), hotbarSlot, 8 + hotbarSlot * 18, 163));
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.f_19853_.f_46443_) {
            this.m_150411_(player, this.inputs);
        }
    }

    protected void updateOutput(int index) {
        ItemStack slotStack = this.inputs.m_8020_(index);
        if (!(slotStack.m_41619_() || index < 3 && slotStack.m_41613_() < 20)) {
            this.outputs.m_6836_(index, new ItemStack((ItemLike)BankerContainer.getCoinForSlot(index + 6), index < 3 ? 1 : 20));
        } else {
            this.outputs.m_6836_(index, ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index < 12) {
                if (!this.m_38903_(slotStack, 12, 47, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                for (int i = 0; i < 6 && !slotStack.m_41619_(); ++i) {
                    Slot slot2 = (Slot)this.f_38839_.get(i);
                    if (!slot2.m_6657_() || slot2.m_7993_().m_41720_() != slotStack.m_41720_()) continue;
                    this.m_38903_(slotStack, i, i + 1, false);
                }
                if (!slotStack.m_41619_() && (index < 39 ? !this.m_38903_(slotStack, 39, 47, true) : !this.m_38903_(slotStack, 12, 38, false))) {
                    return ItemStack.f_41583_;
                }
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return stack;
    }

    public boolean m_6875_(Player player) {
        return this.banker != null && this.banker.m_6084_() && this.player.m_20280_((Entity)this.banker) <= 64.0;
    }

    public static Item getCoinForSlot(int index) {
        return switch (index) {
            case 0, 9 -> (Item)AoAItems.COPPER_COIN.get();
            case 1, 3, 6, 10 -> (Item)AoAItems.SILVER_COIN.get();
            case 2, 4, 7, 11 -> (Item)AoAItems.GOLD_COIN.get();
            case 5, 8 -> (Item)AoAItems.LUNAVER_COIN.get();
            default -> Items.f_41852_;
        };
    }
}

