/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RenderUtil;

public interface AoASkillRenderer {
    public static final ResourceLocation SKILL_ICON_BASE = new ResourceLocation("aoa3", "textures/gui/aoaskill/skill_icon_base.png");
    public static final AoASkillRenderer DEFAULT = new AoASkillRenderer(){

        @Override
        public void renderInHud(PoseStack matrix, AoASkill.Instance skill, float partialTicks, ProgressRenderType progressRenderType, boolean renderLevel) {
            matrix.m_85836_();
            matrix.m_85841_(0.5f, 0.5f, 0.0f);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            int renderWidth = this.hudRenderWidth(skill) * 2;
            int renderHeight = this.hudRenderHeight(skill) * 2;
            int level = skill.getLevel(true);
            RenderSystem.m_157456_((int)0, (ResourceLocation)SKILL_ICON_BASE);
            RenderUtil.renderScaledCustomSizedTexture(matrix, 0.0f, 0.0f, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth * 4, renderHeight * 2);
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation(AoARegistries.AOA_SKILLS.getId(skill.type()).m_135827_(), "textures/gui/aoaskill/" + AoARegistries.AOA_SKILLS.getId(skill.type()).m_135815_() + ".png"));
            RenderUtil.renderScaledCustomSizedTexture(matrix, 0.0f, 0.0f, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth, renderHeight);
            RenderSystem.m_157456_((int)0, (ResourceLocation)SKILL_ICON_BASE);
            if (level == 1000) {
                RenderUtil.renderScaledCustomSizedTexture(matrix, 0.0f, 0.0f, renderWidth * 3, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth * 4, renderHeight * 2);
            } else {
                float percentComplete = (float)PlayerUtil.getLevelProgressPercentage(skill.getLevel(true), skill.getXp()) / 100.0f;
                RenderUtil.renderScaledCustomSizedTexture(matrix, 0.0f, 0.0f, renderWidth, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth * 4, renderHeight * 2);
                switch (progressRenderType) {
                    case Ring: {
                        RenderUtil.renderScaledCustomSizedTexture(matrix, 0.0f, (float)renderHeight - percentComplete * (float)renderHeight, renderWidth * 2, (float)renderHeight - percentComplete * (float)renderHeight, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth * 4, renderHeight * 2);
                        break;
                    }
                    case Percent: {
                        String percentMessage = NumberUtil.roundToNthDecimalPlace(percentComplete * 100.0f, 0) + "%";
                        int n = (int)((float)renderWidth - (float)fontRenderer.m_92895_(percentMessage) * 1.5f);
                        float f = renderHeight;
                        Objects.requireNonNull(fontRenderer);
                        RenderUtil.drawScaledString(matrix, fontRenderer, percentMessage, n, (int)(f - 9.0f * 1.5f), 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
                        break;
                    }
                    case Bar: {
                        RenderUtil.renderScaledCustomSizedTexture(matrix, 0.0f, renderHeight - 10, 0.0f, 50.0f, 100.0f, 20.0f, renderWidth, 10.0f, renderWidth * 4, renderHeight * 2);
                        RenderUtil.renderScaledCustomSizedTexture(matrix, 0.0f, renderHeight - 10, 0.0f, 70.0f, percentComplete * 100.0f, 20.0f, percentComplete * (float)renderWidth, 10.0f, renderWidth * 4, renderHeight * 2);
                        break;
                    }
                }
            }
            if (renderLevel) {
                RenderUtil.drawScaledString(matrix, fontRenderer, String.valueOf(level), (int)((float)renderWidth - (float)fontRenderer.m_92895_(String.valueOf(level)) * 1.5f), 1, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
                if (skill.getCycles() > 0) {
                    RenderUtil.drawScaledString(matrix, fontRenderer, String.valueOf(skill.getCycles()), 0, 1, 1.5f, ColourUtil.RGB(252, 170, 0), RenderUtil.StringRenderType.OUTLINED);
                }
            }
            matrix.m_85849_();
        }

        @Override
        public void renderInGui(PoseStack matrix, AoASkill.Instance skill, float partialTicks, int mouseX, int mouseY, ProgressRenderType progressRenderType, boolean renderLevel) {
            this.renderInHud(matrix, skill, partialTicks, progressRenderType, renderLevel);
        }
    };

    public void renderInHud(PoseStack var1, AoASkill.Instance var2, float var3, ProgressRenderType var4, boolean var5);

    public void renderInGui(PoseStack var1, AoASkill.Instance var2, float var3, int var4, int var5, ProgressRenderType var6, boolean var7);

    default public int hudRenderWidth(AoASkill.Instance skill) {
        return 25;
    }

    default public int hudRenderHeight(AoASkill.Instance skill) {
        return 25;
    }

    default public int guiRenderWidth(AoASkill.Instance skill) {
        return 25;
    }

    default public int guiRenderHeight(AoASkill.Instance skill) {
        return 25;
    }

    public static enum ProgressRenderType {
        Ring,
        Bar,
        Percent,
        None;

    }
}

