/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.aoa3.geckolib3.core.IAnimatable;
import software.bernie.aoa3.geckolib3.core.PlayState;
import software.bernie.aoa3.geckolib3.core.builder.AnimationBuilder;
import software.bernie.aoa3.geckolib3.core.controller.AnimationController;

public final class AoAAnimations {
    public static final AnimationBuilder IDLE = new AnimationBuilder().addAnimation("misc.idle", true);
    public static final AnimationBuilder RECOVER = new AnimationBuilder().addAnimation("misc.rest", false);
    public static final AnimationBuilder EAT = new AnimationBuilder().addAnimation("misc.eat", false);
    public static final AnimationBuilder SUCCEED = new AnimationBuilder().addAnimation("misc.succeed", false);
    public static final AnimationBuilder SPAWN = new AnimationBuilder().addAnimation("misc.spawn", false);
    public static final AnimationBuilder INTERACT = new AnimationBuilder().addAnimation("misc.interact", false).addAnimation("misc.interact.hold", true);
    public static final AnimationBuilder INTERACT_END = new AnimationBuilder().addAnimation("misc.interact.end", false);
    public static final AnimationBuilder WALK = new AnimationBuilder().addAnimation("move.walk", true);
    public static final AnimationBuilder RUN = new AnimationBuilder().addAnimation("move.run", true);
    public static final AnimationBuilder FLY = new AnimationBuilder().addAnimation("move.fly", true);
    public static final AnimationBuilder SWIM = new AnimationBuilder().addAnimation("move.swim", true);
    public static final AnimationBuilder ATTACK_SWING = new AnimationBuilder().addAnimation("attack.swing", false);
    public static final AnimationBuilder ATTACK_THROW = new AnimationBuilder().addAnimation("attack.throw", false);
    public static final AnimationBuilder ATTACK_BITE = new AnimationBuilder().addAnimation("attack.bite", false);
    public static final AnimationBuilder ATTACK_SLAM = new AnimationBuilder().addAnimation("attack.slam", false);
    public static final AnimationBuilder ATTACK_STOMP = new AnimationBuilder().addAnimation("attack.stomp", false);
    public static final AnimationBuilder ATTACK_STRIKE = new AnimationBuilder().addAnimation("attack.strike", false);
    public static final AnimationBuilder ATTACK_SPIN = new AnimationBuilder().addAnimation("attack.spin", false);
    public static final AnimationBuilder ATTACK_FLYING_BITE = new AnimationBuilder().addAnimation("attack.midair_bite", false);
    public static final AnimationBuilder ATTACK_SHOOT = new AnimationBuilder().addAnimation("attack.shoot", false);
    public static final AnimationBuilder ATTACK_BLOCK = new AnimationBuilder().addAnimation("attack.block", false).addAnimation("attack.block.hold", true);
    public static final AnimationBuilder ATTACK_SWIPE_LEFT = new AnimationBuilder().addAnimation("attack.swipe_left", false);
    public static final AnimationBuilder ATTACK_SWIPE_RIGHT = new AnimationBuilder().addAnimation("attack.swipe_right", false);
    public static final AnimationBuilder ATTACK_SHOOT_ALTERNATE = new AnimationBuilder().addAnimation("attack.shoot_alternate", false);

    public static <T extends IAnimatable> AnimationController<T> genericIdleController(T entity) {
        return new AnimationController<T>(entity, "movement", 0.0f, event -> {
            event.getController().setAnimation(IDLE);
            return PlayState.CONTINUE;
        });
    }

    public static <T extends IAnimatable> AnimationController<T> genericWalkController(T entity) {
        return new AnimationController<T>(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(WALK);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        });
    }

    public static <T extends IAnimatable> AnimationController<T> genericSwimController(T entity) {
        return new AnimationController<T>(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(SWIM);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        });
    }

    public static <T extends IAnimatable> AnimationController<T> genericSwimIdleController(T entity) {
        return new AnimationController<T>(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(SWIM);
            } else {
                event.getController().setAnimation(IDLE);
            }
            return PlayState.CONTINUE;
        });
    }

    public static <T extends IAnimatable> AnimationController<T> genericWalkIdleController(T entity) {
        return new AnimationController<T>(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(WALK);
            } else {
                event.getController().setAnimation(IDLE);
            }
            return PlayState.CONTINUE;
        });
    }

    public static <T extends IAnimatable> AnimationController<T> genericFlyController(T entity) {
        return new AnimationController<T>(entity, "movement", 0.0f, event -> {
            event.getController().setAnimation(FLY);
            return PlayState.CONTINUE;
        });
    }

    public static <T extends IAnimatable> AnimationController<T> genericFlyIdleController(T entity) {
        return new AnimationController<T>(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(FLY);
            } else {
                event.getController().setAnimation(IDLE);
            }
            return PlayState.CONTINUE;
        });
    }

    public static <T extends IAnimatable> AnimationController<T> genericWalkRunIdleController(T entity) {
        return new AnimationController<T>(entity, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(WALK);
            } else {
                event.getController().setAnimation(IDLE);
            }
            return PlayState.CONTINUE;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> genericAttackController(T entity, AnimationBuilder attackAnimation) {
        return new AnimationController<T>(entity, "attacking", 0.0f, event -> {
            if (entity.f_20911_) {
                event.getController().setAnimation(attackAnimation);
                return PlayState.CONTINUE;
            }
            event.getController().markNeedsReload();
            return PlayState.STOP;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> dynamicAttackController(T entity, Supplier<AnimationBuilder> animationSupplier) {
        return new AnimationController<T>(entity, "attacking", 0.0f, event -> {
            if (entity.f_20911_) {
                event.getController().setAnimation((AnimationBuilder)animationSupplier.get());
                return PlayState.CONTINUE;
            }
            event.getController().markNeedsReload();
            return PlayState.STOP;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> customAttackController(T entity, AnimationController.IAnimationPredicate<T> controllerPredicate) {
        return new AnimationController<T>(entity, "attacking", 0.0f, controllerPredicate);
    }

    public static <T extends LivingEntity> AnimationController<T> genericSpawnController(T entity, int spawnTicks) {
        return new AnimationController<T>(entity, "spawning", 0.0f, event -> {
            if (entity.f_19797_ < spawnTicks) {
                event.getController().setAnimation(SPAWN);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> genericInteractionController(T entity, Predicate<T> interactingPredicate) {
        return new AnimationController<T>(entity, "interacting", 0.0f, event -> {
            AnimationController controller = event.getController();
            if (interactingPredicate.test(entity)) {
                controller.setAnimation(INTERACT);
                return PlayState.CONTINUE;
            }
            if (controller.getCurrentAnimation() != null) {
                controller.setAnimation(INTERACT_END);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        });
    }
}

