/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.util.RenderUtil;

public final class ScreenOverlayRenderer {
    private static final ConcurrentHashMap<ResourceLocation, Integer> overlays = new ConcurrentHashMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, RenderGameOverlayEvent.Post.class, ScreenOverlayRenderer::onOverlayRender);
    }

    public static void addOverlay(ResourceLocation overlay, int duration) {
        overlays.put(overlay, duration);
    }

    public static void tickOverlays() {
        overlays.entrySet().removeIf(entry -> (Integer)entry.getValue() <= 0);
        ((ConcurrentHashMap.KeySetView)overlays.keySet()).spliterator().forEachRemaining(overlay -> overlays.compute((ResourceLocation)overlay, (overlay2, duration) -> duration - 1));
    }

    public static void clearOverlays() {
        overlays.clear();
    }

    private static void handleToxicWaste(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        if (mc.f_91074_ != null && mc.f_91074_.m_204029_(AoATags.Fluids.TOXIC_WASTE)) {
            BufferBuilder buff = Tesselator.m_85913_().m_85915_();
            float yMod = mc.f_91074_.m_146909_() / 512.0f + (float)mc.f_91074_.f_19797_ / 1800.0f;
            float xMod = mc.f_91074_.m_146908_() / 1024.0f + (float)mc.f_91074_.f_19797_ / 3600.0f;
            RenderSystem.m_69478_();
            RenderUtil.prepRenderTexture(new ResourceLocation("aoa3", "textures/block/toxic_waste_overlay.png"));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            buff.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buff.m_5483_(0.0, (double)window.m_85446_(), -90.0).m_7421_(xMod, 1.0f + yMod).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buff.m_5483_((double)window.m_85445_(), (double)window.m_85446_(), -90.0).m_7421_(1.0f + xMod, 1.0f + yMod).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buff.m_5483_((double)window.m_85445_(), 0.0, -90.0).m_7421_(1.0f + xMod, yMod).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buff.m_5483_(0.0, 0.0, -90.0).m_7421_(xMod, yMod).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            Tesselator.m_85913_().m_85914_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69461_();
        }
    }

    private static void onOverlayRender(RenderGameOverlayEvent.Post event) {
        if (Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        ScreenOverlayRenderer.handleToxicWaste(event);
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || overlays.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        for (Map.Entry<ResourceLocation, Integer> entry : overlays.entrySet()) {
            RenderUtil.setRenderingTexture(entry.getKey());
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)entry.getValue().intValue() / 50.0f));
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_5483_(0.0, (double)window.m_85446_(), -90.0).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)window.m_85445_(), (double)window.m_85446_(), -90.0).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)window.m_85445_(), 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
            tesselator.m_85914_();
        }
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

