/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.PatchouliBookOpenPacket;
import net.tslat.aoa3.common.packet.packets.PatchouliGiveBookPacket;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.RenderUtil;

public class AdventGuiTabLore
extends Screen {
    private int adjustedMouseX;
    private int adjustedMouseY;
    private static final ConcurrentHashMap<ResourceLocation, ItemStack> loreBooks = new ConcurrentHashMap();

    protected AdventGuiTabLore() {
        super((Component)Component.m_237115_((String)"gui.aoa3.adventGui.lore"));
    }

    protected void m_7856_() {
        int index = 0;
        int accumWidth = 0;
        int height = AdventMainGui.scaledTabRootY + 20;
        for (Map.Entry<ResourceLocation, ItemStack> bookEntry : loreBooks.entrySet()) {
            int width = (int)((float)this.f_96547_.m_92852_((FormattedText)bookEntry.getValue().m_41786_()) * 1.5f);
            if (accumWidth + width + 25 + 25 * index >= 764) {
                height += 80;
                accumWidth = 0;
                index = 0;
            }
            this.m_142416_((GuiEventListener)new PatchouliBook(bookEntry.getKey(), bookEntry.getValue(), AdventMainGui.scaledTabRootX + accumWidth + 25 + 25 * index, height));
            accumWidth += width;
            ++index;
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.adjustedMouseX = (int)((float)mouseX * 2.2222223f);
        this.adjustedMouseY = (int)((float)mouseY * 2.2222223f);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.m_7897_(false);
        for (GuiEventListener listener : this.m_6702_()) {
            if (!listener.m_6348_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public static void syncBooks(Collection<ResourceLocation> bookIds) {
        loreBooks.clear();
        if (!IntegrationManager.isPatchouliActive()) {
            return;
        }
        Item guideBook = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("patchouli", "guide_book"));
        for (ResourceLocation id : bookIds) {
        }
    }

    public static void bookOpened(ResourceLocation id) {
        if (!loreBooks.containsKey(id)) {
            AoAPackets.messageServer(new PatchouliBookOpenPacket(id));
        }
    }

    private static class PatchouliBook
    extends AbstractWidget {
        private final ResourceLocation id;
        private final ItemStack book;
        private final int titleWidth;
        private boolean mouseHolding = false;

        private PatchouliBook(ResourceLocation id, ItemStack book, int x, int y) {
            super(x, y, 100, 100, book.m_41611_());
            this.id = id;
            this.book = book;
            this.titleWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)book.m_41786_());
        }

        protected boolean m_93680_(double mouseX, double mouseY) {
            return this.m_5953_(mouseX, mouseY);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            if (this.m_7972_(button)) {
                if (!this.mouseHolding) {
                    if (this.f_93622_) {
                        return true;
                    }
                } else {
                    this.mouseHolding = false;
                    if (mouseX / (double)0.45f < (double)AdventMainGui.scaledRootX || mouseY / (double)0.45f < (double)AdventMainGui.scaledRootY || mouseX / (double)0.45f > (double)(AdventMainGui.scaledRootX + 976) || mouseY / (double)0.45f > (double)(AdventMainGui.scaledRootY + 480)) {
                        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
                        Item patchouliBook = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("patchouli", "guide_book"));
                        if (patchouliBook == null || patchouliBook == Items.f_41852_) {
                            return true;
                        }
                        for (ItemStack stack : pl.m_150109_().f_35974_) {
                            CompoundTag bookTag;
                            if (stack.m_41720_() != patchouliBook || !stack.m_41782_() || !(bookTag = stack.m_41783_()).m_128441_("patchouli:book") || !bookTag.m_128461_("patchouli:book").equals(this.id.toString())) continue;
                            return true;
                        }
                        AoAPackets.messageServer(new PatchouliGiveBookPacket(this.id));
                        return true;
                    }
                }
            }
            return false;
        }

        protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
            if (this.f_93622_) {
                this.mouseHolding = true;
            }
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            if (!this.f_93623_ || !this.f_93624_) {
                return false;
            }
            if (mouseX < (double)(((float)this.f_93620_ + (float)this.titleWidth / 2.0f - 5.0f) * 0.45f)) {
                return false;
            }
            if (mouseY < (double)((float)(this.f_93621_ + 22 - 5) * 0.45f)) {
                return false;
            }
            if (mouseX > (double)(((float)this.f_93620_ + (float)this.titleWidth / 2.0f + 32.0f + 5.0f) * 0.45f)) {
                return false;
            }
            return mouseY < (double)((float)(this.f_93621_ + 22 + 32 + 5) * 0.45f);
        }

        public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                this.f_93622_ = this.m_5953_(mouseX, mouseY);
                Font fontRenderer = Minecraft.m_91087_().f_91062_;
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                int itemX = this.mouseHolding ? (int)((float)mouseX - 7.2f) : (int)(((float)this.f_93620_ + (float)this.titleWidth / 2.0f) * 0.45f);
                int itemY = this.mouseHolding ? (int)((float)mouseY - 7.2f) : (int)(((float)this.f_93621_ + 12.0f + 10.0f) * 0.45f);
                RenderUtil.drawScaledMessage(matrix, fontRenderer, this.book.m_41786_(), this.f_93620_, this.f_93621_, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.DROP_SHADOW);
                itemRenderer.m_115203_(this.book, itemX, itemY);
                itemRenderer.m_115174_(fontRenderer, this.book, itemX, itemY - 2, "");
                if (this.f_93622_ && !this.mouseHolding) {
                    matrix.m_85836_();
                    matrix.m_85841_(1.5f, 1.5f, 1.5f);
                    AdventMainGui.instance.renderTooltip(matrix, Collections.singletonList(Component.m_237115_((String)"gui.aoa3.adventGui.lore.clickBook")), Optional.empty(), (int)((float)mouseX / 0.45f / 1.5f), (int)((float)mouseY / 0.45f / 1.5f), fontRenderer, this.book);
                    matrix.m_85849_();
                }
            }
        }

        public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

