/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsUpdateListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.client.gui.lib.ScrollablePane;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.content.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.base.AoAWaterMeleeMob;
import net.tslat.aoa3.content.entity.base.AoAWaterRangedMob;
import net.tslat.aoa3.data.client.BestiaryReloadListener;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;

public class AdventGuiTabBestiary
extends Screen
implements StatsUpdateListener {
    private static final ResourceLocation iconsTextures = new ResourceLocation("aoa3", "textures/gui/adventgui/icons.png");
    private static final HashMap<String, Function<Entity, Tuple>> registeredEntryHandlers = new HashMap(1);
    private final HashMap<String, Entity> instancesMap = new HashMap();
    private StatsCounter stats;
    private Object2IntMap<Stat<?>> statsMap;
    private BestiaryMenu scrollMenu;
    private ArrayList<EntityStats> statList;
    private ArrayList<EntityStats> filteredMobList;
    private boolean receivedStats = false;
    private int lastOpenIndex = -1;
    private int openEntryIndex = -1;
    private int openEntryHeight = 0;
    private float lastDistanceScrolled = 0.0f;
    private Entity openEntryInstance = null;
    private List<FormattedCharSequence> openEntryInfoLines = null;
    private List<String> openEntryStatsLines = null;
    private int adjustedMouseX;
    private int adjustedMouseY;
    protected EditBox searchField;

    protected AdventGuiTabBestiary() {
        super((Component)Component.m_237115_((String)"gui.aoa3.adventGui.bestiary"));
    }

    protected void m_7856_() {
        this.receivedStats = false;
        this.openEntryIndex = -1;
        this.stats = this.getMinecraft().f_91074_.m_108630_();
        if (this.statsMap == null) {
            this.statsMap = (Object2IntMap)ObfuscationReflectionHelper.getPrivateValue(StatsCounter.class, (Object)this.stats, (String)"f_13013_");
        }
        if (this.scrollMenu == null) {
            this.scrollMenu = new BestiaryMenu(this.f_96541_, AdventMainGui.scaledTabRootY, AdventMainGui.scaledTabRootX, 340, 764, 0.45f);
        }
        this.searchField = new EditBox(this.f_96547_, AdventMainGui.scaledTabRootX + 20, AdventMainGui.scaledTabRootY, (int)((double)(this.f_96543_ - 40) / 2.0), 15, (Component)Component.m_237113_((String)""));
        this.searchField.m_94194_(false);
        this.getMinecraft().m_91403_().m_104955_((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.adjustedMouseX = (int)((float)mouseX * 2.2222223f);
        this.adjustedMouseY = (int)((float)mouseY * 2.2222223f);
        this.scrollMenu.render(matrixStack, this.adjustedMouseX, this.adjustedMouseY, partialTicks);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        if (this.scrollMenu != null) {
            return this.scrollMenu.handleMouseScroll(-1.0, -1.0, scrollAmount);
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return this.scrollMenu != null && this.scrollMenu.handleMouseClick(this.adjustedMouseX, this.adjustedMouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.scrollMenu != null) {
            return this.scrollMenu.handleMouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        if (this.scrollMenu != null) {
            this.scrollMenu.onResize(this.f_96541_, AdventMainGui.scaledTabRootX, AdventMainGui.scaledTabRootY, 764, 340);
        }
    }

    public void m_7819_() {
        HashMap<String, EntityStats> statsMap = new HashMap<String, EntityStats>();
        this.statList = new ArrayList();
        for (Object stat2 : this.statsMap.keySet()) {
            ResourceLocation registryName;
            if (!(stat2.m_12867_() instanceof EntityType) || (registryName = ForgeRegistries.ENTITIES.getKey((Object)((EntityType)stat2.m_12867_()))) == null || !((Boolean)AoAConfig.CLIENT.thirdPartyBestiary.get()).booleanValue() && !registryName.m_135827_().equals("aoa3")) continue;
            String registryNameString = registryName.toString();
            if (!statsMap.containsKey(registryNameString)) {
                statsMap.put(registryNameString, new EntityStats((Stat<EntityType<?>>)stat2, stat2.m_12859_() == Stats.f_12986_));
                continue;
            }
            ((EntityStats)statsMap.get(registryNameString)).matchAndComplete((Stat<EntityType<?>>)stat2);
        }
        for (Object stat2 : statsMap.values()) {
            if (!((EntityStats)stat2).hasKills()) continue;
            this.statList.add((EntityStats)stat2);
        }
        this.statList.sort(Comparator.comparing(stat -> stat.registryName.m_135815_()));
        this.filteredMobList = (ArrayList)this.statList.clone();
        this.receivedStats = true;
    }

    public void m_7861_() {
        if (this.searchField != null && this.searchField.m_93696_()) {
            this.searchField.m_94178_(false);
        }
    }

    @Nullable
    private Entity getEntityFromStat(EntityStats stat) {
        String registryName = stat.registryName.toString();
        if (this.instancesMap.containsKey(registryName)) {
            return this.instancesMap.get(registryName);
        }
        try {
            Entity entity = ((EntityType)ForgeRegistries.ENTITIES.getValue(stat.registryName)).m_20615_((Level)this.f_96541_.f_91074_.f_108545_);
            this.instancesMap.put(registryName, entity);
            return entity;
        }
        catch (Exception e) {
            Logging.logMessage(org.apache.logging.log4j.Level.DEBUG, "Unable to retrieve entity from entity type: " + registryName);
            return null;
        }
    }

    public boolean m_5534_(char character, int arg) {
        if (this.searchField.m_93696_()) {
            int searchTextLength = this.searchField.m_94155_().length();
            if (this.searchField.m_5534_(character, arg)) {
                if (this.searchField.m_94155_().isEmpty()) {
                    this.filteredMobList = (ArrayList)this.statList.clone();
                    this.searchField.m_94202_(ColourUtil.WHITE);
                } else if (this.searchField.m_94155_().length() != searchTextLength) {
                    this.searchFilterBestiaryEntries(searchTextLength < this.searchField.m_94155_().length());
                }
            }
            return true;
        }
        return super.m_5534_(character, arg);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean success = super.m_7933_(keyCode, scanCode, modifiers);
        if (this.openEntryIndex < 0 && keyCode == 70 && AdventGuiTabBestiary.m_96637_() && !AdventGuiTabBestiary.m_96638_() && !AdventGuiTabBestiary.m_96639_()) {
            if (!this.searchField.m_94213_()) {
                this.searchField.m_94194_(true);
            }
            this.searchField.m_94178_(true);
            return true;
        }
        if (this.searchField.m_93696_()) {
            int searchTextLength = this.searchField.m_94155_().length();
            if (this.searchField.m_7933_(keyCode, scanCode, modifiers)) {
                if (this.searchField.m_94155_().isEmpty()) {
                    this.filteredMobList = (ArrayList)this.statList.clone();
                    this.searchField.m_94202_(ColourUtil.WHITE);
                } else if (this.searchField.m_94155_().length() != searchTextLength) {
                    this.searchFilterBestiaryEntries(searchTextLength < this.searchField.m_94155_().length());
                }
            }
            return true;
        }
        return success;
    }

    private void searchFilterBestiaryEntries(boolean additiveEdit) {
        String searchFilter;
        this.searchField.m_94202_(ColourUtil.WHITE);
        if (this.searchField.m_94155_().isEmpty()) {
            this.filteredMobList = (ArrayList)this.statList.clone();
            return;
        }
        if (!additiveEdit || this.filteredMobList == null) {
            this.filteredMobList = (ArrayList)this.statList.clone();
        }
        if ((searchFilter = this.searchField.m_94155_().toLowerCase()).startsWith("@")) {
            String modIdFilter = searchFilter.split("@", 2)[1].split(" ")[0];
            this.filteredMobList.removeIf(stat -> !stat.registryName.m_135827_().startsWith(modIdFilter));
            searchFilter = searchFilter.replace("@" + modIdFilter, "");
            if (searchFilter.startsWith(" ")) {
                searchFilter = searchFilter.substring(1);
            }
            if (searchFilter.isEmpty()) {
                if (this.filteredMobList.isEmpty()) {
                    this.searchField.m_94202_(ColourUtil.RED);
                }
                return;
            }
        }
        String searchedEntityName = searchFilter;
        this.filteredMobList.removeIf(stat -> {
            ResourceLocation registryName = stat.registryName;
            String entityName = LocaleUtil.getLocaleString("entity." + registryName.m_135827_() + "." + registryName.m_135815_()).replace("." + registryName.m_135827_(), "");
            return !entityName.toLowerCase().contains(searchedEntityName);
        });
        if (this.filteredMobList.isEmpty()) {
            this.searchField.m_94202_(ColourUtil.RED);
        }
    }

    private void gatherEntityStats(EntityStats stat) {
        LivingEntity livingInstance;
        ResourceLocation registryName = stat.registryName;
        String entityModId = registryName.m_135827_();
        this.openEntryInstance = this.getEntityFromStat(stat);
        this.openEntryStatsLines = new ArrayList<String>();
        this.openEntryInfoLines = new ArrayList<FormattedCharSequence>(0);
        LivingEntity livingEntity = livingInstance = this.openEntryInstance instanceof LivingEntity ? (LivingEntity)this.openEntryInstance : null;
        if (this.openEntryInstance != null) {
            if (registeredEntryHandlers.containsKey(entityModId)) {
                try {
                    Tuple entityData = registeredEntryHandlers.get(entityModId).apply(this.openEntryInstance);
                    this.openEntryStatsLines = (List)entityData.m_14418_();
                    if (entityData.m_14419_() != null && ((String)entityData.m_14419_()).length() > 0) {
                        this.openEntryInfoLines = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)((String)entityData.m_14419_())), 489);
                    }
                }
                catch (ClassCastException ex) {
                    Logging.logMessage(org.apache.logging.log4j.Level.WARN, "Mod '" + entityModId + "' provided invalid bestiary entry handler. Removing support. Report this to the mod author.");
                    registeredEntryHandlers.remove(entityModId);
                    this.openEntryIndex = -1;
                    this.openEntryHeight = 0;
                }
            } else {
                String bestiaryInfo;
                String attribute = "";
                String type = this.openEntryInstance instanceof LivingEntity && this.openEntryInstance instanceof Enemy ? (this.openEntryInstance instanceof FlyingMob ? (((LivingEntity)this.openEntryInstance).m_21051_(Attributes.f_22281_) != null ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.flyingMelee") : LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.flyingRanged")) : (this.openEntryInstance instanceof AoAWaterRangedMob ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.swimmingRanged") : (this.openEntryInstance instanceof AoAWaterMeleeMob || ((LivingEntity)this.openEntryInstance).m_6336_() == MobType.f_21644_ ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.swimmingMelee") : (((LivingEntity)this.openEntryInstance).m_21051_(Attributes.f_22281_) != null ? (this.openEntryInstance instanceof RangedAttackMob ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.hybrid") : LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.melee")) : LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.ranged"))))) : (this.openEntryInstance instanceof Merchant ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.trader") : (this.openEntryInstance instanceof Animal ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.animal") : (this.openEntryInstance instanceof AmbientCreature || this.openEntryInstance instanceof WaterAnimal ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.ambient") : LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.other"))));
                if (livingInstance != null) {
                    MobType creatureAttribute = livingInstance.m_6336_();
                    if (creatureAttribute == MobType.f_21642_) {
                        attribute = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.arthropod");
                    } else if (creatureAttribute == MobType.f_21643_) {
                        attribute = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.illager");
                    } else if (creatureAttribute == MobType.f_21641_) {
                        attribute = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.undead");
                    } else if (creatureAttribute == MobType.f_21640_ || creatureAttribute == MobType.f_21644_) {
                        attribute = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.none");
                    }
                }
                this.openEntryStatsLines.add(ChatFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type") + ChatFormatting.RESET + " " + type);
                this.openEntryStatsLines.add(ChatFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute") + ChatFormatting.RESET + " " + attribute);
                this.openEntryStatsLines.add(ChatFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.size") + ChatFormatting.RESET + " " + (float)((int)(this.openEntryInstance.m_20205_() * 1000.0f)) / 1000.0f + "x" + (float)((int)(this.openEntryInstance.m_20206_() * 1000.0f)) / 1000.0f);
                this.openEntryStatsLines.add("");
                if (livingInstance != null) {
                    AttributeInstance attackAttribute;
                    this.openEntryStatsLines.add(ChatFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.health") + ChatFormatting.RESET + " " + livingInstance.m_21233_());
                    if (livingInstance.m_21051_(Attributes.f_22284_).m_22135_() > 0.0) {
                        this.openEntryStatsLines.add(ChatFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.armour") + ChatFormatting.RESET + " " + livingInstance.m_21051_(Attributes.f_22284_).m_22135_());
                    }
                    if (livingInstance.m_21051_(Attributes.f_22278_).m_22135_() > 0.0) {
                        this.openEntryStatsLines.add(ChatFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.knockback") + ChatFormatting.RESET + " " + livingInstance.m_21051_(Attributes.f_22278_).m_22135_() * 100.0 + "%");
                    }
                    if ((attackAttribute = livingInstance.m_21051_(Attributes.f_22281_)) != null && attackAttribute.m_22135_() > 0.0) {
                        this.openEntryStatsLines.add(ChatFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.strength") + ChatFormatting.RESET + " " + livingInstance.m_21051_(Attributes.f_22281_).m_22135_());
                    }
                    if (this.openEntryInstance instanceof AoARangedAttacker) {
                        if (this.openEntryInstance instanceof AoARangedMob) {
                            this.openEntryStatsLines.add(ChatFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.projectileStrength") + ChatFormatting.RESET + " " + ((AoARangedMob)this.openEntryInstance).m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
                        } else if (this.openEntryInstance instanceof AoAFlyingRangedMob) {
                            this.openEntryStatsLines.add(ChatFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.projectileStrength") + ChatFormatting.RESET + " " + ((AoAFlyingRangedMob)this.openEntryInstance).m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
                        }
                    }
                    this.openEntryStatsLines.add(ChatFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.speed") + ChatFormatting.RESET + " " + (float)((int)(livingInstance.m_21051_(Attributes.f_22279_).m_22135_() * 1000.0)) / 1000.0f);
                }
                if ((bestiaryInfo = BestiaryReloadListener.BESTIARY.get(registryName)) != null) {
                    this.openEntryInfoLines = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)bestiaryInfo), 489);
                }
            }
        } else {
            this.openEntryIndex = -1;
            this.openEntryHeight = 0;
        }
    }

    public static void registerThirdPartyBestiaryHandler(String modId, Function<Entity, Tuple> entityHandlerFunction) {
        if (!modId.equalsIgnoreCase("aoa3")) {
            registeredEntryHandlers.put(modId, entityHandlerFunction);
        }
    }

    private class BestiaryMenu
    extends ScrollablePane {
        public BestiaryMenu(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float renderingScale) {
            super(AdventGuiTabBestiary.this.f_96541_, top, left, viewHeight, viewWidth, renderingScale);
        }

        @Override
        public int getFullPaneHeight() {
            return AdventGuiTabBestiary.this.receivedStats ? (AdventGuiTabBestiary.this.openEntryIndex < 0 ? (AdventGuiTabBestiary.this.filteredMobList.size() + AdventGuiTabBestiary.this.filteredMobList.size() % 2) * 100 + 20 : AdventGuiTabBestiary.this.openEntryHeight) : 0;
        }

        @Override
        public void drawPaneContents(PoseStack matrix, int top, int left, int right, int bottom, float scrollDistance, float partialTicks) {
            matrix.m_85836_();
            if (!AdventGuiTabBestiary.this.receivedStats) {
                RenderUtil.drawCenteredScaledString(matrix, AdventGuiTabBestiary.this.f_96547_, LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.downloading"), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f) - 20, 2.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
                RenderUtil.drawCenteredScaledString(matrix, AdventGuiTabBestiary.this.f_96547_, StatsUpdateListener.f_97124_[(int)(Util.m_137550_() / 150L % (long)StatsUpdateListener.f_97124_.length)], left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f), 2.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            } else if (AdventGuiTabBestiary.this.filteredMobList.isEmpty()) {
                if (!AdventGuiTabBestiary.this.statList.isEmpty()) {
                    RenderUtil.drawColouredBox(matrix, left, AdventMainGui.scaledTabRootY, 0, 20, 20, -14671840);
                    RenderSystem.m_157427_(GameRenderer::m_172820_);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)iconsTextures);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderUtil.renderScaledCustomSizedTexture(matrix, left + 2, AdventMainGui.scaledTabRootY + 2, 0.0f, 32.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                    if (AdventGuiTabBestiary.this.searchField.m_94213_()) {
                        AdventGuiTabBestiary.this.searchField.f_93620_ = (int)((double)(left + 20) / 2.0);
                        AdventGuiTabBestiary.this.searchField.f_93621_ = (int)((double)AdventMainGui.scaledTabRootY / 2.0);
                        AdventGuiTabBestiary.this.searchField.m_93674_((int)((double)(right - left - 40) / 2.0));
                        matrix.m_85841_(2.0f, 2.0f, 2.0f);
                        AdventGuiTabBestiary.this.searchField.m_6305_(matrix, AdventGuiTabBestiary.this.adjustedMouseX, AdventGuiTabBestiary.this.adjustedMouseX, partialTicks);
                        matrix.m_85841_(0.5f, 0.5f, 0.5f);
                    }
                    RenderUtil.drawCenteredScaledString(matrix, AdventGuiTabBestiary.this.f_96547_, LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.emptySearch"), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f) - 20, 2.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
                } else {
                    RenderUtil.drawCenteredScaledString(matrix, AdventGuiTabBestiary.this.f_96547_, LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.empty"), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f) - 20, 2.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
                }
            } else if (AdventGuiTabBestiary.this.openEntryIndex < 0) {
                for (int i = Math.max(0, (int)(scrollDistance / 200.0f) * 2); i * 100 <= bottom - top && i < AdventGuiTabBestiary.this.filteredMobList.size(); i += 2) {
                    EntityStats entityStat = AdventGuiTabBestiary.this.filteredMobList.get(i);
                    ResourceLocation registryName = entityStat.registryName;
                    int rowTop = top + 20 + i * 100;
                    Entity entity = AdventGuiTabBestiary.this.getEntityFromStat(entityStat);
                    Component entityName = entity != null ? ((EntityType)entityStat.killStat.m_12867_()).m_20676_() : LocaleUtil.getLocaleMessage("entity." + registryName.m_135827_().replace(".minecraft", "") + "." + registryName.m_135815_());
                    RenderUtil.drawColouredBox(matrix, left + 40, rowTop + 30, 0, 320, 150, -14671840);
                    if (entity != null) {
                        this.drawEntity(matrix, entity, left + 200, rowTop + 170, 50.0f);
                    }
                    matrix.m_85836_();
                    matrix.m_85837_(0.0, 0.0, 100.0);
                    RenderUtil.drawColouredBox(matrix, left + 40, rowTop, 0, 320, 30, -16711423);
                    RenderUtil.drawCenteredScaledMessage(matrix, AdventGuiTabBestiary.this.f_96547_, entityName, left + 200, rowTop + 8, 2.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.NORMAL);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)iconsTextures);
                    RenderUtil.renderScaledCustomSizedTexture(matrix, left + 300, rowTop + 160, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                    RenderUtil.renderScaledCustomSizedTexture(matrix, left + 43, rowTop + 160, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                    RenderUtil.drawScaledString(matrix, AdventGuiTabBestiary.this.f_96547_, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.m_13015_(entityStat.killStat), true), left + 60, rowTop + 163, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.NORMAL);
                    RenderUtil.drawScaledString(matrix, AdventGuiTabBestiary.this.f_96547_, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.m_13015_(entityStat.deathStat), true), left + 320, rowTop + 163, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.NORMAL);
                    matrix.m_85849_();
                    if (i + 1 >= AdventGuiTabBestiary.this.filteredMobList.size()) continue;
                    entityStat = AdventGuiTabBestiary.this.filteredMobList.get(i + 1);
                    entity = AdventGuiTabBestiary.this.getEntityFromStat(entityStat);
                    entityName = entity != null ? entity.m_5446_() : LocaleUtil.getLocaleMessage("entity." + entityStat.registryName.m_135827_().replace(".minecraft", "") + "." + entityStat.registryName.m_135815_());
                    RenderUtil.drawColouredBox(matrix, right - 360, rowTop + 30, 0, 320, 150, -14671840);
                    if (entity != null) {
                        this.drawEntity(matrix, entity, right - 200, rowTop + 170, 50.0f);
                    }
                    matrix.m_85836_();
                    matrix.m_85837_(0.0, 0.0, 100.0);
                    RenderUtil.drawColouredBox(matrix, right - 360, rowTop, 0, 320, 30, -16711423);
                    RenderUtil.drawCenteredScaledMessage(matrix, AdventGuiTabBestiary.this.f_96547_, entityName, right - 200, rowTop + 8, 2.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.NORMAL);
                    RenderSystem.m_157427_(GameRenderer::m_172820_);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)iconsTextures);
                    RenderUtil.renderScaledCustomSizedTexture(matrix, right - 100, rowTop + 160, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                    RenderUtil.renderScaledCustomSizedTexture(matrix, right - 357, rowTop + 160, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                    RenderUtil.drawScaledString(matrix, AdventGuiTabBestiary.this.f_96547_, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.m_13015_(entityStat.killStat), true), right - 340, rowTop + 163, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.NORMAL);
                    RenderUtil.drawScaledString(matrix, AdventGuiTabBestiary.this.f_96547_, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.m_13015_(entityStat.deathStat), true), right - 80, rowTop + 163, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.NORMAL);
                    matrix.m_85849_();
                }
                RenderSystem.m_69465_();
                RenderUtil.drawColouredBox(matrix, left, AdventMainGui.scaledTabRootY, 0, 20, 20, -14671840);
                RenderSystem.m_157427_(GameRenderer::m_172820_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)iconsTextures);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtil.renderScaledCustomSizedTexture(matrix, left + 2, AdventMainGui.scaledTabRootY + 2, 0.0f, 32.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                if (AdventGuiTabBestiary.this.searchField.m_94213_()) {
                    AdventGuiTabBestiary.this.searchField.f_93620_ = (int)((double)(left + 20) / 2.0);
                    AdventGuiTabBestiary.this.searchField.f_93621_ = (int)((double)AdventMainGui.scaledTabRootY / 2.0);
                    AdventGuiTabBestiary.this.searchField.m_93674_((int)((double)(right - left - 40) / 2.0));
                    matrix.m_85841_(2.0f, 2.0f, 2.0f);
                    AdventGuiTabBestiary.this.searchField.m_6305_(matrix, AdventGuiTabBestiary.this.adjustedMouseX, AdventGuiTabBestiary.this.adjustedMouseX, partialTicks);
                    matrix.m_85841_(0.5f, 0.5f, 0.5f);
                }
                RenderSystem.m_69482_();
            } else {
                int i;
                EntityStats entityStat = AdventGuiTabBestiary.this.filteredMobList.get(AdventGuiTabBestiary.this.openEntryIndex);
                ResourceLocation registryName = entityStat.registryName;
                int n = AdventGuiTabBestiary.this.openEntryInfoLines.size();
                Objects.requireNonNull(AdventGuiTabBestiary.this.f_96547_);
                AdventGuiTabBestiary.this.openEntryHeight = Math.max(this.viewHeight - 30, 320 + (int)((float)(n * 9) * 1.5f));
                RenderUtil.drawColouredBox(matrix, left, top + 30, 0, right - left, bottom - top, -14671840);
                RenderUtil.drawColouredBox(matrix, left, top, 0, right - left, 30, -16711423);
                Component entityName = AdventGuiTabBestiary.this.openEntryInstance != null ? AdventGuiTabBestiary.this.openEntryInstance.m_7755_() : LocaleUtil.getLocaleMessage("entity." + registryName.m_135827_().replace(".minecraft", "") + "." + registryName.m_135815_());
                RenderUtil.drawCenteredScaledMessage(matrix, AdventGuiTabBestiary.this.f_96547_, entityName, left + (int)((float)this.viewWidth / 2.0f), top + 8, 2.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.NORMAL);
                if (AdventGuiTabBestiary.this.openEntryInstance != null) {
                    this.drawEntity(matrix, AdventGuiTabBestiary.this.openEntryInstance, left + 200, top + 240, 75.0f);
                }
                RenderSystem.m_157427_(GameRenderer::m_172820_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)iconsTextures);
                RenderUtil.renderScaledCustomSizedTexture(matrix, left + 425, top + 45, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                RenderUtil.renderScaledCustomSizedTexture(matrix, left + 425, top + 65, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                RenderUtil.drawScaledString(matrix, AdventGuiTabBestiary.this.f_96547_, "X", right - 20, top + 5, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.NORMAL);
                RenderUtil.drawScaledString(matrix, AdventGuiTabBestiary.this.f_96547_, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.m_13015_(entityStat.killStat), true), left + 445, top + 48, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.NORMAL);
                RenderUtil.drawScaledString(matrix, AdventGuiTabBestiary.this.f_96547_, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.m_13015_(entityStat.deathStat), true), left + 445, top + 68, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.NORMAL);
                matrix.m_85841_(1.5f, 1.5f, 1.5f);
                for (i = 0; i < AdventGuiTabBestiary.this.openEntryStatsLines.size(); ++i) {
                    AdventGuiTabBestiary.this.f_96547_.m_92750_(matrix, AdventGuiTabBestiary.this.openEntryStatsLines.get(i), (float)((int)((float)(left + 425) / 1.5f)), (float)((int)((float)(top + 100 + 14 * i) / 1.5f)), ColourUtil.WHITE);
                }
                for (i = 0; i < AdventGuiTabBestiary.this.openEntryInfoLines.size(); ++i) {
                    AdventGuiTabBestiary.this.f_96547_.m_92877_(matrix, AdventGuiTabBestiary.this.openEntryInfoLines.get(i), (float)((int)((float)(left + 20) / 1.5f)), (float)((int)((float)(top + 300 + i * 14) / 1.5f)), ColourUtil.WHITE);
                }
            }
            matrix.m_85849_();
        }

        @Override
        public void drawBackground(PoseStack matrix) {
        }

        private void drawEntity(PoseStack matrix, Entity entity, int posX, int posY, float scale) {
            matrix.m_85836_();
            matrix.m_85837_((double)posX, (double)posY, 1050.0);
            matrix.m_85841_(1.0f, 1.0f, -1.0f);
            Minecraft mc = Minecraft.m_91087_();
            float sizeFactor = Math.max(entity.m_20205_(), entity.m_20206_());
            if ((double)sizeFactor > 2.5) {
                scale = (float)((double)scale / ((double)sizeFactor / 2.5));
            }
            matrix.m_85837_(0.0, 0.0, 1000.0);
            matrix.m_85841_(scale, scale, scale);
            Quaternion quaternion = Vector3f.f_122223_.m_122240_(180.0f);
            matrix.m_85845_(quaternion);
            entity.f_19797_ = mc.f_91074_.f_19797_;
            entity.m_146922_(0.0f);
            entity.m_146926_(0.0f);
            EntityRenderDispatcher renderManager = mc.m_91290_();
            renderManager.m_114468_(false);
            MultiBufferSource.BufferSource renderBuffer = mc.m_91269_().m_110104_();
            renderManager.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrix, (MultiBufferSource)renderBuffer, 0xF000F0);
            renderBuffer.m_109911_();
            renderManager.m_114468_(true);
            matrix.m_85849_();
        }

        @Override
        public boolean handleMouseClick(double mouseX, double mouseY, int button) {
            super.handleMouseClick(mouseX, mouseY, button);
            if (!AdventGuiTabBestiary.this.receivedStats) {
                return false;
            }
            int relativeMouseX = (int)mouseX - this.left + 2;
            if (relativeMouseX < 0) {
                return false;
            }
            if (AdventGuiTabBestiary.this.openEntryIndex < 0) {
                if (relativeMouseX <= 20 && mouseY - (double)this.top + 2.0 < 20.0) {
                    AdventGuiTabBestiary.this.searchField.m_94194_(!AdventGuiTabBestiary.this.searchField.m_94213_());
                    if (AdventGuiTabBestiary.this.searchField.m_94213_()) {
                        AdventGuiTabBestiary.this.searchField.m_94178_(true);
                    } else {
                        AdventGuiTabBestiary.this.searchField.m_94144_("");
                        AdventGuiTabBestiary.this.searchFilterBestiaryEntries(false);
                    }
                } else if (AdventGuiTabBestiary.this.searchField.m_94213_() && AdventGuiTabBestiary.this.searchField.m_6375_((double)((int)((double)(relativeMouseX + this.left) / 2.0)), (double)((int)((mouseY - 2.0) / 2.0)), 0)) {
                    return true;
                }
                if (relativeMouseX < 40 || relativeMouseX > this.right - this.left - 40) {
                    return false;
                }
            }
            int newTop = this.top - Math.max(0, (int)this.distanceScrolled);
            int relativeMouseY = (int)mouseY - newTop + 2;
            if (mouseY - (double)this.top < 0.0 || mouseY > (double)(this.top + this.viewHeight)) {
                return false;
            }
            if (AdventGuiTabBestiary.this.openEntryIndex < 0) {
                float preIndexY;
                int selectedIndex = -1;
                if (relativeMouseX < 360) {
                    float preIndexY2 = (float)relativeMouseY / 200.0f;
                    if ((double)(preIndexY2 - (float)((int)preIndexY2)) > 0.11) {
                        selectedIndex = 2 * (int)preIndexY2;
                    }
                } else if (relativeMouseX > this.right - this.left - 360 && (double)((preIndexY = (float)relativeMouseY / 200.0f) - (float)((int)preIndexY)) > 0.11) {
                    selectedIndex = 1 + (int)preIndexY * 2;
                }
                if (selectedIndex >= 0 && AdventGuiTabBestiary.this.filteredMobList.size() > selectedIndex) {
                    AdventGuiTabBestiary.this.openEntryIndex = selectedIndex;
                    AdventGuiTabBestiary.this.openEntryHeight = 600;
                    AdventGuiTabBestiary.this.lastDistanceScrolled = this.distanceScrolled;
                    this.distanceScrolled = 0.0f;
                    if (AdventGuiTabBestiary.this.lastOpenIndex != selectedIndex) {
                        if (AdventGuiTabBestiary.this.openEntryInstance != null) {
                            AdventGuiTabBestiary.this.openEntryInstance.m_146870_();
                        }
                        AdventGuiTabBestiary.this.gatherEntityStats(AdventGuiTabBestiary.this.filteredMobList.get(selectedIndex));
                    }
                    AdventGuiTabBestiary.this.lastOpenIndex = selectedIndex;
                    AdventGuiTabBestiary.this.searchField.m_94194_(false);
                }
            } else if (relativeMouseY <= 30) {
                AdventGuiTabBestiary.this.lastOpenIndex = AdventGuiTabBestiary.this.openEntryIndex;
                AdventGuiTabBestiary.this.openEntryIndex = -1;
                AdventGuiTabBestiary.this.openEntryHeight = 0;
                this.distanceScrolled = AdventGuiTabBestiary.this.lastDistanceScrolled;
            }
            return true;
        }
    }

    private static class EntityStats {
        @Nonnull
        private final ResourceLocation registryName;
        private Stat<EntityType<?>> killStat = null;
        private Stat<EntityType<?>> deathStat = null;

        private EntityStats(Stat<EntityType<?>> stat, boolean killStat) {
            this.registryName = ForgeRegistries.ENTITIES.getKey((Object)((EntityType)stat.m_12867_()));
            if (killStat) {
                this.killStat = stat;
            } else {
                this.deathStat = stat;
            }
        }

        private void matchAndComplete(Stat<EntityType<?>> stat) {
            if (this.killStat == null) {
                this.killStat = stat;
            } else {
                this.deathStat = stat;
            }
        }

        private boolean hasKills() {
            return this.killStat != null;
        }

        private int getKills(StatsCounter statsManager) {
            return statsManager.m_13015_(this.killStat);
        }

        private int getDeaths(StatsCounter statsManager) {
            return this.deathStat != null ? statsManager.m_13015_(this.deathStat) : 0;
        }
    }
}

