/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.event;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.gui.overlay.ScreenOverlayRenderer;
import net.tslat.aoa3.client.model.armor.AoAMiscModels;
import net.tslat.aoa3.client.render.entity.layer.PlayerHaloRenderLayer;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.HaloChangePacket;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.content.entity.mob.greckon.SilencerEntity;
import net.tslat.aoa3.data.client.AdventGuiThemeReloadListener;
import net.tslat.aoa3.data.client.BestiaryReloadListener;
import net.tslat.aoa3.data.client.MiscellaneousReloadListener;
import net.tslat.aoa3.data.client.RealmstoneInsertsReloadListener;
import net.tslat.aoa3.data.server.AoASkillReqReloadListener;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.player.ClientPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AoAHaloUtil;
import net.tslat.aoa3.util.LocaleUtil;

public final class ClientEventHandler {
    public static void init() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, false, TickEvent.ClientTickEvent.class, ClientEventHandler::onClientTick);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerLoggedInEvent.class, ClientEventHandler::onPlayerJoin);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerLoggedOutEvent.class, ClientEventHandler::onPlayerLogout);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingDeathEvent.class, ClientEventHandler::onPlayerDeath);
        forgeBus.addListener(EventPriority.NORMAL, false, PlaySoundEvent.class, ClientEventHandler::onSoundPlay);
        forgeBus.addListener(EventPriority.NORMAL, false, ItemTooltipEvent.class, ClientEventHandler::onTooltip);
        AdventOfAscension.modEventBus.addListener(EventPriority.NORMAL, false, RegisterClientReloadListenersEvent.class, ClientEventHandler::onResourceListenersRegistration);
        AdventOfAscension.modEventBus.addListener(EventPriority.NORMAL, false, EntityRenderersEvent.AddLayers.class, ClientEventHandler::onRenderLayerRegistration);
    }

    private static void onClientTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            if (!Minecraft.m_91087_().m_91104_()) {
                ScreenOverlayRenderer.tickOverlays();
            }
            if (!Minecraft.m_91087_().m_91091_()) {
                AoAScheduler.handleSyncScheduledTasks(++GlobalEvents.tick);
            }
        }
    }

    private static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent ev) {
        if (ev.getPlayer().f_19853_.m_5776_()) {
            if (((Boolean)AoAConfig.CLIENT.showWelcomeMessage.get()).booleanValue()) {
                if (AoAKeybinds.ADVENT_GUI.getKey().m_84873_() == -1) {
                    ev.getPlayer().m_213846_((Component)LocaleUtil.getLocaleMessage("message.login.welcome.alt", ChatFormatting.GRAY, new Component[0]));
                } else {
                    ev.getPlayer().m_213846_((Component)LocaleUtil.getLocaleMessage("message.login.welcome", ChatFormatting.GRAY, AoAKeybinds.ADVENT_GUI.m_90863_()));
                }
            }
            AoAPackets.INSTANCE.sendTo((Object)new HaloChangePacket((AoAHaloUtil.Type.Choosable)((Object)AoAConfig.CLIENT.personalHaloPreference.get())), ((LocalPlayer)ev.getPlayer()).f_108617_.m_6198_(), NetworkDirection.PLAY_TO_SERVER);
            ClientPlayerDataManager.get().updatePlayerInstance(ev.getPlayer());
        }
    }

    private static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent ev) {
        ClientPlayerDataManager.get().reset();
    }

    private static void onPlayerDeath(LivingDeathEvent ev) {
        if (ev.getEntity() == Minecraft.m_91087_().f_91074_) {
            ScreenOverlayRenderer.clearOverlays();
        }
    }

    private static void onSoundPlay(PlaySoundEvent ev) {
        if (SilencerEntity.isClientNearby) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                SilencerEntity.isClientNearby = false;
                return;
            }
            if (player.f_19853_.m_45976_(SilencerEntity.class, player.m_20191_().m_82400_(8.0)).isEmpty()) {
                SilencerEntity.isClientNearby = false;
                Minecraft.m_91087_().m_91106_().m_120358_(SoundSource.MASTER, SilencerEntity.previousGain);
            }
        }
    }

    private static void onTooltip(ItemTooltipEvent ev) {
        Map<String, List<Pair<ResourceLocation, Integer>>> restrictions = AoASkillReqReloadListener.getParsedReqDataFor(ForgeRegistries.ITEMS.getKey((Object)ev.getItemStack().m_41720_()));
        if (!restrictions.isEmpty()) {
            List lines = ev.getToolTip();
            if (ev.getFlags().m_7050_()) {
                lines.add(1, LocaleUtil.getLocaleMessage("gui.tooltip.skillReq", ChatFormatting.DARK_RED, new Component[0]));
                int index = 2;
                for (Map.Entry<String, List<Pair<ResourceLocation, Integer>>> reqEntry : restrictions.entrySet()) {
                    lines.add(index++, Component.m_237113_((String)"  ").m_130940_(ChatFormatting.RED).m_7220_((Component)LocaleUtil.getLocaleMessage(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.LEVEL_RESTRICTION.getId()) + ".description." + reqEntry.getKey())).m_130946_(":"));
                    for (Pair<ResourceLocation, Integer> pair : reqEntry.getValue()) {
                        AoASkill skill = AoASkills.getSkill((ResourceLocation)pair.getFirst());
                        lines.add(index++, Component.m_237113_((String)"    ").m_130940_(ChatFormatting.GOLD).m_130946_(pair.getSecond() + " ").m_7220_((Component)skill.getName()));
                    }
                }
                lines.add(index, Component.m_237113_((String)""));
            } else {
                lines.add(1, LocaleUtil.getLocaleMessage("gui.tooltip.skillReq.hidden", ChatFormatting.DARK_RED, new Component[0]));
            }
        }
    }

    private static void onResourceListenersRegistration(RegisterClientReloadListenersEvent ev) {
        ev.registerReloadListener((PreparableReloadListener)new BestiaryReloadListener());
        ev.registerReloadListener((PreparableReloadListener)new MiscellaneousReloadListener());
        ev.registerReloadListener((PreparableReloadListener)new RealmstoneInsertsReloadListener());
        ev.registerReloadListener((PreparableReloadListener)new AdventGuiThemeReloadListener());
        ev.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> {
            if (ModLoader.isLoadingStateValid()) {
                AoAMiscModels.generateFactories();
            }
        }));
    }

    private static void onRenderLayerRegistration(EntityRenderersEvent.AddLayers ev) {
        for (String skin : ev.getSkins()) {
            LivingEntityRenderer renderer = ev.getSkin(skin);
            renderer.m_115326_((RenderLayer)new PlayerHaloRenderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer, ev.getEntityModels()));
        }
    }
}

