/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.worldgen.feature;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.advent.datagen.builder.worldgen.feature.WorldgenFeatureBuilder;
import net.tslat.aoa3.advent.datagen.worldgen.feature.DataGenPlacedFeatures;
import net.tslat.aoa3.advent.datagen.worldgen.feature.dim.DataGenOverworldFeatures;
import org.apache.logging.log4j.Level;

public final class DataGenConfiguredFeatures
implements DataProvider {
    static final HashMap<String, WorldgenFeatureBuilder<?>> FEATURES = new HashMap();
    private final DataGenerator generator;

    public DataGenConfiguredFeatures(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        Path outputPath = this.generator.m_123916_();
        ArrayList<WorldgenFeatureBuilder> features = new ArrayList<WorldgenFeatureBuilder>();
        features.addAll(DataGenOverworldFeatures.generate());
        features.forEach(feature -> {
            DataGenPlacedFeatures.generatedFeatures.add(feature.placedFeatureBuilder());
            ResourceLocation path = feature.getId();
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)feature.toJson(), (Path)DataGenConfiguredFeatures.getPath(outputPath, feature.getId()));
            }
            catch (IOException ex) {
                Logging.logMessage(Level.ERROR, "Unable to save configured feature json: " + path);
            }
        });
    }

    public String m_6055_() {
        return "Configured Features";
    }

    private static Path getPath(Path rootPath, ResourceLocation id) {
        return rootPath.resolve("data/" + id.m_135827_() + "/worldgen/configured_feature/" + id.m_135815_() + ".json");
    }
}

