/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.registration.AoARecipes;

public class UpgradeKitRecipeBuilder {
    private final ItemStack output;
    private final Ingredient input;
    private final Ingredient upgradeKit;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private String group = "";

    public UpgradeKitRecipeBuilder(ItemLike input, ItemLike upgradeKit, ItemLike output) {
        this(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input.m_5456_()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{upgradeKit.m_5456_()}), output, 1);
    }

    public UpgradeKitRecipeBuilder(Ingredient input, Ingredient upgradeKit, ItemLike output, int amount) {
        this.input = input;
        this.upgradeKit = upgradeKit;
        this.output = new ItemStack(output, amount);
    }

    public UpgradeKitRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public UpgradeKitRecipeBuilder addCriterion(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        CreativeModeTab itemGroup = this.output.m_41720_().m_41471_();
        consumer.accept(new Result(id, this.group, this.input, this.upgradeKit, this.output, this.advancementBuilder, new ResourceLocation(id.m_135827_(), "recipes/" + (String)(itemGroup == null ? "" : itemGroup.m_40783_() + "/") + id.m_135815_())));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack output;
        private final Ingredient input;
        private final Ingredient upgradeKit;
        private final String group;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        private Result(ResourceLocation id, String group, Ingredient input, Ingredient upgradeKit, ItemStack output, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.group = group;
            this.input = input;
            this.upgradeKit = upgradeKit;
            this.output = output;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("input", this.input.m_43942_());
            json.add("upgrade_kit", this.upgradeKit.m_43942_());
            JsonObject result = new JsonObject();
            result.addProperty("item", Registry.f_122827_.m_7981_((Object)this.output.m_41720_()).toString());
            if (this.output.m_41613_() > 1) {
                result.addProperty("count", (Number)this.output.m_41613_());
            }
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)AoARecipes.UPGRADE_KIT.serializer().get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

