/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.tslat.aoa3.common.registration.AoARecipes;

public class InfusionRecipeBuilder {
    private final ItemStack output;
    private final Ingredient input;
    private final ArrayList<Ingredient> ingredients;
    private final int minXp;
    private final int maxXp;
    private final int infusionReq;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private String group = "";

    public InfusionRecipeBuilder(Ingredient input, ArrayList<Ingredient> ingredients, ItemStack output) {
        this(input, ingredients, output, 0, 0, 1);
    }

    public InfusionRecipeBuilder(Ingredient input, ArrayList<Ingredient> ingredients, ItemStack output, int infusionReq) {
        this(input, ingredients, output, 0, 0, infusionReq);
    }

    public InfusionRecipeBuilder(Ingredient input, ArrayList<Ingredient> ingredients, ItemStack output, int minXp, int maxXp, int infusionReq) {
        this.input = input;
        this.ingredients = ingredients;
        this.output = output;
        this.minXp = minXp;
        this.maxXp = maxXp;
        this.infusionReq = infusionReq;
        if (ingredients.size() > 9 || ingredients.size() < 1) {
            throw new IllegalArgumentException("Invalid ingredients list for Infusion Recipe. Must be between 1 and 9 ingredients (inclusive). Provided ingredients list size: " + ingredients.size());
        }
        if (maxXp < minXp) {
            throw new IllegalArgumentException("Invalid XP arguments for Infusion Recipe. Max XP must be equal to or higher than Min XP.");
        }
        if (infusionReq < 1 || infusionReq > 1000) {
            throw new IllegalArgumentException("Invalid Infusion level requirement for Infusion Recipe. Level must be between 1 and 1000. Level given: " + infusionReq);
        }
    }

    public InfusionRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public InfusionRecipeBuilder addCriterion(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, Registry.f_122827_.m_7981_((Object)this.output.m_41720_()));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        CreativeModeTab itemGroup = this.output.m_41720_().m_41471_();
        consumer.accept(new Result(id, this.group, this.input, this.ingredients, this.output, this.minXp, this.maxXp, this.infusionReq, this.advancementBuilder, new ResourceLocation(id.m_135827_(), "recipes/" + (String)(itemGroup == null ? "" : itemGroup.m_40783_() + "/") + id.m_135815_())));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack output;
        private final Ingredient input;
        private final ArrayList<Ingredient> ingredients;
        private final int minXp;
        private final int maxXp;
        private final int infusionReq;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final String group;

        private Result(ResourceLocation id, String group, Ingredient input, ArrayList<Ingredient> ingredients, ItemStack output, int minXp, int maxXp, int infusionReq, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.input = input;
            this.output = output;
            this.ingredients = ingredients;
            this.minXp = minXp;
            this.maxXp = maxXp;
            this.infusionReq = infusionReq;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
            this.group = group;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("input", this.input.m_43942_());
            if (this.infusionReq > 1) {
                json.addProperty("infusion_level", (Number)this.infusionReq);
            }
            if (this.maxXp > 0) {
                if (this.maxXp != this.minXp) {
                    JsonObject xpOBj = new JsonObject();
                    xpOBj.addProperty("min", (Number)this.minXp);
                    xpOBj.addProperty("max", (Number)this.maxXp);
                    json.add("infusion_xp", (JsonElement)xpOBj);
                } else {
                    json.addProperty("infusion_xp", (Number)this.minXp);
                }
            }
            JsonArray ingredientArray = new JsonArray();
            for (Ingredient ing : this.ingredients) {
                ingredientArray.add(ing.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredientArray);
            JsonObject result = new JsonObject();
            result.addProperty("item", Registry.f_122827_.m_7981_((Object)this.output.m_41720_()).toString());
            if (this.output.m_41613_() > 1) {
                result.addProperty("count", (Number)this.output.m_41613_());
            }
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)AoARecipes.INFUSION.serializer().get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

