/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.registration.AoARecipes;

public class ImbuingRecipeBuilder {
    private final EnchantmentInstance enchantment;
    private final ArrayList<Ingredient> ingredients;
    private final int minXp;
    private final int maxXp;
    private final int infusionReq;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private String group = "";

    public ImbuingRecipeBuilder(ArrayList<Ingredient> ingredients, EnchantmentInstance enchantment) {
        this(ingredients, enchantment, 0, 0, 1);
    }

    public ImbuingRecipeBuilder(ArrayList<Ingredient> ingredients, EnchantmentInstance enchantment, int infusionReq) {
        this(ingredients, enchantment, 0, 0, infusionReq);
    }

    public ImbuingRecipeBuilder(ArrayList<Ingredient> ingredients, EnchantmentInstance enchantment, int minXp, int maxXp, int infusionReq) {
        this.ingredients = ingredients;
        this.enchantment = enchantment;
        this.minXp = minXp;
        this.maxXp = maxXp;
        this.infusionReq = infusionReq;
        if (ingredients.size() > 9) {
            throw new IllegalArgumentException("Invalid ingredients list for Imbuing Recipe. Max ingredients in grid: 9. Provided ingredients list size: " + ingredients.size());
        }
        if (maxXp < minXp) {
            throw new IllegalArgumentException("Invalid XP arguments for Imbuing Recipe. Max XP must be equal to or higher than Min XP.");
        }
        if (infusionReq < 1 || infusionReq > 1000) {
            throw new IllegalArgumentException("Invalid Infusion level requirement for Imbuing Recipe. Level must be between 1 and 1000. Level given: " + infusionReq);
        }
    }

    public ImbuingRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public ImbuingRecipeBuilder addCriterion(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.group, this.ingredients, this.enchantment, this.minXp, this.maxXp, this.infusionReq, this.advancementBuilder, new ResourceLocation(id.m_135827_(), "recipes/imbuing/" + id.m_135815_())));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final EnchantmentInstance enchantment;
        private final ArrayList<Ingredient> ingredients;
        private final int minXp;
        private final int maxXp;
        private final int infusionReq;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final String group;

        private Result(ResourceLocation id, String group, ArrayList<Ingredient> ingredients, EnchantmentInstance enchantment, int minXp, int maxXp, int infusionReq, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.enchantment = enchantment;
            this.ingredients = ingredients;
            this.minXp = minXp;
            this.maxXp = maxXp;
            this.infusionReq = infusionReq;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
            this.group = group;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonObject infusionObj = new JsonObject();
            infusionObj.addProperty("enchantment", ForgeRegistries.ENCHANTMENTS.getKey((Object)this.enchantment.f_44947_).toString());
            if (this.enchantment.f_44948_ > 1) {
                infusionObj.addProperty("level", (Number)this.enchantment.f_44948_);
            }
            json.add("infusion", (JsonElement)infusionObj);
            if (this.infusionReq > 1) {
                json.addProperty("infusion_level", (Number)this.infusionReq);
            }
            if (this.maxXp > 0) {
                if (this.maxXp != this.minXp) {
                    JsonObject xpOBj = new JsonObject();
                    xpOBj.addProperty("min", (Number)this.minXp);
                    xpOBj.addProperty("max", (Number)this.maxXp);
                    json.add("infusion_xp", (JsonElement)xpOBj);
                } else {
                    json.addProperty("infusion_xp", (Number)this.minXp);
                }
            }
            JsonArray ingredientArray = new JsonArray();
            for (Ingredient ing : this.ingredients) {
                ingredientArray.add(ing.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredientArray);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)AoARecipes.INFUSION.serializer().get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

