/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.recipes;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.advent.datagen.builder.recipe.RecipeBuilder;
import net.tslat.aoa3.advent.datagen.recipes.DataGenBlockRecipes;
import net.tslat.aoa3.advent.datagen.recipes.DataGenItemRecipes;
import org.apache.logging.log4j.Level;

public class DataGenRecipes
extends RecipeProvider {
    public static final ArrayList<RecipeBuilder> RECIPES = new ArrayList();
    private final DataGenerator generator;

    public DataGenRecipes(DataGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public void m_213708_(CachedOutput cache) {
        Path path = this.generator.m_123916_();
        HashSet recipeSet = new HashSet();
        Consumer<FinishedRecipe> serializer = recipe -> {
            if (!recipeSet.add(recipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.m_6445_());
            }
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)recipe.m_125966_(), (Path)path.resolve("data/" + recipe.m_6445_().m_135827_() + "/recipes/" + recipe.m_6445_().m_135815_() + ".json"));
            }
            catch (IOException ex) {
                Logging.logMessage(Level.ERROR, "Couldn't save recipe: " + path, ex);
            }
        };
        DataGenBlockRecipes.registerRecipes();
        DataGenItemRecipes.registerRecipes();
        for (RecipeBuilder recipe2 : RECIPES) {
            try {
                recipe2.finalise(serializer);
            }
            catch (Exception ex) {
                if (recipe2.getId() != null) {
                    Logging.logMessage(Level.FATAL, "Failed to finalise recipe: " + recipe2.getId().toString());
                } else {
                    Logging.logMessage(Level.FATAL, "Failed to finalise recipe of type: " + recipe2.getType().toString());
                    Logging.logMessage(Level.INFO, "Has ingredients: ");
                    for (Ingredient ing : recipe2.getIngredients()) {
                        Logging.logMessage(Level.INFO, ForgeRegistries.ITEMS.getKey((Object)ing.m_43908_()[0].m_41720_()).toString());
                    }
                }
                throw ex;
            }
        }
    }
}

