/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.recipes;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.datagen.builder.recipe.RecipeBuilder;
import net.tslat.aoa3.advent.datagen.builder.recipe.ToolInteractionRecipeBuilder;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.common.registration.item.AoAWeapons;

public class DataGenItemRecipes {
    protected static void registerRecipes() {
        DataGenItemRecipes.registerRuneRecipes();
        DataGenItemRecipes.registerTabletRecipes();
        DataGenItemRecipes.registerToolRecipes();
        DataGenItemRecipes.registerWeaponRecipes();
        DataGenItemRecipes.registerNuggetRecipes();
        DataGenItemRecipes.registerUpgradeKitRecipes();
        DataGenItemRecipes.registerSmeltingRecipes();
        DataGenItemRecipes.registerCookingRecipes();
        DataGenItemRecipes.registerImbuingRecipes();
        DataGenItemRecipes.registerInfusionRecipes();
        DataGenItemRecipes.registerMiscItemRecipes();
    }

    private static void registerRuneRecipes() {
        BiConsumer<ItemLike, Item> consumer = (ingredient, rune) -> {
            new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", "ABA", "AAA").ingredient('A', (ItemLike)AoAItems.UNPOWERED_RUNE.get()).ingredient('B', (ItemLike)ingredient).output(new ItemStack((ItemLike)rune, 8));
            new RecipeBuilder("shaped_craft_" + ForgeRegistries.ITEMS.getKey(rune).m_135815_() + "_powered", RecipeBuilder.Type.SHAPED).shape("AAA", "ABA", "AAA").ingredient('A', (ItemLike)AoAItems.CHARGED_RUNE.get()).ingredient('B', (ItemLike)ingredient).output(new ItemStack((ItemLike)rune, 16));
        };
        consumer.accept((ItemLike)Items.f_42522_, (Item)AoAItems.COMPASS_RUNE.get());
        consumer.accept((ItemLike)Items.f_42584_, (Item)AoAItems.DISTORTION_RUNE.get());
        consumer.accept((ItemLike)Blocks.f_50130_, (Item)AoAItems.ENERGY_RUNE.get());
        consumer.accept((ItemLike)Items.f_42484_, (Item)AoAItems.FIRE_RUNE.get());
        consumer.accept((ItemLike)Items.f_42109_, (Item)AoAItems.KINETIC_RUNE.get());
        consumer.accept((ItemLike)Items.f_42677_, (Item)AoAItems.LIFE_RUNE.get());
        consumer.accept((ItemLike)Items.f_42731_, (Item)AoAItems.LUNAR_RUNE.get());
        consumer.accept((ItemLike)Items.f_42675_, (Item)AoAItems.POISON_RUNE.get());
        consumer.accept((ItemLike)Blocks.f_50330_, (Item)AoAItems.POWER_RUNE.get());
        consumer.accept((ItemLike)Blocks.f_50329_, (Item)AoAItems.STORM_RUNE.get());
        consumer.accept((ItemLike)Items.f_42412_, (Item)AoAItems.STRIKE_RUNE.get());
        consumer.accept((ItemLike)Items.f_42447_, (Item)AoAItems.WATER_RUNE.get());
        consumer.accept((ItemLike)Items.f_42583_, (Item)AoAItems.WITHER_RUNE.get());
        BiConsumer<TagKey, Item> tagConsumer = (ingredient, rune) -> {
            new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", "ABA", "AAA").ingredient('A', (ItemLike)AoAItems.UNPOWERED_RUNE.get()).ingredient('B', (TagKey<Item>)ingredient).output(new ItemStack((ItemLike)rune, 8));
            new RecipeBuilder("shaped_craft_" + ForgeRegistries.ITEMS.getKey(rune).m_135815_() + "_powered", RecipeBuilder.Type.SHAPED).shape("AAA", "ABA", "AAA").ingredient('A', (ItemLike)AoAItems.CHARGED_RUNE.get()).ingredient('B', (TagKey<Item>)ingredient).output(new ItemStack((ItemLike)rune, 16));
        };
        tagConsumer.accept(Tags.Items.FEATHERS, (Item)AoAItems.WIND_RUNE.get());
    }

    private static void registerTabletRecipes() {
        BiConsumer<ItemLike, ItemStack> consumer = (input, output) -> {};
        consumer.accept((ItemLike)Items.f_42502_, new ItemStack((ItemLike)AoAItems.AGILITY_TABLET.get()));
        consumer.accept((ItemLike)Blocks.f_50141_, new ItemStack((ItemLike)AoAItems.AWARENESS_TABLET.get()));
        consumer.accept((ItemLike)Items.f_42677_, new ItemStack((ItemLike)AoAItems.BREEDING_TABLET.get()));
        consumer.accept((ItemLike)Items.f_42455_, new ItemStack((ItemLike)AoAItems.CLEANSING_TABLET.get()));
        consumer.accept((ItemLike)AoAItems.LUNA_GLOBE.get(), new ItemStack((ItemLike)AoAItems.DISTORTION_TABLET.get()));
        consumer.accept((ItemLike)AoAItems.EYE_CANDY.get(), new ItemStack((ItemLike)AoAItems.ENERGY_TABLET.get()));
        consumer.accept((ItemLike)AoAItems.GOLDICAP_PETALS.get(), new ItemStack((ItemLike)AoAItems.GRAVITY_TABLET.get()));
        consumer.accept((ItemLike)AoAItems.BUBBLE_BERRIES.get(), new ItemStack((ItemLike)AoAItems.OXYGEN_TABLET.get()));
        consumer.accept((ItemLike)AoAWeapons.GOO_BALL.get(), new ItemStack((ItemLike)AoAItems.PRESSURE_TABLET.get()));
        consumer.accept((ItemLike)AoAItems.ARMOUR_PLATING.get(), new ItemStack((ItemLike)AoAItems.RESISTANCE_TABLET.get()));
        consumer.accept((ItemLike)Items.f_42613_, new ItemStack((ItemLike)AoAItems.SANCTITY_TABLET.get()));
        consumer.accept((ItemLike)Items.f_42436_, new ItemStack((ItemLike)AoAItems.SATIATION_TABLET.get()));
        consumer.accept((ItemLike)AoAItems.SHARP_CLAW.get(), new ItemStack((ItemLike)AoAItems.STRENGTH_TABLET.get()));
        consumer.accept((ItemLike)AoAItems.HEART_FRUIT.get(), new ItemStack((ItemLike)AoAItems.UNTIRING_TABLET.get()));
        consumer.accept((ItemLike)Items.f_42437_, new ItemStack((ItemLike)AoAItems.VITALITY_TABLET.get()));
        BiConsumer<TagKey, ItemStack> tagConsumer = (input, output) -> {};
        tagConsumer.accept(Tags.Items.CROPS_CARROT, new ItemStack((ItemLike)AoAItems.SIGHT_TABLET.get()));
    }

    private static void registerToolRecipes() {
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AA", "AB", " B").ingredient('A', AoATags.Items.INGOTS_EMBERSTONE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.EMBERSTONE_AXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AB", "AC", " D").ingredient('A', (TagKey<Item>)Tags.Items.INGOTS_IRON).ingredient('B', (ItemLike)AoAItems.BALLOON.get()).ingredient('C', (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get()).ingredient('D', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.GOOFY_AXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AA", "AB", " B").ingredient('A', AoATags.Items.GEMS_JADE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.JADE_AXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AA", "AB", " B").ingredient('A', AoATags.Items.INGOTS_LIMONITE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.LIMONITE_AXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AA", "AB", " B").ingredient('A', (ItemLike)AoAItems.ORNAMYTE.get()).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.ORNAMYTE_AXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AA", "AB", " B").ingredient('A', AoATags.Items.PRECASIAN_BONE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.SKELETAL_AXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", " B ", " B ").ingredient('A', AoATags.Items.INGOTS_EMBERSTONE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.EMBERSTONE_PICKAXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", " B ", " C ").ingredient('A', AoATags.Items.GEMS_CRYSTALLITE).ingredient('B', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).ingredient('C', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.GEMCRACKER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABA", " C ", " D ").ingredient('A', (ItemLike)AoAItems.BALLOON.get()).ingredient('B', (TagKey<Item>)Tags.Items.INGOTS_IRON).ingredient('C', (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get()).ingredient('D', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.GOOFY_PICKAXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", " B ", " B ").ingredient('A', AoATags.Items.GEMS_JADE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.JADE_PICKAXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", " B ", " B ").ingredient('A', AoATags.Items.INGOTS_LIMONITE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.LIMONITE_PICKAXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", " B ", " B ").ingredient('A', (ItemLike)AoAItems.ORNAMYTE.get()).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.ORNAMYTE_PICKAXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABA", " C ", " B ").ingredient('A', AoATags.Items.INGOTS_SHYRESTONE).ingredient('B', AoATags.Items.GEMS_SHYREGEM).ingredient('C', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoATools.PICKMAX.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", " B ", " B ").ingredient('A', AoATags.Items.PRECASIAN_BONE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.SKELETAL_PICKAXE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "B").ingredient('A', AoATags.Items.INGOTS_EMBERSTONE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.EMBERSTONE_SHOVEL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "C").ingredient('A', (ItemLike)AoAItems.BALLOON.get()).ingredient('B', (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get()).ingredient('C', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.GOOFY_SHOVEL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "B").ingredient('A', AoATags.Items.GEMS_JADE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.JADE_SHOVEL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "B").ingredient('A', AoATags.Items.INGOTS_LIMONITE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.LIMONITE_SHOVEL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "B").ingredient('A', (ItemLike)AoAItems.ORNAMYTE.get()).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.ORNAMYTE_SHOVEL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "B").ingredient('A', AoATags.Items.PRECASIAN_BONE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.SKELETAL_SHOVEL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("LL", " S", " S").ingredient('L', AoATags.Items.INGOTS_LIMONITE).ingredient('S', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.LIMONITE_HOE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("JJ", " S", " S").ingredient('J', AoATags.Items.GEMS_JADE).ingredient('S', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.JADE_HOE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("EE", " S", " S").ingredient('E', AoATags.Items.INGOTS_EMBERSTONE).ingredient('S', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoATools.EMBERSTONE_HOE.get(), 1));
    }

    private static void registerWeaponRecipes() {
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", " AB").ingredient('A', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', AoATags.Items.GEMS_JADE).output(new ItemStack((ItemLike)AoAWeapons.ALACRITY_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", " DB").ingredient('A', AoATags.Items.INGOTS_BARONYTE).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredient('D', AoATags.Items.INGOTS_BLAZIUM).output(new ItemStack((ItemLike)AoAWeapons.BARON_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", " AB").ingredient('A', AoATags.Items.INGOTS_GHOULISH).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.GHOULASM.get()).output(new ItemStack((ItemLike)AoAWeapons.HAUNTED_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", " AB").ingredient('A', (ItemLike)AoAItems.ICE_CRYSTAL.get()).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.REINFORCED_CLOTH.get()).output(new ItemStack((ItemLike)AoAWeapons.ICE_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", " AB").ingredient('A', AoATags.Items.INGOTS_BLAZIUM).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.REINFORCED_CLOTH.get()).output(new ItemStack((ItemLike)AoAWeapons.INFERNAL_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("DAB", "C B", "DAB").ingredient('A', AoATags.Items.GEMS_CRYSTALLITE).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredient('D', (ItemLike)AoAItems.SHARP_CLAW.get()).output(new ItemStack((ItemLike)AoAWeapons.JUSTICE_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", "DAB").ingredient('A', AoATags.Items.INGOTS_LUNAR).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.ORBULON.get()).ingredient('D', (ItemLike)AoAItems.FLOATING_STONE.get()).output(new ItemStack((ItemLike)AoAWeapons.LUNAR_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.INCOMPLETE_MECHA_BOW.get()).ingredients((ItemLike)AoAItems.POWER_CORE.get()).ingredients((ItemLike)AoAItems.MECHA_GEAR.get()).output(new ItemStack((ItemLike)AoAWeapons.MECHA_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", " AB").ingredient('A', (ItemLike)AoAItems.NIGHTMARE_FLAKES.get()).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.REINFORCED_CLOTH.get()).output(new ItemStack((ItemLike)AoAWeapons.NIGHTMARE_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", " AB").ingredient('A', AoATags.Items.INGOTS_SKELETAL).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.SKULLBONE_FRAGMENT.get()).output(new ItemStack((ItemLike)AoAWeapons.PREDATIOUS_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", " AB").ingredient('A', (ItemLike)AoAItems.ROSID_ROOT.get()).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.REINFORCED_CLOTH.get()).output(new ItemStack((ItemLike)AoAWeapons.ROSIDIAN_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "A B", " AB").ingredient('A', (ItemLike)AoAItems.DENSE_ROCK.get()).ingredient('B', (TagKey<Item>)Tags.Items.STRING).output(new ItemStack((ItemLike)AoAWeapons.SCREAMER_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", " AB").ingredient('A', AoATags.Items.INGOTS_SHYRESTONE).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', AoATags.Items.GEMS_SHYREGEM).output(new ItemStack((ItemLike)AoAWeapons.SHYREGEM_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "A B", " AB").ingredient('A', AoATags.Items.INGOTS_SKELETAL).ingredient('B', (TagKey<Item>)Tags.Items.STRING).output(new ItemStack((ItemLike)AoAWeapons.SKELETAL_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("DAB", "C B", "DAB").ingredient('A', AoATags.Items.INGOTS_ELECANIUM).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.RUNIC_ENERGY.get()).ingredient('D', (ItemLike)AoAItems.GHOSTLY_POWDER.get()).output(new ItemStack((ItemLike)AoAWeapons.SOULFIRE_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("DAB", "C B", "DAB").ingredient('A', (ItemLike)AoAItems.BLUE_DRUSE.get()).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.WHITE_DRUSE.get()).ingredient('D', (ItemLike)AoAItems.GHOSTLY_POWDER.get()).output(new ItemStack((ItemLike)AoAWeapons.SPECTRAL_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", " AB").ingredient('A', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.FLOATING_STONE.get()).output(new ItemStack((ItemLike)AoAWeapons.SPEED_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "C B", " AB").ingredient('A', (ItemLike)AoAItems.TOXIC_LUMP.get()).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', AoATags.Items.GEMS_JADE).output(new ItemStack((ItemLike)AoAWeapons.TOXIN_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" AB", "A B", " AB").ingredient('A', (ItemLike)AoAItems.VOID_SCALES.get()).ingredient('B', (TagKey<Item>)Tags.Items.STRING).output(new ItemStack((ItemLike)AoAWeapons.VOID_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("DAB", "C B", "DAB").ingredient('A', (TagKey<Item>)Tags.Items.INGOTS_GOLD).ingredient('B', (TagKey<Item>)Tags.Items.STRING).ingredient('C', (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredient('D', (ItemLike)AoAItems.YELLOW_SPORES.get()).output(new ItemStack((ItemLike)AoAWeapons.WEAKEN_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.INCOMPLETE_MECHA_CANNON.get()).ingredients((ItemLike)AoAItems.POWER_CORE.get()).ingredients((ItemLike)AoAItems.MECHA_GEAR.get()).output(new ItemStack((ItemLike)AoAWeapons.MECHA_CANNON.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.INCOMPLETE_MECHA_CROSSBOW.get()).ingredients((ItemLike)AoAItems.POWER_CORE.get()).ingredients((ItemLike)AoAItems.MECHA_GEAR.get()).output(new ItemStack((ItemLike)AoAWeapons.MECHA_CROSSBOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", " A ", "BCD").ingredient('A', AoATags.Items.GEMS_BLOODSTONE).ingredient('B', (TagKey<Item>)Tags.Items.INGOTS_IRON).ingredient('C', AoATags.Items.RODS_METAL).ingredient('D', (ItemLike)Items.f_42591_).output(new ItemStack((ItemLike)AoAWeapons.BLOODLURKER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" B ", "ABA", " C ").ingredient('A', (ItemLike)Blocks.f_50585_).ingredient('B', (ItemLike)AoAItems.CORAL_STONE.get()).ingredient('C', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoAWeapons.CORAL_GREATBLADE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", " B ", "CDC").ingredient('A', AoATags.Items.GEMS_GEMENYTE).ingredient('B', AoATags.Items.GEMS_JEWELYTE).ingredient('C', (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredient('D', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoAWeapons.CREEPOID_GREATBLADE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", " B ", "BCB").ingredient('A', AoATags.Items.GEMS_JADE).ingredient('B', (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get()).ingredient('C', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoAWeapons.GOOFY_GREATBLADE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", "ABD", "BCB").ingredient('A', AoATags.Items.GEMS_SHYREGEM).ingredient('B', AoATags.Items.INGOTS_SHYRESTONE).ingredient('C', AoATags.Items.RODS_METAL).ingredient('D', (ItemLike)AoAItems.ARMOUR_PLATING.get()).output(new ItemStack((ItemLike)AoAWeapons.KNIGHTS_GUARD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", "BAB", " C ").ingredient('A', (TagKey<Item>)Tags.Items.INGOTS_GOLD).ingredient('B', (ItemLike)AoAItems.ORANGE_SPORES.get()).ingredient('C', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoAWeapons.LELYETIAN_GREATBLADE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", "DAD", "BCB").ingredient('A', AoATags.Items.INGOTS_BARONYTE).ingredient('B', (TagKey<Item>)Tags.Items.INGOTS_GOLD).ingredient('C', AoATags.Items.RODS_METAL).ingredient('D', (TagKey<Item>)Tags.Items.NUGGETS_GOLD).output(new ItemStack((ItemLike)AoAWeapons.ROYAL_GREATBLADE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("DAD", "DAD", "BCB").ingredient('A', (TagKey<Item>)Tags.Items.INGOTS_IRON).ingredient('B', AoATags.Items.INGOTS_ELECANIUM).ingredient('C', AoATags.Items.RODS_METAL).ingredient('D', (ItemLike)AoAItems.RUNIC_ENERGY.get()).output(new ItemStack((ItemLike)AoAWeapons.RUNIC_GREATBLADE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", "ABA", " B ").ingredient('A', (ItemLike)AoAItems.MUSHROOM_SPORES.get()).ingredient('B', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoAWeapons.SHROOMIC_GREATBLADE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", "BDB", "ACA").ingredient('A', AoATags.Items.INGOTS_SHYRESTONE).ingredient('B', AoATags.Items.GEMS_SHYREGEM).ingredient('C', AoATags.Items.RODS_METAL).ingredient('D', (ItemLike)Blocks.f_50141_).output(new ItemStack((ItemLike)AoAWeapons.SHYRE_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AB ", "CB ", "DED").ingredient('A', (TagKey<Item>)Tags.Items.DUSTS_REDSTONE).ingredient('B', (ItemLike)AoAItems.DENSE_ROCK.get()).ingredient('C', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).ingredient('D', (ItemLike)Items.f_42591_).ingredient('E', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoAWeapons.UNDERWORLD_GREATBLADE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.INCOMPLETE_MECHANICAL_ASSAULT_RIFLE.get()).ingredients((ItemLike)AoAItems.POWER_CORE.get()).ingredients((ItemLike)AoAItems.MECHA_GEAR.get()).output(new ItemStack((ItemLike)AoAWeapons.MECHANICAL_ASSAULT_RIFLE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).ingredient('A', (ItemLike)AoAItems.CORAL_STONE.get()).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', (ItemLike)Blocks.f_50587_).shape("ACA", "ABA", " B ").output(new ItemStack((ItemLike)AoAWeapons.CORALSTONE_MAUL.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).ingredient('A', (ItemLike)AoAItems.FLOATING_STONE.get()).ingredient('B', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).ingredient('C', AoATags.Items.RODS_METAL).shape("ABA", " C ", " C ").output(new ItemStack((ItemLike)AoAWeapons.HORIZON_MAUL.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(Tags.Items.GUNPOWDER).ingredients((ItemLike)AoAItems.SCRAP_METAL.get()).ingredients(Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.GRENADE.get(), 3));
        new RecipeBuilder("grenade_from_unstable_gunpowder", RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredients((ItemLike)AoAItems.SCRAP_METAL.get()).ingredients(Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.GRENADE.get(), 10));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.INCOMPLETE_MECHYRO.get()).ingredients((ItemLike)AoAItems.POWER_CORE.get()).ingredients((ItemLike)AoAItems.MECHA_GEAR.get()).output(new ItemStack((ItemLike)AoAWeapons.MECHYRO.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("CAC", "ABA", " B ").ingredient('A', (ItemLike)AoAItems.CORAL_STONE.get()).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', (ItemLike)AoAItems.WATER_RUNE.get()).output(new ItemStack((ItemLike)AoAWeapons.AQUATIC_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("CDC", " A ", " B ").ingredient('A', AoATags.Items.INGOTS_BARONYTE).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', (ItemLike)AoAItems.POWER_RUNE.get()).ingredient('D', (ItemLike)AoAItems.HIVE_CHUNK.get()).output(new ItemStack((ItemLike)AoAWeapons.BARON_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", "A A", " B ").ingredient('A', AoATags.Items.GEMS_CRYSTALLITE).ingredient('B', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoAWeapons.CELESTIAL_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABA", " B ", " C ").ingredient('A', (ItemLike)AoAItems.ICE_CRYSTAL.get()).ingredient('B', (ItemLike)AoAItems.BLUE_DRUSE.get()).ingredient('C', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoAWeapons.CRYSTIK_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("CDC", " A ", " B ").ingredient('A', AoATags.Items.INGOTS_LYON).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', (TagKey<Item>)Tags.Items.GUNPOWDER).ingredient('D', AoATags.Items.INGOTS_BLAZIUM).output(new ItemStack((ItemLike)AoAWeapons.DESTRUCTION_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("DCD", " A ", " B ").ingredient('A', AoATags.Items.INGOTS_EMBERSTONE).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', (ItemLike)AoAItems.FLAMMABLE_DUST.get()).ingredient('D', (ItemLike)AoAItems.WIND_RUNE.get()).output(new ItemStack((ItemLike)AoAWeapons.EMBER_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("DCD", " A ", " B ").ingredient('A', AoATags.Items.GEMS_BLOODSTONE).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', (ItemLike)AoAItems.FLAMMABLE_DUST.get()).ingredient('D', (ItemLike)AoAItems.NIGHTMARE_FLAKES.get()).output(new ItemStack((ItemLike)AoAWeapons.FIRESTORM_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "B").ingredient('A', (ItemLike)AoAItems.FIRE_RUNE.get()).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.FIRE_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABC", " D ", " E ").ingredient('A', (ItemLike)AoAItems.ENERGY_RUNE.get()).ingredient('B', (ItemLike)AoAItems.MAGNET_SHARD.get()).ingredient('C', (ItemLike)AoAItems.WITHER_RUNE.get()).ingredient('D', AoATags.Items.INGOTS_LYON).ingredient('E', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoAWeapons.LYONIC_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.INCOMPLETE_MECHA_STAFF.get()).ingredients((ItemLike)AoAItems.POWER_CORE.get()).ingredients((ItemLike)AoAItems.MECHA_GEAR.get()).output(new ItemStack((ItemLike)AoAWeapons.MECHA_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("DCD", " A ", " B ").ingredient('A', AoATags.Items.INGOTS_GHOULISH).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).ingredient('D', (ItemLike)AoAItems.GHOULASM.get()).output(new ItemStack((ItemLike)AoAWeapons.MOONLIGHT_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "B").ingredient('A', (ItemLike)AoAItems.POISON_RUNE.get()).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.POISON_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("DCD", " A ", " B ").ingredient('A', (TagKey<Item>)Tags.Items.INGOTS_IRON).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', (ItemLike)AoAItems.DENSE_ROCK.get()).ingredient('D', (ItemLike)AoABlocks.DEEP_CRYSTAL.get()).output(new ItemStack((ItemLike)AoAWeapons.POWER_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" C ", "DAD", " B ").ingredient('A', (TagKey<Item>)Tags.Items.INGOTS_IRON).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', (ItemLike)Items.f_42436_).ingredient('D', (ItemLike)AoAItems.ROSID_ROOT.get()).output(new ItemStack((ItemLike)AoAWeapons.REJUVENATION_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "C").ingredient('A', (ItemLike)AoAItems.ROSID_ROOT.get()).ingredient('B', (ItemLike)Items.f_42029_).ingredient('C', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoAWeapons.ROSIDIAN_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" C ", "DAD", " B ").ingredient('A', AoATags.Items.INGOTS_BARONYTE).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', (ItemLike)AoAItems.GREEN_DRUSE.get()).ingredient('D', (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get()).output(new ItemStack((ItemLike)AoAWeapons.SHOW_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("DCD", "EAE", " B ").ingredient('A', AoATags.Items.INGOTS_SHYRESTONE).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', AoATags.Items.GEMS_CRYSTALLITE).ingredient('D', AoATags.Items.GEMS_SHYREGEM).ingredient('E', (ItemLike)Items.f_42584_).output(new ItemStack((ItemLike)AoAWeapons.SHYRE_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", "ACA", " B ").ingredient('A', (ItemLike)AoAItems.FLOATING_STONE.get()).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', AoATags.Items.GEMS_CRYSTALLITE).output(new ItemStack((ItemLike)AoAWeapons.SKY_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "B").ingredient('A', (ItemLike)AoAItems.ENERGY_RUNE.get()).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.STRIKER_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ADA", " C ", " B ").ingredient('A', (ItemLike)AoAItems.POWER_RUNE.get()).ingredient('B', AoATags.Items.RODS_METAL).ingredient('C', (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get()).ingredient('D', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAWeapons.SURGE_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "C").ingredient('A', AoATags.Items.GEMS_BLOODSTONE).ingredient('B', (ItemLike)AoAItems.NIGHTMARE_FLAKES.get()).ingredient('C', AoATags.Items.RODS_METAL).output(new ItemStack((ItemLike)AoAWeapons.UNDERWORLD_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "B").ingredient('A', (ItemLike)AoAItems.WATER_RUNE.get()).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.WATER_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "B").ingredient('A', (ItemLike)AoAItems.WIND_RUNE.get()).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.WIND_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B", "B").ingredient('A', (ItemLike)AoAItems.WITHER_RUNE.get()).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.WITHER_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "A", "B").ingredient('A', AoATags.Items.INGOTS_BARONYTE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.BARON_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", " A ", "CBC").ingredient('A', AoATags.Items.GEMS_BLOODSTONE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).ingredient('C', (ItemLike)AoAItems.NIGHTMARE_FLAKES.get()).output(new ItemStack((ItemLike)AoAWeapons.BLOODFURY.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "A", "B").ingredient('A', AoATags.Items.GEMS_BLOODSTONE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.BLOODSTONE_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "A", "B").ingredient('A', AoATags.Items.GEMS_CRYSTALLITE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.CRYSTALLITE_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "A", "B").ingredient('A', AoATags.Items.INGOTS_EMBERSTONE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.EMBERSTONE_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("CDE", " A ", " B ").ingredient('A', AoATags.Items.INGOTS_LYON).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).ingredient('C', (ItemLike)AoAItems.ENCHANTED_GUNPOWDER.get()).ingredient('D', AoATags.Items.INGOTS_BLAZIUM).ingredient('E', (TagKey<Item>)Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.EXPLOCHRON_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", " A ", "CBC").ingredient('A', AoATags.Items.INGOTS_EMBERSTONE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).ingredient('C', (ItemLike)AoAItems.FLAMMABLE_DUST.get()).output(new ItemStack((ItemLike)AoAWeapons.FIREBORNE_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "A", "B").ingredient('A', AoATags.Items.GEMS_JADE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.JADE_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A ", "A ", "BC").ingredient('A', AoATags.Items.INGOTS_SHYRESTONE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).ingredient('C', AoATags.Items.GEMS_SHYREGEM).output(new ItemStack((ItemLike)AoAWeapons.LIGHTS_WAY.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "A", "B").ingredient('A', AoATags.Items.INGOTS_LIMONITE).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).output(new ItemStack((ItemLike)AoAWeapons.LIMONITE_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", " A ", "CBD").ingredient('A', (TagKey<Item>)Tags.Items.OBSIDIAN).ingredient('B', (TagKey<Item>)Tags.Items.RODS_WOODEN).ingredient('C', (ItemLike)AoAItems.DARKLY_POWDER.get()).ingredient('D', (ItemLike)AoAItems.URKA_HIDE.get()).output(new ItemStack((ItemLike)AoAWeapons.SHADOW_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", " B ", "CDE").ingredient('A', (ItemLike)AoAItems.SHARP_CLAW.get()).ingredient('B', (TagKey<Item>)Tags.Items.INGOTS_IRON).ingredient('C', (TagKey<Item>)Tags.Items.GEMS_AMETHYST).ingredient('D', (TagKey<Item>)Tags.Items.RODS_WOODEN).ingredient('E', (ItemLike)AoAItems.CONFETTI_PILE.get()).output(new ItemStack((ItemLike)AoAWeapons.SUPREMACY_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" D ", "BAB", " C ").ingredient('A', (ItemLike)AoAItems.SOUR_GUMMY.get()).ingredient('B', (ItemLike)AoABlocks.PINK_COTTON_CANDY.get()).ingredient('C', (TagKey<Item>)Tags.Items.RODS_WOODEN).ingredient('D', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAWeapons.SWEET_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B").ingredient('A', (ItemLike)AoAItems.BATTLE_VULCANE_AUGMENT.get()).ingredient('B', (ItemLike)AoAWeapons.VULCANE.get()).output(new ItemStack((ItemLike)AoAWeapons.BATTLE_VULCANE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B").ingredient('A', (ItemLike)AoAItems.EQUALITY_VULCANE_AUGMENT.get()).ingredient('B', (ItemLike)AoAWeapons.VULCANE.get()).output(new ItemStack((ItemLike)AoAWeapons.EQUALITY_VULCANE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B").ingredient('A', (ItemLike)AoAItems.FIRE_VULCANE_AUGMENT.get()).ingredient('B', (ItemLike)AoAWeapons.VULCANE.get()).output(new ItemStack((ItemLike)AoAWeapons.FIRE_VULCANE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B").ingredient('A', (ItemLike)AoAItems.IMPAIRMENT_VULCANE_AUGMENT.get()).ingredient('B', (ItemLike)AoAWeapons.VULCANE.get()).output(new ItemStack((ItemLike)AoAWeapons.IMPAIRMENT_VULCANE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B").ingredient('A', (ItemLike)AoAItems.POISON_VULCANE_AUGMENT.get()).ingredient('B', (ItemLike)AoAWeapons.VULCANE.get()).output(new ItemStack((ItemLike)AoAWeapons.POISON_VULCANE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B").ingredient('A', (ItemLike)AoAItems.POWER_VULCANE_AUGMENT.get()).ingredient('B', (ItemLike)AoAWeapons.VULCANE.get()).output(new ItemStack((ItemLike)AoAWeapons.POWER_VULCANE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "B").ingredient('A', (ItemLike)AoAItems.WITHER_VULCANE_AUGMENT.get()).ingredient('B', (ItemLike)AoAWeapons.VULCANE.get()).output(new ItemStack((ItemLike)AoAWeapons.WITHER_VULCANE.get(), 1));
    }

    private static void registerNuggetRecipes() {
        BiConsumer<TagKey, ItemStack> consumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((TagKey<Item>)input).output((ItemStack)output);
        consumer.accept(AoATags.Items.INGOTS_BARONYTE, new ItemStack((ItemLike)AoAItems.BARONYTE_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_VARSIUM, new ItemStack((ItemLike)AoAItems.VARSIUM_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_SHYRESTONE, new ItemStack((ItemLike)AoAItems.SHYRESTONE_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_MYSTITE, new ItemStack((ItemLike)AoAItems.MYSTITE_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_LYON, new ItemStack((ItemLike)AoAItems.LYON_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_LUNAR, new ItemStack((ItemLike)AoAItems.LUNAR_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_LIMONITE, new ItemStack((ItemLike)AoAItems.LIMONITE_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_GHOULISH, new ItemStack((ItemLike)AoAItems.GHOULISH_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_GHASTLY, new ItemStack((ItemLike)AoAItems.GHASTLY_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_EMBERSTONE, new ItemStack((ItemLike)AoAItems.EMBERSTONE_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_ELECANIUM, new ItemStack((ItemLike)AoAItems.ELECANIUM_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_BLAZIUM, new ItemStack((ItemLike)AoAItems.BLAZIUM_NUGGET.get(), 9));
        consumer.accept(AoATags.Items.INGOTS_SKELETAL, new ItemStack((ItemLike)AoAItems.SKELETAL_NUGGET.get(), 9));
        new RecipeBuilder("baronyte_ingot_from_nugget", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.BARONYTE_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.BARONYTE_INGOT.get(), 1));
        new RecipeBuilder("varsium_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.VARSIUM_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.VARSIUM_INGOT.get(), 1));
        new RecipeBuilder("shyrestone_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.SHYRESTONE_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.SHYRESTONE_INGOT.get(), 1));
        new RecipeBuilder("mystite_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.MYSTITE_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.MYSTITE_INGOT.get(), 1));
        new RecipeBuilder("lyon_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.LYON_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.LYON_INGOT.get(), 1));
        new RecipeBuilder("lunar_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.LUNAR_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.LUNAR_INGOT.get(), 1));
        new RecipeBuilder("limonite_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.LIMONITE_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.LIMONITE_INGOT.get(), 1));
        new RecipeBuilder("ghoulish_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.GHOULISH_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.GHOULISH_INGOT.get(), 1));
        new RecipeBuilder("ghastly_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.GHASTLY_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.GHASTLY_INGOT.get(), 1));
        new RecipeBuilder("emberstone_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.EMBERSTONE_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.EMBERSTONE_INGOT.get(), 1));
        new RecipeBuilder("elecanium_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.ELECANIUM_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.ELECANIUM_INGOT.get(), 1));
        new RecipeBuilder("skeletal_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.SKELETAL_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.SKELETAL_INGOT.get(), 1));
        new RecipeBuilder("blazium_ingot_from_nuggets", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.BLAZIUM_NUGGET.get(), 9)).output(new ItemStack((ItemLike)AoAItems.BLAZIUM_INGOT.get(), 1));
    }

    private static void registerUpgradeKitRecipes() {
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.MECHYRO.get()).ingredients((ItemLike)AoAItems.ABYSSAL_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.ABYSSRO.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.BOOM_CANNON.get()).ingredients((ItemLike)AoAItems.ANCIENT_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.ANCIENT_BOMBER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.ALACRITY_BOW.get()).ingredients((ItemLike)AoAItems.ANCIENT_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.ANCIENT_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.DISCHARGE_CANNON.get()).ingredients((ItemLike)AoAItems.ANCIENT_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.ANCIENT_DISCHARGER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.MECHANICAL_ASSAULT_RIFLE.get()).ingredients((ItemLike)AoAItems.APOCO_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.APOCO_ASSAULT_RIFLE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.DISCHARGE_RIFLE.get()).ingredients((ItemLike)AoAItems.APOCO_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.APOCO_RIFLE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.SPIRIT_SHOWER.get()).ingredients((ItemLike)AoAItems.APOCO_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.APOCO_SHOWER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.MINT_MAGNUM.get()).ingredients((ItemLike)AoAItems.SEASIDE_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.AQUA_MAGNUM.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.STORMER.get()).ingredients((ItemLike)AoAItems.WEAPON_PARTS.get()).output(new ItemStack((ItemLike)AoAWeapons.ARTIFACT.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.PREDATIOUS_BOW.get()).ingredients((ItemLike)AoAItems.SEASIDE_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.ATLANTIC_BOW.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.BIG_BLAST.get()).ingredients((ItemLike)AoAItems.SMILEY_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.BLISSFUL_BLAST.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.BROWN_BLASTER.get()).ingredients((ItemLike)AoAItems.SEASIDE_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.BLUE_BARREL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.BLAST_CANNON.get()).ingredients((ItemLike)AoAItems.WEAPON_PARTS.get()).output(new ItemStack((ItemLike)AoAWeapons.BOMB_LAUNCHER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.DEMOLISHER.get()).ingredients((ItemLike)AoAItems.ROCKY_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.BOULDER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.WITHER_CANNON.get()).ingredients((ItemLike)AoAItems.ABYSSAL_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.BULB_CANNON.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.FIREBORNE_SWORD.get()).ingredients((ItemLike)AoAItems.NETHER_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.CANDLEFIRE_SWORD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.OVERSHOT.get()).ingredients((ItemLike)AoAItems.CLOWN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.CLOWNERSHOT.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.DECIMATOR.get()).ingredients((ItemLike)AoAItems.CLOWN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.CLOWNIMATOR.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.PULSE_CANNON.get()).ingredients((ItemLike)AoAItems.CLOWN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.CLOWNO_PULSE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.WRECKER.get()).ingredients((ItemLike)AoAItems.DARKLY_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.DARKENER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.WHIMSY_WINDER.get()).ingredients((ItemLike)AoAItems.DARKLY_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.DARKLY_GUSTER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.MONSTER.get()).ingredients((ItemLike)AoAItems.DARKLY_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.DARK_BEAST.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.POWER_RAY.get()).ingredients((ItemLike)AoAItems.ABYSSAL_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.DEATH_RAY.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.DISCHARGE_RIFLE.get()).ingredients((ItemLike)AoAItems.WEAPON_PARTS.get()).output(new ItemStack((ItemLike)AoAWeapons.DISCHARGE_SNIPER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.CHAIN_WRECKER.get()).ingredients((ItemLike)AoAItems.NETHER_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.FLAME_WRECKER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.KA_500.get()).ingredients((ItemLike)AoAItems.FLORO_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.FLORO500.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.IRO_RIFLE.get()).ingredients((ItemLike)AoAItems.FLORO_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.FLORO_RIFLE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.RPG.get()).ingredients((ItemLike)AoAItems.FLORO_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.FLORO_RPG.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.PROTON.get()).ingredients((ItemLike)AoAItems.ROCKY_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.FRAGMENT.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.FLOWER_CANNON.get()).ingredients((ItemLike)AoAItems.FUNGAL_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.FUNGAL_CANNON.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.FLAMING_FURY.get()).ingredients((ItemLike)AoAItems.GOLDEN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.GOLDEN_FURY.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.BOULDER_BOMBER.get()).ingredients((ItemLike)AoAItems.GOLDEN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.GOLDER_BOMBER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.DOOM_BRINGER.get()).ingredients((ItemLike)AoAItems.GOLDEN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.GOLD_BRINGER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.HAUNTER_RIFLE.get()).ingredients((ItemLike)AoAItems.SMILEY_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.HAPPY_HAUNTER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.HOT_SHOT.get()).ingredients((ItemLike)AoAItems.NETHER_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.HEAT_WAVE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.BUBBLE_HORN.get()).ingredients((ItemLike)AoAItems.NETHER_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.HELL_HORN.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.CONSTRUCT.get()).ingredients((ItemLike)AoAItems.LELYETIAN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.HIVER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.SHADOW_BLASTER.get()).ingredients((ItemLike)AoAItems.LELYETIAN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.HIVE_BLASTER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.CLOWN_CRACKER.get()).ingredients((ItemLike)AoAItems.LELYETIAN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.HIVE_CRACKER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.ABOMINATOR.get()).ingredients((ItemLike)AoAItems.ANCIENT_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.IOMINATOR.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.JACK_ROCKER.get()).ingredients((ItemLike)AoAItems.FUNGAL_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.JACK_FUNGER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.STRIKER_STAFF.get()).ingredients((ItemLike)AoAItems.PREDATOR_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.LIGHTNING_STAFF.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.MIND_BLASTER.get()).ingredients((ItemLike)AoAItems.LIGHT_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.LIGHT_BLASTER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.BLOOD_IRON.get()).ingredients((ItemLike)AoAItems.LIGHT_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.LIGHT_IRON.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.SOUL_SPARK.get()).ingredients((ItemLike)AoAItems.LIGHT_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.LIGHT_SPARK.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.KA_500.get()).ingredients((ItemLike)AoAItems.WEAPON_PARTS.get()).output(new ItemStack((ItemLike)AoAWeapons.MARK_MAKER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.MINIGUN.get()).ingredients((ItemLike)AoAItems.WEAPON_PARTS.get()).output(new ItemStack((ItemLike)AoAWeapons.MEGAGUN.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.LUNAR_GREATBLADE.get()).ingredients((ItemLike)AoAItems.LIGHT_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.MILLENNIUM_GREATBLADE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.TERMINATOR.get()).ingredients((ItemLike)AoAItems.ROCKY_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.MINERAL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.MK.get()).ingredients((ItemLike)AoAItems.FUNGAL_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.MK_FUNG.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.ENERGY_CANNON.get()).ingredients((ItemLike)AoAItems.LUNAR_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.MOON_CANNON.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.DARK_DESTROYER.get()).ingredients((ItemLike)AoAItems.LUNAR_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.MOON_DESTROYER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.MARK_MAKER.get()).ingredients((ItemLike)AoAItems.LUNAR_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.MOON_MAKER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.BAYONETTE_RIFLE.get()).ingredients((ItemLike)AoAItems.NETHER_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.NETHENETTE_RIFLE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.NETHENGEIC_SLUGGER.get()).ingredients((ItemLike)AoAItems.PRECASIAN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.PRECASIAN_SLUGGER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.PULSATOR.get()).ingredients((ItemLike)AoAItems.PREDATOR_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.PREDATOR.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.GHAST_BLASTER.get()).ingredients((ItemLike)AoAItems.PREDATOR_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.PREDATORIAN_BLASTER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.MINIGUN.get()).ingredients((ItemLike)AoAItems.PREDATOR_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.PREDIGUN.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.DESTRUCTION_SHOTGUN.get()).ingredients((ItemLike)AoAItems.FUNGAL_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.PURITY_SHOTGUN.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.RED_ROCKET.get()).ingredients((ItemLike)AoAItems.HAUNTED_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.PURPLE_PUNISHER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.STAMPEDE.get()).ingredients((ItemLike)AoAItems.WEAPON_PARTS.get()).output(new ItemStack((ItemLike)AoAWeapons.ROULETTE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.ORBOCRON.get()).ingredients((ItemLike)AoAItems.SEASIDE_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.SEAOCRON.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.ROULETTE.get()).ingredients((ItemLike)AoAItems.HAUNTED_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.SKULLETTE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.ARTIFACT.get()).ingredients((ItemLike)AoAItems.HAUNTED_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.SKULLIFACT.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.LUNA_BLASTER.get()).ingredients((ItemLike)AoAItems.HAUNTED_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.SKULLO_BLASTER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.SHADOW_BLASTER.get()).ingredients((ItemLike)AoAItems.SMILEY_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.SMILE_BLASTER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.BLOOD_DRAINER.get()).ingredients((ItemLike)AoAItems.FUNGAL_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.SOUL_DRAINER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.SQUAD_GUN.get()).ingredients((ItemLike)AoAItems.PRECASIAN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.SPINE_GUN.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.TOMMY.get()).ingredients((ItemLike)AoAItems.PRECASIAN_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.TIGER_TOMMY.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.UPGRADE_KIT).ingredients((ItemLike)AoAWeapons.BALLOON_BOMBER.get()).ingredients((ItemLike)AoAItems.SEASIDE_UPGRADE_KIT.get()).output(new ItemStack((ItemLike)AoAWeapons.WATER_BALLOON_BOMBER.get(), 1));
    }

    private static void registerMiscItemRecipes() {
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).ingredient('A', AoATags.Items.INGOTS_LIMONITE).shape("AA", "AA").output(new ItemStack((ItemLike)AoAItems.CANNONBALL.get(), 12));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).ingredient('A', AoATags.Items.INGOTS_LIMONITE).ingredient('B', (TagKey<Item>)Tags.Items.GUNPOWDER).ingredient('C', (TagKey<Item>)Tags.Items.INGOTS_COPPER).shape("A", "B", "C").output(new ItemStack((ItemLike)AoAItems.LIMONITE_BULLET.get(), 48));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).ingredient('A', (TagKey<Item>)Tags.Items.INGOTS_IRON).ingredient('B', AoATags.Items.INGOTS_LIMONITE).ingredient('C', (TagKey<Item>)Tags.Items.GUNPOWDER).shape("A", "B", "C").output(new ItemStack((ItemLike)AoAItems.METAL_SLUG.get(), 8));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).ingredient('A', (ItemLike)AoAItems.LIMONITE_BULLET.get()).ingredient('B', (TagKey<Item>)Tags.Items.GUNPOWDER).ingredient('C', AoATags.Items.INGOTS_LIMONITE).shape(" A ", "ABA", " C ").output(new ItemStack((ItemLike)AoAItems.SPREADSHOT.get(), 5));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("  E", "  D", "ABC").ingredient('A', (ItemLike)AoAItems.IVORY.get()).ingredient('B', (ItemLike)AoAItems.FOOTBONE_FRAGMENT.get()).ingredient('C', (ItemLike)AoAItems.LEGBONE_FRAGMENT.get()).ingredient('D', (ItemLike)AoAItems.CHESTBONE_FRAGMENT.get()).ingredient('E', (ItemLike)AoAItems.SKULLBONE_FRAGMENT.get()).output(new ItemStack((ItemLike)AoAItems.BONE_HORN.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.DENSE_ROCK.get(), 3)).ingredients(new ItemLike[]{Items.f_42499_}).output(new ItemStack((ItemLike)AoAItems.BOULDER_DASH.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ACA", "BDB", " B ").ingredient('A', AoATags.Items.GEMS_GEMENYTE).ingredient('B', (ItemLike)AoAItems.ORNAMYTE.get()).ingredient('C', AoATags.Items.GEMS_JEWELYTE).ingredient('D', (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).output(new ItemStack((ItemLike)AoAItems.EXPLOSIVE_GEMS.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AB ", " C ", " BA").ingredient('A', (ItemLike)AoAItems.PRIMED_GHOULASM.get()).ingredient('B', (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredient('C', (ItemLike)AoAItems.GHOULASM.get()).output(new ItemStack((ItemLike)AoAItems.HAUNTED_IDOL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.SMALL_BLUE_PETAL.get()).ingredients((ItemLike)AoAItems.SMALL_GREEN_PETAL.get()).ingredients((ItemLike)AoAItems.SMALL_ORANGE_PETAL.get()).ingredients((ItemLike)AoAItems.SMALL_PURPLE_PETAL.get()).ingredients((ItemLike)AoAItems.SMALL_RED_PETAL.get()).output(new ItemStack((ItemLike)AoAItems.PETALS.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" A ", "ABA", "CCC").ingredient('A', (ItemLike)AoAItems.MYSTIC_SHROOMS.get()).ingredient('B', (ItemLike)AoAItems.MUSHROOM_SPORES.get()).ingredient('C', (ItemLike)AoABlocks.FUNGAL_ROCK.get()).output(new ItemStack((ItemLike)AoAItems.SHROOM_STONE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", "ABA", "AAA").ingredient('A', AoATags.Items.CANDY).ingredient('B', (ItemLike)AoAItems.SOUR_GUMMY.get()).output(new ItemStack((ItemLike)AoAItems.TREAT_BAG.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABA", "CDC", " B ").ingredient('A', (TagKey<Item>)Tags.Items.GEMS_EMERALD).ingredient('B', (TagKey<Item>)Tags.Items.LEATHER).ingredient('C', (TagKey<Item>)Tags.Items.STRING).ingredient('D', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAItems.TROLL_IDOL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABA", " C ", "A A").ingredient('A', (ItemLike)AoAItems.RUNIUM_CHUNK.get()).ingredient('B', AoATags.Items.INGOTS_BARONYTE).ingredient('C', (TagKey<Item>)Tags.Items.GEMS_QUARTZ).output(new ItemStack((ItemLike)AoAItems.WARLOCK_GEM.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AA", "AA").ingredient('A', (ItemLike)AoAItems.CHITIN.get()).output(new ItemStack((ItemLike)AoAItems.ARMOUR_PLATING.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.DEEP_BLOOMS.get()).output(new ItemStack((ItemLike)Items.f_42498_, 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)Blocks.f_50069_, 4)).ingredients((ItemLike)AoAItems.RUNIUM_CHUNK.get()).output(new ItemStack((ItemLike)AoAItems.BLANK_SLAB.get(), 1));
        new RecipeBuilder("blank_slab_from_charged_runium", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)Blocks.f_50069_, 4)).ingredients((ItemLike)AoAItems.CHARGED_RUNIUM_CHUNK.get()).output(new ItemStack((ItemLike)AoAItems.BLANK_SLAB.get(), 4));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.CHARGED_RUNIUM_CHUNK.get()).output(new ItemStack((ItemLike)AoAItems.CHARGED_RUNE.get(), 16));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A A", " A ").ingredient('A', (ItemLike)AoAItems.IVORY.get()).output(new ItemStack((ItemLike)AoAItems.CUP.get(), 3));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.BLUE_OCEALITES.get()).output(new ItemStack((ItemLike)Items.f_42492_, 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A A", "ABA", "AAA").ingredient('A', (TagKey<Item>)Tags.Items.GEMS_DIAMOND).ingredient('B', (TagKey<Item>)Tags.Items.INGOTS_GOLD).output(new ItemStack((ItemLike)AoATools.DIAMOND_BOWL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A A", "BCB", "ABA").ingredient('A', (ItemLike)AoAItems.VOID_SCALES.get()).ingredient('B', AoATags.Items.GEMS_BLOODSTONE).ingredient('C', (ItemLike)Items.f_42545_).output(new ItemStack((ItemLike)AoAItems.DISTORTING_ARTIFACT.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.EYE_BULB.get()).ingredients(new ItemLike[]{Items.f_42501_}).output(new ItemStack((ItemLike)AoAItems.EYE_CANDY.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.DAWN_BUSH.get()).output(new ItemStack((ItemLike)Items.f_42490_, 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AA", "AA").ingredient('A', (ItemLike)AoAItems.CONFETTI_PILE.get()).output(new ItemStack((ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.HEART_FRUIT.get()).output(new ItemStack((ItemLike)AoAItems.HEART_FRUIT_SEEDS.get(), 3));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.RAW_FURLION_CHOP.get()).ingredients((ItemLike)AoAItems.CHILLI.get()).output(new ItemStack((ItemLike)AoAItems.HOT_ROD.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.RUNIC_BUSH.get()).output(new ItemStack((ItemLike)Items.f_42538_, 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.GREEN_CELEBULBS.get()).output(new ItemStack((ItemLike)Items.f_42540_, 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A", "A").ingredient('A', AoATags.Items.INGOTS_LIMONITE).output(new ItemStack((ItemLike)AoAItems.LIMONITE_ROD.get(), 2));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.LUNTAR.get()).output(new ItemStack((ItemLike)Items.f_42537_, 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.MAGIC_REPAIR_DUST.get(), 3)).ingredients(new ItemLike[]{Items.f_42448_}).ingredients((ItemLike)AoAItems.METAL_TUB.get()).output(new ItemStack((ItemLike)AoAItems.MAGIC_MENDING_SOLUTION.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AB", "CD").ingredient('A', (ItemLike)AoAItems.GREEN_MEGA_RUNE_FRAGMENT.get()).ingredient('B', (ItemLike)AoAItems.YELLOW_MEGA_RUNE_FRAGMENT.get()).ingredient('C', (ItemLike)AoAItems.BLUE_MEGA_RUNE_FRAGMENT.get()).ingredient('D', (ItemLike)AoAItems.RED_MEGA_RUNE_FRAGMENT.get()).output(new ItemStack((ItemLike)AoAItems.MEGA_RUNE_STONE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A A", "BCB").ingredient('A', (TagKey<Item>)Tags.Items.INGOTS_IRON).ingredient('B', (ItemLike)Items.f_42461_).ingredient('C', AoATags.Items.INGOTS_EMBERSTONE).output(new ItemStack((ItemLike)AoAItems.METAL_TUB.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(ItemTags.f_13167_).ingredients(ItemTags.f_13167_).ingredients(new ItemStack((ItemLike)AoAItems.TORN_CLOTH.get(), 2)).output(new ItemStack((ItemLike)AoAItems.PADDED_CLOTH.get(), 3));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.LUNALIP.get()).output(new ItemStack((ItemLike)Items.f_42493_, 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.RED_DRUSE.get()).ingredients((ItemLike)AoAItems.GREEN_DRUSE.get()).ingredients((ItemLike)AoAItems.PURPLE_DRUSE.get()).ingredients((ItemLike)AoAItems.BLUE_DRUSE.get()).ingredients((ItemLike)AoAItems.WHITE_DRUSE.get()).ingredients((ItemLike)AoAItems.YELLOW_DRUSE.get()).output(new ItemStack((ItemLike)AoAItems.RAINBOW_DRUSE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.BLOOD_PINE.get()).output(new ItemStack((ItemLike)Items.f_42497_, 1));
        new RecipeBuilder("red_dye_from_blood_pine_stem", RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.BLOOD_PINE_STEM.get()).output(new ItemStack((ItemLike)Items.f_42497_, 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(Tags.Items.STRING).ingredients(Tags.Items.STRING).ingredients(new ItemStack((ItemLike)AoAItems.TORN_CLOTH.get(), 2)).output(new ItemStack((ItemLike)AoAItems.REINFORCED_CLOTH.get(), 3));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(Tags.Items.INGOTS_IRON).ingredients(Tags.Items.NUGGETS_GOLD).ingredients((ItemLike)AoAItems.LIMONITE_NUGGET.get()).output(new ItemStack((ItemLike)AoAItems.SCRAP_METAL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A A", "ABA", "AAA").ingredient('A', (ItemLike)AoABlocks.ANCIENT_ROCK.get()).ingredient('B', (TagKey<Item>)Tags.Items.INGOTS_GOLD).output(new ItemStack((ItemLike)AoATools.STONE_BOWL.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.RUNIUM_CHUNK.get()).output(new ItemStack((ItemLike)AoAItems.UNPOWERED_RUNE.get(), 16));
        new RecipeBuilder("black_dye_from_deep_blooms", RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.DEEP_BLOOMS.get()).output(new ItemStack((ItemLike)Items.f_42498_, 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.YELLOW_CELEBULBS.get()).output(new ItemStack((ItemLike)Items.f_42539_, 1));
        new RecipeBuilder("yellow_dye_from_irotops", RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoABlocks.IROTOPS.get()).output(new ItemStack((ItemLike)Items.f_42539_, 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{Items.f_42799_, Items.f_42801_, Items.f_42800_, Items.f_41826_, Items.f_41827_, Items.f_41828_, (ItemLike)AoAItems.BLANK_REALMSTONE.get()}).output(new ItemStack((ItemLike)AoAItems.PRECASIA_REALMSTONE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(AoATags.Items.SHULKER_BOXES).ingredients(new ItemLike[]{Blocks.f_50273_, Items.f_42436_, (ItemLike)AoAItems.BLANK_REALMSTONE.get()}).output(new ItemStack((ItemLike)AoAItems.NOWHERE_REALMSTONE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.DARKLY_POWDER.get(), Blocks.f_50141_, (ItemLike)AoABlocks.HAUNTED_FLOWER.get(), (ItemLike)AoAItems.MAGIC_MENDING_SOLUTION.get(), (ItemLike)AoAItems.BLANK_REALMSTONE.get()}).ingredients(AoATags.Items.GEMS_BLOODSTONE).output(new ItemStack((ItemLike)AoAItems.SHYRELANDS_REALMSTONE.get(), 1));
        new RecipeBuilder("torn_cloth_from_banners", RecipeBuilder.Type.SHAPELESS).ingredients(ItemTags.f_13191_).output(new ItemStack((ItemLike)AoAItems.TORN_CLOTH.get(), 2));
        new RecipeBuilder("torn_cloth_from_beds", RecipeBuilder.Type.SHAPELESS).ingredients(ItemTags.f_13146_).output(new ItemStack((ItemLike)AoAItems.TORN_CLOTH.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.COMPASS_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.COMPASS_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.DISTORTION_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.DISTORTION_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.ENERGY_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.ENERGY_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.FIRE_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.FIRE_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.KINETIC_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.KINETIC_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.LIFE_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.LIFE_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.LUNAR_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.LUNAR_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.POISON_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.POISON_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.POWER_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.POWER_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.STORM_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.STORM_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.STRIKE_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.STRIKE_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.WATER_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.WATER_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.WIND_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.WIND_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoAItems.WITHER_RUNE.get(), Items.f_42516_}).output(new ItemStack((ItemLike)AoAItems.WITHER_RUNE_BANNER_PATTERN.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(AoATags.Items.PRECASIAN_BONE).output(new ItemStack((ItemLike)Items.f_42499_));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).ingredient('B', (ItemLike)Items.f_42406_).ingredient('C', (ItemLike)AoAItems.CHUM.get()).shape("B", "C", "B").output(new ItemStack((ItemLike)AoAItems.CHUM_BURGER.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).ingredient('B', (ItemLike)Items.f_42406_).ingredient('C', (ItemLike)AoAItems.CHUM.get()).ingredient('A', (TagKey<Item>)Tags.Items.CROPS_CARROT).ingredient('P', (TagKey<Item>)Tags.Items.CROPS_POTATO).shape(" B ", "ACP", " B ").output(new ItemStack((ItemLike)AoAItems.CHUM_AND_SALAD_BURGER.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{Items.f_42523_, Items.f_42414_, (ItemLike)AoAItems.LIMONITE_NUGGET.get()}).ingredients(Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoATools.HAULING_ROD.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{(ItemLike)AoATools.HAULING_ROD.get(), Items.f_42542_, Items.f_42542_, Items.f_42542_, Items.f_42542_, Items.f_42419_, Items.f_42419_}).output(new ItemStack((ItemLike)AoATools.THERMALLY_INSULATED_ROD.get()));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).ingredient('S', (TagKey<Item>)Tags.Items.RODS_WOODEN).ingredient('C', (ItemLike)AoAItems.CHUM.get()).ingredient('P', (TagKey<Item>)ItemTags.f_13168_).shape(" S ", "SCS", "PPP").output(new ItemStack((ItemLike)AoATools.FISHING_CAGE.get()));
        new ToolInteractionRecipeBuilder().toolItem(AoATags.Items.SWORDS).ingredients(AoATags.Items.RAWFISH, AoATags.Items.SWORDS).output(new ItemStack((ItemLike)AoAItems.CHUM.get()));
        new RecipeBuilder(RecipeBuilder.Type.SMELTING).ingredients((ItemLike)AoAItems.HYDRONE.get()).xp(4.0f).output(new ItemStack((ItemLike)Items.f_42416_, 2));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.SKELECANTH.get()).output(new ItemStack((ItemLike)Items.f_42500_, 3));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.CHOCAW.get()).output(new ItemStack((ItemLike)Items.f_42533_, 4));
        new RecipeBuilder("grenade_from_rocketfish", RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.ROCKETFISH.get()).output(new ItemStack((ItemLike)AoAWeapons.GRENADE.get(), 3));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.CANDLEFISH.get()).output(new ItemStack((ItemLike)Items.f_42000_, 8));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.IRONBACK.get()).output(new ItemStack((ItemLike)Items.f_42749_, 7));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)AoAItems.RAZORFISH.get()).output(new ItemStack((ItemLike)AoAWeapons.SLICE_STAR.get(), 5));
    }

    private static void registerSmeltingRecipes() {
        new RecipeBuilder("smelting_skeletal_ingot_from_chestbone", RecipeBuilder.Type.SMELTING).ingredients((ItemLike)AoAItems.CHESTBONE_FRAGMENT.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.SKELETAL_INGOT.get()));
        new RecipeBuilder("smelting_skeletal_ingot_from_footbone", RecipeBuilder.Type.SMELTING).ingredients((ItemLike)AoAItems.FOOTBONE_FRAGMENT.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.SKELETAL_INGOT.get()));
        new RecipeBuilder("smelting_skeletal_ingot_from_legbone", RecipeBuilder.Type.SMELTING).ingredients((ItemLike)AoAItems.LEGBONE_FRAGMENT.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.SKELETAL_INGOT.get()));
        new RecipeBuilder("smelting_skeletal_ingot_from_skullbone", RecipeBuilder.Type.SMELTING).ingredients((ItemLike)AoAItems.SKULLBONE_FRAGMENT.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.SKELETAL_INGOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.SMELTING).ingredients((ItemLike)AoAItems.SCRAP_METAL.get()).xp(1.0f).output(new ItemStack((ItemLike)Items.f_42749_, 1));
        new RecipeBuilder(RecipeBuilder.Type.SMELTING).ingredients(new ResourceLocation("aoa3", "toxic_waste_bucket")).xp(1.0f).output(new ItemStack((ItemLike)AoAItems.VILE_STONE.get()));
    }

    private static void registerCookingRecipes() {
        new RecipeBuilder(RecipeBuilder.Type.ALL_COOKING).ingredients((ItemLike)AoAItems.RAW_CHARGER_SHANK.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.COOKED_CHARGER_SHANK.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_COOKING).ingredients((ItemLike)AoAItems.RAW_CHIMERA_CHOP.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.COOKED_CHIMERA_CHOP.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_COOKING).ingredients((ItemLike)AoAItems.RAW_FURLION_CHOP.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.COOKED_FURLION_CHOP.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_COOKING).ingredients((ItemLike)AoAItems.RAW_HALYCON_BEEF.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.COOKED_HALYCON_BEEF.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_COOKING).ingredients((ItemLike)AoAItems.RAW_RAINBOWFISH.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.COOKED_RAINBOWFISH.get()));
        Consumer<RegistryObject> haulingFishConsumer = fish -> new RecipeBuilder("cooked_fish_from_" + fish.getId().m_135815_(), RecipeBuilder.Type.ALL_COOKING).ingredients((ItemLike)fish.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.COOKED_FISH.get()));
        haulingFishConsumer.accept(AoAItems.BLUE_GEMTRAP);
        haulingFishConsumer.accept(AoAItems.CANDLEFISH);
        haulingFishConsumer.accept(AoAItems.CHARRED_CHAR);
        haulingFishConsumer.accept(AoAItems.CRIMSON_SKIPPER);
        haulingFishConsumer.accept(AoAItems.CRIMSON_STRIPEFISH);
        haulingFishConsumer.accept(AoAItems.DARK_HATCHETFISH);
        haulingFishConsumer.accept(AoAItems.GREEN_GEMTRAP);
        haulingFishConsumer.accept(AoAItems.IRONBACK);
        haulingFishConsumer.accept(AoAItems.PEARL_STRIPEFISH);
        haulingFishConsumer.accept(AoAItems.PURPLE_GEMTRAP);
        haulingFishConsumer.accept(AoAItems.RAZORFISH);
        haulingFishConsumer.accept(AoAItems.RED_GEMTRAP);
        haulingFishConsumer.accept(AoAItems.REEFTOOTH);
        haulingFishConsumer.accept(AoAItems.ROCKETFISH);
        haulingFishConsumer.accept(AoAItems.SAILBACK);
        haulingFishConsumer.accept(AoAItems.SAPPHIRE_STRIDER);
        haulingFishConsumer.accept(AoAItems.WHITE_GEMTRAP);
        haulingFishConsumer.accept(AoAItems.YELLOW_GEMTRAP);
        haulingFishConsumer.accept(AoAItems.TURQUOISE_STRIPEFISH);
        haulingFishConsumer.accept(AoAItems.VIOLET_SKIPPER);
        new RecipeBuilder(RecipeBuilder.Type.ALL_COOKING).ingredients((ItemLike)AoAItems.PARAPIRANHA.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAWeapons.HARDENED_PARAPIRANHA.get()));
    }

    private static void registerImbuingRecipes() {
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(39).infusionEnchant(Enchantments.f_44971_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.RADIANT_POWER_STONE.get()).infusionRequirement(70).infusionEnchant((Enchantment)AoAEnchantments.ARCHMAGE.get());
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.BLOOMING_POWER_STONE.get()).infusionRequirement(80).infusionEnchant((Enchantment)AoAEnchantments.ARCHMAGE.get(), 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.BLOOMING_POWER_STONE.get()).infusionRequirement(89).infusionEnchant((Enchantment)AoAEnchantments.ARCHMAGE.get(), 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), Items.f_42591_, (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()}).infusionRequirement(5).infusionEnchant(Enchantments.f_44979_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), Items.f_42591_, (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()}).infusionRequirement(11).infusionEnchant(Enchantments.f_44979_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), Items.f_42591_, (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()}).infusionRequirement(19).infusionEnchant(Enchantments.f_44979_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), Items.f_42591_, (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()}).infusionRequirement(27).infusionEnchant(Enchantments.f_44979_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), Items.f_42591_, (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()}).infusionRequirement(36).infusionEnchant(Enchantments.f_44979_, 5);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), Items.f_42591_, (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()}).infusionRequirement(45).infusionEnchant(Enchantments.f_44979_, 6);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).ingredients(Tags.Items.GUNPOWDER).infusionRequirement(4).infusionEnchant(Enchantments.f_44968_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).ingredients(Tags.Items.GUNPOWDER).infusionRequirement(9).infusionEnchant(Enchantments.f_44968_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).ingredients(Tags.Items.GUNPOWDER).infusionRequirement(17).infusionEnchant(Enchantments.f_44968_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).ingredients(Tags.Items.GUNPOWDER).infusionRequirement(26).infusionEnchant(Enchantments.f_44968_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.SHINING_POWER_STONE.get()).infusionRequirement(61).infusionEnchant((Enchantment)AoAEnchantments.BRACE.get());
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(17).infusionEnchant((Enchantment)AoAEnchantments.CONTROL.get());
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(34).infusionEnchant((Enchantment)AoAEnchantments.CONTROL.get(), 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(51).infusionEnchant((Enchantment)AoAEnchantments.CONTROL.get(), 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.SHINING_POWER_STONE.get()).infusionRequirement(72).infusionEnchant((Enchantment)AoAEnchantments.CONTROL.get(), 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.AMBIENT_POWER_STONE.get()).infusionRequirement(19).infusionEnchant(Enchantments.f_44973_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.AMBIENT_POWER_STONE.get()).infusionRequirement(27).infusionEnchant(Enchantments.f_44973_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.AMBIENT_POWER_STONE.get()).infusionRequirement(37).infusionEnchant(Enchantments.f_44973_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(11).infusionEnchant(Enchantments.f_44984_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(23).infusionEnchant(Enchantments.f_44984_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(34).infusionEnchant(Enchantments.f_44984_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(47).infusionEnchant(Enchantments.f_44984_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(62).infusionEnchant(Enchantments.f_44984_, 5);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.BLOOMING_POWER_STONE.get()).infusionRequirement(87).infusionEnchant(Enchantments.f_44984_, 6);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.AMBIENT_POWER_STONE.get()).ingredients(Tags.Items.FEATHERS).infusionRequirement(6).infusionEnchant(Enchantments.f_44967_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).ingredients(Tags.Items.FEATHERS).infusionRequirement(13).infusionEnchant(Enchantments.f_44967_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).ingredients(Tags.Items.FEATHERS).infusionRequirement(21).infusionEnchant(Enchantments.f_44967_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).ingredients(Tags.Items.FEATHERS).infusionRequirement(29).infusionEnchant(Enchantments.f_44967_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), Items.f_42448_, (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()}).infusionEnchant(Enchantments.f_44981_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), Items.f_42448_, (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()}).infusionRequirement(10).infusionEnchant(Enchantments.f_44981_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), Items.f_42448_, (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()}).infusionRequirement(5).infusionEnchant(Enchantments.f_44966_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), Items.f_42448_, (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()}).infusionRequirement(10).infusionEnchant(Enchantments.f_44966_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), Items.f_42448_, (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()}).infusionRequirement(18).infusionEnchant(Enchantments.f_44966_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), Items.f_42448_, (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()}).infusionRequirement(26).infusionEnchant(Enchantments.f_44966_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), Items.f_42593_, (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()}).infusionRequirement(22).infusionEnchant(Enchantments.f_44990_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.AMBIENT_POWER_STONE.get()).infusionRequirement(20).infusionEnchant((Enchantment)AoAEnchantments.FORM.get());
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.AMBIENT_POWER_STONE.get()).infusionRequirement(31).infusionEnchant((Enchantment)AoAEnchantments.FORM.get(), 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.AMBIENT_POWER_STONE.get()).infusionRequirement(46).infusionEnchant((Enchantment)AoAEnchantments.FORM.get(), 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(63).infusionEnchant((Enchantment)AoAEnchantments.FORM.get(), 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(15).infusionEnchant(Enchantments.f_44987_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(30).infusionEnchant(Enchantments.f_44987_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(45).infusionEnchant(Enchantments.f_44987_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.RADIANT_POWER_STONE.get()).infusionRequirement(70).infusionEnchant(Enchantments.f_44987_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.BLOOMING_POWER_STONE.get()).infusionRequirement(85).infusionEnchant(Enchantments.f_44987_, 5);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.DIVINE_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(55).infusionEnchant(Enchantments.f_44974_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.DIVINE_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(65).infusionEnchant(Enchantments.f_44974_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.DIVINE_ENHANCER.get(), (ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), Items.f_42412_, (ItemLike)AoAItems.SHINING_POWER_STONE.get()}).infusionRequirement(62).infusionEnchant(Enchantments.f_44952_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoAItems.BLOOMING_POWER_STONE.get(), (ItemLike)AoAItems.RADIANT_POWER_STONE.get()).infusionRequirement(97).infusionEnchant((Enchantment)AoAEnchantments.INTERVENTION.get());
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.GLARING_POWER_STONE.get()).infusionRequirement(21).infusionEnchant(Enchantments.f_44980_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.GLARING_POWER_STONE.get()).infusionRequirement(39).infusionEnchant(Enchantments.f_44980_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.GLARING_POWER_STONE.get()).infusionRequirement(65).infusionEnchant(Enchantments.f_44980_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.RADIANT_POWER_STONE.get()).infusionRequirement(78).infusionEnchant(Enchantments.f_44980_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(18).infusionEnchant(Enchantments.f_44982_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(30).infusionEnchant(Enchantments.f_44982_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(45).infusionEnchant(Enchantments.f_44982_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.RADIANT_POWER_STONE.get()).infusionRequirement(71).infusionEnchant(Enchantments.f_44982_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(13).infusionEnchant(Enchantments.f_44953_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(27).infusionEnchant(Enchantments.f_44953_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(40).infusionEnchant(Enchantments.f_44953_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.SHINING_POWER_STONE.get()).infusionRequirement(76).infusionEnchant(Enchantments.f_44953_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(4).infusionEnchant(Enchantments.f_44954_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(18).infusionEnchant(Enchantments.f_44954_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(39).infusionEnchant(Enchantments.f_44954_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(62).infusionEnchant(Enchantments.f_44954_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.SHINING_POWER_STONE.get()).infusionRequirement(78).infusionEnchant(Enchantments.f_44954_, 5);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DIVINE_ENHANCER.get(), (ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.BLOOMING_POWER_STONE.get()).infusionRequirement(97).infusionEnchant(Enchantments.f_44962_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(Tags.Items.STRING).infusionEnchant(Enchantments.f_44988_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(Tags.Items.STRING).infusionRequirement(15).infusionEnchant(Enchantments.f_44988_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(Tags.Items.STRING).infusionRequirement(25).infusionEnchant(Enchantments.f_44988_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(Tags.Items.STRING).infusionRequirement(35).infusionEnchant(Enchantments.f_44988_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(Tags.Items.STRING).infusionRequirement(45).infusionEnchant(Enchantments.f_44988_, 5);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.RADIANT_POWER_STONE.get()).ingredients(Tags.Items.STRING).infusionRequirement(75).infusionEnchant(Enchantments.f_44988_, 6);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), Items.f_42412_, (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()}).infusionRequirement(8).infusionEnchant(Enchantments.f_44969_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), Items.f_42412_, (ItemLike)AoAItems.AMBIENT_POWER_STONE.get()}).infusionRequirement(22).infusionEnchant(Enchantments.f_44969_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), Items.f_42412_, (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()}).infusionRequirement(30).infusionEnchant(Enchantments.f_44969_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients(new ItemLike[]{(ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), Items.f_42412_, (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()}).infusionRequirement(34).infusionEnchant(Enchantments.f_44969_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.AMBIENT_POWER_STONE.get()).infusionEnchant(Enchantments.f_44965_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.AMBIENT_POWER_STONE.get()).infusionRequirement(19).infusionEnchant(Enchantments.f_44965_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.AMBIENT_POWER_STONE.get()).infusionRequirement(33).infusionEnchant(Enchantments.f_44965_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoAItems.GLARING_POWER_STONE.get()).infusionRequirement(47).infusionEnchant(Enchantments.f_44965_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLARING_POWER_STONE.get()).infusionRequirement(19).infusionEnchant(Enchantments.f_44989_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLARING_POWER_STONE.get()).infusionRequirement(37).infusionEnchant(Enchantments.f_44989_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLARING_POWER_STONE.get()).infusionRequirement(63).infusionEnchant(Enchantments.f_44989_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.RADIANT_POWER_STONE.get()).infusionRequirement(76).infusionEnchant(Enchantments.f_44989_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(9).infusionEnchant((Enchantment)AoAEnchantments.RECHARGE.get());
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(25).infusionEnchant((Enchantment)AoAEnchantments.RECHARGE.get(), 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(38).infusionEnchant((Enchantment)AoAEnchantments.RECHARGE.get(), 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(51).infusionEnchant((Enchantment)AoAEnchantments.RECHARGE.get(), 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.RADIANT_POWER_STONE.get()).infusionRequirement(63).infusionEnchant((Enchantment)AoAEnchantments.RECHARGE.get(), 5);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoAItems.BLOOMING_POWER_STONE.get()).infusionRequirement(79).infusionEnchant((Enchantment)AoAEnchantments.RECHARGE.get(), 6);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.BUBBLE_BERRIES.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(15).infusionEnchant(Enchantments.f_44970_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.BUBBLE_BERRIES.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(23).infusionEnchant(Enchantments.f_44970_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.BUBBLE_BERRIES.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(37).infusionEnchant(Enchantments.f_44970_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoAItems.BUBBLE_BERRIES.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(59).infusionEnchant(Enchantments.f_44970_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(AoATags.Items.RODS_METAL).infusionRequirement(12).infusionEnchant((Enchantment)AoAEnchantments.SEVER.get());
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(AoATags.Items.RODS_METAL).infusionRequirement(22).infusionEnchant((Enchantment)AoAEnchantments.SEVER.get(), 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(AoATags.Items.RODS_METAL).infusionRequirement(32).infusionEnchant((Enchantment)AoAEnchantments.SEVER.get(), 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(AoATags.Items.RODS_METAL).infusionRequirement(42).infusionEnchant((Enchantment)AoAEnchantments.SEVER.get(), 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(AoATags.Items.RODS_METAL).infusionRequirement(52).infusionEnchant((Enchantment)AoAEnchantments.SEVER.get(), 5);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.RADIANT_POWER_STONE.get()).ingredients(AoATags.Items.RODS_METAL).infusionRequirement(80).infusionEnchant((Enchantment)AoAEnchantments.SEVER.get(), 6);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionEnchant(Enchantments.f_44977_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(10).infusionEnchant(Enchantments.f_44977_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(20).infusionEnchant(Enchantments.f_44977_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(30).infusionEnchant(Enchantments.f_44977_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(40).infusionEnchant(Enchantments.f_44977_, 5);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.RADIANT_POWER_STONE.get()).infusionRequirement(70).infusionEnchant(Enchantments.f_44977_, 6);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(Tags.Items.GUNPOWDER).infusionRequirement(20).infusionEnchant((Enchantment)AoAEnchantments.SHELL.get());
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).ingredients(Tags.Items.GUNPOWDER).infusionRequirement(40).infusionEnchant((Enchantment)AoAEnchantments.SHELL.get(), 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.RADIANT_POWER_STONE.get()).ingredients(Tags.Items.GUNPOWDER).infusionRequirement(70).infusionEnchant((Enchantment)AoAEnchantments.SHELL.get(), 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.DIVINE_ENHANCER.get(), (ItemLike)AoAItems.GLARING_POWER_STONE.get()).infusionRequirement(44).infusionEnchant(Enchantments.f_44985_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(7).infusionEnchant(Enchantments.f_44978_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(15).infusionEnchant(Enchantments.f_44978_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(21).infusionEnchant(Enchantments.f_44978_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoAItems.GLISTENING_POWER_STONE.get()).infusionRequirement(30).infusionEnchant(Enchantments.f_44978_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoAItems.GLARING_POWER_STONE.get()).infusionRequirement(37).infusionEnchant(Enchantments.f_44978_, 5);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.LUCK_ENHANCER.get(), (ItemLike)AoAItems.GLOWING_POWER_STONE.get()).infusionRequirement(46).infusionEnchant(Enchantments.f_44978_, 6);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(21).infusionEnchant(Enchantments.f_44983_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(31).infusionEnchant(Enchantments.f_44983_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).infusionRequirement(44).infusionEnchant(Enchantments.f_44983_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.SPEED_ENHANCER.get(), (ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), (ItemLike)AoAItems.SHINING_POWER_STONE.get()).infusionRequirement(68).infusionEnchant(Enchantments.f_44983_, 4);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLARING_POWER_STONE.get()).infusionRequirement(36).infusionEnchant(Enchantments.f_44972_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.GLARING_POWER_STONE.get()).infusionRequirement(50).infusionEnchant(Enchantments.f_44972_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoAItems.SHINING_POWER_STONE.get()).infusionRequirement(65).infusionEnchant(Enchantments.f_44972_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).ingredients(Tags.Items.GEMS_DIAMOND).infusionRequirement(16).infusionEnchant(Enchantments.f_44986_);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).ingredients(Tags.Items.GEMS_DIAMOND).infusionRequirement(32).infusionEnchant(Enchantments.f_44986_, 2);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoAItems.GLEAMING_POWER_STONE.get()).ingredients(Tags.Items.GEMS_DIAMOND).infusionRequirement(48).infusionEnchant(Enchantments.f_44986_, 3);
        new RecipeBuilder(RecipeBuilder.Type.IMBUING).ingredients((ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), (ItemLike)AoAItems.BLOOMING_POWER_STONE.get()).ingredients(Tags.Items.GEMS_DIAMOND).infusionRequirement(83).infusionEnchant(Enchantments.f_44986_, 4);
    }

    /*
     * Opcode count of 13063 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void registerInfusionRecipes() {
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.FLOATING_STONE.get()).ingredients(AoATags.Items.GEMS_CRYSTALLITE, Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.ALACRITY_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.FLOATING_STONE.get()).ingredients(AoATags.Items.GEMS_CRYSTALLITE, AoATags.Items.GEMS_CRYSTALLITE, AoATags.Items.GEMS_CRYSTALLITE, Tags.Items.GEMS_DIAMOND, Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.ALACRITY_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.FLOATING_STONE.get()).ingredients(AoATags.Items.GEMS_CRYSTALLITE, AoATags.Items.GEMS_CRYSTALLITE, Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.ALACRITY_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.FLOATING_STONE.get()).ingredients(AoATags.Items.GEMS_CRYSTALLITE, AoATags.Items.GEMS_CRYSTALLITE, AoATags.Items.GEMS_CRYSTALLITE, Tags.Items.GEMS_DIAMOND, Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.ALACRITY_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.GEMS_BLOODSTONE, Tags.Items.INGOTS_NETHERITE).output(new ItemStack((ItemLike)AoAArmour.BATTLEBORN_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.GEMS_BLOODSTONE, Tags.Items.INGOTS_NETHERITE, Tags.Items.DUSTS_REDSTONE).output(new ItemStack((ItemLike)AoAArmour.BATTLEBORN_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.GEMS_BLOODSTONE, Tags.Items.DUSTS_REDSTONE).output(new ItemStack((ItemLike)AoAArmour.BATTLEBORN_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.GEMS_BLOODSTONE, Tags.Items.INGOTS_NETHERITE).output(new ItemStack((ItemLike)AoAArmour.BATTLEBORN_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.VOID_SCALES.get(), Items.f_41996_, (ItemLike)AoAItems.CORAL_STONE.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()}).output(new ItemStack((ItemLike)AoAArmour.BOREIC_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.VOID_SCALES.get(), (ItemLike)AoAItems.CORAL_STONE.get(), (ItemLike)AoAItems.CORAL_STONE.get(), Items.f_41996_, (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).output(new ItemStack((ItemLike)AoAArmour.BOREIC_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{Items.f_41996_, (ItemLike)AoAItems.VOID_SCALES.get(), (ItemLike)AoAItems.CORAL_STONE.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()}).output(new ItemStack((ItemLike)AoAArmour.BOREIC_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(new ItemLike[]{Items.f_41996_, (ItemLike)AoAItems.VOID_SCALES.get(), (ItemLike)AoAItems.CORAL_STONE.get(), (ItemLike)AoAItems.CORAL_STONE.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).output(new ItemStack((ItemLike)AoAArmour.BOREIC_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.RAINBOW_DRUSE.get(), (ItemLike)AoAItems.GREEN_DRUSE.get(), (ItemLike)AoAItems.BLUE_DRUSE.get()).output(new ItemStack((ItemLike)AoAArmour.CRYSTALLIS_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.RAINBOW_DRUSE.get(), (ItemLike)AoAItems.RAINBOW_DRUSE.get(), (ItemLike)AoAItems.RAINBOW_DRUSE.get(), (ItemLike)AoAItems.GREEN_DRUSE.get(), (ItemLike)AoAItems.BLUE_DRUSE.get()).output(new ItemStack((ItemLike)AoAArmour.CRYSTALLIS_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.RAINBOW_DRUSE.get(), (ItemLike)AoAItems.RAINBOW_DRUSE.get(), (ItemLike)AoAItems.GREEN_DRUSE.get(), (ItemLike)AoAItems.BLUE_DRUSE.get()).output(new ItemStack((ItemLike)AoAArmour.CRYSTALLIS_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.RAINBOW_DRUSE.get(), (ItemLike)AoAItems.RAINBOW_DRUSE.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.GREEN_DRUSE.get(), (ItemLike)AoAItems.BLUE_DRUSE.get()).output(new ItemStack((ItemLike)AoAArmour.CRYSTALLIS_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_MYSTITE, AoATags.Items.INGOTS_ELECANIUM).output(new ItemStack((ItemLike)AoAArmour.ELECANYTE_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_MYSTITE, AoATags.Items.INGOTS_ELECANIUM, AoATags.Items.INGOTS_ELECANIUM).output(new ItemStack((ItemLike)AoAArmour.ELECANYTE_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_MYSTITE, AoATags.Items.INGOTS_ELECANIUM).output(new ItemStack((ItemLike)AoAArmour.ELECANYTE_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_MYSTITE, AoATags.Items.INGOTS_ELECANIUM, AoATags.Items.INGOTS_ELECANIUM).output(new ItemStack((ItemLike)AoAArmour.ELECANYTE_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients(AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_BLAZIUM, AoATags.Items.INGOTS_BLAZIUM).output(new ItemStack((ItemLike)AoAArmour.EMBRODIUM_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_BLAZIUM, AoATags.Items.INGOTS_BLAZIUM, AoATags.Items.INGOTS_BLAZIUM).output(new ItemStack((ItemLike)AoAArmour.EMBRODIUM_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_BLAZIUM, AoATags.Items.INGOTS_BLAZIUM).output(new ItemStack((ItemLike)AoAArmour.EMBRODIUM_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_BLAZIUM, AoATags.Items.INGOTS_BLAZIUM).output(new ItemStack((ItemLike)AoAArmour.EMBRODIUM_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42532_}).ingredients(Tags.Items.GEMS_QUARTZ, Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.EXOPLATE_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42532_}).ingredients(Tags.Items.GEMS_QUARTZ, Tags.Items.GEMS_DIAMOND, Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.EXOPLATE_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42532_}).ingredients(Tags.Items.GEMS_QUARTZ, Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.EXOPLATE_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42532_}).ingredients(Tags.Items.GEMS_QUARTZ, Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.EXOPLATE_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.MUSHROOM_SPORES.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(Tags.Items.MUSHROOMS).output(new ItemStack((ItemLike)AoAArmour.FUNGAL_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(Tags.Items.MUSHROOMS, Tags.Items.MUSHROOMS).output(new ItemStack((ItemLike)AoAArmour.FUNGAL_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.MUSHROOM_SPORES.get(), (ItemLike)AoAItems.MUSHROOM_SPORES.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get()).ingredients(Tags.Items.MUSHROOMS).output(new ItemStack((ItemLike)AoAArmour.FUNGAL_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(Tags.Items.MUSHROOMS, Tags.Items.MUSHROOMS).output(new ItemStack((ItemLike)AoAArmour.FUNGAL_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.GEMS_JADE, AoATags.Items.INGOTS_GHASTLY).output(new ItemStack((ItemLike)AoAArmour.GHASTLY_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.GEMS_JADE, AoATags.Items.INGOTS_GHASTLY, AoATags.Items.INGOTS_GHASTLY).output(new ItemStack((ItemLike)AoAArmour.GHASTLY_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.GEMS_JADE, AoATags.Items.INGOTS_GHASTLY).output(new ItemStack((ItemLike)AoAArmour.GHASTLY_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.GEMS_JADE, AoATags.Items.INGOTS_GHASTLY, AoATags.Items.INGOTS_GHASTLY).output(new ItemStack((ItemLike)AoAArmour.GHASTLY_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_GHOULISH).output(new ItemStack((ItemLike)AoAArmour.GHOULISH_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_GHOULISH, AoATags.Items.INGOTS_GHOULISH).output(new ItemStack((ItemLike)AoAArmour.GHOULISH_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_GHOULISH).output(new ItemStack((ItemLike)AoAArmour.GHOULISH_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_GHOULISH, AoATags.Items.INGOTS_GHOULISH).output(new ItemStack((ItemLike)AoAArmour.GHOULISH_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(Tags.Items.STRING).output(new ItemStack((ItemLike)AoAArmour.HAZMAT_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(Tags.Items.STRING, Tags.Items.STRING, Tags.Items.STRING).output(new ItemStack((ItemLike)AoAArmour.HAZMAT_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{Items.f_42414_, (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()}).ingredients(Tags.Items.STRING).output(new ItemStack((ItemLike)AoAArmour.HAZMAT_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(Tags.Items.STRING, Tags.Items.STRING).output(new ItemStack((ItemLike)AoAArmour.HAZMAT_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get()).ingredients(Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAArmour.ICE_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get()).ingredients(Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAArmour.ICE_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get()).ingredients(Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAArmour.ICE_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get()).ingredients(Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAArmour.ICE_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients(new ItemLike[]{Items.f_42542_, (ItemLike)AoAItems.ICE_CRYSTAL.get()}).ingredients(AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE).output(new ItemStack((ItemLike)AoAArmour.INFERNAL_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(new ItemLike[]{Items.f_42542_, Items.f_42542_, Items.f_42542_, (ItemLike)AoAItems.ICE_CRYSTAL.get()}).ingredients(AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE).output(new ItemStack((ItemLike)AoAArmour.INFERNAL_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{Items.f_42542_, (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()}).ingredients(AoATags.Items.INGOTS_EMBERSTONE).output(new ItemStack((ItemLike)AoAArmour.INFERNAL_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(new ItemLike[]{Items.f_42542_, Items.f_42542_, Items.f_42542_, (ItemLike)AoAItems.ICE_CRYSTAL.get()}).ingredients(AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE).output(new ItemStack((ItemLike)AoAArmour.INFERNAL_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.WHITEWASHING_SOLUTION.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_SHYRESTONE, AoATags.Items.GEMS_SHYREGEM).output(new ItemStack((ItemLike)AoAArmour.KNIGHT_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(new ItemLike[]{Items.f_42436_, (ItemLike)AoAItems.WHITEWASHING_SOLUTION.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).ingredients(AoATags.Items.INGOTS_SHYRESTONE, AoATags.Items.GEMS_SHYREGEM).output(new ItemStack((ItemLike)AoAArmour.KNIGHT_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.WHITEWASHING_SOLUTION.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_SHYRESTONE, AoATags.Items.GEMS_SHYREGEM).output(new ItemStack((ItemLike)AoAArmour.KNIGHT_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(new ItemLike[]{Items.f_42436_, (ItemLike)AoAItems.WHITEWASHING_SOLUTION.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).ingredients(AoATags.Items.INGOTS_SHYRESTONE, AoATags.Items.GEMS_SHYREGEM).output(new ItemStack((ItemLike)AoAArmour.KNIGHT_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients(AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE).output(new ItemStack((ItemLike)AoAArmour.LYNDAMYTE_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE).output(new ItemStack((ItemLike)AoAArmour.LYNDAMYTE_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE).output(new ItemStack((ItemLike)AoAArmour.LYNDAMYTE_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE).output(new ItemStack((ItemLike)AoAArmour.LYNDAMYTE_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.MAGNET_SHARD.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get()).ingredients(AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON).output(new ItemStack((ItemLike)AoAArmour.LYONIC_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.MAGNET_SHARD.get(), (ItemLike)AoAItems.MAGNET_SHARD.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON).output(new ItemStack((ItemLike)AoAArmour.LYONIC_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.MAGNET_SHARD.get()).ingredients(AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON).output(new ItemStack((ItemLike)AoAArmour.LYONIC_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.MAGNET_SHARD.get(), (ItemLike)AoAItems.MAGNET_SHARD.get()).ingredients(AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON).output(new ItemStack((ItemLike)AoAArmour.LYONIC_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredients(Tags.Items.GEMS_DIAMOND, AoATags.Items.GEMS_JEWELYTE, AoATags.Items.GEMS_GEMENYTE).output(new ItemStack((ItemLike)AoAArmour.MERCURIAL_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredients(Tags.Items.GEMS_DIAMOND, Tags.Items.GEMS_DIAMOND, AoATags.Items.GEMS_GEMENYTE, AoATags.Items.GEMS_GEMENYTE, AoATags.Items.GEMS_JEWELYTE, AoATags.Items.GEMS_JEWELYTE).output(new ItemStack((ItemLike)AoAArmour.MERCURIAL_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(Tags.Items.GEMS_DIAMOND, AoATags.Items.GEMS_JEWELYTE, AoATags.Items.GEMS_GEMENYTE).output(new ItemStack((ItemLike)AoAArmour.MERCURIAL_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredients(Tags.Items.GEMS_DIAMOND, AoATags.Items.GEMS_GEMENYTE, AoATags.Items.GEMS_GEMENYTE, AoATags.Items.GEMS_JEWELYTE, AoATags.Items.GEMS_JEWELYTE).output(new ItemStack((ItemLike)AoAArmour.MERCURIAL_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(Tags.Items.INGOTS_IRON, ItemTags.f_13160_, ItemTags.f_13160_).output(new ItemStack((ItemLike)AoAArmour.FACE_MASK.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.CORAL_STONE.get(), Items.f_42501_, (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).ingredients(Tags.Items.GLASS_PANES_COLORLESS, Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.SEALORD_DIVING_HELMET.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.CORAL_STONE.get(), Items.f_42696_, (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).ingredients(Tags.Items.GEMS_DIAMOND, Tags.Items.GLASS_PANES_COLORLESS).output(new ItemStack((ItemLike)AoAArmour.OCEANUS_DIVING_HELMET.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(Tags.Items.GEMS_EMERALD, Tags.Items.GEMS_EMERALD, AoATags.Items.GEMS_JADE, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAArmour.NIGHT_VISION_GOGGLES.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.CHARGED_RUNIUM_CHUNK.get(), (ItemLike)AoAItems.PHANTASM.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_GHOULISH).output(new ItemStack((ItemLike)AoAArmour.NIGHTMARE_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.CHARGED_RUNIUM_CHUNK.get(), (ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_GHOULISH).output(new ItemStack((ItemLike)AoAArmour.NIGHTMARE_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.CHARGED_RUNIUM_CHUNK.get(), (ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_GHOULISH).output(new ItemStack((ItemLike)AoAArmour.NIGHTMARE_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.CHARGED_RUNIUM_CHUNK.get(), (ItemLike)AoAItems.PHANTASM.get(), (ItemLike)AoAItems.PHANTASM.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_GHOULISH).output(new ItemStack((ItemLike)AoAArmour.NIGHTMARE_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).output(new ItemStack((ItemLike)AoAArmour.POISON_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).output(new ItemStack((ItemLike)AoAArmour.POISON_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get()).output(new ItemStack((ItemLike)AoAArmour.POISON_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).output(new ItemStack((ItemLike)AoAArmour.POISON_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients(new ItemLike[]{Items.f_42455_, (ItemLike)AoAItems.RUNIC_ENERGY.get(), Items.f_42471_, (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()}).output(new ItemStack((ItemLike)AoAArmour.PURITY_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.RUNIC_ENERGY.get(), Items.f_42469_, Items.f_42455_, (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).output(new ItemStack((ItemLike)AoAArmour.PURITY_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{Items.f_42455_, (ItemLike)AoAItems.RUNIC_ENERGY.get(), Items.f_42468_, (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()}).output(new ItemStack((ItemLike)AoAArmour.PURITY_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(new ItemLike[]{Items.f_42455_, (ItemLike)AoAItems.RUNIC_ENERGY.get(), Items.f_42470_, (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).output(new ItemStack((ItemLike)AoAArmour.PURITY_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(Tags.Items.BONES).output(new ItemStack((ItemLike)AoAArmour.ROCKBONE_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42412_, Items.f_42412_}).ingredients(Tags.Items.BONES, Tags.Items.BONES).output(new ItemStack((ItemLike)AoAArmour.ROCKBONE_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42412_, (ItemLike)AoAItems.PADDED_CLOTH.get()}).ingredients(Tags.Items.BONES).output(new ItemStack((ItemLike)AoAArmour.ROCKBONE_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42412_}).ingredients(Tags.Items.BONES, Tags.Items.BONES).output(new ItemStack((ItemLike)AoAArmour.ROCKBONE_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ROSID_ROOT.get()).ingredients(Tags.Items.GEMS_AMETHYST, AoATags.Items.GEMS_JADE).output(new ItemStack((ItemLike)AoAArmour.ROSIDIAN_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ROSID_ROOT.get(), (ItemLike)AoAItems.ROSID_ROOT.get(), (ItemLike)AoAItems.ROSID_ROOT.get()).ingredients(Tags.Items.GEMS_AMETHYST, AoATags.Items.GEMS_JADE).output(new ItemStack((ItemLike)AoAArmour.ROSIDIAN_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ROSID_ROOT.get(), (ItemLike)AoAItems.ROSID_ROOT.get()).ingredients(Tags.Items.GEMS_AMETHYST, AoATags.Items.GEMS_JADE).output(new ItemStack((ItemLike)AoAArmour.ROSIDIAN_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.ROSID_ROOT.get(), (ItemLike)AoAItems.ROSID_ROOT.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get()).ingredients(Tags.Items.GEMS_AMETHYST, AoATags.Items.GEMS_JADE).output(new ItemStack((ItemLike)AoAArmour.ROSIDIAN_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients(new ItemLike[]{Items.f_42498_, (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), (ItemLike)AoAItems.METAL_SLUG.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()}).output(new ItemStack((ItemLike)AoAArmour.SHARPSHOT_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(new ItemLike[]{Items.f_42498_, Items.f_42498_, (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.METAL_SLUG.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).output(new ItemStack((ItemLike)AoAArmour.SHARPSHOT_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{Items.f_42498_, (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.METAL_SLUG.get()}).output(new ItemStack((ItemLike)AoAArmour.SHARPSHOT_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(new ItemLike[]{Items.f_42498_, Items.f_42498_, (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.METAL_SLUG.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).output(new ItemStack((ItemLike)AoAArmour.SHARPSHOT_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.FOOTBONE_FRAGMENT.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_SKELETAL, AoATags.Items.INGOTS_SKELETAL).ingredients(AoATags.Items.FOOD).output(new ItemStack((ItemLike)AoAArmour.SKELETAL_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.CHESTBONE_FRAGMENT.get(), (ItemLike)AoAItems.CHESTBONE_FRAGMENT.get()).ingredients(AoATags.Items.INGOTS_SKELETAL, AoATags.Items.INGOTS_SKELETAL, AoATags.Items.INGOTS_SKELETAL, AoATags.Items.INGOTS_SKELETAL).ingredients(AoATags.Items.FOOD, AoATags.Items.FOOD).output(new ItemStack((ItemLike)AoAArmour.SKELETAL_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.SKULLBONE_FRAGMENT.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_SKELETAL, AoATags.Items.INGOTS_SKELETAL, AoATags.Items.INGOTS_SKELETAL).ingredients(AoATags.Items.FOOD).output(new ItemStack((ItemLike)AoAArmour.SKELETAL_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.LEGBONE_FRAGMENT.get(), (ItemLike)AoAItems.LEGBONE_FRAGMENT.get()).ingredients(AoATags.Items.INGOTS_SKELETAL, AoATags.Items.INGOTS_SKELETAL, AoATags.Items.INGOTS_SKELETAL).ingredients(AoATags.Items.FOOD, AoATags.Items.FOOD).output(new ItemStack((ItemLike)AoAArmour.SKELETAL_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.ORBULON.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_LUNAR, AoATags.Items.INGOTS_LUNAR).output(new ItemStack((ItemLike)AoAArmour.LUNAR_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.ORBULON.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_LUNAR, AoATags.Items.INGOTS_LUNAR, AoATags.Items.INGOTS_LUNAR).output(new ItemStack((ItemLike)AoAArmour.LUNAR_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.ORBULON.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_LUNAR, AoATags.Items.INGOTS_LUNAR).output(new ItemStack((ItemLike)AoAArmour.LUNAR_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.ORBULON.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.INGOTS_LUNAR, AoATags.Items.INGOTS_LUNAR, AoATags.Items.INGOTS_LUNAR).output(new ItemStack((ItemLike)AoAArmour.LUNAR_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients(new ItemLike[]{Items.f_42695_, (ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()}).ingredients(AoATags.Items.INGOTS_ELECANIUM).output(new ItemStack((ItemLike)AoAArmour.SPEED_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.RUNIC_ENERGY.get(), Items.f_42695_, (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).ingredients(AoATags.Items.INGOTS_ELECANIUM, AoATags.Items.INGOTS_ELECANIUM).output(new ItemStack((ItemLike)AoAArmour.SPEED_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{Items.f_42695_, (ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()}).ingredients(AoATags.Items.INGOTS_ELECANIUM).output(new ItemStack((ItemLike)AoAArmour.SPEED_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(new ItemLike[]{Items.f_42695_, (ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).ingredients(AoATags.Items.INGOTS_ELECANIUM, AoATags.Items.INGOTS_ELECANIUM).output(new ItemStack((ItemLike)AoAArmour.SPEED_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42432_}).ingredients(Tags.Items.DUSTS_REDSTONE).output(new ItemStack((ItemLike)AoAArmour.SUBTERRANEAN_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42432_}).ingredients(Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE).output(new ItemStack((ItemLike)AoAArmour.SUBTERRANEAN_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42432_, (ItemLike)AoAItems.PADDED_CLOTH.get()}).ingredients(Tags.Items.DUSTS_REDSTONE).output(new ItemStack((ItemLike)AoAArmour.SUBTERRANEAN_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42432_}).ingredients(Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE).output(new ItemStack((ItemLike)AoAArmour.SUBTERRANEAN_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.VOID_SCALES.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAArmour.VOID_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.VOID_SCALES.get(), (ItemLike)AoAItems.VOID_SCALES.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAArmour.VOID_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.VOID_SCALES.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAArmour.VOID_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.VOID_SCALES.get(), (ItemLike)AoAItems.VOID_SCALES.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAArmour.VOID_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.YELLOW_SPORES.get(), Items.f_42675_}).ingredients(Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.WEAKEN_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.YELLOW_SPORES.get(), (ItemLike)AoAItems.ORANGE_SPORES.get(), Items.f_42675_}).ingredients(Tags.Items.GEMS_DIAMOND, Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.WEAKEN_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.YELLOW_SPORES.get(), Items.f_42675_, (ItemLike)AoAItems.PADDED_CLOTH.get()}).ingredients(Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.WEAKEN_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.YELLOW_SPORES.get(), (ItemLike)AoAItems.ORANGE_SPORES.get(), Items.f_42675_}).ingredients(Tags.Items.GEMS_DIAMOND).output(new ItemStack((ItemLike)AoAArmour.WEAKEN_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BOOTS_FRAME.get()).ingredients((ItemLike)AoAItems.WITHER_RUNE.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get()).ingredients(AoATags.Items.GEMS_BLOODSTONE, AoATags.Items.GEMS_BLOODSTONE).output(new ItemStack((ItemLike)AoAArmour.WITHER_ARMOUR.boots.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CHESTPLATE_FRAME.get()).ingredients((ItemLike)AoAItems.WITHER_RUNE.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.WITHER_RUNE.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.GEMS_BLOODSTONE, AoATags.Items.GEMS_BLOODSTONE, AoATags.Items.GEMS_BLOODSTONE).output(new ItemStack((ItemLike)AoAArmour.WITHER_ARMOUR.chestplate.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.HELMET_FRAME.get()).ingredients((ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.PADDED_CLOTH.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.WITHER_RUNE.get()).ingredients(AoATags.Items.GEMS_BLOODSTONE, AoATags.Items.GEMS_BLOODSTONE).output(new ItemStack((ItemLike)AoAArmour.WITHER_ARMOUR.helmet.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.LEGGINGS_FRAME.get()).ingredients((ItemLike)AoAItems.WITHER_RUNE.get(), (ItemLike)AoAItems.ARMOUR_PLATING.get(), (ItemLike)AoAItems.WITHER_RUNE.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get(), (ItemLike)AoAItems.REINFORCED_CLOTH.get()).ingredients(AoATags.Items.GEMS_BLOODSTONE, AoATags.Items.GEMS_BLOODSTONE, AoATags.Items.GEMS_BLOODSTONE).output(new ItemStack((ItemLike)AoAArmour.WITHER_ARMOUR.leggings.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients(AoATags.Items.RODS_METAL).ingredients((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), (ItemLike)AoABlocks.DIVINE_ENHANCER.get()).output(new ItemStack((ItemLike)AoAWeapons.VULCANE.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CROSSBOW_FRAME.get()).ingredients((ItemLike)AoAItems.GHOSTLY_POWDER.get(), (ItemLike)AoAItems.FLOATING_STONE.get(), (ItemLike)AoAItems.ORBULON.get()).ingredients(AoATags.Items.INGOTS_LUNAR, AoATags.Items.INGOTS_LUNAR, AoATags.Items.INGOTS_LUNAR).output(new ItemStack((ItemLike)AoAWeapons.LUNAR_CROSSBOW.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CROSSBOW_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.RUNIC_ENERGY.get(), Items.f_42412_, (ItemLike)AoAItems.GHOSTLY_POWDER.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get()}).ingredients(AoATags.Items.INGOTS_ELECANIUM, AoATags.Items.INGOTS_ELECANIUM, Tags.Items.INGOTS_NETHERITE).output(new ItemStack((ItemLike)AoAWeapons.SPECTRAL_CROSSBOW.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CROSSBOW_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), Items.f_42532_}).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.VIRAL_CROSSBOW.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.POWER_CORE.get()).ingredients(AoATags.Items.INGOTS_ELECANIUM, Tags.Items.GEMS_DIAMOND, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.ATOMIZER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients(new ItemLike[]{Items.f_42447_, (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get(), (ItemLike)AoAItems.ICE_CRYSTAL.get()}).ingredients(Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.BLAST_CHILLER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.NIGHTMARE_FLAKES.get(), (ItemLike)AoAItems.NIGHTMARE_FLAKES.get()).ingredients(AoATags.Items.GEMS_BLOODSTONE, AoATags.Items.GEMS_BLOODSTONE, AoATags.Items.GEMS_BLOODSTONE).output(new ItemStack((ItemLike)AoAWeapons.BLOOD_DRAINER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.JUNGLE_THORNS.get(), (ItemLike)AoAItems.JUNGLE_THORNS.get()).ingredients(Tags.Items.BONES, AoATags.Items.INGOTS_SKELETAL, AoATags.Items.PRECASIAN_BONE, AoATags.Items.PRECASIAN_BONE).output(new ItemStack((ItemLike)AoAWeapons.BONE_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.CORAL_STONE.get(), (ItemLike)AoAItems.CORAL_STONE.get(), (ItemLike)AoAItems.STICKY_SLIME.get()).ingredients(AoATags.Items.INGOTS_VARSIUM, Tags.Items.GEMS_DIAMOND, Tags.Items.INGOTS_GOLD).output(new ItemStack((ItemLike)AoAWeapons.BUBBLE_HORN.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.BLUE_DRUSE.get(), (ItemLike)AoAItems.PURPLE_DRUSE.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.POWER_CORE.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.GEMS_LAPIS).output(new ItemStack((ItemLike)AoAWeapons.DOOM_BRINGER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.POWER_CORE.get(), Items.f_42484_, Items.f_42484_}).ingredients(AoATags.Items.GEMS_JADE, AoATags.Items.GEMS_JADE).output(new ItemStack((ItemLike)AoAWeapons.ERADICATOR.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.SOUR_GUMMY.get(), (ItemLike)AoAItems.SOUR_GUMMY.get(), (ItemLike)AoAItems.SPEARMINT_CANDY.get(), (ItemLike)AoAItems.PEPPERMINT_CANDY.get(), Items.f_42501_}).ingredients(Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.FROSTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.ROSID_ROOT.get(), (ItemLike)AoAItems.JUNGLE_THORNS.get(), (ItemLike)AoAItems.POWER_CORE.get()).ingredients(AoATags.Items.GEMS_JADE, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.GAS_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.GHOULASM.get(), Items.f_42591_}).ingredients(AoATags.Items.INGOTS_GHOULISH, Tags.Items.INGOTS_NETHERITE, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.GHOUL_GASSER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.FLOATING_STONE.get(), (ItemLike)AoAItems.FLOATING_STONE.get(), (ItemLike)AoAItems.FLOATING_STONE.get(), (ItemLike)AoAItems.FLOATING_STONE.get()).output(new ItemStack((ItemLike)AoAWeapons.GRAVITY_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get()).ingredients(AoATags.Items.INGOTS_ELECANIUM, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.ILLUSION_REVOLVER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.WHITE_DRUSE.get(), (ItemLike)AoAItems.WHITE_DRUSE.get(), (ItemLike)AoAItems.BLUE_DRUSE.get(), (ItemLike)AoAItems.POWER_CORE.get()).ingredients(Tags.Items.DUSTS_REDSTONE, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.ION_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.ORBULON.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get(), Items.f_42053_}).ingredients(AoATags.Items.INGOTS_LUNAR, AoATags.Items.INGOTS_LUNAR, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.LUNA_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.MAGNET_SHARD.get()).ingredients(AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_BARONYTE, AoATags.Items.INGOTS_VARSIUM).output(new ItemStack((ItemLike)AoAWeapons.MECHA_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.ENCHANTED_GUNPOWDER.get()).ingredients(AoATags.Items.INGOTS_ELECANIUM, AoATags.Items.INGOTS_ELECANIUM).output(new ItemStack((ItemLike)AoAWeapons.MIND_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.GHOSTLY_POWDER.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.MOON_SHINER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get(), (ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.MAGNET_SHARD.get()).ingredients(AoATags.Items.GEMS_BLOODSTONE, Tags.Items.INGOTS_NETHERITE).output(new ItemStack((ItemLike)AoAWeapons.ODIOUS.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.PURPLE_DRUSE.get(), (ItemLike)AoAItems.ORBULON.get(), (ItemLike)AoAItems.ORBULON.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get()).ingredients(AoATags.Items.INGOTS_LUNAR, AoATags.Items.INGOTS_LUNAR).output(new ItemStack((ItemLike)AoAWeapons.ORBOCRON.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.CONFETTI_PILE.get(), (ItemLike)AoAItems.CONFETTI_PILE.get(), (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), Items.f_42516_, Items.f_42497_}).ingredients(Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.PARTY_POPPER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.MUSHROOM_SPORES.get(), (ItemLike)AoAItems.MUSHROOM_SPORES.get(), Items.f_42591_}).ingredients(AoATags.Items.INGOTS_MYSTITE, AoATags.Items.GEMS_JADE, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.POISON_PLUNGER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredients(AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_BLAZIUM, AoATags.Items.INGOTS_BLAZIUM, AoATags.Items.INGOTS_BLAZIUM).output(new ItemStack((ItemLike)AoAWeapons.REVOLUTION.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get(), (ItemLike)AoAItems.GHOSTLY_POWDER.get()).ingredients(AoATags.Items.INGOTS_GHASTLY).output(new ItemStack((ItemLike)AoAWeapons.SOUL_STORM.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.HIVE_CHUNK.get(), (ItemLike)AoAItems.HIVE_CHUNK.get(), (ItemLike)AoAItems.HIVE_CHUNK.get()).ingredients(AoATags.Items.INGOTS_BARONYTE, AoATags.Items.INGOTS_BARONYTE, AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_BLAZIUM).output(new ItemStack((ItemLike)AoAWeapons.SWARMOTRON.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, AoATags.Items.GEMS_JADE, AoATags.Items.GEMS_JADE).output(new ItemStack((ItemLike)AoAWeapons.TOXIC_TERRORIZER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.BLASTER_FRAME.get()).ingredients((ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), (ItemLike)AoAItems.FLOATING_STONE.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.WHIMSY_WINDER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.PURPLE_DRUSE.get(), (ItemLike)AoAItems.PURPLE_DRUSE.get(), (ItemLike)AoAItems.ENCHANTED_GUNPOWDER.get(), (ItemLike)AoAItems.STICKY_SLIME.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.GEMS_LAPIS).output(new ItemStack((ItemLike)AoAWeapons.BLAST_CANNON.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get(), (ItemLike)AoAItems.ORNAMYTE.get()).ingredients(Tags.Items.INGOTS_IRON, AoATags.Items.GEMS_GEMENYTE, AoATags.Items.GEMS_JEWELYTE, AoATags.Items.GEMS_JEWELYTE).output(new ItemStack((ItemLike)AoAWeapons.BOOM_BOOM.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get(), (ItemLike)AoAWeapons.GRENADE.get()).ingredients(AoATags.Items.INGOTS_LYON, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.BOOM_CANNON.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.CONFETTI_PILE.get(), (ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get()).ingredients(AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE, Tags.Items.GEMS_LAPIS, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.BOZO_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.SMALL_ORANGE_PETAL.get(), (ItemLike)AoAItems.ROSID_ROOT.get()).ingredients(Tags.Items.INGOTS_IRON, AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE, Tags.Items.CROPS_CARROT).output(new ItemStack((ItemLike)AoAWeapons.CARROT_CANNON.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.POWER_CORE.get()).ingredients(AoATags.Items.INGOTS_ELECANIUM, AoATags.Items.INGOTS_ELECANIUM).output(new ItemStack((ItemLike)AoAWeapons.ENERGY_CANNON.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.SMALL_GREEN_PETAL.get(), (ItemLike)AoAItems.ROSID_ROOT.get(), (ItemLike)AoAItems.STICKY_SLIME.get(), Items.f_41939_}).ingredients(AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE, AoATags.Items.GEMS_JADE).output(new ItemStack((ItemLike)AoAWeapons.FLOWER_CANNON.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.WITHER_RUNE.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredients(AoATags.Items.INGOTS_GHASTLY, AoATags.Items.INGOTS_GHASTLY, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.GHAST_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.GHOULASM.get()).ingredients(AoATags.Items.INGOTS_GHOULISH, AoATags.Items.INGOTS_GHOULISH, Tags.Items.GUNPOWDER, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.GHOUL_CANNON.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.HIVE_CHUNK.get(), (ItemLike)AoAItems.HIVE_CHUNK.get(), (ItemLike)AoAItems.HIVE_CHUNK.get()).ingredients(AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_BARONYTE).output(new ItemStack((ItemLike)AoAWeapons.HIVE_HOWITZER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients(new ItemLike[]{Items.f_42594_, (ItemLike)AoAItems.DENSE_ROCK.get(), Items.f_42461_}).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.JACK_ROCKER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.ENCHANTED_GUNPOWDER.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredients(AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.MISSILE_MAKER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.PURPLE_DRUSE.get(), (ItemLike)AoAItems.RED_DRUSE.get(), (ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.PULSE_CANNON.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.VOID_SCALES.get(), Items.f_41996_}).ingredients(AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.RPG.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients((ItemLike)AoAItems.NIGHTMARE_FLAKES.get(), (ItemLike)AoAItems.NIGHTMARE_FLAKES.get()).ingredients(AoATags.Items.GEMS_BLOODSTONE, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.SHADOW_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.CANNON_FRAME.get()).ingredients(AoATags.Items.INGOTS_SHYRESTONE, AoATags.Items.INGOTS_SHYRESTONE, AoATags.Items.GEMS_SHYREGEM, AoATags.Items.GEMS_SHYREGEM, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.SHYRE_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get()).ingredients(AoATags.Items.INGOTS_GHASTLY, AoATags.Items.INGOTS_GHASTLY, AoATags.Items.INGOTS_GHOULISH, AoATags.Items.INGOTS_GHOULISH, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.ABOMINATOR.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAWeapons.GRENADE.get()).ingredients(Tags.Items.INGOTS_IRON, AoATags.Items.INGOTS_BARONYTE, AoATags.Items.INGOTS_VARSIUM).output(new ItemStack((ItemLike)AoAWeapons.BARONATOR.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.SHARP_CLAW.get()).ingredients(AoATags.Items.INGOTS_SKELETAL, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.GUNPOWDER).ingredients(ItemTags.f_13168_).output(new ItemStack((ItemLike)AoAWeapons.BAYONETTE_RIFLE.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), Items.f_41874_, Items.f_41937_, (ItemLike)AoAItems.REINFORCED_CLOTH.get()}).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.BIG_TOP.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients(Tags.Items.INGOTS_NETHERITE, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, AoATags.Items.GEMS_BLOODSTONE, AoATags.Items.GEMS_BLOODSTONE, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.BLOOD_IRON.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.MAGNET_SHARD.get(), (ItemLike)AoAItems.MECHA_GEAR.get()).ingredients(AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_VARSIUM).output(new ItemStack((ItemLike)AoAWeapons.CHAIN_WRECKER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.SMALL_RED_PETAL.get(), (ItemLike)AoAItems.CHILLI.get(), (ItemLike)AoAItems.FLAMMABLE_DUST.get()).ingredients(AoATags.Items.INGOTS_BARONYTE, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.CHILLI_CHUGGER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.GREEN_DRUSE.get(), (ItemLike)AoAItems.GREEN_DRUSE.get(), (ItemLike)AoAItems.POWER_CORE.get()).ingredients(AoATags.Items.GEMS_JADE, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.CONSTRUCT.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoABlocks.LELYETIAN_LEAVES.get(), (ItemLike)AoAItems.YELLOW_SPORES.get(), (ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.SCRAP_METAL.get()).ingredients(AoATags.Items.INGOTS_LIMONITE, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.CORE_RIFLE.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.RAINBOW_DRUSE.get(), (ItemLike)AoAItems.BLUE_DRUSE.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.GEMS_DIAMOND, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.CRYSTAL_CARVER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredients(Tags.Items.DUSTS_REDSTONE, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.DESTRUCTION_RIFLE.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.ORNAMYTE.get(), (ItemLike)AoAItems.ORNAMYTE.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get(), (ItemLike)AoAItems.DISCHARGE_CAPSULE.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.DUSTS_REDSTONE).output(new ItemStack((ItemLike)AoAWeapons.DISCHARGE_RIFLE.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAWeapons.GRENADE.get(), (ItemLike)AoAItems.URKA_HIDE.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).output(new ItemStack((ItemLike)AoAWeapons.DUSTOMETER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients(new ItemLike[]{Items.f_42525_}).ingredients(AoATags.Items.INGOTS_BARONYTE, AoATags.Items.INGOTS_BARONYTE, Tags.Items.LEATHER, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.ECHO_GULL.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.FLAMMABLE_DUST.get(), (ItemLike)AoAItems.FLAMMABLE_DUST.get()).ingredients(AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_LIMONITE).output(new ItemStack((ItemLike)AoAWeapons.HOT_SHOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoABlocks.TOXICWOOD_PLANKS.get()).ingredients(AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_VARSIUM, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.HUNTERS_RIFLE.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.PURPLE_DRUSE.get(), (ItemLike)AoAItems.PURPLE_DRUSE.get(), (ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.DENSE_ROCK.get()).ingredients(AoATags.Items.INGOTS_LIMONITE, Tags.Items.DUSTS_REDSTONE).output(new ItemStack((ItemLike)AoAWeapons.ION_REVOLVER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.POWER_CORE.get()).ingredients(AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_LYON, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.IRO_RIFLE.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.MUSHROOM_SPORES.get(), (ItemLike)AoAItems.JUNGLE_THORNS.get()).ingredients(AoATags.Items.INGOTS_MYSTITE, Tags.Items.GEMS_AMETHYST, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.KRILINATOR.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.SMALL_GREEN_PETAL.get(), (ItemLike)AoAItems.ROSID_ROOT.get(), (ItemLike)AoAItems.JUNGLE_THORNS.get()).ingredients(AoATags.Items.GEMS_JADE, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.MIASMA.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients(Tags.Items.INGOTS_IRON).ingredients((ItemLike)AoAItems.SOUR_GUMMY.get(), (ItemLike)AoAItems.SOUR_GUMMY.get()).ingredients(AoATags.Items.MINTS, AoATags.Items.MINTS, AoATags.Items.MINTS).output(new ItemStack((ItemLike)AoAWeapons.MINT_MAGNUM.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.ORBULON.get(), (ItemLike)AoAItems.ENCHANTED_GUNPOWDER.get(), (ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.STRIKE_RUNE.get()).ingredients(AoATags.Items.INGOTS_LUNAR, AoATags.Items.INGOTS_LUNAR).output(new ItemStack((ItemLike)AoAWeapons.PULSATOR.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.RUNIC_ENERGY.get(), (ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.WHITE_DRUSE.get()).ingredients(AoATags.Items.INGOTS_ELECANIUM, AoATags.Items.INGOTS_ELECANIUM, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.PURITY_RIFLE.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.OLD_BOOT.get()).output(new ItemStack((ItemLike)AoAWeapons.SHOE_FLINGER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoAItems.DARKLY_POWDER.get()).ingredients(Tags.Items.GUNPOWDER, AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_VARSIUM).ingredients(ItemTags.f_13168_).output(new ItemStack((ItemLike)AoAWeapons.SQUAD_GUN.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.LIMONITE_BULLET.get()).ingredients(Tags.Items.LEATHER, Tags.Items.INGOTS_IRON, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.STAMPEDE.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.SOUR_POP.get(), (ItemLike)AoAItems.GINGERBREAD_WING.get(), (ItemLike)AoAItems.FLOATING_STONE.get()).ingredients(Tags.Items.INGOTS_IRON, AoATags.Items.INGOTS_LIMONITE, AoATags.Items.GEMS_JADE).output(new ItemStack((ItemLike)AoAWeapons.STORMER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.WHITEWASHING_SOLUTION.get(), (ItemLike)AoAItems.ROSID_ROOT.get(), (ItemLike)AoAItems.POWER_CORE.get()).ingredients(AoATags.Items.INGOTS_SHYRESTONE, AoATags.Items.GEMS_SHYREGEM, Tags.Items.INGOTS_IRON, Tags.Items.GEMS_QUARTZ).output(new ItemStack((ItemLike)AoAWeapons.SUBLIMUS.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.SCRAP_METAL.get()).ingredients(AoATags.Items.INGOTS_LIMONITE, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.LEATHER, Tags.Items.GUNPOWDER).ingredients(ItemTags.f_13168_).output(new ItemStack((ItemLike)AoAWeapons.TOMMY.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.VOID_SCALES.get(), (ItemLike)AoAItems.STICKY_SLIME.get(), (ItemLike)AoAItems.POWER_CORE.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.VILE_VANQUISHER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients(Tags.Items.CROPS_NETHER_WART, Tags.Items.CROPS_NETHER_WART, Tags.Items.CROPS_NETHER_WART, AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.WART_GUN.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.GUN_FRAME.get()).ingredients((ItemLike)AoAItems.GINGERBREAD_WING.get(), (ItemLike)AoAItems.GINGERBREAD_COOKIE.get(), (ItemLike)AoAItems.POWER_CORE.get()).ingredients(AoATags.Items.INGOTS_VARSIUM, AoATags.Items.INGOTS_LIMONITE, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.WRECKER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SHOTGUN_FRAME.get()).ingredients((ItemLike)AoAItems.ENCHANTED_GUNPOWDER.get()).ingredients(AoATags.Items.INGOTS_SHYRESTONE, AoATags.Items.INGOTS_SHYRESTONE, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, AoATags.Items.GEMS_SHYREGEM).output(new ItemStack((ItemLike)AoAWeapons.AMPLIFIER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SHOTGUN_FRAME.get()).ingredients((ItemLike)AoAItems.SPREADSHOT.get()).ingredients(Tags.Items.LEATHER, Tags.Items.INGOTS_IRON, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.BROWN_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SHOTGUN_FRAME.get()).ingredients((ItemLike)AoAItems.HARDENED_CONFETTI_BALL.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get()).ingredients(AoATags.Items.INGOTS_EMBERSTONE, AoATags.Items.INGOTS_EMBERSTONE, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.DESTRUCTION_SHOTGUN.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SHOTGUN_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.SOUR_GUMMY.get(), (ItemLike)AoAItems.SOUR_GUMMY.get(), (ItemLike)AoAItems.SPREADSHOT.get(), Items.f_42501_}).ingredients(Tags.Items.INGOTS_IRON).ingredients(AoATags.Items.GINGERBREAD).output(new ItemStack((ItemLike)AoAWeapons.GINGER_BLASTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SHOTGUN_FRAME.get()).ingredients((ItemLike)AoAItems.POWER_CORE.get(), (ItemLike)AoAItems.SMALL_BLUE_PETAL.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.LONG_SHOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SHOTGUN_FRAME.get()).ingredients(AoATags.Items.INGOTS_BARONYTE, AoATags.Items.INGOTS_BARONYTE, AoATags.Items.INGOTS_BLAZIUM, Tags.Items.INGOTS_IRON, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.RED_ROCKET.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SHOTGUN_FRAME.get()).ingredients((ItemLike)AoAItems.MAGNET_SHARD.get()).ingredients(AoATags.Items.INGOTS_LYON, AoATags.Items.INGOTS_LYON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.VIVO.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.MUSHROOM_SPORES.get(), Items.f_42383_}).ingredients(AoATags.Items.INGOTS_MYSTITE, AoATags.Items.INGOTS_MYSTITE, Tags.Items.GEMS_AMETHYST, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.BAYONETTE_SR.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.GEMS_DIAMOND, Tags.Items.GUNPOWDER).ingredients(ItemTags.f_13168_, ItemTags.f_13168_).output(new ItemStack((ItemLike)AoAWeapons.BOLT_RIFLE.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.JUNGLE_THORNS.get(), (ItemLike)AoAItems.JUNGLE_THORNS.get(), Items.f_41864_}).ingredients(Tags.Items.INGOTS_IRON).ingredients(ItemTags.f_13143_).output(new ItemStack((ItemLike)AoAWeapons.CAMO_RIFLE.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.CONFETTI_PILE.get(), (ItemLike)AoAItems.CONFETTI_PILE.get(), Items.f_42516_}).ingredients(Tags.Items.GEMS_DIAMOND, Tags.Items.INGOTS_IRON, AoATags.Items.INGOTS_LIMONITE, AoATags.Items.INGOTS_LIMONITE).output(new ItemStack((ItemLike)AoAWeapons.CLOWN_CRACKER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients((ItemLike)AoAItems.RAINBOW_DRUSE.get(), (ItemLike)AoAItems.RAINBOW_DRUSE.get(), (ItemLike)AoAItems.RAINBOW_DRUSE.get()).ingredients(Tags.Items.GEMS_AMETHYST, Tags.Items.GEMS_EMERALD, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.CRYSTANEER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients(ItemTags.f_13160_, Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE, Tags.Items.INGOTS_IRON, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.DEADLOCK.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients((ItemLike)AoAItems.ORANGE_SPORES.get(), (ItemLike)AoAItems.ZHINX_DUST.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.DECIMATOR.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients((ItemLike)AoAItems.BLUE_DRUSE.get(), (ItemLike)AoAItems.BLUE_DRUSE.get(), (ItemLike)AoAItems.DENSE_ROCK.get()).ingredients(Tags.Items.GEMS_QUARTZ, Tags.Items.GEMS_QUARTZ, Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.DUAL_SIGHT.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.LEATHER, Tags.Items.LEATHER, Tags.Items.GUNPOWDER).ingredients(ItemTags.f_13168_).output(new ItemStack((ItemLike)AoAWeapons.DUSTER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients((ItemLike)AoAItems.SMALL_ORANGE_PETAL.get()).ingredients(Tags.Items.GEMS_QUARTZ, AoATags.Items.INGOTS_SKELETAL, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.KA_500.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients((ItemLike)AoAItems.GHOULASM.get(), (ItemLike)AoAItems.PRIMORDIAL_SKULL.get(), (ItemLike)AoAItems.DARKLY_POWDER.get()).ingredients(AoATags.Items.INGOTS_GHOULISH, AoATags.Items.INGOTS_GHASTLY, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.SABBATH.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.TOXIC_LUMP.get(), (ItemLike)AoAItems.STICKY_SLIME.get(), Items.f_42094_}).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.GUNPOWDER, AoATags.Items.GEMS_JADE).output(new ItemStack((ItemLike)AoAWeapons.SLUDGE_SNIPER.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients(new ItemLike[]{(ItemLike)AoAItems.CANDY_CORN.get(), (ItemLike)AoAItems.CANDY_CORN.get(), (ItemLike)AoAItems.CANDY_CANE.get(), (ItemLike)AoABlocks.CHOCOLATE_BLOCK.get(), (ItemLike)AoAItems.GINGERBREAD_COOKIE.get(), Items.f_42501_}).ingredients(Tags.Items.INGOTS_IRON).output(new ItemStack((ItemLike)AoAWeapons.SWEET_TOOTH.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients((ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoAItems.UNSTABLE_GUNPOWDER.get(), (ItemLike)AoAItems.POWER_CORE.get()).ingredients(Tags.Items.OBSIDIAN, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, AoATags.Items.GEMS_BLOODSTONE).output(new ItemStack((ItemLike)AoAWeapons.TERMINATOR.get()));
        new RecipeBuilder(RecipeBuilder.Type.INFUSION).ingredients((ItemLike)AoAItems.SNIPER_FRAME.get()).ingredients((ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.DENSE_ROCK.get(), (ItemLike)AoAItems.JUNGLE_THORNS.get()).ingredients(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.GUNPOWDER).output(new ItemStack((ItemLike)AoAWeapons.VIPER_1.get()));
    }
}

