/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.recipes;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.tslat.aoa3.advent.datagen.builder.recipe.RecipeBuilder;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;

public class DataGenBlockRecipes {
    protected static void registerRecipes() {
        DataGenBlockRecipes.registerBannerRecipes();
        DataGenBlockRecipes.registerMineralBlockRecipes();
        DataGenBlockRecipes.registerFenceAndGateRecipes();
        DataGenBlockRecipes.registerIvoryRecipes();
        DataGenBlockRecipes.registerLogRecipes();
        DataGenBlockRecipes.registerSlabRecipes();
        DataGenBlockRecipes.registerStairsRecipes();
        DataGenBlockRecipes.registerPlankRecipes();
        DataGenBlockRecipes.registerLampRecipes();
        DataGenBlockRecipes.registerWallRecipes();
        DataGenBlockRecipes.registerMiscBlockRecipes();
        DataGenBlockRecipes.registerStoneCutterRecipes();
        DataGenBlockRecipes.registerSmeltingRecipes();
        new RecipeBuilder(RecipeBuilder.Type.TROPHY).ingredients((ItemLike)AoABlocks.TROPHY.get()).output(new ItemStack((ItemLike)AoABlocks.GOLD_TROPHY.get()));
    }

    private static void registerBannerRecipes() {
        BiConsumer<ItemLike, ItemStack> consumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("XXX", "XXX", "XXX").ingredient('X', (ItemLike)input).output((ItemStack)output);
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_ANCIENT_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_ANCIENT_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_BARON_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_BARON_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_RAGE_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_RAGE_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_BOREIC_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_BOREIC_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_CANDY_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_CANDY_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_CLOWN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_CLOWN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_CREEPY_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_CREEPY_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_CRYSTAL_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_CRYSTAL_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_DEEP_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_DEEP_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_DUSTOPIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_DUSTOPIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_ENERGY_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_ENERGY_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_FUNGAL_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_FUNGAL_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_HAUNTED_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_HAUNTED_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_LELYETIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_LELYETIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_LOTTO_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_LOTTO_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_LUNAR_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_LUNAR_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_MECHA_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_MECHA_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_NETHER_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_NETHER_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_ROSIDIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_ROSIDIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_RUNIC_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_RUNIC_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_SHADOW_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_SHADOW_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_SHYRE_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_SHYRE_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_SPIRIT_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_SPIRIT_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_UTOPIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_UTOPIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_VOID_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_VOID_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENCRUSTED_VOX_BANNER.get(), new ItemStack((ItemLike)AoABlocks.BEJEWELLED_VOX_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_ANCIENT_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_ANCIENT_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_BARON_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_BARON_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_RAGE_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_RAGE_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_BOREIC_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_BOREIC_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_CANDY_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_CANDY_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_CLOWN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_CLOWN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_CREEPY_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_CREEPY_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_CRYSTAL_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_CRYSTAL_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_DEEP_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_DEEP_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_DUSTOPIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_DUSTOPIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_ENERGY_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_ENERGY_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_FUNGAL_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_FUNGAL_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_HAUNTED_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_HAUNTED_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_LELYETIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_LELYETIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_LOTTO_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_LOTTO_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_LUNAR_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_LUNAR_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_MECHA_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_MECHA_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_NETHER_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_NETHER_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_ROSIDIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_ROSIDIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_RUNIC_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_RUNIC_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_SHADOW_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_SHADOW_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_SHYRE_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_SHYRE_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_SPIRIT_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_SPIRIT_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_UTOPIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_UTOPIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_VOID_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_VOID_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.GILDED_VOX_BANNER.get(), new ItemStack((ItemLike)AoABlocks.ENCRUSTED_VOX_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ANCIENT_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_ANCIENT_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.BARON_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_BARON_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.RAGE_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_RAGE_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.BOREIC_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_BOREIC_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.CANDY_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_CANDY_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.CLOWN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_CLOWN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.CREEPY_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_CREEPY_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.CRYSTAL_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_CRYSTAL_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.DEEP_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_DEEP_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.DUSTOPIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_DUSTOPIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ENERGY_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_ENERGY_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.FUNGAL_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_FUNGAL_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.HAUNTED_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_HAUNTED_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.LELYETIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_LELYETIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.LOTTO_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_LOTTO_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.LUNAR_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_LUNAR_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.MECHA_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_MECHA_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.NETHER_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_NETHER_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.ROSIDIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_ROSIDIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.RUNIC_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_RUNIC_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.SHADOW_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_SHADOW_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.SHYRE_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_SHYRE_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.SPIRIT_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_SPIRIT_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.UTOPIAN_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_UTOPIAN_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.VOID_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_VOID_BANNER.get(), 1));
        consumer.accept((ItemLike)AoABlocks.VOX_BANNER.get(), new ItemStack((ItemLike)AoABlocks.GILDED_VOX_BANNER.get(), 1));
    }

    private static void registerMineralBlockRecipes() {
        BiConsumer<TagKey, ItemStack> consumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("XXX", "XXX", "XXX").ingredient('X', (TagKey<Item>)input).output((ItemStack)output);
        consumer.accept(AoATags.Items.INGOTS_BARONYTE, new ItemStack((ItemLike)AoABlocks.BARONYTE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_BLAZIUM, new ItemStack((ItemLike)AoABlocks.BLAZIUM_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.GEMS_BLOODSTONE, new ItemStack((ItemLike)AoABlocks.BLOODSTONE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.GEMS_CRYSTALLITE, new ItemStack((ItemLike)AoABlocks.CRYSTALLITE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_ELECANIUM, new ItemStack((ItemLike)AoABlocks.ELECANIUM_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_EMBERSTONE, new ItemStack((ItemLike)AoABlocks.EMBERSTONE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.GEMS_GEMENYTE, new ItemStack((ItemLike)AoABlocks.GEMENYTE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_GHASTLY, new ItemStack((ItemLike)AoABlocks.GHASTLY_INGOT_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_GHOULISH, new ItemStack((ItemLike)AoABlocks.GHOULISH_INGOT_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.GEMS_JADE, new ItemStack((ItemLike)AoABlocks.JADE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.GEMS_JEWELYTE, new ItemStack((ItemLike)AoABlocks.JEWELYTE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_LIMONITE, new ItemStack((ItemLike)AoABlocks.LIMONITE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_LUNAR, new ItemStack((ItemLike)AoABlocks.LUNAR_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_LYON, new ItemStack((ItemLike)AoABlocks.LYON_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_MYSTITE, new ItemStack((ItemLike)AoABlocks.MYSTITE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.GEMS_ORNAMYTE, new ItemStack((ItemLike)AoABlocks.ORNAMYTE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.GEMS_SHYREGEM, new ItemStack((ItemLike)AoABlocks.SHYREGEM_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_SHYRESTONE, new ItemStack((ItemLike)AoABlocks.SHYRESTONE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_SKELETAL, new ItemStack((ItemLike)AoABlocks.SKELETAL_INGOT_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.INGOTS_VARSIUM, new ItemStack((ItemLike)AoABlocks.VARSIUM_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.RAW_MATERIALS_LIMONITE, new ItemStack((ItemLike)AoABlocks.RAW_LIMONITE_BLOCK.get(), 1));
        consumer.accept(AoATags.Items.RAW_MATERIALS_EMBERSTONE, new ItemStack((ItemLike)AoABlocks.RAW_EMBERSTONE_BLOCK.get(), 1));
        BiConsumer<ItemLike, ItemStack> consumer2 = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)input).output((ItemStack)output);
        consumer2.accept((ItemLike)AoABlocks.BARONYTE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.BARONYTE_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.BLAZIUM_BLOCK.get(), new ItemStack((ItemLike)AoAItems.BLAZIUM_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.BLOODSTONE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.BLOODSTONE.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.CRYSTALLITE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.CRYSTALLITE.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.ELECANIUM_BLOCK.get(), new ItemStack((ItemLike)AoAItems.ELECANIUM_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.EMBERSTONE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.EMBERSTONE_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.GEMENYTE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.GEMENYTE.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.GHASTLY_INGOT_BLOCK.get(), new ItemStack((ItemLike)AoAItems.GHASTLY_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.GHOULISH_INGOT_BLOCK.get(), new ItemStack((ItemLike)AoAItems.GHOULISH_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.JADE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.JADE.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.JEWELYTE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.JEWELYTE.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.LIMONITE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.LIMONITE_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.LUNAR_BLOCK.get(), new ItemStack((ItemLike)AoAItems.LUNAR_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.LYON_BLOCK.get(), new ItemStack((ItemLike)AoAItems.LYON_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.MYSTITE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.MYSTITE_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.ORNAMYTE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.ORNAMYTE.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.SHYREGEM_BLOCK.get(), new ItemStack((ItemLike)AoAItems.SHYREGEM.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.SHYRESTONE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.SHYRESTONE_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.SKELETAL_INGOT_BLOCK.get(), new ItemStack((ItemLike)AoAItems.SKELETAL_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.VARSIUM_BLOCK.get(), new ItemStack((ItemLike)AoAItems.VARSIUM_INGOT.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.RAW_LIMONITE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.RAW_LIMONITE.get(), 9));
        consumer2.accept((ItemLike)AoABlocks.RAW_EMBERSTONE_BLOCK.get(), new ItemStack((ItemLike)AoAItems.RAW_EMBERSTONE.get(), 9));
    }

    private static void registerFenceAndGateRecipes() {
        BiConsumer<ItemLike, ItemStack> consumer = (plankItem, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("PSP", "PSP").ingredient('P', (ItemLike)plankItem).ingredient('S', (ItemLike)Items.f_42398_).output((ItemStack)output);
        consumer.accept((ItemLike)AoABlocks.ACHONY_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.ACHONY_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.BLOODWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.BLOODWOOD_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.CHURRY_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.CHURRY_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.CREEP_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.CREEP_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.DAWNWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.DAWNWOOD_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.HAUNTEDWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.HAUNTEDWOOD_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.IROWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.IROWOOD_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.LUCALUS_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.LUCALUS_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.LUNIDE_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.LUNIDE_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.RUNIC_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.RUNIC_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.SHADOW_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.SHADOW_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.SHYRE_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.SHYRE_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.STRANGLEWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.STRANGLEWOOD_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.TOXICWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.TOXICWOOD_FENCE.get(), 3));
        consumer.accept((ItemLike)AoABlocks.TWINKLESTONE.get(), new ItemStack((ItemLike)AoABlocks.TWINKLESTONE_FENCE.get(), 3));
        consumer = (plankItem, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("SPS", "SPS").ingredient('P', (ItemLike)plankItem).ingredient('S', (ItemLike)Items.f_42398_).output((ItemStack)output);
        consumer.accept((ItemLike)AoABlocks.ACHONY_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.ACHONY_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.BLOODWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.BLOODWOOD_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.CHURRY_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.CHURRY_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.CREEP_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.CREEP_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.DAWNWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.DAWNWOOD_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.HAUNTEDWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.HAUNTEDWOOD_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.IROWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.IROWOOD_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.LUCALUS_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.LUCALUS_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.LUNIDE_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.LUNIDE_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.RUNIC_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.RUNIC_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.SHADOW_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.SHADOW_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.SHYRE_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.SHYRE_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.STRANGLEWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.STRANGLEWOOD_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.TOXICWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.TOXICWOOD_FENCE_GATE.get(), 1));
        consumer.accept((ItemLike)AoABlocks.TWINKLESTONE.get(), new ItemStack((ItemLike)AoABlocks.TWINKLESTONE_FENCE_GATE.get(), 1));
    }

    private static void registerIvoryRecipes() {
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.IVORY.get(), 9)).output(new ItemStack((ItemLike)AoABlocks.NATURAL_IVORY.get(), 4));
        BiConsumer<TagKey, ItemStack> tagRecipeConsumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoAItems.IVORY.get(), 8)).ingredients((TagKey<Item>)input).output((ItemStack)output);
        tagRecipeConsumer.accept(Tags.Items.GEMS_AMETHYST, new ItemStack((ItemLike)AoABlocks.NATURAL_AMETHYST_IVORY.get(), 4));
        tagRecipeConsumer.accept(AoATags.Items.GEMS_JADE, new ItemStack((ItemLike)AoABlocks.NATURAL_JADE_IVORY.get(), 4));
        tagRecipeConsumer.accept(AoATags.Items.INGOTS_LIMONITE, new ItemStack((ItemLike)AoABlocks.NATURAL_LIMONITE_IVORY.get(), 4));
        tagRecipeConsumer.accept(Tags.Items.DUSTS_REDSTONE, new ItemStack((ItemLike)AoABlocks.NATURAL_REDSTONE_IVORY.get(), 4));
        tagRecipeConsumer.accept(Tags.Items.GEMS_LAPIS, new ItemStack((ItemLike)AoABlocks.NATURAL_LAPIS_IVORY.get(), 4));
        BiConsumer<Block, ItemStack> consumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("X  ", " X ", "  X").ingredient('X', (ItemLike)input).output((ItemStack)output);
        consumer.accept((Block)AoABlocks.NATURAL_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_IVORY.get(), 3));
        consumer.accept((Block)AoABlocks.NATURAL_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_AMETHYST_IVORY.get(), 3));
        consumer.accept((Block)AoABlocks.NATURAL_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_JADE_IVORY.get(), 3));
        consumer.accept((Block)AoABlocks.NATURAL_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_LIMONITE_IVORY.get(), 3));
        consumer.accept((Block)AoABlocks.NATURAL_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_REDSTONE_IVORY.get(), 3));
        consumer.accept((Block)AoABlocks.NATURAL_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_LAPIS_IVORY.get(), 3));
        consumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("X X", "   ", "X X").ingredient('X', (ItemLike)input).output((ItemStack)output);
        consumer.accept((Block)AoABlocks.PATTERNED_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_IVORY.get(), 4));
        consumer.accept((Block)AoABlocks.PATTERNED_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_AMETHYST_IVORY.get(), 4));
        consumer.accept((Block)AoABlocks.PATTERNED_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_JADE_IVORY.get(), 4));
        consumer.accept((Block)AoABlocks.PATTERNED_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_LIMONITE_IVORY.get(), 4));
        consumer.accept((Block)AoABlocks.PATTERNED_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_REDSTONE_IVORY.get(), 4));
        consumer.accept((Block)AoABlocks.PATTERNED_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_LAPIS_IVORY.get(), 4));
        consumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("X X", " X ", "X X").ingredient('X', (ItemLike)input).output((ItemStack)output);
        consumer.accept((Block)AoABlocks.ORNATE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_IVORY.get(), 5));
        consumer.accept((Block)AoABlocks.ORNATE_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_AMETHYST_IVORY.get(), 5));
        consumer.accept((Block)AoABlocks.ORNATE_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_JADE_IVORY.get(), 5));
        consumer.accept((Block)AoABlocks.ORNATE_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_LIMONITE_IVORY.get(), 5));
        consumer.accept((Block)AoABlocks.ORNATE_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_REDSTONE_IVORY.get(), 5));
        consumer.accept((Block)AoABlocks.ORNATE_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_LAPIS_IVORY.get(), 5));
    }

    private static void registerLogRecipes() {
        BiConsumer<String, ItemLike[]> consumer = (name, blocks) -> {
            new RecipeBuilder(name + "_planks", RecipeBuilder.Type.SHAPELESS).ingredients(blocks[0]).output(new ItemStack(blocks[1], 4));
            new RecipeBuilder(name + "_planks_from_stripped_log", RecipeBuilder.Type.SHAPELESS).ingredients(blocks[2]).output(new ItemStack(blocks[1], 4));
            new RecipeBuilder(name + "_planks_from_stripped_wood", RecipeBuilder.Type.SHAPELESS).ingredients(blocks[3]).output(new ItemStack(blocks[1], 4));
            new RecipeBuilder(name + "_planks_from_wood", RecipeBuilder.Type.SHAPELESS).ingredients(blocks[4]).output(new ItemStack(blocks[1], 4));
            new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("XX", "XX").ingredient('X', blocks[2]).output(new ItemStack(blocks[3], 3));
            new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("XX", "XX").ingredient('X', blocks[0]).output(new ItemStack(blocks[4], 3));
            new RecipeBuilder(name + "_log", RecipeBuilder.Type.SMELTING).ingredients(blocks[0]).output(new ItemStack((ItemLike)Items.f_42414_, 1)).xp(0.15f);
            new RecipeBuilder("stripped_" + name + "_log", RecipeBuilder.Type.SMELTING).ingredients(blocks[2]).output(new ItemStack((ItemLike)Items.f_42414_, 1)).xp(0.15f);
            new RecipeBuilder("stripped_" + name + "_wood", RecipeBuilder.Type.SMELTING).ingredients(blocks[3]).output(new ItemStack((ItemLike)Items.f_42414_, 1)).xp(0.15f);
            new RecipeBuilder(name + "_wood", RecipeBuilder.Type.SMELTING).ingredients(blocks[4]).output(new ItemStack((ItemLike)Items.f_42414_, 1)).xp(0.15f);
        };
        consumer.accept("achony", new ItemLike[]{(ItemLike)AoABlocks.ACHONY_LOG.get(), (ItemLike)AoABlocks.ACHONY_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_ACHONY_LOG.get(), (ItemLike)AoABlocks.STRIPPED_ACHONY_WOOD.get(), (ItemLike)AoABlocks.ACHONY_WOOD.get()});
        consumer.accept("blood", new ItemLike[]{(ItemLike)AoABlocks.BLOOD_LOG.get(), (ItemLike)AoABlocks.BLOODWOOD_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_BLOOD_LOG.get(), (ItemLike)AoABlocks.STRIPPED_BLOOD_WOOD.get(), (ItemLike)AoABlocks.BLOOD_WOOD.get()});
        consumer.accept("churry", new ItemLike[]{(ItemLike)AoABlocks.CHURRY_LOG.get(), (ItemLike)AoABlocks.CHURRY_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_CHURRY_LOG.get(), (ItemLike)AoABlocks.STRIPPED_CHURRY_WOOD.get(), (ItemLike)AoABlocks.CHURRY_WOOD.get()});
        consumer.accept("creep", new ItemLike[]{(ItemLike)AoABlocks.CREEP_LOG.get(), (ItemLike)AoABlocks.CREEP_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_CREEP_LOG.get(), (ItemLike)AoABlocks.STRIPPED_CREEP_WOOD.get(), (ItemLike)AoABlocks.CREEP_WOOD.get()});
        consumer.accept("dawn", new ItemLike[]{(ItemLike)AoABlocks.DAWN_LOG.get(), (ItemLike)AoABlocks.DAWNWOOD_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_DAWN_LOG.get(), (ItemLike)AoABlocks.STRIPPED_DAWN_WOOD.get(), (ItemLike)AoABlocks.DAWN_WOOD.get()});
        consumer.accept("haunted", new ItemLike[]{(ItemLike)AoABlocks.HAUNTED_LOG.get(), (ItemLike)AoABlocks.HAUNTEDWOOD_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_HAUNTED_LOG.get(), (ItemLike)AoABlocks.STRIPPED_HAUNTED_WOOD.get(), (ItemLike)AoABlocks.HAUNTED_WOOD.get()});
        consumer.accept("iro", new ItemLike[]{(ItemLike)AoABlocks.IROLOG.get(), (ItemLike)AoABlocks.IROWOOD_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_IROLOG.get(), (ItemLike)AoABlocks.STRIPPED_IROWOOD.get(), (ItemLike)AoABlocks.IROWOOD.get()});
        consumer.accept("lucalus", new ItemLike[]{(ItemLike)AoABlocks.LUCALUS_LOG.get(), (ItemLike)AoABlocks.LUCALUS_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_LUCALUS_LOG.get(), (ItemLike)AoABlocks.STRIPPED_LUCALUS_WOOD.get(), (ItemLike)AoABlocks.LUCALUS_WOOD.get()});
        consumer.accept("lunide", new ItemLike[]{(ItemLike)AoABlocks.LUNIDE_LOG.get(), (ItemLike)AoABlocks.LUNIDE_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_LUNIDE_LOG.get(), (ItemLike)AoABlocks.STRIPPED_LUNIDE_WOOD.get(), (ItemLike)AoABlocks.LUNIDE_WOOD.get()});
        consumer.accept("runic", new ItemLike[]{(ItemLike)AoABlocks.RUNIC_LOG.get(), (ItemLike)AoABlocks.RUNIC_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_RUNIC_LOG.get(), (ItemLike)AoABlocks.STRIPPED_RUNIC_WOOD.get(), (ItemLike)AoABlocks.RUNIC_WOOD.get()});
        consumer.accept("shadow", new ItemLike[]{(ItemLike)AoABlocks.SHADOW_LOG.get(), (ItemLike)AoABlocks.SHADOW_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_SHADOW_LOG.get(), (ItemLike)AoABlocks.STRIPPED_SHADOW_WOOD.get(), (ItemLike)AoABlocks.SHADOW_WOOD.get()});
        consumer.accept("shyre", new ItemLike[]{(ItemLike)AoABlocks.SHYRE_LOG.get(), (ItemLike)AoABlocks.SHYRE_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_SHYRE_LOG.get(), (ItemLike)AoABlocks.STRIPPED_SHYRE_WOOD.get(), (ItemLike)AoABlocks.SHYRE_WOOD.get()});
        consumer.accept("stranglewood", new ItemLike[]{(ItemLike)AoABlocks.STRANGLEWOOD_LOG.get(), (ItemLike)AoABlocks.STRANGLEWOOD_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_STRANGLEWOOD_LOG.get(), (ItemLike)AoABlocks.STRIPPED_STRANGLEWOOD.get(), (ItemLike)AoABlocks.STRANGLEWOOD.get()});
        consumer.accept("toxic", new ItemLike[]{(ItemLike)AoABlocks.TOXIC_LOG.get(), (ItemLike)AoABlocks.TOXICWOOD_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_TOXIC_LOG.get(), (ItemLike)AoABlocks.STRIPPED_TOXIC_WOOD.get(), (ItemLike)AoABlocks.TOXIC_WOOD.get()});
        consumer.accept("eyeball", new ItemLike[]{(ItemLike)AoABlocks.EYEBALL_LOG.get(), (ItemLike)AoABlocks.BLOODWOOD_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_EYEBALL_LOG.get(), (ItemLike)AoABlocks.STRIPPED_EYEBALL_WOOD.get(), (ItemLike)AoABlocks.EYEBALL_WOOD.get()});
        consumer.accept("haunted_eye", new ItemLike[]{(ItemLike)AoABlocks.HAUNTED_EYE_LOG.get(), (ItemLike)AoABlocks.HAUNTEDWOOD_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_HAUNTED_EYE_LOG.get(), (ItemLike)AoABlocks.STRIPPED_HAUNTED_EYE_WOOD.get(), (ItemLike)AoABlocks.HAUNTED_EYE_WOOD.get()});
        consumer.accept("haunted_eyes", new ItemLike[]{(ItemLike)AoABlocks.HAUNTED_EYES_LOG.get(), (ItemLike)AoABlocks.HAUNTEDWOOD_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_HAUNTED_EYES_LOG.get(), (ItemLike)AoABlocks.STRIPPED_HAUNTED_EYES_WOOD.get(), (ItemLike)AoABlocks.HAUNTED_EYES_WOOD.get()});
        consumer.accept("haunted_flashing", new ItemLike[]{(ItemLike)AoABlocks.HAUNTED_FLASHING_LOG.get(), (ItemLike)AoABlocks.HAUNTEDWOOD_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_HAUNTED_FLASHING_LOG.get(), (ItemLike)AoABlocks.STRIPPED_HAUNTED_FLASHING_WOOD.get(), (ItemLike)AoABlocks.HAUNTED_FLASHING_WOOD.get()});
        consumer.accept("haunted_purpling", new ItemLike[]{(ItemLike)AoABlocks.HAUNTED_PURPLING_LOG.get(), (ItemLike)AoABlocks.HAUNTEDWOOD_PLANKS.get(), (ItemLike)AoABlocks.STRIPPED_HAUNTED_PURPLING_LOG.get(), (ItemLike)AoABlocks.STRIPPED_HAUNTED_PURPLING_WOOD.get(), (ItemLike)AoABlocks.HAUNTED_PURPLING_WOOD.get()});
    }

    private static void registerSlabRecipes() {
        BiConsumer<ItemLike, ItemStack> consumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA").ingredient('A', (ItemLike)input).output((ItemStack)output);
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_SMALL.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_SMALL_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_NODE.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_NODE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_STREAM.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_STREAM_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ABYSSAL_STONE.get(), new ItemStack((ItemLike)AoABlocks.ABYSSAL_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ACHONY_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.ACHONY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.AROMATIC_STONE.get(), new ItemStack((ItemLike)AoABlocks.AROMATIC_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BARON_STONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.BARON_STONE_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BARON_STONE.get(), new ItemStack((ItemLike)AoABlocks.BARON_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BARON_TILES.get(), new ItemStack((ItemLike)AoABlocks.BARON_TILE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BLACK_MYSTERIUM_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.BLACK_MYSTERIUM_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BLOODSTONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.BLOODSTONE_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BLOODWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.BLOODWOOD_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BRIGHT_ROCK.get(), new ItemStack((ItemLike)AoABlocks.BRIGHT_ROCK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CHURRY_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.CHURRY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CORAL_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CORAL_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CORAL_ROCK.get(), new ItemStack((ItemLike)AoABlocks.CORAL_ROCK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CREEPONIA_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CREEPONIA_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CREEP_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.CREEP_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CREEP_STONE.get(), new ItemStack((ItemLike)AoABlocks.CREEP_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CRYSTALLISED_ROCK.get(), new ItemStack((ItemLike)AoABlocks.CRYSTALLISED_ROCK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CRYSTALLITE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CRYSTALLITE_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CRYSTEVIA_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CRYSTEVIA_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.DARKENED_ROCK.get(), new ItemStack((ItemLike)AoABlocks.DARKENED_ROCK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.DARKWASH_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.DARKWASH_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.DARK_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.DARK_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.DAWNWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.DAWNWOOD_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.DENSE_STONE.get(), new ItemStack((ItemLike)AoABlocks.DENSE_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.FUNGAL_ROCK.get(), new ItemStack((ItemLike)AoABlocks.FUNGAL_ROCK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.GARDENCIA_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.GARDENCIA_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.GRECKON_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.GRECKON_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.GRECKON_STONE.get(), new ItemStack((ItemLike)AoABlocks.GRECKON_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.GREEN_MYSTERIUM_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.GREEN_MYSTERIUM_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.HAUNTEDWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.HAUNTEDWOOD_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.HAUNTED_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.HAUNTED_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.HELLSTONE.get(), new ItemStack((ItemLike)AoABlocks.HELLSTONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.HELLSTONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.HELLSTONE_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_AMETHYST_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_JADE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_LIMONITE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_REDSTONE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_LAPIS_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.IROSTONE.get(), new ItemStack((ItemLike)AoABlocks.IROSTONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.IROWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.IROWOOD_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.IRO_DOTTED_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.IRO_DOTTED_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.IRO_STRIPED_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.IRO_STRIPED_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.LELYETIAN_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.LELYETIAN_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.LELYETIAN_STONE.get(), new ItemStack((ItemLike)AoABlocks.LELYETIAN_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.LUCALUS_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.LUCALUS_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.LUNAR_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.LUNAR_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.LUNIDE_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.LUNIDE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_AMETHYST_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_JADE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_LIMONITE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_REDSTONE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_LAPIS_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_AMETHYST_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_JADE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_LIMONITE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_REDSTONE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_LAPIS_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_AMETHYST_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_JADE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_LIMONITE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_REDSTONE_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_LAPIS_IVORY_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.POLLUTED_STONE.get(), new ItemStack((ItemLike)AoABlocks.POLLUTED_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PRECASIAN_LOWER_ROCK.get(), new ItemStack((ItemLike)AoABlocks.PRECASIAN_LOWER_ROCK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PRECASIAN_SURFACE_ROCK.get(), new ItemStack((ItemLike)AoABlocks.PRECASIAN_SURFACE_ROCK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PRESSED_CREEP_STONE.get(), new ItemStack((ItemLike)AoABlocks.PRESSED_CREEP_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PRIMED_STONE.get(), new ItemStack((ItemLike)AoABlocks.PRIMED_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ROSIDIAN_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.ROSIDIAN_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.RUNIC_STONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CHISELLED_RUNIC_STONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CHISELLED_RUNIC_STONE_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.RUNIC_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.RUNIC_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.RUNIC_STONE.get(), new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.SHADOW_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.SHADOW_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.SHYRE_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.SHYRE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.SKELETAL_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.SKELETAL_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.STRANGLEWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.STRANGLEWOOD_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.TOXICWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.TOXICWOOD_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.WEIGHTLESS_STONE.get(), new ItemStack((ItemLike)AoABlocks.WEIGHTLESS_STONE_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.WHITEWASH_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.WHITE_SHYRE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.WHITE_SHYRE_BRICK_SLAB.get(), 6));
        consumer.accept((ItemLike)AoABlocks.YELLOW_SHYRE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.YELLOW_SHYRE_BRICK_SLAB.get(), 6));
    }

    private static void registerStoneCutterRecipes() {
        BiConsumer<ItemLike, List> stoneConsumer = (input, output) -> {
            new RecipeBuilder(RecipeBuilder.Type.STONECUTTING).ingredients((ItemLike)input).output((ItemStack)output.get(0));
            new RecipeBuilder(RecipeBuilder.Type.STONECUTTING).ingredients((ItemLike)input).output((ItemStack)output.get(1));
            new RecipeBuilder(RecipeBuilder.Type.STONECUTTING).ingredients((ItemLike)input).output((ItemStack)output.get(2));
        };
        stoneConsumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_SMALL.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_SMALL_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_SMALL_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_SMALL_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_NODE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_NODE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_NODE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_NODE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_STREAM.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_STREAM_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_STREAM_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_STREAM_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.ABYSSAL_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ABYSSAL_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ABYSSAL_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ABYSSAL_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.AROMATIC_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.AROMATIC_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.AROMATIC_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.AROMATIC_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.BARON_STONE_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.BARON_STONE_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.BARON_STONE_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.BARON_STONE_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.BARON_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.BARON_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.BARON_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.BARON_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.BARON_TILES.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.BARON_TILE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.BARON_TILE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.BARON_TILE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.BLACK_MYSTERIUM_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.BLACK_MYSTERIUM_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.BLACK_MYSTERIUM_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.BLACK_MYSTERIUM_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.BLOODSTONE_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.BLOODSTONE_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.BLOODSTONE_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.BLOODSTONE_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.BRIGHT_ROCK.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.BRIGHT_ROCK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.BRIGHT_ROCK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.BRIGHT_ROCK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.CORAL_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.CORAL_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.CORAL_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.CORAL_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.CORAL_ROCK.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.CORAL_ROCK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.CORAL_ROCK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.CORAL_ROCK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.CREEPONIA_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.CREEPONIA_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.CREEPONIA_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.CREEPONIA_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.CREEP_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.CREEP_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.CREEP_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.CREEP_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.CRYSTALLISED_ROCK.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.CRYSTALLISED_ROCK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.CRYSTALLISED_ROCK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.CRYSTALLISED_ROCK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.CRYSTALLITE_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.CRYSTALLITE_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.CRYSTALLITE_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.CRYSTALLITE_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.CRYSTEVIA_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.CRYSTEVIA_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.CRYSTEVIA_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.CRYSTEVIA_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.DARKENED_ROCK.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.DARKENED_ROCK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.DARKENED_ROCK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.DARKENED_ROCK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.DARKWASH_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.DARKWASH_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.DARKWASH_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.DARKWASH_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.DARK_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.DARK_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.DARK_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.DARK_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.DENSE_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.DENSE_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.DENSE_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.DENSE_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.FUNGAL_ROCK.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.FUNGAL_ROCK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.FUNGAL_ROCK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.FUNGAL_ROCK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.GARDENCIA_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.GARDENCIA_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.GARDENCIA_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.GARDENCIA_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.GRECKON_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.GRECKON_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.GRECKON_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.GRECKON_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.GRECKON_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.GRECKON_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.GRECKON_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.GRECKON_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.GREEN_MYSTERIUM_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.GREEN_MYSTERIUM_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.GREEN_MYSTERIUM_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.GREEN_MYSTERIUM_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.HAUNTED_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.HAUNTED_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.HAUNTED_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.HAUNTED_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.HELLSTONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.HELLSTONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.HELLSTONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.HELLSTONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.HELLSTONE_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.HELLSTONE_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.HELLSTONE_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.HELLSTONE_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.INTRICATE_AMETHYST_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.INTRICATE_AMETHYST_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.INTRICATE_AMETHYST_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.INTRICATE_AMETHYST_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.INTRICATE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.INTRICATE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.INTRICATE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.INTRICATE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.INTRICATE_JADE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.INTRICATE_JADE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.INTRICATE_JADE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.INTRICATE_JADE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.INTRICATE_LIMONITE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.INTRICATE_LIMONITE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.INTRICATE_LIMONITE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.INTRICATE_LIMONITE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.INTRICATE_REDSTONE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.INTRICATE_REDSTONE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.INTRICATE_REDSTONE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.INTRICATE_REDSTONE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.INTRICATE_LAPIS_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.INTRICATE_LAPIS_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.INTRICATE_LAPIS_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.INTRICATE_LAPIS_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.IROSTONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.IROSTONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.IROSTONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.IROSTONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.IRO_DOTTED_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.IRO_DOTTED_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.IRO_DOTTED_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.IRO_DOTTED_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.IRO_STRIPED_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.IRO_STRIPED_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.IRO_STRIPED_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.IRO_STRIPED_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.LELYETIAN_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.LELYETIAN_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.LELYETIAN_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.LELYETIAN_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.LELYETIAN_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.LELYETIAN_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.LELYETIAN_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.LELYETIAN_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.LUNAR_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.LUNAR_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.LUNAR_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.LUNAR_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.NATURAL_AMETHYST_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.NATURAL_AMETHYST_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.NATURAL_AMETHYST_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.NATURAL_AMETHYST_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.NATURAL_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.NATURAL_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.NATURAL_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.NATURAL_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.NATURAL_JADE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.NATURAL_JADE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.NATURAL_JADE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.NATURAL_JADE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.NATURAL_LIMONITE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.NATURAL_LIMONITE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.NATURAL_LIMONITE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.NATURAL_LIMONITE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.NATURAL_REDSTONE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.NATURAL_REDSTONE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.NATURAL_REDSTONE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.NATURAL_REDSTONE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.NATURAL_LAPIS_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.NATURAL_LAPIS_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.NATURAL_LAPIS_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.NATURAL_LAPIS_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.ORNATE_AMETHYST_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ORNATE_AMETHYST_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ORNATE_AMETHYST_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ORNATE_AMETHYST_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.ORNATE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ORNATE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ORNATE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ORNATE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.ORNATE_JADE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ORNATE_JADE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ORNATE_JADE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ORNATE_JADE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.ORNATE_LIMONITE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ORNATE_LIMONITE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ORNATE_LIMONITE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ORNATE_LIMONITE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.ORNATE_REDSTONE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ORNATE_REDSTONE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ORNATE_REDSTONE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ORNATE_REDSTONE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.ORNATE_LAPIS_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ORNATE_LAPIS_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ORNATE_LAPIS_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ORNATE_LAPIS_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.PATTERNED_AMETHYST_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.PATTERNED_AMETHYST_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.PATTERNED_AMETHYST_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.PATTERNED_AMETHYST_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.PATTERNED_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.PATTERNED_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.PATTERNED_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.PATTERNED_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.PATTERNED_JADE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.PATTERNED_JADE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.PATTERNED_JADE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.PATTERNED_JADE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.PATTERNED_LIMONITE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.PATTERNED_LIMONITE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.PATTERNED_LIMONITE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.PATTERNED_LIMONITE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.PATTERNED_REDSTONE_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.PATTERNED_REDSTONE_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.PATTERNED_REDSTONE_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.PATTERNED_REDSTONE_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.PATTERNED_LAPIS_IVORY.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.PATTERNED_LAPIS_IVORY_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.PATTERNED_LAPIS_IVORY_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.PATTERNED_LAPIS_IVORY_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.POLLUTED_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.POLLUTED_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.POLLUTED_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.POLLUTED_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.PRECASIAN_LOWER_ROCK.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.PRECASIAN_LOWER_ROCK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.PRECASIAN_LOWER_ROCK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.PRECASIAN_LOWER_ROCK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.PRECASIAN_SURFACE_ROCK.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.PRECASIAN_SURFACE_ROCK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.PRECASIAN_SURFACE_ROCK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.PRECASIAN_SURFACE_ROCK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.PRESSED_CREEP_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.PRESSED_CREEP_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.PRESSED_CREEP_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.PRESSED_CREEP_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.PRIMED_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.PRIMED_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.PRIMED_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.PRIMED_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.ROSIDIAN_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.ROSIDIAN_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.ROSIDIAN_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.ROSIDIAN_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.RUNIC_STONE_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.CHISELLED_RUNIC_STONE_BRICKS.get()), new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.CHISELLED_RUNIC_STONE_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.CHISELLED_RUNIC_STONE_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.CHISELLED_RUNIC_STONE_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.CHISELLED_RUNIC_STONE_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.RUNIC_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.SKELETAL_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.SKELETAL_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.SKELETAL_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.SKELETAL_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.WEIGHTLESS_STONE.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.WEIGHTLESS_STONE_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.WEIGHTLESS_STONE_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.WEIGHTLESS_STONE_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.WHITEWASH_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.WHITE_SHYRE_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.WHITE_SHYRE_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.WHITE_SHYRE_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.WHITE_SHYRE_BRICK_WALL.get())));
        stoneConsumer.accept((ItemLike)AoABlocks.YELLOW_SHYRE_BRICKS.get(), Arrays.asList(new ItemStack((ItemLike)AoABlocks.YELLOW_SHYRE_BRICK_SLAB.get(), 2), new ItemStack((ItemLike)AoABlocks.YELLOW_SHYRE_BRICK_STAIRS.get()), new ItemStack((ItemLike)AoABlocks.YELLOW_SHYRE_BRICK_WALL.get())));
    }

    private static void registerPlankRecipes() {
        BiConsumer<ItemLike, ItemLike[]> consumer = (planks, items) -> {
            new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("XX").ingredient('X', (ItemLike)planks).output(new ItemStack(items[0]));
            new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients((ItemLike)planks).output(new ItemStack(items[1]));
        };
        consumer.accept((ItemLike)AoABlocks.ACHONY_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.ACHONY_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.ACHONY_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.BLOODWOOD_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.BLOODWOOD_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.BLOODWOOD_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.CHURRY_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.CHURRY_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.CHURRY_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.CREEP_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.CREEP_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.CREEP_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.DAWNWOOD_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.DAWNWOOD_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.DAWNWOOD_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.HAUNTEDWOOD_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.HAUNTEDWOOD_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.HAUNTEDWOOD_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.IROWOOD_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.IROWOOD_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.IROWOOD_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.LUCALUS_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.LUCALUS_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.LUCALUS_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.LUNIDE_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.LUNIDE_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.LUNIDE_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.RUNIC_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.RUNIC_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.RUNIC_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.SHADOW_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.SHADOW_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.SHADOW_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.SHYRE_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.SHYRE_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.SHYRE_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.STRANGLEWOOD_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.STRANGLEWOOD_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.STRANGLEWOOD_BUTTON.get()});
        consumer.accept((ItemLike)AoABlocks.TOXICWOOD_PLANKS.get(), new ItemLike[]{(ItemLike)AoABlocks.TOXICWOOD_PRESSURE_PLATE.get(), (ItemLike)AoABlocks.TOXICWOOD_BUTTON.get()});
    }

    private static void registerStairsRecipes() {
        BiConsumer<ItemLike, ItemStack> consumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("A  ", "AA ", "AAA").ingredient('A', (ItemLike)input).output((ItemStack)output);
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_SMALL.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_SMALL_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_NODE.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_NODE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_STREAM.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_STREAM_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ABYSSAL_STONE.get(), new ItemStack((ItemLike)AoABlocks.ABYSSAL_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ACHONY_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.ACHONY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.AROMATIC_STONE.get(), new ItemStack((ItemLike)AoABlocks.AROMATIC_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.BARON_STONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.BARON_STONE_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.BARON_STONE.get(), new ItemStack((ItemLike)AoABlocks.BARON_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.BARON_TILES.get(), new ItemStack((ItemLike)AoABlocks.BARON_TILE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.BLACK_MYSTERIUM_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.BLACK_MYSTERIUM_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.BLOODSTONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.BLOODSTONE_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.BLOODWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.BLOODWOOD_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.BRIGHT_ROCK.get(), new ItemStack((ItemLike)AoABlocks.BRIGHT_ROCK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.CHURRY_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.CHURRY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.CORAL_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CORAL_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.CORAL_ROCK.get(), new ItemStack((ItemLike)AoABlocks.CORAL_ROCK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.CREEPONIA_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CREEPONIA_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.CREEP_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.CREEP_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.CREEP_STONE.get(), new ItemStack((ItemLike)AoABlocks.CREEP_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.CRYSTALLISED_ROCK.get(), new ItemStack((ItemLike)AoABlocks.CRYSTALLISED_ROCK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.CRYSTALLITE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CRYSTALLITE_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.CRYSTEVIA_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CRYSTEVIA_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.DARKENED_ROCK.get(), new ItemStack((ItemLike)AoABlocks.DARKENED_ROCK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.DARKWASH_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.DARKWASH_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.DARK_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.DARK_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.DAWNWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.DAWNWOOD_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.DENSE_STONE.get(), new ItemStack((ItemLike)AoABlocks.DENSE_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.FUNGAL_ROCK.get(), new ItemStack((ItemLike)AoABlocks.FUNGAL_ROCK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.GARDENCIA_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.GARDENCIA_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.GRECKON_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.GRECKON_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.GRECKON_STONE.get(), new ItemStack((ItemLike)AoABlocks.GRECKON_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.GREEN_MYSTERIUM_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.GREEN_MYSTERIUM_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.HAUNTEDWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.HAUNTEDWOOD_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.HAUNTED_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.HAUNTED_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.HELLSTONE.get(), new ItemStack((ItemLike)AoABlocks.HELLSTONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.HELLSTONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.HELLSTONE_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_AMETHYST_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_JADE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_LIMONITE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_REDSTONE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_LAPIS_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.IROSTONE.get(), new ItemStack((ItemLike)AoABlocks.IROSTONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.IROWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.IROWOOD_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.IRO_DOTTED_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.IRO_DOTTED_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.IRO_STRIPED_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.IRO_STRIPED_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.LELYETIAN_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.LELYETIAN_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.LELYETIAN_STONE.get(), new ItemStack((ItemLike)AoABlocks.LELYETIAN_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.LUCALUS_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.LUCALUS_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.LUNAR_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.LUNAR_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.LUNIDE_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.LUNIDE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.NATURAL_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_AMETHYST_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.NATURAL_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.NATURAL_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_JADE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.NATURAL_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_LIMONITE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.NATURAL_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_REDSTONE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.NATURAL_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_LAPIS_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ORNATE_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_AMETHYST_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ORNATE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ORNATE_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_JADE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ORNATE_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_LIMONITE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ORNATE_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_REDSTONE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ORNATE_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_LAPIS_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_AMETHYST_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_JADE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_LIMONITE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_REDSTONE_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_LAPIS_IVORY_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.POLLUTED_STONE.get(), new ItemStack((ItemLike)AoABlocks.POLLUTED_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.PRECASIAN_LOWER_ROCK.get(), new ItemStack((ItemLike)AoABlocks.PRECASIAN_LOWER_ROCK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.PRECASIAN_SURFACE_ROCK.get(), new ItemStack((ItemLike)AoABlocks.PRECASIAN_SURFACE_ROCK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.PRESSED_CREEP_STONE.get(), new ItemStack((ItemLike)AoABlocks.PRESSED_CREEP_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.PRIMED_STONE.get(), new ItemStack((ItemLike)AoABlocks.PRIMED_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.ROSIDIAN_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.ROSIDIAN_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.RUNIC_STONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.CHISELLED_RUNIC_STONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CHISELLED_RUNIC_STONE_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.RUNIC_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.RUNIC_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.RUNIC_STONE.get(), new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.SHADOW_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.SHADOW_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.SHYRE_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.SHYRE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.SKELETAL_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.SKELETAL_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.STRANGLEWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.STRANGLEWOOD_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.TOXICWOOD_PLANKS.get(), new ItemStack((ItemLike)AoABlocks.TOXICWOOD_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.WEIGHTLESS_STONE.get(), new ItemStack((ItemLike)AoABlocks.WEIGHTLESS_STONE_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.WHITEWASH_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.WHITE_SHYRE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.WHITE_SHYRE_BRICK_STAIRS.get(), 4));
        consumer.accept((ItemLike)AoABlocks.YELLOW_SHYRE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.YELLOW_SHYRE_BRICK_STAIRS.get(), 4));
    }

    private static void registerLampRecipes() {
        BiConsumer<TagKey, ItemStack> lampRecipeConsumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" R ", "RXR", " R ").ingredient('R', (TagKey<Item>)Tags.Items.DUSTS_REDSTONE).ingredient('X', (TagKey<Item>)input).output((ItemStack)output);
        lampRecipeConsumer.accept(Tags.Items.GEMS_AMETHYST, new ItemStack((ItemLike)AoABlocks.AMETHYST_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.INGOTS_BARONYTE, new ItemStack((ItemLike)AoABlocks.BARONYTE_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.INGOTS_BLAZIUM, new ItemStack((ItemLike)AoABlocks.BLAZIUM_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.GEMS_BLOODSTONE, new ItemStack((ItemLike)AoABlocks.BLOODSTONE_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.GEMS_CRYSTALLITE, new ItemStack((ItemLike)AoABlocks.CRYSTALLITE_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.INGOTS_ELECANIUM, new ItemStack((ItemLike)AoABlocks.ELECANIUM_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.INGOTS_EMBERSTONE, new ItemStack((ItemLike)AoABlocks.EMBERSTONE_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.INGOTS_GHASTLY, new ItemStack((ItemLike)AoABlocks.GHASTLY_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.INGOTS_GHOULISH, new ItemStack((ItemLike)AoABlocks.GHOULISH_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.IVORY, new ItemStack((ItemLike)AoABlocks.IVORY_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.GEMS_JADE, new ItemStack((ItemLike)AoABlocks.JADE_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.INGOTS_LIMONITE, new ItemStack((ItemLike)AoABlocks.LIMONITE_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.INGOTS_LYON, new ItemStack((ItemLike)AoABlocks.LYON_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.INGOTS_MYSTITE, new ItemStack((ItemLike)AoABlocks.MYSTIC_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.GEMS_LAPIS, new ItemStack((ItemLike)AoABlocks.LAPIS_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.INGOTS_SKELETAL, new ItemStack((ItemLike)AoABlocks.SKELETAL_LAMP.get()));
        lampRecipeConsumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" Q ", "RXR", " R ").ingredient('R', (TagKey<Item>)Tags.Items.DUSTS_REDSTONE).ingredient('X', (TagKey<Item>)input).ingredient('Q', (TagKey<Item>)Tags.Items.GEMS_QUARTZ).output((ItemStack)output);
        lampRecipeConsumer.accept(Tags.Items.DYES_LIGHT_BLUE, new ItemStack((ItemLike)AoABlocks.AQUA_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_BLACK, new ItemStack((ItemLike)AoABlocks.BLACK_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_BLUE, new ItemStack((ItemLike)AoABlocks.BLUE_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_BROWN, new ItemStack((ItemLike)AoABlocks.BROWN_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_CYAN, new ItemStack((ItemLike)AoABlocks.CYAN_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_GRAY, new ItemStack((ItemLike)AoABlocks.DARK_GREY_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_GREEN, new ItemStack((ItemLike)AoABlocks.GREEN_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_LIGHT_GRAY, new ItemStack((ItemLike)AoABlocks.GREY_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_LIME, new ItemStack((ItemLike)AoABlocks.LIME_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_MAGENTA, new ItemStack((ItemLike)AoABlocks.MAGENTA_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_ORANGE, new ItemStack((ItemLike)AoABlocks.ORANGE_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_PINK, new ItemStack((ItemLike)AoABlocks.PINK_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_PURPLE, new ItemStack((ItemLike)AoABlocks.PURPLE_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_RED, new ItemStack((ItemLike)AoABlocks.RED_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_WHITE, new ItemStack((ItemLike)AoABlocks.WHITE_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DYES_YELLOW, new ItemStack((ItemLike)AoABlocks.YELLOW_STAINED_GLASS_LAMP.get()));
        lampRecipeConsumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape(" I ", "RXR", " R ").ingredient('R', (TagKey<Item>)Tags.Items.DUSTS_REDSTONE).ingredient('X', (TagKey<Item>)input).ingredient('I', AoATags.Items.IVORY).output((ItemStack)output);
        lampRecipeConsumer.accept(Tags.Items.GEMS_AMETHYST, new ItemStack((ItemLike)AoABlocks.IVORY_AMETHYST_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.GEMS_JADE, new ItemStack((ItemLike)AoABlocks.IVORY_JADE_LAMP.get()));
        lampRecipeConsumer.accept(AoATags.Items.INGOTS_LIMONITE, new ItemStack((ItemLike)AoABlocks.IVORY_LIMONITE_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.DUSTS_REDSTONE, new ItemStack((ItemLike)AoABlocks.IVORY_REDSTONE_LAMP.get()));
        lampRecipeConsumer.accept(Tags.Items.GEMS_LAPIS, new ItemStack((ItemLike)AoABlocks.IVORY_LAPIS_LAMP.get()));
    }

    private static void registerWallRecipes() {
        BiConsumer<ItemLike, ItemStack> consumer = (input, output) -> new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("XXX", "XXX").ingredient('X', (ItemLike)input).output((ItemStack)output);
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_SMALL.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_SMALL_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_NODE.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_NODE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ARCHAIC_TILE_STREAM.get(), new ItemStack((ItemLike)AoABlocks.ARCHAIC_TILE_STREAM_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ABYSSAL_STONE.get(), new ItemStack((ItemLike)AoABlocks.ABYSSAL_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.AROMATIC_STONE.get(), new ItemStack((ItemLike)AoABlocks.AROMATIC_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BARON_STONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.BARON_STONE_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BARON_STONE.get(), new ItemStack((ItemLike)AoABlocks.BARON_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BARON_TILES.get(), new ItemStack((ItemLike)AoABlocks.BARON_TILE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BLACK_MYSTERIUM_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.BLACK_MYSTERIUM_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BLOODSTONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.BLOODSTONE_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.BRIGHT_ROCK.get(), new ItemStack((ItemLike)AoABlocks.BRIGHT_ROCK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CORAL_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CORAL_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CORAL_ROCK.get(), new ItemStack((ItemLike)AoABlocks.CORAL_ROCK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CREEPONIA_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CREEPONIA_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CREEP_STONE.get(), new ItemStack((ItemLike)AoABlocks.CREEP_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CRYSTALLISED_ROCK.get(), new ItemStack((ItemLike)AoABlocks.CRYSTALLISED_ROCK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CRYSTALLITE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CRYSTALLITE_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CRYSTEVIA_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CRYSTEVIA_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.DARKENED_ROCK.get(), new ItemStack((ItemLike)AoABlocks.DARKENED_ROCK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.DARKWASH_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.DARKWASH_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.DARK_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.DARK_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.DENSE_STONE.get(), new ItemStack((ItemLike)AoABlocks.DENSE_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.FUNGAL_ROCK.get(), new ItemStack((ItemLike)AoABlocks.FUNGAL_ROCK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.GARDENCIA_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.GARDENCIA_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.GRECKON_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.GRECKON_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.GRECKON_STONE.get(), new ItemStack((ItemLike)AoABlocks.GRECKON_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.GREEN_MYSTERIUM_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.GREEN_MYSTERIUM_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.HAUNTED_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.HAUNTED_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.HELLSTONE.get(), new ItemStack((ItemLike)AoABlocks.HELLSTONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.HELLSTONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.HELLSTONE_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_AMETHYST_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_JADE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_LIMONITE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_REDSTONE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.INTRICATE_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.INTRICATE_LAPIS_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.IROSTONE.get(), new ItemStack((ItemLike)AoABlocks.IROSTONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.IRO_DOTTED_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.IRO_DOTTED_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.IRO_STRIPED_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.IRO_STRIPED_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.LELYETIAN_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.LELYETIAN_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.LELYETIAN_STONE.get(), new ItemStack((ItemLike)AoABlocks.LELYETIAN_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.LUNAR_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.LUNAR_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_AMETHYST_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_JADE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_LIMONITE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_REDSTONE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.NATURAL_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.NATURAL_LAPIS_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_AMETHYST_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_JADE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_LIMONITE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_REDSTONE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ORNATE_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.ORNATE_LAPIS_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_AMETHYST_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_AMETHYST_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_JADE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_JADE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_LIMONITE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_LIMONITE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_REDSTONE_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_REDSTONE_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PATTERNED_LAPIS_IVORY.get(), new ItemStack((ItemLike)AoABlocks.PATTERNED_LAPIS_IVORY_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.POLLUTED_STONE.get(), new ItemStack((ItemLike)AoABlocks.POLLUTED_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PRECASIAN_LOWER_ROCK.get(), new ItemStack((ItemLike)AoABlocks.PRECASIAN_LOWER_ROCK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PRECASIAN_SURFACE_ROCK.get(), new ItemStack((ItemLike)AoABlocks.PRECASIAN_SURFACE_ROCK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PRESSED_CREEP_STONE.get(), new ItemStack((ItemLike)AoABlocks.PRESSED_CREEP_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.PRIMED_STONE.get(), new ItemStack((ItemLike)AoABlocks.PRIMED_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.ROSIDIAN_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.ROSIDIAN_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.RUNIC_STONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.CHISELLED_RUNIC_STONE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.CHISELLED_RUNIC_STONE_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.RUNIC_STONE.get(), new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.SKELETAL_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.SKELETAL_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.WEIGHTLESS_STONE.get(), new ItemStack((ItemLike)AoABlocks.WEIGHTLESS_STONE_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.WHITEWASH_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.WHITE_SHYRE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.WHITE_SHYRE_BRICK_WALL.get(), 6));
        consumer.accept((ItemLike)AoABlocks.YELLOW_SHYRE_BRICKS.get(), new ItemStack((ItemLike)AoABlocks.YELLOW_SHYRE_BRICK_WALL.get(), 6));
    }

    private static void registerMiscBlockRecipes() {
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("BCB", "BAB", "BBB").ingredient('A', (ItemLike)AoABlocks.ANCIENT_ROCK.get()).ingredient('B', (ItemLike)AoAItems.UNPOWERED_RUNE.get()).ingredient('C', (ItemLike)Items.f_42545_).output(new ItemStack((ItemLike)AoABlocks.CARVED_RUNE_OF_POWER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABC", "BDB", "CBA").ingredient('A', (ItemLike)Items.f_42415_).ingredient('B', (ItemLike)Items.f_42451_).ingredient('C', (ItemLike)AoAItems.RUNIUM_CHUNK.get()).ingredient('D', (ItemLike)Blocks.f_50058_).output(new ItemStack((ItemLike)AoABlocks.DAMAGE_ENHANCER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABC", "BDB", "CBE").ingredient('A', (ItemLike)Items.f_42686_).ingredient('B', (ItemLike)Items.f_42451_).ingredient('C', (ItemLike)AoAItems.CHARGED_RUNIUM_CHUNK.get()).ingredient('D', (ItemLike)Blocks.f_50058_).ingredient('E', (ItemLike)Items.f_42586_).output(new ItemStack((ItemLike)AoABlocks.DIVINE_ENHANCER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABC", "BDB", "CBA").ingredient('A', (ItemLike)Items.f_42616_).ingredient('B', (ItemLike)Items.f_42451_).ingredient('C', (ItemLike)AoAItems.RUNIUM_CHUNK.get()).ingredient('D', (ItemLike)Blocks.f_50058_).output(new ItemStack((ItemLike)AoABlocks.DURABILITY_ENHANCER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABC", "BDB", "CBA").ingredient('A', (ItemLike)Items.f_42648_).ingredient('B', (ItemLike)Items.f_42451_).ingredient('C', (ItemLike)AoAItems.CHARGED_RUNIUM_CHUNK.get()).ingredient('D', (ItemLike)Blocks.f_50058_).output(new ItemStack((ItemLike)AoABlocks.LUCK_ENHANCER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABC", "BDB", "CBA").ingredient('A', (ItemLike)Items.f_42545_).ingredient('B', (ItemLike)Items.f_42451_).ingredient('C', (ItemLike)AoAItems.CHARGED_RUNIUM_CHUNK.get()).ingredient('D', (ItemLike)Blocks.f_50058_).output(new ItemStack((ItemLike)AoABlocks.MAGIC_ENHANCER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABC", "BDB", "CBA").ingredient('A', (ItemLike)Items.f_42416_).ingredient('B', (ItemLike)Items.f_42451_).ingredient('C', (ItemLike)AoAItems.RUNIUM_CHUNK.get()).ingredient('D', (ItemLike)Blocks.f_50058_).output(new ItemStack((ItemLike)AoABlocks.RESISTANCE_ENHANCER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABC", "BDB", "CBA").ingredient('A', (ItemLike)Items.f_42695_).ingredient('B', (ItemLike)Items.f_42451_).ingredient('C', (ItemLike)AoAItems.RUNIUM_CHUNK.get()).ingredient('D', (ItemLike)Blocks.f_50058_).output(new ItemStack((ItemLike)AoABlocks.SPEED_ENHANCER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("ABC", "BDB", "CBA").ingredient('A', (ItemLike)Items.f_42417_).ingredient('B', (ItemLike)Items.f_42451_).ingredient('C', (ItemLike)AoAItems.RUNIUM_CHUNK.get()).ingredient('D', (ItemLike)Blocks.f_50058_).output(new ItemStack((ItemLike)AoABlocks.WEIGHT_ENHANCER.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemLike[]{Blocks.f_50091_}).ingredients(new ItemLike[]{Items.f_42386_}).ingredients(new ItemLike[]{Items.f_42574_}).output(new ItemStack((ItemLike)AoABlocks.FRAME_BENCH.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", "BCB", "DDD").ingredient('A', (TagKey<Item>)ItemTags.f_13167_).ingredient('B', (ItemLike)AoABlocks.ANCIENT_ROCK.get()).ingredient('C', AoATags.Items.INFUSION_STONE).ingredient('D', (ItemLike)Blocks.f_50080_).output(new ItemStack((ItemLike)AoABlocks.INFUSION_TABLE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", "BCB", "BBB").ingredient('A', (ItemLike)AoAItems.EMBERSTONE_INGOT.get()).ingredient('B', (ItemLike)Blocks.f_50080_).ingredient('C', (ItemLike)AoAItems.MAGIC_REPAIR_DUST.get()).output(new ItemStack((ItemLike)AoABlocks.MENDING_TABLE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AB ", "AC ", "AAA").ingredient('A', (TagKey<Item>)ItemTags.f_13168_).ingredient('B', (ItemLike)Items.f_42416_).ingredient('C', (ItemLike)Items.f_42544_).output(new ItemStack((ItemLike)AoABlocks.TEA_SINK.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoABlocks.DARKWASH_BRICKS.get(), 4)).ingredients((ItemLike)AoAItems.MYSTITE_INGOT.get()).output(new ItemStack((ItemLike)AoABlocks.BLACK_MYSTERIUM_BRICKS.get(), 4));
        new RecipeBuilder("bloodstone_bricks_from_whitewash", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICKS.get(), 8)).ingredients((ItemLike)AoAItems.BLOODSTONE.get()).output(new ItemStack((ItemLike)AoABlocks.BLOODSTONE_BRICKS.get(), 8));
        new RecipeBuilder("coral_bricks_from_whitewash", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICKS.get(), 8)).ingredients((ItemLike)AoAItems.CORAL_STONE.get()).output(new ItemStack((ItemLike)AoABlocks.CORAL_BRICKS.get(), 8));
        new RecipeBuilder("crystallite_bricks_from_whitewash", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICKS.get(), 8)).ingredients((ItemLike)AoAItems.CRYSTALLITE.get()).output(new ItemStack((ItemLike)AoABlocks.CRYSTALLITE_BRICKS.get(), 8));
        new RecipeBuilder(RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICKS.get(), 4)).ingredients((ItemLike)AoAItems.MYSTITE_INGOT.get()).output(new ItemStack((ItemLike)AoABlocks.GREEN_MYSTERIUM_BRICKS.get(), 4));
        new RecipeBuilder("skeletal_bricks_from_whitewash", RecipeBuilder.Type.SHAPELESS).ingredients(new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICKS.get(), 8)).ingredients((ItemLike)AoAItems.SKELETAL_INGOT.get()).output(new ItemStack((ItemLike)AoABlocks.SKELETAL_BRICKS.get(), 8));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AAA", "ABA", "AAA").ingredient('A', (TagKey<Item>)ItemTags.f_13168_).ingredient('B', (ItemLike)AoAItems.REINFORCED_CLOTH.get()).output(new ItemStack((ItemLike)AoABlocks.CRATE.get(), 1));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AA", "AA").ingredient('A', (ItemLike)AoABlocks.BARON_STONE.get()).output(new ItemStack((ItemLike)AoABlocks.BARON_STONE_BRICKS.get(), 4));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AA", "AA").ingredient('A', (ItemLike)AoABlocks.HELLSTONE.get()).output(new ItemStack((ItemLike)AoABlocks.HELLSTONE_BRICKS.get(), 4));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AB", "BA").ingredient('A', (ItemLike)AoABlocks.HELLSTONE.get()).ingredient('B', (ItemLike)AoABlocks.BARON_STONE.get()).output(new ItemStack((ItemLike)AoABlocks.BARON_TILES.get(), 4));
        new RecipeBuilder(RecipeBuilder.Type.SHAPED).shape("AA", "AA").ingredient('A', (ItemLike)AoABlocks.RUNIC_STONE.get()).output(new ItemStack((ItemLike)AoABlocks.RUNIC_STONE_BRICKS.get(), 4));
    }

    private static void registerSmeltingRecipes() {
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.BARONYTE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.BARONYTE_INGOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.BLAZIUM_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.BLAZIUM_INGOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.BLOODSTONE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.BLOODSTONE.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.CHARGED_RUNIUM_ORE.get()).xp(2.0f).output(new ItemStack((ItemLike)AoAItems.CHARGED_RUNIUM_CHUNK.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.CRYSTALLITE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.CRYSTALLITE.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.ELECANIUM_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.ELECANIUM_INGOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.EMBERSTONE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.EMBERSTONE_INGOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.GEMENYTE_ORE.get()).xp(2.0f).output(new ItemStack((ItemLike)AoAItems.GEMENYTE.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.GHASTLY_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.GHASTLY_INGOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.GHOULISH_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.GHOULISH_INGOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.JADE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.JADE.get()));
        new RecipeBuilder("deepslate_jade", RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.DEEPSLATE_JADE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.JADE.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.JEWELYTE_ORE.get()).xp(2.0f).output(new ItemStack((ItemLike)AoAItems.JEWELYTE.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.LIMONITE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.LIMONITE_INGOT.get()));
        new RecipeBuilder("deepslate_limonite", RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.DEEPSLATE_LIMONITE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.LIMONITE_INGOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.LYON_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.LYON_INGOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.MYSTITE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.MYSTITE_INGOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.ORNAMYTE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.ORNAMYTE.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.RUNIUM_ORE.get()).xp(2.0f).output(new ItemStack((ItemLike)AoAItems.RUNIUM_CHUNK.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.BLUE_GEMSTONE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.BLUE_GEMSTONES.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.GREEN_GEMSTONE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.GREEN_GEMSTONES.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.PURPLE_GEMSTONE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.PURPLE_GEMSTONES.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.RED_GEMSTONE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.RED_GEMSTONES.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.WHITE_GEMSTONE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.WHITE_GEMSTONES.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.YELLOW_GEMSTONE_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.YELLOW_GEMSTONES.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.SHYREGEM_ORE.get()).xp(5.0f).output(new ItemStack((ItemLike)AoAItems.SHYREGEM.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.SHYRESTONE_ORE.get()).xp(2.0f).output(new ItemStack((ItemLike)AoAItems.SHYRESTONE_INGOT.get()));
        new RecipeBuilder(RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients((ItemLike)AoABlocks.VARSIUM_ORE.get()).xp(3.0f).output(new ItemStack((ItemLike)AoAItems.VARSIUM_INGOT.get()));
        new RecipeBuilder("limonite_ingot_from_raw_limonite", RecipeBuilder.Type.ALL_MINERAL_PROCESSING).ingredients(AoATags.Items.RAW_MATERIALS_LIMONITE).xp(0.7f).output(new ItemStack((ItemLike)AoAItems.LIMONITE_INGOT.get()));
    }
}

