/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages.generic.block;

import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.datagen.DataGenBlockModels;
import net.tslat.aoa3.advent.datagen.builder.loot.LootPoolBuilder;
import net.tslat.aoa3.advent.datagen.builder.loot.LootTableBuilder;
import net.tslat.aoa3.advent.datagen.loot.DataGenBlockLootTables;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.common.registration.block.AoABlocks;

public class GenericTrophyBlockPackage
extends DataGenBlockPackage {
    private DataGenBlockModels blockModels = null;

    public GenericTrophyBlockPackage(RegistryObject<? extends Block> block) {
        super(block);
        this.customModel((DataGenBlockModels dataGen) -> {
            this.blockModels = dataGen;
            if (block == AoABlocks.GOLD_TROPHY) {
                return this::customGoldModel;
            }
            if (block == AoABlocks.ORNATE_TROPHY) {
                return this::customOrnateModel;
            }
            return this::customModel;
        });
        this.blockTags(BlockTags.f_144282_);
        this.customDrops(dataGen -> this::customLootTable);
    }

    private void customModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockModels.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().getBuilder(outputPath.toString())).texture("texture", outputPath)).texture("particle", outputPath);
        ItemModelBuilder itemModel = (ItemModelBuilder)this.blockModels.itemModels().getBuilder(blockPackage.getRegistryName().toString());
        ModelBuilder.TransformsBuilder transforms = itemModel.transforms();
        ModelBuilder.ElementBuilder bottomElement = model.element().from(4.0f, 0.0f, 4.0f).to(12.0f, 2.0f, 12.0f);
        ModelBuilder.ElementBuilder middleElement = model.element().from(5.0f, 2.0f, 5.0f).to(11.0f, 9.0f, 11.0f);
        ModelBuilder.ElementBuilder topElement = model.element().from(4.5f, 9.0f, 4.5f).to(11.5f, 11.0f, 11.5f);
        bottomElement.rotation().angle(0.0f).axis(Direction.Axis.Y).origin(12.0f, 8.0f, 12.0f);
        middleElement.rotation().angle(0.0f).axis(Direction.Axis.Y).origin(12.0f, 10.0f, 12.0f);
        topElement.rotation().angle(0.0f).axis(Direction.Axis.Y).origin(12.5f, 17.0f, 12.5f);
        block8: for (Direction dir : Direction.values()) {
            switch (dir) {
                case NORTH: {
                    bottomElement.face(dir).uvs(4.0f, 15.0f, 8.0f, 16.0f).texture("#texture");
                    middleElement.face(dir).uvs(3.0f, 7.5f, 6.0f, 11.0f).texture("#texture");
                    topElement.face(dir).uvs(3.5f, 3.5f, 7.0f, 4.5f).texture("#texture");
                    continue block8;
                }
                case SOUTH: {
                    bottomElement.face(dir).uvs(12.0f, 15.0f, 16.0f, 16.0f).texture("#texture");
                    middleElement.face(dir).uvs(9.0f, 7.5f, 12.0f, 11.0f).texture("#texture");
                    topElement.face(dir).uvs(10.5f, 3.5f, 14.0f, 4.5f).texture("#texture");
                    continue block8;
                }
                case EAST: {
                    bottomElement.face(dir).uvs(0.0f, 15.0f, 4.0f, 16.0f).texture("#texture");
                    middleElement.face(dir).uvs(0.0f, 7.5f, 3.0f, 11.0f).texture("#texture");
                    topElement.face(dir).uvs(0.0f, 3.5f, 3.5f, 4.5f).texture("#texture");
                    continue block8;
                }
                case WEST: {
                    bottomElement.face(dir).uvs(8.0f, 15.0f, 12.0f, 16.0f).texture("#texture");
                    middleElement.face(dir).uvs(6.0f, 7.5f, 9.0f, 11.0f).texture("#texture");
                    topElement.face(dir).uvs(7.0f, 3.5f, 10.5f, 4.5f).texture("#texture");
                    continue block8;
                }
                case UP: {
                    bottomElement.face(dir).uvs(8.0f, 15.0f, 4.0f, 11.0f).texture("#texture");
                    middleElement.face(dir).uvs(6.0f, 7.5f, 3.0f, 4.5f).texture("#texture");
                    topElement.face(dir).uvs(7.0f, 3.5f, 3.5f, 0.0f).texture("#texture");
                    continue block8;
                }
                case DOWN: {
                    bottomElement.face(dir).uvs(12.0f, 11.0f, 8.0f, 15.0f).texture("#texture");
                    middleElement.face(dir).uvs(9.0f, 4.5f, 6.0f, 7.5f).texture("#texture");
                    topElement.face(dir).uvs(10.5f, 0.0f, 7.0f, 3.5f).texture("#texture");
                }
            }
        }
        transforms.transform(ModelBuilder.Perspective.GUI).rotation(18.0f, 45.0f, 0.0f).translation(0.0f, 2.0f, 0.0f).scale(1.0f);
        transforms.transform(ModelBuilder.Perspective.GROUND).translation(0.0f, 1.0f, 0.0f).scale(0.5f, 0.5f, 0.5f);
        model.ao(false);
        itemModel.parent((ModelFile)model);
        this.blockModels.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
    }

    private void customGoldModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockModels.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().getBuilder(outputPath.toString())).texture("texture", outputPath)).texture("particle", outputPath);
        ItemModelBuilder itemModel = (ItemModelBuilder)this.blockModels.itemModels().getBuilder(blockPackage.getRegistryName().toString());
        ModelBuilder.TransformsBuilder transforms = itemModel.transforms();
        ModelBuilder.ElementBuilder bottomElement = model.element().from(4.0f, 0.0f, 4.0f).to(12.0f, 2.0f, 12.0f);
        ModelBuilder.ElementBuilder middleElement = model.element().from(5.0f, 2.0f, 5.0f).to(11.0f, 9.0f, 11.0f);
        ModelBuilder.ElementBuilder topElement = model.element().from(4.5f, 9.0f, 4.5f).to(11.5f, 11.0f, 11.5f);
        ModelBuilder.ElementBuilder northGem = model.element().from(7.25f, 3.0f, 4.5f).to(8.75f, 5.5f, 5.0f);
        ModelBuilder.ElementBuilder southGem = model.element().from(7.25f, 3.0f, 11.0f).to(8.75f, 5.5f, 11.5f);
        ModelBuilder.ElementBuilder eastGem = model.element().from(4.5f, 3.0f, 7.25f).to(5.0f, 5.5f, 8.75f);
        ModelBuilder.ElementBuilder westGem = model.element().from(11.0f, 3.0f, 7.25f).to(11.5f, 5.5f, 8.75f);
        bottomElement.rotation().angle(0.0f).axis(Direction.Axis.Y).origin(12.0f, 8.0f, 12.0f);
        middleElement.rotation().angle(0.0f).axis(Direction.Axis.Y).origin(12.0f, 10.0f, 12.0f);
        topElement.rotation().angle(0.0f).axis(Direction.Axis.Y).origin(12.5f, 17.0f, 12.5f);
        northGem.rotation().angle(0.0f).axis(Direction.Axis.Y).origin(15.0f, 11.75f, 12.25f);
        southGem.rotation().angle(0.0f).axis(Direction.Axis.Y).origin(15.0f, 11.75f, 18.75f);
        eastGem.rotation().angle(0.0f).axis(Direction.Axis.Y).origin(12.25f, 11.75f, 16.0f);
        westGem.rotation().angle(0.0f).axis(Direction.Axis.Y).origin(18.75f, 11.75f, 16.0f);
        block8: for (Direction dir : Direction.values()) {
            switch (dir) {
                case NORTH: {
                    bottomElement.face(dir).uvs(4.0f, 15.0f, 8.0f, 16.0f).texture("#texture");
                    middleElement.face(dir).uvs(3.0f, 7.5f, 6.0f, 11.0f).texture("#texture");
                    topElement.face(dir).uvs(3.5f, 3.5f, 7.0f, 4.5f).texture("#texture");
                    northGem.face(dir).uvs(1.5f, 0.5f, 0.5f, 2.0f).texture("#texture");
                    southGem.face(dir).uvs(11.0f, 0.5f, 12.0f, 2.0f).texture("#texture");
                    eastGem.face(dir).uvs(10.5f, 5.5f, 10.0f, 7.0f).texture("#texture");
                    westGem.face(dir).uvs(1.0f, 5.5f, 1.5f, 7.0f).texture("#texture");
                    continue block8;
                }
                case SOUTH: {
                    bottomElement.face(dir).uvs(12.0f, 15.0f, 16.0f, 16.0f).texture("#texture");
                    middleElement.face(dir).uvs(9.0f, 7.5f, 12.0f, 11.0f).texture("#texture");
                    topElement.face(dir).uvs(10.5f, 3.5f, 14.0f, 4.5f).texture("#texture");
                    northGem.face(dir).uvs(3.0f, 0.5f, 2.0f, 2.0f).texture("#texture");
                    southGem.face(dir).uvs(12.5f, 0.5f, 13.5f, 2.0f).texture("#texture");
                    eastGem.face(dir).uvs(12.0f, 5.5f, 11.5f, 7.0f).texture("#texture");
                    westGem.face(dir).uvs(2.5f, 5.5f, 3.0f, 7.0f).texture("#texture");
                    continue block8;
                }
                case EAST: {
                    bottomElement.face(dir).uvs(0.0f, 15.0f, 4.0f, 16.0f).texture("#texture");
                    middleElement.face(dir).uvs(0.0f, 7.5f, 3.0f, 11.0f).texture("#texture");
                    topElement.face(dir).uvs(0.0f, 3.5f, 3.5f, 4.5f).texture("#texture");
                    northGem.face(dir).uvs(2.0f, 0.5f, 1.5f, 2.0f).texture("#texture");
                    southGem.face(dir).uvs(10.5f, 0.5f, 11.0f, 2.0f).texture("#texture");
                    eastGem.face(dir).uvs(11.5f, 5.5f, 10.5f, 7.0f).texture("#texture");
                    westGem.face(dir).uvs(0.0f, 5.5f, 1.0f, 7.0f).texture("#texture");
                    continue block8;
                }
                case WEST: {
                    bottomElement.face(dir).uvs(8.0f, 15.0f, 12.0f, 16.0f).texture("#texture");
                    middleElement.face(dir).uvs(6.0f, 7.5f, 9.0f, 11.0f).texture("#texture");
                    topElement.face(dir).uvs(7.0f, 3.5f, 10.5f, 4.5f).texture("#texture");
                    northGem.face(dir).uvs(0.5f, 0.5f, 0.0f, 2.0f).texture("#texture");
                    southGem.face(dir).uvs(12.0f, 0.5f, 12.5f, 2.0f).texture("#texture");
                    eastGem.face(dir).uvs(10.0f, 5.5f, 9.0f, 7.0f).texture("#texture");
                    westGem.face(dir).uvs(1.5f, 5.5f, 2.5f, 7.0f).texture("#texture");
                    continue block8;
                }
                case UP: {
                    bottomElement.face(dir).uvs(8.0f, 15.0f, 4.0f, 11.0f).texture("#texture");
                    middleElement.face(dir).uvs(6.0f, 7.5f, 3.0f, 4.5f).texture("#texture");
                    topElement.face(dir).uvs(7.0f, 3.5f, 3.5f, 0.0f).texture("#texture");
                    northGem.face(dir).uvs(0.5f, 0.5f, 1.5f, 0.0f).texture("#texture");
                    southGem.face(dir).uvs(12.0f, 0.5f, 11.0f, 0.0f).texture("#texture");
                    eastGem.face(dir).uvs(10.0f, 5.5f, 10.5f, 4.5f).texture("#texture");
                    westGem.face(dir).uvs(1.5f, 5.5f, 1.0f, 4.5f).texture("#texture");
                    continue block8;
                }
                case DOWN: {
                    bottomElement.face(dir).uvs(12.0f, 11.0f, 8.0f, 15.0f).texture("#texture");
                    middleElement.face(dir).uvs(9.0f, 4.5f, 6.0f, 7.5f).texture("#texture");
                    topElement.face(dir).uvs(10.5f, 0.0f, 7.0f, 3.5f).texture("#texture");
                    northGem.face(dir).uvs(1.5f, 0.0f, 2.5f, 0.5f).texture("#texture");
                    southGem.face(dir).uvs(13.0f, 0.0f, 12.0f, 0.5f).texture("#texture");
                    eastGem.face(dir).uvs(10.5f, 4.5f, 11.0f, 5.5f).texture("#texture");
                    westGem.face(dir).uvs(2.0f, 4.5f, 1.5f, 5.5f).texture("#texture");
                }
            }
        }
        transforms.transform(ModelBuilder.Perspective.GUI).rotation(18.0f, 45.0f, 0.0f).translation(0.0f, 2.0f, 0.0f).scale(1.0f);
        transforms.transform(ModelBuilder.Perspective.GROUND).translation(0.0f, 1.0f, 0.0f).scale(0.5f, 0.5f, 0.5f);
        model.ao(false);
        itemModel.parent((ModelFile)model);
        this.blockModels.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        DataGenBlockModels.itemModel(this.blockModels.itemModels(), blockPackage, (ModelFile)model);
    }

    private void customOrnateModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockModels.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().getBuilder(outputPath.toString())).texture("texture", outputPath)).texture("particle", outputPath);
        ItemModelBuilder itemModel = (ItemModelBuilder)this.blockModels.itemModels().getBuilder(blockPackage.getRegistryName().toString());
        ModelBuilder.TransformsBuilder transforms = itemModel.transforms();
        ModelBuilder.ElementBuilder element = model.element().from(4.0f, 0.0f, 4.0f).to(12.0f, 2.0f, 12.0f);
        element.rotation().angle(0.0f).axis(Direction.Axis.Y).origin(12.0f, 8.0f, 12.0f);
        element.face(Direction.NORTH).uvs(4.0f, 3.5f, 6.0f, 4.0f).texture("#texture");
        element.face(Direction.EAST).uvs(6.0f, 4.75f, 8.0f, 5.25f).texture("#texture");
        element.face(Direction.SOUTH).uvs(6.0f, 5.25f, 8.0f, 5.75f).texture("#texture");
        element.face(Direction.WEST).uvs(3.0f, 7.5f, 5.0f, 8.0f).texture("#texture");
        element.face(Direction.UP).uvs(2.0f, 2.0f, 0.0f, 0.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(2.0f, 2.0f, 0.0f, 4.0f).texture("#texture");
        element = model.element().from(4.0f, -0.001f, 4.0f).to(12.0f, 1.999f, 12.0f);
        element.rotation().angle(45.0f).axis(Direction.Axis.Y).origin(8.0f, 1.0f, 8.0f);
        element.face(Direction.NORTH).uvs(4.0f, 3.5f, 6.0f, 4.0f).texture("#texture");
        element.face(Direction.EAST).uvs(6.0f, 4.75f, 8.0f, 5.25f).texture("#texture");
        element.face(Direction.SOUTH).uvs(6.0f, 5.25f, 8.0f, 5.75f).texture("#texture");
        element.face(Direction.WEST).uvs(3.0f, 7.5f, 5.0f, 8.0f).texture("#texture");
        element.face(Direction.UP).uvs(2.0f, 2.0f, 0.0f, 0.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(2.0f, 2.0f, 0.0f, 4.0f).texture("#texture");
        element = model.element().from(5.0f, 2.0f, 5.0f).to(11.0f, 9.0f, 11.0f);
        element.face(Direction.NORTH).uvs(0.0f, 6.0f, 1.5f, 7.75f).texture("#texture");
        element.face(Direction.EAST).uvs(1.5f, 6.0f, 3.0f, 7.75f).texture("#texture");
        element.face(Direction.SOUTH).uvs(6.0f, 6.0f, 7.5f, 7.75f).texture("#texture");
        element.face(Direction.WEST).uvs(6.0f, 0.0f, 7.5f, 1.75f).texture("#texture");
        element.face(Direction.UP).uvs(7.5f, 3.25f, 6.0f, 1.75f).texture("#texture");
        element.face(Direction.DOWN).uvs(7.5f, 3.25f, 6.0f, 4.75f).texture("#texture");
        element = model.element().from(4.0f, 9.0f, 4.0f).to(12.0f, 11.0f, 12.0f);
        element.face(Direction.NORTH).uvs(7.5f, 7.5f, 9.5f, 8.0f).texture("#texture");
        element.face(Direction.EAST).uvs(7.5f, 0.0f, 9.5f, 0.5f).texture("#texture");
        element.face(Direction.SOUTH).uvs(7.5f, 0.5f, 9.5f, 1.0f).texture("#texture");
        element.face(Direction.WEST).uvs(7.5f, 1.0f, 9.5f, 1.5f).texture("#texture");
        element.face(Direction.UP).uvs(4.0f, 4.0f, 2.0f, 2.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(4.0f, 0.0f, 2.0f, 2.0f).texture("#texture");
        element = model.element().from(4.0f, 2.0f, 4.0f).to(12.0f, 9.0f, 12.0f);
        element.face(Direction.NORTH).uvs(4.0f, 4.0f, 6.0f, 5.75f).texture("#texture");
        element.face(Direction.EAST).uvs(4.0f, 0.0f, 6.0f, 1.75f).texture("#texture");
        element.face(Direction.SOUTH).uvs(4.0f, 1.75f, 6.0f, 3.5f).texture("#texture");
        element.face(Direction.WEST).uvs(4.0f, 5.75f, 6.0f, 7.5f).texture("#texture");
        element.face(Direction.UP).uvs(2.0f, 6.0f, 0.0f, 4.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(4.0f, 4.0f, 2.0f, 6.0f).texture("#texture");
        element = model.element().from(4.01f, 11.55f, 5.875f).to(6.01f, 15.55f, 7.875f);
        element.rotation().angle(-45.0f).axis(Direction.Axis.X).origin(8.0f, 8.0f, 8.0f);
        element.face(Direction.NORTH).uvs(8.0f, 6.5f, 8.5f, 7.5f).texture("#texture");
        element.face(Direction.EAST).uvs(5.0f, 8.5f, 5.5f, 9.5f).texture("#texture");
        element.face(Direction.SOUTH).uvs(5.5f, 8.5f, 6.0f, 9.5f).texture("#texture");
        element.face(Direction.WEST).uvs(8.5f, 8.5f, 9.0f, 9.5f).texture("#texture");
        element.face(Direction.UP).uvs(9.0f, 7.5f, 8.5f, 7.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(9.0f, 8.0f, 8.5f, 8.5f).texture("#texture");
        element = model.element().from(9.99f, 11.55f, 5.875f).to(11.99f, 15.55f, 7.875f);
        element.rotation().angle(-45.0f).axis(Direction.Axis.X).origin(14.0f, 8.0f, 8.0f);
        element.face(Direction.NORTH).uvs(4.5f, 8.0f, 5.0f, 9.0f).texture("#texture");
        element.face(Direction.EAST).uvs(7.5f, 8.0f, 8.0f, 9.0f).texture("#texture");
        element.face(Direction.SOUTH).uvs(8.0f, 8.0f, 8.5f, 9.0f).texture("#texture");
        element.face(Direction.WEST).uvs(8.0f, 1.5f, 8.5f, 2.5f).texture("#texture");
        element.face(Direction.UP).uvs(9.0f, 5.5f, 8.5f, 5.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(9.0f, 5.5f, 8.5f, 6.0f).texture("#texture");
        element = model.element().from(9.99f, 11.55f, 8.125f).to(11.99f, 15.55f, 10.125f);
        element.rotation().angle(45.0f).axis(Direction.Axis.X).origin(14.0f, 8.0f, 8.0f);
        element.face(Direction.NORTH).uvs(8.0f, 2.5f, 8.5f, 3.5f).texture("#texture");
        element.face(Direction.EAST).uvs(8.0f, 3.5f, 8.5f, 4.5f).texture("#texture");
        element.face(Direction.SOUTH).uvs(8.0f, 4.5f, 8.5f, 5.5f).texture("#texture");
        element.face(Direction.WEST).uvs(8.0f, 5.5f, 8.5f, 6.5f).texture("#texture");
        element.face(Direction.UP).uvs(9.0f, 6.5f, 8.5f, 6.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(9.0f, 6.5f, 8.5f, 7.0f).texture("#texture");
        element = model.element().from(4.01f, 11.55f, 8.125f).to(6.01f, 15.55f, 10.125f);
        element.rotation().angle(45.0f).axis(Direction.Axis.X).origin(8.0f, 8.0f, 8.0f);
        element.face(Direction.NORTH).uvs(7.0f, 7.75f, 7.5f, 8.75f).texture("#texture");
        element.face(Direction.EAST).uvs(3.0f, 8.0f, 3.5f, 9.0f).texture("#texture");
        element.face(Direction.SOUTH).uvs(3.5f, 8.0f, 4.0f, 9.0f).texture("#texture");
        element.face(Direction.WEST).uvs(4.0f, 8.0f, 4.5f, 9.0f).texture("#texture");
        element.face(Direction.UP).uvs(9.0f, 4.5f, 8.5f, 4.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(9.0f, 4.5f, 8.5f, 5.0f).texture("#texture");
        element = model.element().from(5.875f, 11.55f, 4.01f).to(7.875f, 15.55f, 6.01f);
        element.rotation().angle(45.0f).axis(Direction.Axis.Z).origin(8.0f, 8.0f, 8.0f);
        element.face(Direction.NORTH).uvs(2.0f, 7.75f, 2.5f, 8.75f).texture("#texture");
        element.face(Direction.EAST).uvs(2.5f, 7.75f, 3.0f, 8.75f).texture("#texture");
        element.face(Direction.SOUTH).uvs(6.0f, 7.75f, 6.5f, 8.75f).texture("#texture");
        element.face(Direction.WEST).uvs(6.5f, 7.75f, 7.0f, 8.75f).texture("#texture");
        element.face(Direction.UP).uvs(9.0f, 3.5f, 8.5f, 3.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(9.0f, 3.5f, 8.5f, 4.0f).texture("#texture");
        element = model.element().from(5.875f, 11.55f, 9.99f).to(7.875f, 15.55f, 11.99f);
        element.rotation().angle(45.0f).axis(Direction.Axis.Z).origin(8.0f, 8.0f, 14.0f);
        element.face(Direction.NORTH).uvs(0.0f, 7.75f, 0.5f, 8.75f).texture("#texture");
        element.face(Direction.EAST).uvs(0.5f, 7.75f, 1.0f, 8.75f).texture("#texture");
        element.face(Direction.SOUTH).uvs(1.0f, 7.75f, 1.5f, 8.75f).texture("#texture");
        element.face(Direction.WEST).uvs(1.5f, 7.75f, 2.0f, 8.75f).texture("#texture");
        element.face(Direction.UP).uvs(9.0f, 2.5f, 8.5f, 2.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(9.0f, 2.5f, 8.5f, 3.0f).texture("#texture");
        element = model.element().from(8.125f, 11.55f, 9.99f).to(10.125f, 15.55f, 11.99f);
        element.rotation().angle(-45.0f).axis(Direction.Axis.Z).origin(8.0f, 8.0f, 14.0f);
        element.face(Direction.NORTH).uvs(7.5f, 1.5f, 8.0f, 2.5f).texture("#texture");
        element.face(Direction.EAST).uvs(7.5f, 2.5f, 8.0f, 3.5f).texture("#texture");
        element.face(Direction.SOUTH).uvs(7.5f, 3.5f, 8.0f, 4.5f).texture("#texture");
        element.face(Direction.WEST).uvs(7.5f, 5.75f, 8.0f, 6.75f).texture("#texture");
        element.face(Direction.UP).uvs(8.0f, 7.25f, 7.5f, 6.75f).texture("#texture");
        element.face(Direction.DOWN).uvs(9.0f, 1.5f, 8.5f, 2.0f).texture("#texture");
        element = model.element().from(8.125f, 11.55f, 4.01f).to(10.125f, 15.55f, 6.01f);
        element.rotation().angle(-45.0f).axis(Direction.Axis.Z).origin(8.0f, 8.0f, 8.0f);
        element.face(Direction.NORTH).uvs(3.0f, 6.0f, 3.5f, 7.0f).texture("#texture");
        element.face(Direction.EAST).uvs(3.5f, 6.0f, 4.0f, 7.0f).texture("#texture");
        element.face(Direction.SOUTH).uvs(5.0f, 7.5f, 5.5f, 8.5f).texture("#texture");
        element.face(Direction.WEST).uvs(5.5f, 7.5f, 6.0f, 8.5f).texture("#texture");
        element.face(Direction.UP).uvs(3.5f, 7.5f, 3.0f, 7.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(4.0f, 7.0f, 3.5f, 7.5f).texture("#texture");
        transforms.transform(ModelBuilder.Perspective.GUI).rotation(18.0f, 45.0f, 0.0f).translation(0.0f, 1.25f, 0.0f).scale(0.9f, 0.9f, 0.9f);
        transforms.transform(ModelBuilder.Perspective.GROUND).translation(0.0f, 1.0f, 0.0f).scale(0.5f, 0.5f, 0.5f);
        model.ao(false);
        itemModel.parent((ModelFile)model);
        this.blockModels.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
    }

    private void customLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().andDo(new LootItemFunction.Builder[]{CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY), CopyNbtFunction.m_165178_((LootContext.EntityTarget)LootContext.EntityTarget.THIS).m_80279_("EntityID", "BlockEntityTag.EntityID"), CopyNbtFunction.m_165178_((LootContext.EntityTarget)LootContext.EntityTarget.THIS).m_80279_("OriginalTrophy", "BlockEntityTag.OriginalTrophy")}).item((ItemLike)blockPackage.getItem(), 1, new Consumer[0])).finalize(lootTables);
    }
}

