/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages.generic.block;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.datagen.DataGenBlockModels;
import net.tslat.aoa3.advent.datagen.loot.DataGenBlockLootTables;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.content.block.functional.portal.PortalBlock;

public class GenericPortalBlockPackage
extends DataGenBlockPackage {
    private static boolean generatedBaseModels = false;
    private DataGenBlockModels blockModels = null;

    public GenericPortalBlockPackage(RegistryObject<? extends Block> block) {
        super(block);
        this.dropsType(DataGenBlockLootTables.BlockDropType.NONE);
        this.blockTags(BlockTags.f_13075_);
        this.customModel((DataGenBlockModels dataGen) -> {
            this.blockModels = dataGen;
            return this::customModel;
        });
    }

    private void customModel(DataGenBlockPackage blockPackage) {
        this.baseModel();
        PortalBlock block = (PortalBlock)blockPackage.getBlock();
        ResourceLocation outputPath = this.blockModels.blockTexture(block);
        BlockModelBuilder xModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().withExistingParent(outputPath.toString() + "_ns", new ResourceLocation("aoa3", "block/portal_ns"))).texture("texture", outputPath)).texture("particle", outputPath);
        BlockModelBuilder zModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().withExistingParent(outputPath.toString() + "_ew", new ResourceLocation("aoa3", "block/portal_ew"))).texture("texture", outputPath)).texture("particle", outputPath);
        this.blockModels.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.X).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)xModel)});
        this.blockModels.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.Z).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)zModel)});
        DataGenBlockModels.itemModel(this.blockModels.itemModels(), blockPackage, (ModelFile)zModel);
    }

    private void baseModel() {
        if (generatedBaseModels) {
            return;
        }
        ResourceLocation outputPathX = new ResourceLocation("aoa3", "block/portal_ns");
        ResourceLocation outputPathZ = new ResourceLocation("aoa3", "block/portal_ew");
        BlockModelBuilder xModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().withExistingParent(outputPathX.toString(), this.blockModels.mcLoc("block/block"))).texture("texture", "#")).texture("particle", "#");
        BlockModelBuilder zModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().withExistingParent(outputPathZ.toString(), this.blockModels.mcLoc("block/block"))).texture("texture", "#")).texture("particle", "#");
        ModelBuilder.ElementBuilder element = xModel.element();
        element.from(6.0f, 0.0f, 0.0f).to(10.0f, 16.0f, 16.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(6.0f, 0.0f, 10.0f, 16.0f).cullface(Direction.NORTH);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 0.0f, 16.0f, 16.0f);
        element.face(Direction.SOUTH).texture("#texture").uvs(6.0f, 0.0f, 10.0f, 16.0f).cullface(Direction.SOUTH);
        element.face(Direction.WEST).texture("#texture").uvs(0.0f, 0.0f, 16.0f, 16.0f);
        element.face(Direction.UP).texture("#texture").uvs(0.0f, 6.0f, 16.0f, 10.0f).cullface(Direction.UP).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 6.0f, 16.0f, 10.0f).cullface(Direction.DOWN).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90);
        element = zModel.element();
        element.from(0.0f, 0.0f, 6.0f).to(16.0f, 16.0f, 10.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.0f, 0.0f, 16.0f, 16.0f);
        element.face(Direction.EAST).texture("#texture").uvs(6.0f, 0.0f, 10.0f, 16.0f).cullface(Direction.EAST);
        element.face(Direction.SOUTH).texture("#texture").uvs(0.0f, 0.0f, 16.0f, 16.0f);
        element.face(Direction.WEST).texture("#texture").uvs(6.0f, 0.0f, 10.0f, 16.0f).cullface(Direction.WEST);
        element.face(Direction.UP).texture("#texture").uvs(0.0f, 6.0f, 16.0f, 10.0f).cullface(Direction.UP);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 6.0f, 16.0f, 10.0f).cullface(Direction.DOWN);
        generatedBaseModels = true;
    }
}

