/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages.generic.block;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.datagen.DataGenBlockModels;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.content.block.decoration.banner.BannerBlock;

public class GenericBannerBlockPackage
extends DataGenBlockPackage {
    private static boolean generatedBaseModels = false;
    private DataGenBlockModels blockModels = null;

    public GenericBannerBlockPackage(RegistryObject<? extends Block> block, boolean bejewelled) {
        super(block);
        this.customModel((DataGenBlockModels dataGen) -> {
            this.blockModels = dataGen;
            return bejewelled ? this::customBejewelledModel : this::customModel;
        });
    }

    private void customModel(DataGenBlockPackage blockPackage) {
        this.baseModels();
        BannerBlock block = (BannerBlock)blockPackage.getBlock();
        ResourceLocation outputPath = this.blockModels.blockTexture(block);
        BlockModelBuilder freeStandingModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().withExistingParent(outputPath.toString() + "_freestand", new ResourceLocation("aoa3", "block/banner_freestand"))).texture("texture", outputPath)).texture("particle", outputPath);
        BlockModelBuilder mountedModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().withExistingParent(outputPath + "_mounted", new ResourceLocation("aoa3", "block/banner_mounted"))).texture("texture", outputPath)).texture("particle", outputPath);
        MultiPartBlockStateBuilder stateBuilder = this.blockModels.getMultipartBuilder(block);
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)freeStandingModel).rotationY(180).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.NORTH}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.STANDING});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)freeStandingModel).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.SOUTH}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.STANDING});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)freeStandingModel).rotationY(90).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.WEST}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.STANDING});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)freeStandingModel).rotationY(270).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.EAST}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.STANDING});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)mountedModel).rotationY(180).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.NORTH}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.MOUNTED});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)mountedModel).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.SOUTH}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.MOUNTED});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)mountedModel).rotationY(90).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.WEST}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.MOUNTED});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)mountedModel).rotationY(270).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.EAST}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.MOUNTED});
        DataGenBlockModels.itemModel(this.blockModels.itemModels(), blockPackage, (ModelFile)mountedModel);
    }

    private void customBejewelledModel(DataGenBlockPackage blockPackage) {
        this.baseModels();
        BannerBlock block = (BannerBlock)blockPackage.getBlock();
        ResourceLocation outputPath = this.blockModels.blockTexture(block);
        BlockModelBuilder freeStandingModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().withExistingParent(outputPath.toString() + "_freestand", new ResourceLocation("aoa3", "block/bejewelled_banner_freestand"))).texture("texture", outputPath)).texture("particle", outputPath);
        BlockModelBuilder mountedModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().withExistingParent(outputPath + "_mounted", new ResourceLocation("aoa3", "block/bejewelled_banner_mounted"))).texture("texture", outputPath)).texture("particle", outputPath);
        MultiPartBlockStateBuilder stateBuilder = this.blockModels.getMultipartBuilder(block);
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)freeStandingModel).rotationY(180).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.NORTH}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.STANDING});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)freeStandingModel).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.SOUTH}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.STANDING});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)freeStandingModel).rotationY(90).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.WEST}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.STANDING});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)freeStandingModel).rotationY(270).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.EAST}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.STANDING});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)mountedModel).rotationY(180).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.NORTH}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.MOUNTED});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)mountedModel).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.SOUTH}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.MOUNTED});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)mountedModel).rotationY(90).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.WEST}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.MOUNTED});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)mountedModel).rotationY(270).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{Direction.EAST}).condition(BannerBlock.TYPE, (Comparable[])new BannerBlock.BannerType[]{BannerBlock.BannerType.MOUNTED});
        DataGenBlockModels.itemModel(this.blockModels.itemModels(), blockPackage, (ModelFile)mountedModel);
    }

    private void baseModels() {
        if (generatedBaseModels) {
            return;
        }
        ResourceLocation outputPath = new ResourceLocation("aoa3", "block/banner");
        BlockModelBuilder freeStandModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().getBuilder(outputPath + "_freestand")).texture("texture", "#")).texture("particle", "#")).ao(false);
        BlockModelBuilder mountedModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().getBuilder(outputPath + "_mounted")).texture("texture", "#")).texture("particle", "#")).ao(false);
        ModelBuilder.ElementBuilder element = freeStandModel.element();
        element.from(-0.5f, 28.5f, 5.25f).to(2.0f, 31.0f, 7.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.625f, 0.625f, 1.25f, 1.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 0.625f, 0.625f, 1.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(1.875f, 0.625f, 2.5f, 1.25f);
        element.face(Direction.WEST).texture("#texture").uvs(1.25f, 0.625f, 1.875f, 1.25f);
        element.face(Direction.UP).texture("#texture").uvs(0.625f, 0.0f, 1.25f, 0.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.25f, 0.0f, 1.875f, 0.625f);
        element = freeStandModel.element();
        element.from(14.0f, 28.5f, 5.25f).to(16.5f, 31.0f, 7.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.625f, 0.625f, 1.25f, 1.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 0.625f, 0.625f, 1.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(1.875f, 0.625f, 2.5f, 1.25f);
        element.face(Direction.WEST).texture("#texture").uvs(1.25f, 0.625f, 1.875f, 1.25f);
        element.face(Direction.UP).texture("#texture").uvs(0.625f, 0.0f, 1.25f, 0.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.25f, 0.0f, 1.875f, 0.625f);
        element = freeStandModel.element();
        element.from(8.0f, 29.0f, 5.75f).to(14.5f, 30.5f, 7.25f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 1.75f, 2.0f, 2.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 1.75f, 0.375f, 2.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.0f, 1.75f, 3.625f, 2.125f);
        element.face(Direction.WEST).texture("#texture").uvs(3.625f, 1.75f, 4.0f, 2.125f);
        element.face(Direction.UP).texture("#texture").uvs(0.375f, 1.375f, 2.0f, 1.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.0f, 1.375f, 3.625f, 1.75f);
        element = freeStandModel.element();
        element.from(1.5f, 29.0f, 5.75f).to(8.0f, 30.5f, 7.25f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 1.75f, 2.0f, 2.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 1.75f, 0.375f, 2.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.0f, 1.75f, 3.625f, 2.125f);
        element.face(Direction.WEST).texture("#texture").uvs(3.625f, 1.75f, 4.0f, 2.125f);
        element.face(Direction.UP).texture("#texture").uvs(0.375f, 1.375f, 2.0f, 1.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.0f, 1.375f, 3.625f, 1.75f);
        element = freeStandModel.element();
        element.from(3.0f, 5.5f, 6.25f).to(13.0f, 29.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.0f, 2.75f, 2.5f, 8.75f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 2.75f, 0.125f, 8.75f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.5f, 2.75f, 5.0f, 8.75f);
        element.face(Direction.WEST).texture("#texture").uvs(2.375f, 2.75f, 2.5f, 8.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 8.625f, 2.5f, 8.75f);
        element = freeStandModel.element();
        element.from(4.0f, 4.5f, 6.25f).to(12.0f, 5.0f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.25f, 8.875f, 2.25f, 9.0f);
        element.face(Direction.EAST).texture("#texture").uvs(0.25f, 8.875f, 0.375f, 9.0f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.75f, 8.875f, 4.75f, 9.0f);
        element.face(Direction.WEST).texture("#texture").uvs(2.125f, 8.875f, 2.25f, 9.0f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.25f, 8.875f, 2.25f, 9.0f);
        element = freeStandModel.element();
        element.from(3.5f, 5.0f, 6.25f).to(12.5f, 5.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.125f, 8.75f, 2.375f, 8.875f);
        element.face(Direction.EAST).texture("#texture").uvs(0.125f, 8.75f, 0.25f, 8.875f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.625f, 8.75f, 4.875f, 8.875f);
        element.face(Direction.WEST).texture("#texture").uvs(2.25f, 8.75f, 2.375f, 8.875f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.125f, 8.75f, 2.375f, 8.875f);
        element = freeStandModel.element();
        element.from(4.5f, 4.0f, 6.25f).to(11.5f, 4.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 9.0f, 2.125f, 9.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.375f, 9.0f, 0.5f, 9.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.875f, 9.0f, 4.625f, 9.125f);
        element.face(Direction.WEST).texture("#texture").uvs(2.0f, 9.0f, 2.125f, 9.125f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 0.0f, 0.0f, 0.0f);
        element = freeStandModel.element();
        element.from(5.0f, 3.5f, 6.25f).to(11.0f, 4.0f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.5f, 9.125f, 2.0f, 9.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.5f, 9.125f, 0.625f, 9.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.0f, 9.125f, 4.5f, 9.25f);
        element.face(Direction.WEST).texture("#texture").uvs(1.875f, 9.125f, 2.0f, 9.25f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.5f, 9.125f, 2.0f, 9.25f);
        element = freeStandModel.element();
        element.from(5.5f, 3.0f, 6.25f).to(10.5f, 3.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.625f, 9.25f, 1.875f, 9.375f);
        element.face(Direction.EAST).texture("#texture").uvs(0.625f, 9.25f, 0.75f, 9.375f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.125f, 9.25f, 4.375f, 9.375f);
        element.face(Direction.WEST).texture("#texture").uvs(1.75f, 9.25f, 1.875f, 9.375f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.625f, 9.25f, 1.875f, 9.375f);
        element = freeStandModel.element();
        element.from(6.0f, 2.5f, 6.25f).to(10.0f, 3.0f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.75f, 9.375f, 1.75f, 9.5f);
        element.face(Direction.EAST).texture("#texture").uvs(0.75f, 9.375f, 0.875f, 9.5f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.25f, 9.375f, 4.25f, 9.5f);
        element.face(Direction.WEST).texture("#texture").uvs(1.625f, 9.375f, 1.75f, 9.5f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.75f, 9.375f, 1.75f, 9.5f);
        element = freeStandModel.element();
        element.from(6.5f, 2.0f, 6.25f).to(9.5f, 2.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.875f, 9.5f, 1.625f, 9.625f);
        element.face(Direction.EAST).texture("#texture").uvs(0.875f, 9.5f, 1.0f, 9.625f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.375f, 9.5f, 4.125f, 9.625f);
        element.face(Direction.WEST).texture("#texture").uvs(1.5f, 9.5f, 1.625f, 9.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.875f, 9.5f, 1.625f, 9.625f);
        element = freeStandModel.element();
        element.from(7.0f, 1.5f, 6.25f).to(9.0f, 2.0f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(1.0f, 9.625f, 1.5f, 9.75f);
        element.face(Direction.EAST).texture("#texture").uvs(1.0f, 9.625f, 1.125f, 9.75f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.5f, 9.625f, 4.0f, 9.75f);
        element.face(Direction.WEST).texture("#texture").uvs(1.375f, 9.625f, 1.5f, 9.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.0f, 9.625f, 1.5f, 9.75f);
        element = freeStandModel.element();
        element.from(7.25f, 29.5f, 7.25f).to(8.75f, 30.0f, 7.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.0f, 0.0f, 3.0f, 1.0f);
        element.face(Direction.EAST).texture("#texture").uvs(2.625f, 1.125f, 2.75f, 1.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.125f, 1.125f, 3.5f, 1.25f);
        element.face(Direction.WEST).texture("#texture").uvs(3.5f, 1.125f, 3.625f, 1.25f);
        element.face(Direction.UP).texture("#texture").uvs(3.125f, 1.0f, 3.5f, 1.125f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.75f, 1.0f, 3.125f, 1.125f);
        element = freeStandModel.element();
        element.from(7.25f, 29.0f, 7.25f).to(8.75f, 29.5f, 8.25f);
        element.face(Direction.NORTH).texture("#texture").uvs(3.25f, 0.75f, 3.625f, 0.875f);
        element.face(Direction.EAST).texture("#texture").uvs(2.625f, 0.75f, 2.875f, 0.875f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.625f, 0.75f, 3.875f, 0.875f);
        element.face(Direction.WEST).texture("#texture").uvs(3.25f, 0.75f, 3.625f, 0.875f);
        element.face(Direction.UP).texture("#texture").uvs(2.875f, 0.5f, 3.25f, 0.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(3.25f, 0.5f, 3.625f, 0.75f);
        element = freeStandModel.element();
        element.from(7.25f, 0.0f, 7.25f).to(8.75f, 29.0f, 8.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(5.5f, 0.375f, 5.875f, 7.625f);
        element.face(Direction.EAST).texture("#texture").uvs(5.125f, 0.375f, 5.5f, 7.625f);
        element.face(Direction.SOUTH).texture("#texture").uvs(6.25f, 0.375f, 6.625f, 7.625f);
        element.face(Direction.WEST).texture("#texture").uvs(5.875f, 0.375f, 6.25f, 7.625f);
        element.face(Direction.UP).texture("#texture").uvs(5.5f, 0.0f, 5.875f, 0.375f);
        element.face(Direction.DOWN).texture("#texture").uvs(5.5f, 7.625f, 5.875f, 8.0f);
        element = mountedModel.element();
        element.from(-0.5f, 12.5f, 13.5f).to(2.0f, 15.0f, 16.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.625f, 0.625f, 1.25f, 1.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 0.625f, 0.625f, 1.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(1.875f, 0.625f, 2.5f, 1.25f);
        element.face(Direction.WEST).texture("#texture").uvs(1.25f, 0.625f, 1.875f, 1.25f);
        element.face(Direction.UP).texture("#texture").uvs(0.625f, 0.0f, 1.25f, 0.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.25f, 0.0f, 1.875f, 0.625f);
        element = mountedModel.element();
        element.from(14.0f, 12.5f, 13.5f).to(16.5f, 15.0f, 16.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.625f, 0.625f, 1.25f, 1.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 0.625f, 0.625f, 1.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(1.875f, 0.625f, 2.5f, 1.25f);
        element.face(Direction.WEST).texture("#texture").uvs(1.25f, 0.625f, 1.875f, 1.25f);
        element.face(Direction.UP).texture("#texture").uvs(0.625f, 0.0f, 1.25f, 0.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.25f, 0.0f, 1.875f, 0.625f);
        element = mountedModel.element();
        element.from(8.0f, 13.0f, 14.0f).to(14.5f, 14.5f, 15.5f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 1.75f, 2.0f, 2.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 1.75f, 0.375f, 2.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.0f, 1.75f, 3.625f, 2.125f);
        element.face(Direction.WEST).texture("#texture").uvs(3.625f, 1.75f, 4.0f, 2.125f);
        element.face(Direction.UP).texture("#texture").uvs(0.375f, 1.375f, 2.0f, 1.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.0f, 1.375f, 3.625f, 1.75f);
        element = mountedModel.element();
        element.from(1.5f, 13.0f, 14.0f).to(8.0f, 14.5f, 15.5f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 1.75f, 2.0f, 2.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 1.75f, 0.375f, 2.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.0f, 1.75f, 3.625f, 2.125f);
        element.face(Direction.WEST).texture("#texture").uvs(3.625f, 1.75f, 4.0f, 2.125f);
        element.face(Direction.UP).texture("#texture").uvs(0.375f, 1.375f, 2.0f, 1.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.0f, 1.375f, 3.625f, 1.75f);
        element = mountedModel.element();
        element.from(3.0f, -10.5f, 14.5f).to(13.0f, 13.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.0f, 2.75f, 2.5f, 8.75f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 2.75f, 0.125f, 8.75f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.5f, 2.75f, 5.0f, 8.75f);
        element.face(Direction.WEST).texture("#texture").uvs(2.375f, 2.75f, 2.5f, 8.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 8.625f, 2.5f, 8.75f);
        element = mountedModel.element();
        element.from(4.0f, -11.5f, 14.5f).to(12.0f, -11.0f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.25f, 8.875f, 2.25f, 9.0f);
        element.face(Direction.EAST).texture("#texture").uvs(0.25f, 8.875f, 0.375f, 9.0f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.75f, 8.875f, 4.75f, 9.0f);
        element.face(Direction.WEST).texture("#texture").uvs(2.125f, 8.875f, 2.25f, 9.0f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.25f, 8.875f, 2.25f, 9.0f);
        element = mountedModel.element();
        element.from(3.5f, -11.0f, 14.5f).to(12.5f, -10.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.125f, 8.75f, 2.375f, 8.875f);
        element.face(Direction.EAST).texture("#texture").uvs(0.125f, 8.75f, 0.25f, 8.875f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.625f, 8.75f, 4.875f, 8.875f);
        element.face(Direction.WEST).texture("#texture").uvs(2.25f, 8.75f, 2.375f, 8.875f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.125f, 8.75f, 2.375f, 8.875f);
        element = mountedModel.element();
        element.from(4.5f, -12.0f, 14.5f).to(11.5f, -11.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 9.0f, 2.125f, 9.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.375f, 9.0f, 0.5f, 9.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.875f, 9.0f, 4.625f, 9.125f);
        element.face(Direction.WEST).texture("#texture").uvs(2.0f, 9.0f, 2.125f, 9.125f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 0.0f, 0.0f, 0.0f);
        element = mountedModel.element();
        element.from(5.0f, -12.5f, 14.5f).to(11.0f, -12.0f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.5f, 9.125f, 2.0f, 9.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.5f, 9.125f, 0.625f, 9.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.0f, 9.125f, 4.5f, 9.25f);
        element.face(Direction.WEST).texture("#texture").uvs(1.875f, 9.125f, 2.0f, 9.25f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.5f, 9.125f, 2.0f, 9.25f);
        element = mountedModel.element();
        element.from(5.5f, -13.0f, 14.5f).to(10.5f, -12.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.625f, 9.25f, 1.875f, 9.375f);
        element.face(Direction.EAST).texture("#texture").uvs(0.625f, 9.25f, 0.75f, 9.375f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.125f, 9.25f, 4.375f, 9.375f);
        element.face(Direction.WEST).texture("#texture").uvs(1.75f, 9.25f, 1.875f, 9.375f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.625f, 9.25f, 1.875f, 9.375f);
        element = mountedModel.element();
        element.from(6.0f, -13.5f, 14.5f).to(10.0f, -13.0f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.75f, 9.375f, 1.75f, 9.5f);
        element.face(Direction.EAST).texture("#texture").uvs(0.75f, 9.375f, 0.875f, 9.5f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.25f, 9.375f, 4.25f, 9.5f);
        element.face(Direction.WEST).texture("#texture").uvs(1.625f, 9.375f, 1.75f, 9.5f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.75f, 9.375f, 1.75f, 9.5f);
        element = mountedModel.element();
        element.from(6.5f, -14.0f, 14.5f).to(9.5f, -13.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.875f, 9.5f, 1.625f, 9.625f);
        element.face(Direction.EAST).texture("#texture").uvs(0.875f, 9.5f, 1.0f, 9.625f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.375f, 9.5f, 4.125f, 9.625f);
        element.face(Direction.WEST).texture("#texture").uvs(1.5f, 9.5f, 1.625f, 9.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.875f, 9.5f, 1.625f, 9.625f);
        element = mountedModel.element();
        element.from(7.0f, -14.5f, 14.5f).to(9.0f, -14.0f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(1.0f, 9.625f, 1.5f, 9.75f);
        element.face(Direction.EAST).texture("#texture").uvs(1.0f, 9.625f, 1.125f, 9.75f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.5f, 9.625f, 4.0f, 9.75f);
        element.face(Direction.WEST).texture("#texture").uvs(1.375f, 9.625f, 1.5f, 9.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.0f, 9.625f, 1.5f, 9.75f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).scale(0.5f, 0.5f, 0.5f).rotation(67.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, -4.0f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.GUI).scale(0.5f, 0.5f, 0.5f).rotation(0.0f, -180.0f, 0.0f).translation(0.0f, 4.0f, 0.0f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.FIXED).scale(0.5f, 0.5f, 0.5f).translation(0.0f, 4.0f, -4.0f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.GROUND).scale(0.25f, 0.25f, 0.25f).translation(0.0f, 1.0f, -1.5f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).scale(0.8f, 0.8f, 0.8f).rotation(0.0f, -86.0f, 0.0f).translation(6.0f, 2.5f, -3.5f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).scale(0.8f, 0.8f, 0.8f).rotation(0.0f, -86.0f, 0.0f).translation(6.0f, 2.5f, -3.5f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).scale(0.5f, 0.5f, 0.5f).rotation(67.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, -4.0f);
        outputPath = new ResourceLocation("aoa3", "block/bejewelled_banner");
        freeStandModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().getBuilder(outputPath + "_freestand")).texture("texture", "#")).texture("particle", "#")).ao(false);
        mountedModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().getBuilder(outputPath + "_mounted")).texture("texture", "#")).texture("particle", "#")).ao(false);
        element = freeStandModel.element();
        element.from(-0.5f, 28.5f, 5.25f).to(2.0f, 31.0f, 7.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.625f, 0.625f, 1.25f, 1.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 0.625f, 0.625f, 1.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(1.875f, 0.625f, 2.5f, 1.25f);
        element.face(Direction.WEST).texture("#texture").uvs(1.25f, 0.625f, 1.875f, 1.25f);
        element.face(Direction.UP).texture("#texture").uvs(0.625f, 0.0f, 1.25f, 0.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.25f, 0.0f, 1.875f, 0.625f);
        element = freeStandModel.element();
        element.from(14.0f, 28.5f, 5.25f).to(16.5f, 31.0f, 7.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.625f, 0.625f, 1.25f, 1.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 0.625f, 0.625f, 1.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(1.875f, 0.625f, 2.5f, 1.25f);
        element.face(Direction.WEST).texture("#texture").uvs(1.25f, 0.625f, 1.875f, 1.25f);
        element.face(Direction.UP).texture("#texture").uvs(0.625f, 0.0f, 1.25f, 0.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.25f, 0.0f, 1.875f, 0.625f);
        element = freeStandModel.element();
        element.from(8.0f, 29.0f, 5.75f).to(14.5f, 30.5f, 7.25f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 1.75f, 2.0f, 2.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 1.75f, 0.375f, 2.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.0f, 1.75f, 3.625f, 2.125f);
        element.face(Direction.WEST).texture("#texture").uvs(3.625f, 1.75f, 4.0f, 2.125f);
        element.face(Direction.UP).texture("#texture").uvs(0.375f, 1.375f, 2.0f, 1.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.0f, 1.375f, 3.625f, 1.75f);
        element = freeStandModel.element();
        element.from(1.5f, 29.0f, 5.75f).to(8.0f, 30.5f, 7.25f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 1.75f, 2.0f, 2.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 1.75f, 0.375f, 2.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.0f, 1.75f, 3.625f, 2.125f);
        element.face(Direction.WEST).texture("#texture").uvs(3.625f, 1.75f, 4.0f, 2.125f);
        element.face(Direction.UP).texture("#texture").uvs(0.375f, 1.375f, 2.0f, 1.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.0f, 1.375f, 3.625f, 1.75f);
        element = freeStandModel.element();
        element.from(3.0f, 5.5f, 6.25f).to(13.0f, 29.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.0f, 2.75f, 2.5f, 8.75f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 2.75f, 0.125f, 8.75f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.5f, 2.75f, 5.0f, 8.75f);
        element.face(Direction.WEST).texture("#texture").uvs(2.375f, 2.75f, 2.5f, 8.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 8.625f, 2.5f, 8.75f);
        element = freeStandModel.element();
        element.from(4.0f, 4.5f, 6.25f).to(12.0f, 5.0f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.25f, 8.875f, 2.25f, 9.0f);
        element.face(Direction.EAST).texture("#texture").uvs(0.25f, 8.875f, 0.375f, 9.0f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.75f, 8.875f, 4.75f, 9.0f);
        element.face(Direction.WEST).texture("#texture").uvs(2.125f, 8.875f, 2.25f, 9.0f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.25f, 8.875f, 2.25f, 9.0f);
        element = freeStandModel.element();
        element.from(3.5f, 5.0f, 6.25f).to(12.5f, 5.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.125f, 8.75f, 2.375f, 8.875f);
        element.face(Direction.EAST).texture("#texture").uvs(0.125f, 8.75f, 0.25f, 8.875f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.625f, 8.75f, 4.875f, 8.875f);
        element.face(Direction.WEST).texture("#texture").uvs(2.25f, 8.75f, 2.375f, 8.875f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.125f, 8.75f, 2.375f, 8.875f);
        element = freeStandModel.element();
        element.from(4.5f, 4.0f, 6.25f).to(11.5f, 4.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 9.0f, 2.125f, 9.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.375f, 9.0f, 0.5f, 9.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.875f, 9.0f, 4.625f, 9.125f);
        element.face(Direction.WEST).texture("#texture").uvs(2.0f, 9.0f, 2.125f, 9.125f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 0.0f, 0.0f, 0.0f);
        element = freeStandModel.element();
        element.from(4.0f, 3.5f, 6.25f).to(12.0f, 4.0f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.25f, 9.125f, 2.25f, 9.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.25f, 9.125f, 0.375f, 9.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.75f, 9.125f, 4.75f, 9.25f);
        element.face(Direction.WEST).texture("#texture").uvs(2.125f, 9.125f, 2.25f, 9.25f);
        element.face(Direction.UP).texture("#texture").uvs(0.25f, 9.125f, 2.25f, 9.25f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.25f, 9.125f, 2.25f, 9.25f);
        element = freeStandModel.element();
        element.from(3.5f, 3.0f, 6.25f).to(12.5f, 3.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.125f, 9.25f, 2.375f, 9.375f);
        element.face(Direction.EAST).texture("#texture").uvs(0.125f, 9.25f, 0.25f, 9.375f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.625f, 9.25f, 4.875f, 9.375f);
        element.face(Direction.WEST).texture("#texture").uvs(2.25f, 9.25f, 2.375f, 9.375f);
        element.face(Direction.UP).texture("#texture").uvs(0.125f, 9.25f, 2.375f, 9.375f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.125f, 9.25f, 2.375f, 9.375f);
        element = freeStandModel.element();
        element.from(11.5f, 2.0f, 6.25f).to(12.5f, 2.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.125f, 9.5f, 0.375f, 9.625f);
        element.face(Direction.EAST).texture("#texture").uvs(0.125f, 9.5f, 0.25f, 9.625f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.625f, 9.5f, 2.875f, 9.625f);
        element.face(Direction.WEST).texture("#texture").uvs(0.25f, 9.5f, 0.375f, 9.625f);
        element.face(Direction.UP).texture("#texture").uvs(0.125f, 9.5f, 0.375f, 9.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.125f, 9.5f, 0.375f, 9.625f);
        element = freeStandModel.element();
        element.from(3.5f, 2.0f, 6.25f).to(4.5f, 2.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(2.125f, 9.5f, 2.375f, 9.625f);
        element.face(Direction.EAST).texture("#texture").uvs(2.125f, 9.5f, 2.25f, 9.625f);
        element.face(Direction.SOUTH).texture("#texture").uvs(4.625f, 9.5f, 4.875f, 9.625f);
        element.face(Direction.WEST).texture("#texture").uvs(2.25f, 9.5f, 2.375f, 9.625f);
        element.face(Direction.UP).texture("#texture").uvs(2.125f, 9.5f, 2.375f, 9.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.125f, 9.5f, 2.375f, 9.625f);
        element = freeStandModel.element();
        element.from(3.0f, 2.5f, 6.25f).to(5.0f, 3.0f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(2.0f, 9.375f, 2.5f, 9.5f);
        element.face(Direction.EAST).texture("#texture").uvs(2.0f, 9.375f, 2.125f, 9.5f);
        element.face(Direction.SOUTH).texture("#texture").uvs(4.5f, 9.375f, 5.0f, 9.5f);
        element.face(Direction.WEST).texture("#texture").uvs(2.375f, 9.375f, 2.5f, 9.5f);
        element.face(Direction.UP).texture("#texture").uvs(2.0f, 9.375f, 2.5f, 9.5f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.0f, 9.375f, 2.5f, 9.5f);
        element = freeStandModel.element();
        element.from(11.0f, 2.5f, 6.25f).to(13.0f, 3.0f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.0f, 9.375f, 0.5f, 9.5f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 9.375f, 0.125f, 9.5f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.5f, 9.375f, 3.0f, 9.5f);
        element.face(Direction.WEST).texture("#texture").uvs(0.375f, 9.375f, 0.5f, 9.5f);
        element.face(Direction.UP).texture("#texture").uvs(0.0f, 9.375f, 0.5f, 9.5f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 9.375f, 0.5f, 9.5f);
        element = freeStandModel.element();
        element.from(6.0f, 2.5f, 6.25f).to(10.0f, 3.0f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.75f, 9.375f, 1.75f, 9.5f);
        element.face(Direction.EAST).texture("#texture").uvs(0.75f, 9.375f, 0.875f, 9.5f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.25f, 9.375f, 4.25f, 9.5f);
        element.face(Direction.WEST).texture("#texture").uvs(1.625f, 9.375f, 1.75f, 9.5f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.75f, 9.375f, 1.75f, 9.5f);
        element = freeStandModel.element();
        element.from(6.5f, 2.0f, 6.25f).to(9.5f, 2.5f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.875f, 9.5f, 1.625f, 9.625f);
        element.face(Direction.EAST).texture("#texture").uvs(0.875f, 9.5f, 1.0f, 9.625f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.375f, 9.5f, 4.125f, 9.625f);
        element.face(Direction.WEST).texture("#texture").uvs(1.5f, 9.5f, 1.625f, 9.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.875f, 9.5f, 1.625f, 9.625f);
        element = freeStandModel.element();
        element.from(7.0f, 1.5f, 6.25f).to(9.0f, 2.0f, 6.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(1.0f, 9.625f, 1.5f, 9.75f);
        element.face(Direction.EAST).texture("#texture").uvs(1.0f, 9.625f, 1.125f, 9.75f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.5f, 9.625f, 4.0f, 9.75f);
        element.face(Direction.WEST).texture("#texture").uvs(1.375f, 9.625f, 1.5f, 9.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.0f, 9.625f, 1.5f, 9.75f);
        element = freeStandModel.element();
        element.from(7.25f, 29.5f, 7.25f).to(8.75f, 30.0f, 7.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.0f, 0.0f, 3.0f, 1.0f);
        element.face(Direction.EAST).texture("#texture").uvs(2.625f, 1.125f, 2.75f, 1.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.125f, 1.125f, 3.5f, 1.25f);
        element.face(Direction.WEST).texture("#texture").uvs(3.5f, 1.125f, 3.625f, 1.25f);
        element.face(Direction.UP).texture("#texture").uvs(3.125f, 1.0f, 3.5f, 1.125f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.75f, 1.0f, 3.125f, 1.125f);
        element = freeStandModel.element();
        element.from(7.25f, 29.0f, 7.25f).to(8.75f, 29.5f, 8.25f);
        element.face(Direction.NORTH).texture("#texture").uvs(3.25f, 0.75f, 3.625f, 0.875f);
        element.face(Direction.EAST).texture("#texture").uvs(2.625f, 0.75f, 2.875f, 0.875f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.625f, 0.75f, 3.875f, 0.875f);
        element.face(Direction.WEST).texture("#texture").uvs(3.25f, 0.75f, 3.625f, 0.875f);
        element.face(Direction.UP).texture("#texture").uvs(2.875f, 0.5f, 3.25f, 0.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(3.25f, 0.5f, 3.625f, 0.75f);
        element = freeStandModel.element();
        element.from(7.25f, 0.0f, 7.25f).to(8.75f, 29.0f, 8.75f);
        element.face(Direction.NORTH).texture("#texture").uvs(5.5f, 0.375f, 5.875f, 7.625f);
        element.face(Direction.EAST).texture("#texture").uvs(5.125f, 0.375f, 5.5f, 7.625f);
        element.face(Direction.SOUTH).texture("#texture").uvs(6.25f, 0.375f, 6.625f, 7.625f);
        element.face(Direction.WEST).texture("#texture").uvs(5.875f, 0.375f, 6.25f, 7.625f);
        element.face(Direction.UP).texture("#texture").uvs(5.5f, 0.0f, 5.875f, 0.375f);
        element.face(Direction.DOWN).texture("#texture").uvs(5.5f, 7.625f, 5.875f, 8.0f);
        element = mountedModel.element();
        element.from(-0.5f, 12.5f, 13.5f).to(2.0f, 15.0f, 16.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.625f, 0.625f, 1.25f, 1.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 0.625f, 0.625f, 1.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(1.875f, 0.625f, 2.5f, 1.25f);
        element.face(Direction.WEST).texture("#texture").uvs(1.25f, 0.625f, 1.875f, 1.25f);
        element.face(Direction.UP).texture("#texture").uvs(0.625f, 0.0f, 1.25f, 0.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.25f, 0.0f, 1.875f, 0.625f);
        element = mountedModel.element();
        element.from(14.0f, 12.5f, 13.5f).to(16.5f, 15.0f, 16.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.625f, 0.625f, 1.25f, 1.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 0.625f, 0.625f, 1.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(1.875f, 0.625f, 2.5f, 1.25f);
        element.face(Direction.WEST).texture("#texture").uvs(1.25f, 0.625f, 1.875f, 1.25f);
        element.face(Direction.UP).texture("#texture").uvs(0.625f, 0.0f, 1.25f, 0.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.25f, 0.0f, 1.875f, 0.625f);
        element = mountedModel.element();
        element.from(8.0f, 13.0f, 14.0f).to(14.5f, 14.5f, 15.5f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 1.75f, 2.0f, 2.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 1.75f, 0.375f, 2.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.0f, 1.75f, 3.625f, 2.125f);
        element.face(Direction.WEST).texture("#texture").uvs(3.625f, 1.75f, 4.0f, 2.125f);
        element.face(Direction.UP).texture("#texture").uvs(0.375f, 1.375f, 2.0f, 1.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.0f, 1.375f, 3.625f, 1.75f);
        element = mountedModel.element();
        element.from(1.5f, 13.0f, 14.0f).to(8.0f, 14.5f, 15.5f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 1.75f, 2.0f, 2.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 1.75f, 0.375f, 2.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.0f, 1.75f, 3.625f, 2.125f);
        element.face(Direction.WEST).texture("#texture").uvs(3.625f, 1.75f, 4.0f, 2.125f);
        element.face(Direction.UP).texture("#texture").uvs(0.375f, 1.375f, 2.0f, 1.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.0f, 1.375f, 3.625f, 1.75f);
        element = mountedModel.element();
        element.from(3.0f, -10.5f, 14.5f).to(13.0f, 13.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.0f, 2.75f, 2.5f, 8.75f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 2.75f, 0.125f, 8.75f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.5f, 2.75f, 5.0f, 8.75f);
        element.face(Direction.WEST).texture("#texture").uvs(2.375f, 2.75f, 2.5f, 8.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 8.625f, 2.5f, 8.75f);
        element = mountedModel.element();
        element.from(4.0f, -11.5f, 14.5f).to(12.0f, -11.0f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.25f, 8.875f, 2.25f, 9.0f);
        element.face(Direction.EAST).texture("#texture").uvs(0.25f, 8.875f, 0.375f, 9.0f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.75f, 8.875f, 4.75f, 9.0f);
        element.face(Direction.WEST).texture("#texture").uvs(2.125f, 8.875f, 2.25f, 9.0f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.25f, 8.875f, 2.25f, 9.0f);
        element = mountedModel.element();
        element.from(3.5f, -11.0f, 14.5f).to(12.5f, -10.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.125f, 8.75f, 2.375f, 8.875f);
        element.face(Direction.EAST).texture("#texture").uvs(0.125f, 8.75f, 0.25f, 8.875f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.625f, 8.75f, 4.875f, 8.875f);
        element.face(Direction.WEST).texture("#texture").uvs(2.25f, 8.75f, 2.375f, 8.875f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.125f, 8.75f, 2.375f, 8.875f);
        element = mountedModel.element();
        element.from(4.5f, -12.0f, 14.5f).to(11.5f, -11.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.375f, 9.0f, 2.125f, 9.125f);
        element.face(Direction.EAST).texture("#texture").uvs(0.375f, 9.0f, 0.5f, 9.125f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.875f, 9.0f, 4.625f, 9.125f);
        element.face(Direction.WEST).texture("#texture").uvs(2.0f, 9.0f, 2.125f, 9.125f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 0.0f, 0.0f, 0.0f);
        element = mountedModel.element();
        element.from(4.0f, -12.5f, 14.5f).to(12.0f, -12.0f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.25f, 9.125f, 2.25f, 9.25f);
        element.face(Direction.EAST).texture("#texture").uvs(0.25f, 9.125f, 0.375f, 9.25f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.75f, 9.125f, 4.75f, 9.25f);
        element.face(Direction.WEST).texture("#texture").uvs(2.125f, 9.125f, 2.25f, 9.25f);
        element.face(Direction.UP).texture("#texture").uvs(0.25f, 9.125f, 2.25f, 9.25f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.25f, 9.125f, 2.25f, 9.25f);
        element = mountedModel.element();
        element.from(3.5f, -13.0f, 14.5f).to(12.5f, -12.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.125f, 9.25f, 2.375f, 9.375f);
        element.face(Direction.EAST).texture("#texture").uvs(0.125f, 9.25f, 0.25f, 9.375f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.625f, 9.25f, 4.875f, 9.375f);
        element.face(Direction.WEST).texture("#texture").uvs(2.25f, 9.25f, 2.375f, 9.375f);
        element.face(Direction.UP).texture("#texture").uvs(0.125f, 9.25f, 2.375f, 9.375f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.125f, 9.25f, 2.375f, 9.375f);
        element = mountedModel.element();
        element.from(11.5f, -14.0f, 14.5f).to(12.5f, -13.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.125f, 9.5f, 0.375f, 9.625f);
        element.face(Direction.EAST).texture("#texture").uvs(0.125f, 9.5f, 0.25f, 9.625f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.625f, 9.5f, 2.875f, 9.625f);
        element.face(Direction.WEST).texture("#texture").uvs(0.25f, 9.5f, 0.375f, 9.625f);
        element.face(Direction.UP).texture("#texture").uvs(0.125f, 9.5f, 0.375f, 9.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.125f, 9.5f, 0.375f, 9.625f);
        element = mountedModel.element();
        element.from(3.5f, -14.0f, 14.5f).to(4.5f, -13.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(2.125f, 9.5f, 2.375f, 9.625f);
        element.face(Direction.EAST).texture("#texture").uvs(2.125f, 9.5f, 2.25f, 9.625f);
        element.face(Direction.SOUTH).texture("#texture").uvs(4.625f, 9.5f, 4.875f, 9.625f);
        element.face(Direction.WEST).texture("#texture").uvs(2.25f, 9.5f, 2.375f, 9.625f);
        element.face(Direction.UP).texture("#texture").uvs(2.125f, 9.5f, 2.375f, 9.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.125f, 9.5f, 2.375f, 9.625f);
        element = mountedModel.element();
        element.from(3.0f, -13.5f, 14.5f).to(5.0f, -13.0f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(2.0f, 9.375f, 2.5f, 9.5f);
        element.face(Direction.EAST).texture("#texture").uvs(2.0f, 9.375f, 2.125f, 9.5f);
        element.face(Direction.SOUTH).texture("#texture").uvs(4.5f, 9.375f, 5.0f, 9.5f);
        element.face(Direction.WEST).texture("#texture").uvs(2.375f, 9.375f, 2.5f, 9.5f);
        element.face(Direction.UP).texture("#texture").uvs(2.0f, 9.375f, 2.5f, 9.5f);
        element.face(Direction.DOWN).texture("#texture").uvs(2.0f, 9.375f, 2.5f, 9.5f);
        element = mountedModel.element();
        element.from(11.0f, -13.5f, 14.5f).to(13.0f, -13.0f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.0f, 9.375f, 0.5f, 9.5f);
        element.face(Direction.EAST).texture("#texture").uvs(0.0f, 9.375f, 0.125f, 9.5f);
        element.face(Direction.SOUTH).texture("#texture").uvs(2.5f, 9.375f, 3.0f, 9.5f);
        element.face(Direction.WEST).texture("#texture").uvs(0.375f, 9.375f, 0.5f, 9.5f);
        element.face(Direction.UP).texture("#texture").uvs(0.0f, 9.375f, 0.5f, 9.5f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.0f, 9.375f, 0.5f, 9.5f);
        element = mountedModel.element();
        element.from(6.0f, -13.5f, 14.5f).to(10.0f, -13.0f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.75f, 9.375f, 1.75f, 9.5f);
        element.face(Direction.EAST).texture("#texture").uvs(0.75f, 9.375f, 0.875f, 9.5f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.25f, 9.375f, 4.25f, 9.5f);
        element.face(Direction.WEST).texture("#texture").uvs(1.625f, 9.375f, 1.75f, 9.5f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.75f, 9.375f, 1.75f, 9.5f);
        element = mountedModel.element();
        element.from(6.5f, -14.0f, 14.5f).to(9.5f, -13.5f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(0.875f, 9.5f, 1.625f, 9.625f);
        element.face(Direction.EAST).texture("#texture").uvs(0.875f, 9.5f, 1.0f, 9.625f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.375f, 9.5f, 4.125f, 9.625f);
        element.face(Direction.WEST).texture("#texture").uvs(1.5f, 9.5f, 1.625f, 9.625f);
        element.face(Direction.DOWN).texture("#texture").uvs(0.875f, 9.5f, 1.625f, 9.625f);
        element = mountedModel.element();
        element.from(7.0f, -14.5f, 14.5f).to(9.0f, -14.0f, 15.0f);
        element.face(Direction.NORTH).texture("#texture").uvs(1.0f, 9.625f, 1.5f, 9.75f);
        element.face(Direction.EAST).texture("#texture").uvs(1.0f, 9.625f, 1.125f, 9.75f);
        element.face(Direction.SOUTH).texture("#texture").uvs(3.5f, 9.625f, 4.0f, 9.75f);
        element.face(Direction.WEST).texture("#texture").uvs(1.375f, 9.625f, 1.5f, 9.75f);
        element.face(Direction.DOWN).texture("#texture").uvs(1.0f, 9.625f, 1.5f, 9.75f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).scale(0.5f, 0.5f, 0.5f).rotation(67.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, -4.0f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.GUI).scale(0.5f, 0.5f, 0.5f).rotation(0.0f, -180.0f, 0.0f).translation(0.0f, 4.0f, 0.0f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.FIXED).scale(0.5f, 0.5f, 0.5f).translation(0.0f, 4.0f, -4.0f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.GROUND).scale(0.25f, 0.25f, 0.25f).translation(0.0f, 1.0f, -1.5f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).scale(0.8f, 0.8f, 0.8f).rotation(0.0f, -86.0f, 0.0f).translation(6.0f, 2.5f, -3.5f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).scale(0.8f, 0.8f, 0.8f).rotation(0.0f, -86.0f, 0.0f).translation(6.0f, 2.5f, -3.5f);
        mountedModel.transforms().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).scale(0.5f, 0.5f, 0.5f).rotation(67.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, -4.0f);
        generatedBaseModels = true;
    }
}

