/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages.custom.block;

import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.tslat.aoa3.advent.datagen.DataGenBlockModels;
import net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder;
import net.tslat.aoa3.advent.datagen.builder.loot.LootPoolBuilder;
import net.tslat.aoa3.advent.datagen.builder.loot.LootTableBuilder;
import net.tslat.aoa3.advent.datagen.loot.DataGenBlockLootTables;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.common.registration.block.AoABlocks;

public class SteelPlateBlockPackage
extends DataGenBlockPackage {
    private DataGenBlockModels blockModels = null;

    public SteelPlateBlockPackage() {
        super(AoABlocks.STEEL_PLATE);
        this.blockTags(BlockTags.f_144282_);
        this.customModel((DataGenBlockModels dataGen) -> {
            this.blockModels = dataGen;
            return this::customModel;
        });
        this.customDrops(dataGen -> this::customLootTable);
    }

    private void customModel(DataGenBlockPackage blockPackage) {
        CompactBlockModelBuilder fullModel = new CompactBlockModelBuilder((BlockStateProvider)this.blockModels, blockPackage).vanillaParent("cube_all").defaultTextureRef("all");
        CompactBlockModelBuilder<Block> topModel = new CompactBlockModelBuilder<Block>(this.blockModels, blockPackage.getBlock(), "_up", true).modParent("steel_plate");
        CompactBlockModelBuilder<Block> bottomModel = new CompactBlockModelBuilder<Block>(this.blockModels, blockPackage.getBlock(), "_down", true).modParent("steel_plate");
        CompactBlockModelBuilder<Block> northModel = new CompactBlockModelBuilder<Block>(this.blockModels, blockPackage.getBlock(), "_north", true).modParent("steel_plate");
        CompactBlockModelBuilder<Block> southModel = new CompactBlockModelBuilder<Block>(this.blockModels, blockPackage.getBlock(), "_south", true).modParent("steel_plate");
        CompactBlockModelBuilder<Block> eastModel = new CompactBlockModelBuilder<Block>(this.blockModels, blockPackage.getBlock(), "_east", true).modParent("steel_plate");
        CompactBlockModelBuilder<Block> westModel = new CompactBlockModelBuilder<Block>(this.blockModels, blockPackage.getBlock(), "_west", true).modParent("steel_plate");
        MultiPartBlockStateBuilder stateBuilder = fullModel.multiPartStateBuilder();
        CompactBlockModelBuilder.CompactElementBuilder element = topModel.newPart();
        element.from(0.0f, 15.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        element.northFace().uv(0.0f, 4.0f, 16.0f, 5.0f).texture("#all").autoCull();
        element.southFace().uv(0.0f, 0.0f, 16.0f, 1.0f).texture("#all").autoCull();
        element.upFace().uv(0.0f, 0.0f, 16.0f, 16.0f).texture("#all").autoCull();
        element.downFace().uv(0.0f, 16.0f, 16.0f, 0.0f).texture("#all");
        element.westFace().uv(0.0f, 0.0f, 16.0f, 1.0f).texture("#all").autoCull();
        element.eastFace().uv(0.0f, 0.0f, 16.0f, 1.0f).texture("#all").flipUpsideDown().autoCull();
        element = bottomModel.newPart();
        element.from(0.0f, 0.0f, 0.0f).to(16.0f, 1.0f, 16.0f);
        element.northFace().uv(0.0f, 4.0f, 16.0f, 5.0f).texture("#all").autoCull();
        element.southFace().uv(0.0f, 0.0f, 16.0f, 1.0f).texture("#all").autoCull();
        element.upFace().uv(0.0f, 0.0f, 16.0f, 16.0f).texture("#all");
        element.downFace().uv(0.0f, 16.0f, 16.0f, 0.0f).texture("#all").autoCull();
        element.westFace().uv(0.0f, 0.0f, 16.0f, 1.0f).texture("#all").autoCull();
        element.eastFace().uv(0.0f, 0.0f, 16.0f, 1.0f).texture("#all").flipUpsideDown().autoCull();
        element = northModel.newPart();
        element.from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 1.0f);
        element.northFace().uv(0.0f, 0.0f, 16.0f, 16.0f).texture("#all").autoCull();
        element.southFace().uv(0.0f, 0.0f, 16.0f, 16.0f).texture("#all").rotateRight();
        element.upFace().uv(0.0f, 12.0f, 16.0f, 13.0f).texture("#all").autoCull();
        element.downFace().uv(0.0f, 5.0f, 16.0f, 6.0f).texture("#all").autoCull();
        element.westFace().uv(15.0f, 0.0f, 16.0f, 16.0f).texture("#all").autoCull();
        element.eastFace().uv(0.0f, 0.0f, 1.0f, 16.0f).texture("#all").autoCull();
        element = southModel.newPart();
        element.from(0.0f, 0.0f, 15.0f).to(16.0f, 16.0f, 16.0f);
        element.northFace().uv(0.0f, 0.0f, 16.0f, 16.0f).texture("#all");
        element.southFace().uv(0.0f, 0.0f, 16.0f, 16.0f).texture("#all").rotateRight().autoCull();
        element.upFace().uv(0.0f, 12.0f, 16.0f, 13.0f).texture("#all").autoCull();
        element.downFace().uv(0.0f, 5.0f, 16.0f, 6.0f).texture("#all").autoCull();
        element.westFace().uv(15.0f, 0.0f, 16.0f, 16.0f).texture("#all").autoCull();
        element.eastFace().uv(0.0f, 0.0f, 1.0f, 16.0f).texture("#all").autoCull();
        element = eastModel.newPart();
        element.from(15.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        element.northFace().uv(0.0f, 0.0f, 1.0f, 16.0f).texture("#all").autoCull();
        element.southFace().uv(15.0f, 0.0f, 16.0f, 16.0f).texture("#all").autoCull();
        element.upFace().uv(0.0f, 0.0f, 1.0f, 16.0f).texture("#all").autoCull();
        element.downFace().uv(13.0f, 0.0f, 14.0f, 16.0f).texture("#all").autoCull();
        element.westFace().uv(0.0f, 0.0f, 16.0f, 16.0f).texture("#all");
        element.eastFace().uv(0.0f, 0.0f, 16.0f, 16.0f).texture("#all").rotateRight().autoCull();
        element = westModel.newPart();
        element.from(0.0f, 0.0f, 0.0f).to(1.0f, 16.0f, 16.0f);
        element.northFace().uv(0.0f, 0.0f, 1.0f, 16.0f).texture("#all").autoCull();
        element.southFace().uv(15.0f, 0.0f, 16.0f, 16.0f).texture("#all").autoCull();
        element.upFace().uv(0.0f, 0.0f, 1.0f, 16.0f).texture("#all").autoCull();
        element.downFace().uv(13.0f, 0.0f, 14.0f, 16.0f).texture("#all").autoCull();
        element.westFace().uv(0.0f, 0.0f, 16.0f, 16.0f).texture("#all").autoCull();
        element.eastFace().uv(0.0f, 0.0f, 16.0f, 16.0f).texture("#all").rotateRight();
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile(fullModel).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile(topModel).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile(bottomModel).addModel()).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile(northModel).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile(southModel).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile(eastModel).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile(westModel).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true});
        bottomModel.itemModel();
    }

    private void customLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().ifSurvivesExplosion().item(AoABlocks.STEEL_PLATE, 1, new Consumer[0]).onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder(blockPackage.getBlock()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BlockStateProperties.f_61366_, false).m_67703_((Property)BlockStateProperties.f_61367_, false).m_67703_((Property)BlockStateProperties.f_61368_, false).m_67703_((Property)BlockStateProperties.f_61370_, false).m_67703_((Property)BlockStateProperties.f_61369_, false).m_67703_((Property)BlockStateProperties.f_61371_, false))}), new LootPoolBuilder().ifSurvivesExplosion().item(AoABlocks.STEEL_PLATE, 1, new Consumer[0]).onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder(blockPackage.getBlock()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BlockStateProperties.f_61366_, true))}), new LootPoolBuilder().ifSurvivesExplosion().item(AoABlocks.STEEL_PLATE, 1, new Consumer[0]).onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder(blockPackage.getBlock()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BlockStateProperties.f_61367_, true))}), new LootPoolBuilder().ifSurvivesExplosion().item(AoABlocks.STEEL_PLATE, 1, new Consumer[0]).onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder(blockPackage.getBlock()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BlockStateProperties.f_61368_, true))}), new LootPoolBuilder().ifSurvivesExplosion().item(AoABlocks.STEEL_PLATE, 1, new Consumer[0]).onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder(blockPackage.getBlock()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BlockStateProperties.f_61370_, true))}), new LootPoolBuilder().ifSurvivesExplosion().item(AoABlocks.STEEL_PLATE, 1, new Consumer[0]).onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder(blockPackage.getBlock()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BlockStateProperties.f_61369_, true))}), new LootPoolBuilder().ifSurvivesExplosion().item(AoABlocks.STEEL_PLATE, 1, new Consumer[0]).onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder(blockPackage.getBlock()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BlockStateProperties.f_61371_, true))})).finalize(lootTables);
    }
}

